/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx;

import com.sonyericsson.kx.MainCanvas;
import com.sonyericsson.kx.Menu;
import com.sonyericsson.kx.MenuBase;
import com.sonyericsson.kx.Tools;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ScriptText {
    public static final boolean ENGLISH = false;
    public static final boolean debug = true;
    private int x;
    private int y;
    private int width;
    private int linemax;
    private Font font;
    private int fontHeight;
    private int color;
    private String[] textStr;
    int currentLine = 0;
    int maxLineNum;
    private static final String pp = "...";
    private static final char[] SIGN_ALL = new char[]{':', ',', '.', '?', '!', ' ', ';', '\uff0c', '\u3002', '\uff1f', '\uff01', '\uff1b', '\u3001'};

    public ScriptText(String s, int x, int y, int w, int linemax, int linespace, Font font, int color) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.linemax = linemax;
        this.font = font;
        this.color = color;
        this.fontHeight = font.getHeight() + linespace;
        this.parseText(s);
        this.currentLine = 0;
    }

    public int getHeight() {
        if (this.textStr != null) {
            return this.textStr.length * this.fontHeight;
        }
        return 0;
    }

    public void paint(Graphics g) {
        if (this.textStr == null) {
            return;
        }
        g.setColor(this.color);
        g.setFont(this.font);
        if (this.textStr != null && this.textStr.length > 0) {
            int len = this.textStr.length;
            int i = 0;
            while (i < len) {
                g.drawString(this.textStr[i], this.x, this.y + this.fontHeight * i, 0);
                ++i;
            }
        }
    }

    public void paint(Graphics g, int x, int y, boolean underline) {
        if (this.textStr == null) {
            return;
        }
        g.setColor(this.color);
        if (underline) {
            Tools.setColor(g, MenuBase.loginTextBlue);
        }
        g.setFont(this.font);
        if (this.textStr != null && this.textStr.length > 0) {
            int len = this.textStr.length;
            int i = 0;
            while (i < len) {
                g.drawString(this.textStr[i], x, y + this.fontHeight * i, 0);
                if (underline) {
                    g.fillRect(x, y + this.fontHeight * i + this.fontHeight - 4, this.font.stringWidth(this.textStr[i]), 1);
                }
                ++i;
            }
        }
    }

    public void paint(Graphics g, int x, int y, int maxline, int color) {
        this.maxLineNum = maxline;
        if (this.textStr == null) {
            return;
        }
        g.setColor(color);
        g.setFont(this.font);
        if (this.textStr != null && this.textStr.length > 0) {
            int max = this.textStr.length;
            if (this.currentLine + this.maxLineNum < max) {
                max = this.currentLine + this.maxLineNum;
            }
            int i = this.currentLine;
            while (i < max) {
                g.drawString(this.textStr[i], x, y + this.fontHeight * (i - this.currentLine), 0);
                ++i;
            }
        }
        if (this.maxLineNum < this.textStr.length) {
            g.drawImage(MainCanvas.scrollBackImg, MainCanvas.screenWidth - 2, Menu.topBarHeight, 24);
            int hei = MainCanvas.screenHeight - Menu.topBarHeight - Menu.commandBarHeight;
            int hei1 = (this.textStr.length - this.maxLineNum) * this.fontHeight;
            int hei2 = hei - MainCanvas.scrollSlipImg.getHeight();
            int hei3 = this.currentLine * this.fontHeight;
            int hei4 = hei2 * hei3 / hei1;
            g.drawImage(MainCanvas.scrollSlipImg, MainCanvas.screenWidth - 1, Menu.topBarHeight + hei4, 24);
        }
    }

    public void keyPressed(int key) {
        switch (key) {
            case 0: {
                if (this.currentLine <= 0) break;
                --this.currentLine;
                break;
            }
            case 2: {
                if (this.textStr == null || this.textStr.length == 0) {
                    return;
                }
                if (this.currentLine + this.maxLineNum >= this.textStr.length) break;
                ++this.currentLine;
            }
        }
    }

    public void parseText(String s) {
        if (s == null || this.linemax <= 0) {
            return;
        }
        String[] result = ScriptText.changeToArray(s, this.font, this.width);
        if (result != null && result.length > this.linemax) {
            this.textStr = new String[this.linemax];
            if (this.linemax > 1) {
                int i = 0;
                while (i < this.linemax - 1) {
                    this.textStr[i] = result[i];
                    ++i;
                }
            }
            this.textStr[this.linemax - 1] = this.font.stringWidth(result[this.linemax - 1]) + this.font.stringWidth(pp) > this.width - 25 ? String.valueOf(result[this.linemax - 1].substring(0, result[this.linemax - 1].length() - 2)) + pp : String.valueOf(result[this.linemax - 1]) + pp;
        } else {
            this.textStr = result;
        }
        result = null;
    }

    public static final String[] changeToArray(String str, Font font, int w) {
        return ScriptText.changeToArrayCn(str, font, w);
    }

    private static final String[] changeToArrayCn(String str, Font font, int width) {
        int nowWidth = 0;
        Vector<String> result = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            int chWidth = font.charWidth(ch);
            if (ch == '\n' | ch == '|') {
                chWidth = 0;
            }
            if (ch == '\n' | ch == '|') {
                result.addElement(buffer.toString());
                buffer = new StringBuffer();
                nowWidth = 0;
            } else {
                if ((nowWidth += chWidth) >= width && !ScriptText.isSign(ch)) {
                    result.addElement(buffer.toString());
                    buffer = new StringBuffer();
                    nowWidth = chWidth;
                }
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            result.addElement(buffer.toString());
        }
        String[] s = new String[result.size()];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = (String)result.elementAt(i2);
            ++i2;
        }
        return s;
    }

    private static final String[] changeToArrayEn(String str, Font font, int width) {
        int nowWidth = 0;
        Vector<String> result = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            block11: {
                char ch;
                block12: {
                    int chWidth;
                    block14: {
                        char pre;
                        block13: {
                            block10: {
                                ch = str.charAt(i);
                                if (ch != '\n') break block10;
                                result.addElement(buffer.toString());
                                buffer = new StringBuffer();
                                nowWidth = 0;
                                break block11;
                            }
                            chWidth = font.charWidth(ch);
                            if (ch == '\n') {
                                chWidth = 0;
                            }
                            if ((nowWidth += chWidth) < width) break block12;
                            pre = str.charAt(i - 1);
                            if (ch != ' ') break block13;
                            result.addElement(buffer.toString());
                            buffer = new StringBuffer();
                            nowWidth = 0;
                            break block11;
                        }
                        if (!ScriptText.isSign(pre)) break block14;
                        result.addElement(buffer.toString());
                        buffer = new StringBuffer();
                        nowWidth = chWidth;
                        break block12;
                    }
                    boolean backSuccesfully = false;
                    int b = buffer.length() - 1;
                    while (b >= 0) {
                        char chB = buffer.charAt(b);
                        if (chB == ' ') {
                            i -= buffer.length() - b;
                            buffer.delete(b, buffer.length());
                            result.addElement(buffer.toString());
                            buffer = new StringBuffer();
                            nowWidth = 0;
                            backSuccesfully = true;
                            break;
                        }
                        if (ScriptText.isSign(chB)) {
                            i -= buffer.length() - b;
                            buffer.delete(b + 1, buffer.length());
                            result.addElement(buffer.toString());
                            buffer = new StringBuffer();
                            nowWidth = 0;
                            backSuccesfully = true;
                            break;
                        }
                        --b;
                    }
                    if (backSuccesfully) break block11;
                    buffer.append('-');
                    result.addElement(buffer.toString());
                    buffer = new StringBuffer();
                    nowWidth = chWidth;
                }
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            result.addElement(buffer.toString());
        }
        String[] s = new String[result.size()];
        int i2 = 0;
        while (i2 < s.length) {
            s[i2] = (String)result.elementAt(i2);
            ++i2;
        }
        return s;
    }

    private static final boolean isSign(char ch) {
        return false;
    }
}

