/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx.invoc;

import com.sonyericsson.kx.invoc.RecordStoreAccess;
import com.sonyericsson.kx.invoc.SessionData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;

public class SessionDataAccess {
    static RecordStoreAccess store = new RecordStoreAccess();

    public static boolean sessionDataExists() {
        boolean bRet = store.openRecordStore("SESSION");
        if (!bRet) {
            return false;
        }
        store.closeRecordStore();
        return true;
    }

    public static boolean readConfig(SessionData data) {
        if (!store.openRecordStore("SESSION")) {
            return false;
        }
        byte[] buf = store.readData();
        if (buf == null) {
            store.closeRecordStore();
            store.deleteRecordStore("SESSION");
            return false;
        }
        store.closeRecordStore();
        SessionData dataA = SessionDataAccess.getData(buf);
        if (dataA == null) {
            return false;
        }
        data.strUid = dataA.strUid;
        data.strVerify = dataA.strVerify;
        data.strWapVerify = dataA.strWapVerify;
        data.strMagic = dataA.strMagic;
        return true;
    }

    public static boolean writeConfig(String uid, String verify, String wapVerify) {
        boolean bRet = false;
        if (!store.createRecordStore("SESSION")) {
            return false;
        }
        store.deleteData();
        bRet = store.addData(SessionDataAccess.getData(uid, verify, wapVerify));
        if (!bRet) {
            store.deleteData();
        }
        store.closeRecordStore();
        return bRet;
    }

    public static SessionData getData(byte[] buf) {
        ByteArrayInputStream bais = null;
        FilterInputStream dis = null;
        SessionData data = null;
        try {
            data = new SessionData();
            bais = new ByteArrayInputStream(buf);
            dis = new DataInputStream(bais);
            data.strUid = ((DataInputStream)dis).readUTF();
            data.strVerify = ((DataInputStream)dis).readUTF();
            data.strWapVerify = ((DataInputStream)dis).readUTF();
            data.strMagic = ((DataInputStream)dis).readUTF();
            dis.close();
            bais.close();
            dis = null;
            bais = null;
        }
        catch (Exception e1) {
            try {
                if (dis != null) {
                    dis.close();
                }
                dis = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (bais != null) {
                    bais.close();
                }
                bais = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            data = null;
            return data;
        }
        if (data.strMagic != null && data.strMagic.compareTo("JW_MAGIC") == 0) {
            return data;
        }
        data = null;
        return data;
    }

    public static byte[] getData(String uid, String verify, String wapVerify) {
        ByteArrayOutputStream baos = null;
        FilterOutputStream dos = null;
        try {
            baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            if (uid == null) {
                ((DataOutputStream)dos).writeUTF("");
            } else {
                ((DataOutputStream)dos).writeUTF(uid);
            }
            if (verify == null) {
                ((DataOutputStream)dos).writeUTF("");
            } else {
                ((DataOutputStream)dos).writeUTF(verify);
            }
            if (wapVerify == null) {
                ((DataOutputStream)dos).writeUTF("");
            } else {
                ((DataOutputStream)dos).writeUTF(wapVerify);
            }
            ((DataOutputStream)dos).writeUTF("JW_MAGIC");
            ((DataOutputStream)dos).flush();
            byte[] buf = baos.toByteArray();
            dos.close();
            dos = null;
            baos.close();
            baos = null;
            return buf;
        }
        catch (Exception e1) {
            try {
                if (dos != null) {
                    dos.close();
                }
                dos = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (baos != null) {
                    baos.close();
                }
                baos = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

