/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.control.thread;

import com.myweather.constants.GeneralConstants;
import com.myweather.control.AppEngine;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.ChargeUI;
import com.myweather.ui.MainUI;
import com.myweather.ui.WaitingForm;
import com.myweather.util.BasicFunction;
import com.myweather.valueobject.CityInfo;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Displayable;

public class GetCityListThread
extends Thread {
    public MainUI mainUI;
    public String currUrl = null;
    public WaitingForm waitingForm;

    public GetCityListThread(MainUI mainUI, String currUrl) {
        this.mainUI = mainUI;
        this.currUrl = currUrl;
        this.init();
    }

    public void init() {
        this.waitingForm = new WaitingForm(null, (Displayable)this.mainUI, false, true, StyleSheet.mainscreenStyle);
        this.waitingForm.showWaitingInfo("");
        MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.waitingForm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            System.out.println("GetCityListThread run... currUrl : " + this.currUrl);
            int[] customizeCityIds = BasicFunction.getCustomizeCityIds();
            int customizeCitySize = customizeCityIds.length;
            if (GeneralConstants.IS_FREE && customizeCitySize > 3) {
                customizeCitySize = 3;
            }
            if (customizeCitySize > 0) {
                CityInfo cityInfoFirst = null;
                if (GeneralConstants.cityIdsMap.get(String.valueOf(customizeCityIds[0])) != null) {
                    cityInfoFirst = (CityInfo)GeneralConstants.cityIdsMap.get(String.valueOf(customizeCityIds[0]));
                } else {
                    cityInfoFirst = AppEngine.getInstance(true).getCityList(BasicFunction.convertUrl(this.currUrl, customizeCityIds[0]));
                    GeneralConstants.cityIdsMap.put(String.valueOf(customizeCityIds[0]), cityInfoFirst);
                    cityInfoFirst.setCity(GeneralConstants.cityList[customizeCityIds[0]][1]);
                }
                GeneralConstants.CURR_DATE_FROM_XML = cityInfoFirst.getCurrDate();
                if (!GeneralConstants.IS_FREE && !BasicFunction.getValidOfDay(cityInfoFirst.getCurrDate(), GeneralConstants.CHARGE_DATE)) {
                    ChargeUI chargeUI = new ChargeUI(null, StyleSheet.addcityscreenStyle);
                    MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)chargeUI);
                    throw new Exception("cancel");
                }
                ArrayList cityList = new ArrayList();
                cityList.add(cityInfoFirst);
                if (this.waitingForm.cancel) {
                    throw new Exception("cancel");
                }
                for (int i = 1; i < customizeCitySize; ++i) {
                    if (this.waitingForm.cancel) {
                        throw new Exception("cancel");
                    }
                    CityInfo cityInfo = null;
                    if (GeneralConstants.cityIdsMap.get(String.valueOf(customizeCityIds[i])) != null) {
                        cityInfo = (CityInfo)GeneralConstants.cityIdsMap.get(String.valueOf(customizeCityIds[i]));
                    } else {
                        cityInfo = AppEngine.getInstance(true).getCityList(BasicFunction.convertUrl(this.currUrl, customizeCityIds[i]));
                        cityInfo.setCity(GeneralConstants.cityList[customizeCityIds[i]][1]);
                        GeneralConstants.cityIdsMap.put(String.valueOf(customizeCityIds[i]), cityInfo);
                    }
                    cityList.add(cityInfo);
                }
                if (this.waitingForm.cancel) {
                    throw new Exception("cancel");
                }
                this.mainUI.showCityList(cityList);
            }
            if (GeneralConstants.IS_FREE) {
                this.mainUI.showAd();
            }
            this.mainUI.showHuafeng();
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.mainUI);
            this.mainUI.showMessageUI();
            BasicFunction.loadRadaImage();
        }
        catch (Exception exception) {}
    }
}

