/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.MainUI;
import com.myweather.util.BasicFunction;
import com.myweather.util.RmsUtility;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TableItem;
import de.enough.polish.util.Debug;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class TemperatureSettingUI
extends Form
implements CommandListener {
    public MainUI mainUI;
    public ChoiceGroup cityGroup;
    public Vector searchResultList = new Vector();
    private boolean isSetTemp = false;

    public TemperatureSettingUI(MainUI mainUI) {
        super("");
        this.mainUI = mainUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
    }

    public TemperatureSettingUI(MainUI mainUI, Style style) {
        super("", style);
        this.mainUI = mainUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
        this.addCommand(CommandConstants.CONFIRM);
        StringItem si = new StringItem(null, "\u9009\u62e9\u6e29\u5ea6\u7c7b\u578b", StyleSheet.inputlabelStyle);
        this.append(si);
        TableItem tableC = new TableItem(1, 1, StyleSheet.temperaturetableStyle);
        tableC.set(0, 0, "\u6444\u6c0f\u5ea6", StyleSheet.temperaturecellStyle);
        tableC.setSelectionMode(16);
        tableC.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.append(tableC);
        TableItem tableF = new TableItem(1, 1, StyleSheet.temperaturetableStyle);
        tableF.set(0, 0, "\u534e\u6c0f\u5ea6", StyleSheet.temperaturecellStyle);
        tableF.setSelectionMode(16);
        tableF.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.append(tableF);
        this.focus(BasicFunction.getTemperatureType());
    }

    public void showAlertUI() {
        String tempType = "\u6444\u6c0f\u5ea6";
        if (this.getCurrentIndex() != 1) {
            tempType = "\u534e\u6c0f\u5ea6";
        }
        Alert alert = new Alert(null, "\u5df2\u542f\u52a8\n\u6e29\u5ea6\u7c7b\u578b:\n" + tempType + "", null, AlertType.INFO, StyleSheet.settemperaturealertStyle);
        alert.setTimeout(2000);
        MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemperatureType() {
        RecordStore tempRms = null;
        try {
            tempRms = RmsUtility.openRms("TEMPERATURE_TYPE", true);
            RecordEnumeration recordEnu = tempRms.enumerateRecords(null, null, false);
            System.out.println("setTemperatureType::::getCurrentIndex=" + this.getCurrentIndex());
            byte[] data = BasicFunction.serialize(this.getCurrentIndex());
            if (recordEnu.numRecords() == 0) {
                tempRms.addRecord(data, 0, data.length);
            } else {
                tempRms.setRecord(recordEnu.nextRecordId(), data, 0, data.length);
            }
            this.isSetTemp = true;
        }
        catch (Exception e) {
            System.out.println("exception:" + e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(tempRms);
        }
    }

    public void commandAction(Command command, Displayable disp) {
        if (command == CommandConstants.BACK) {
            try {
                this.mainUI.deleteAll();
                this.mainUI.showCityListFromMap();
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.mainUI);
            }
            catch (Exception e) {
                Debug.debug("error", "com.myweather.ui.TemperatureSettingUI", 114, e.getMessage());
            }
        }
        if (command == CommandConstants.CONFIRM) {
            this.setTemperatureType();
            this.showAlertUI();
        }
    }
}

