/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.valueobject;

import de.enough.polish.util.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Hashtable;
import java.util.Vector;

public class CityInfo {
    public String city;
    public String currDate;
    public String temperature;
    public String skyConditions;
    public int itemCount;
    public Vector itemList = new Vector();

    public String getCurrDate() {
        return this.currDate;
    }

    public void setCurrDate(String currDate) {
        this.currDate = currDate;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getTemperature() {
        return this.temperature;
    }

    public void setTemperature(String temperature) {
        this.temperature = temperature;
    }

    public String getSkyConditions() {
        return this.skyConditions;
    }

    public void setSkyConditions(String skyConditions) {
        this.skyConditions = skyConditions;
    }

    public void addRssItem(Hashtable rssItem) {
        this.itemList.addElement(rssItem);
        this.itemCount = this.itemList.size();
    }

    public void insertRssItemAt(Hashtable rssItem, int index) {
        this.itemList.insertElementAt(rssItem, index);
        this.itemCount = this.itemList.size();
    }

    public void removeRssItem(Hashtable rssItem) {
        this.itemList.removeElement(rssItem);
        this.itemCount = this.itemList.size();
    }

    public static byte[] serialize(CityInfo cityInfo) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeUTF(cityInfo.city);
        dos.writeUTF(cityInfo.temperature);
        dos.writeUTF(cityInfo.skyConditions);
        dos.flush();
        return bos.toByteArray();
    }

    public static CityInfo deserialize(byte[] data) throws Exception {
        CityInfo cityInfo = new CityInfo();
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(byteIn);
            cityInfo.city = dis.readUTF();
            cityInfo.temperature = dis.readUTF();
            cityInfo.skyConditions = dis.readUTF();
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.valueobject.CityInfo", 89, e.getMessage());
        }
        return cityInfo;
    }
}

