/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.event;

import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class ThreadedCommandListener
implements Runnable,
CommandListener {
    private final CommandListener parent;
    private final ArrayList commands;
    private final ArrayList displays;
    private boolean isStopRequested;

    public ThreadedCommandListener(CommandListener parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.parent = parent;
        this.commands = new ArrayList();
        this.displays = new ArrayList();
        Thread thread = new Thread(this);
        thread.start();
    }

    public void requestStop() {
        this.isStopRequested = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isStopRequested) {
            ThreadedCommandListener threadedCommandListener = this;
            synchronized (threadedCommandListener) {
                if (this.commands.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            while (this.commands.size() > 0) {
                Command cmd = null;
                Displayable disp = null;
                ThreadedCommandListener threadedCommandListener2 = this;
                synchronized (threadedCommandListener2) {
                    cmd = (Command)this.commands.remove(0);
                    disp = (Displayable)this.displays.remove(0);
                }
                try {
                    this.parent.commandAction(cmd, disp);
                }
                catch (Throwable e) {
                    Debug.debug("error", "de.enough.polish.event.ThreadedCommandListener", 107, (Object)("Unable to process cmd " + cmd.getLabel() + " for screen " + disp), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commandAction(Command cmd, Displayable disp) {
        ThreadedCommandListener threadedCommandListener = this;
        synchronized (threadedCommandListener) {
            this.commands.add(cmd);
            this.displays.add(disp);
            this.notify();
        }
    }
}

