/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public abstract class CustomItem
extends Item {
    protected static final int TRAVERSE_HORIZONTAL = 1;
    protected static final int TRAVERSE_VERTICAL = 2;
    protected static final int KEY_PRESS = 4;
    protected static final int KEY_RELEASE = 8;
    protected static final int KEY_REPEAT = 16;
    protected static final int POINTER_PRESS = 32;
    protected static final int POINTER_RELEASE = 64;
    protected static final int POINTER_DRAG = 128;
    protected static final int NONE = 0;
    private static final int INTERACTION_MODES = 31;
    private static final Font DEFAULT_FONT = Font.getDefaultFont();
    private int[] visRect_inout = new int[4];
    private int clipHeight;
    private int clipWidth;
    private boolean supportsInternalTraversal;
    protected boolean isEventHandled;

    protected CustomItem(String label) {
        this(label, null);
    }

    protected CustomItem(String label, Style style) {
        super(label, 0, 3, style);
    }

    public int getGameAction(int keyCode) {
        if (this.screen == null) {
            this.screen = this.getScreen();
            if (this.screen == null) {
                return 0;
            }
        }
        return this.screen.getGameAction(keyCode);
    }

    protected final int getInteractionModes() {
        Screen canvas = this.getScreen();
        if (canvas == null) {
            canvas = StyleSheet.currentScreen;
        }
        if (canvas != null) {
            if (canvas.hasRepeatEvents()) {
                return 31;
            }
            return 31;
        }
        return 31;
    }

    protected abstract int getMinContentWidth();

    protected abstract int getMinContentHeight();

    protected abstract int getPrefContentWidth(int var1);

    protected abstract int getPrefContentHeight(int var1);

    protected void sizeChanged(int w, int h) {
    }

    protected final void invalidate() {
        this.requestInit();
    }

    protected abstract void paint(Graphics var1, int var2, int var3);

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] myVisRect_inout) {
        return false;
    }

    protected void traverseOut() {
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected String createCssSelector() {
        return "customitem";
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        int prefHeight;
        int prefWidth;
        this.preferredWidth = prefWidth = this.getPrefContentWidth(-1);
        boolean resetSize = false;
        if (prefWidth > lineWidth) {
            prefWidth = lineWidth;
            resetSize = true;
        }
        this.preferredHeight = prefHeight = this.getPrefContentHeight(prefWidth);
        if (resetSize) {
            this.sizeChanged(prefWidth, prefHeight);
        }
        if (this.contentHeight > prefHeight && this.parent instanceof Container) {
            ((Container)this.parent).scroll(0, 0, this.relativeY, prefWidth, prefHeight);
        }
        this.contentWidth = prefWidth;
        this.contentHeight = prefHeight;
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        this.clipWidth = g.getClipWidth();
        this.clipHeight = g.getClipHeight();
        g.clipRect(x, y, this.contentWidth, this.contentHeight);
        g.translate(x, y);
        g.setColor(0);
        g.setStrokeStyle(0);
        g.setFont(DEFAULT_FONT);
        this.paint(g, this.contentWidth, this.contentHeight);
        g.translate(-x, -y);
        g.setClip(clipX, clipY, this.clipWidth, this.clipHeight);
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
        this.traverseOut();
    }

    protected Style focus(Style focusStyle, int direction) {
        this.supportsInternalTraversal = this.traverse(direction, this.clipWidth, this.clipHeight, this.visRect_inout);
        return super.focus(focusStyle, direction);
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.supportsInternalTraversal && (gameAction == 1 && keyCode != 50 || gameAction == 2 && keyCode != 52 || gameAction == 6 && keyCode != 56 || gameAction == 5 && keyCode != 54)) {
            this.visRect_inout[0] = 0;
            this.visRect_inout[1] = 0;
            this.visRect_inout[2] = this.contentWidth;
            this.visRect_inout[3] = this.contentHeight;
            boolean isTraversed = this.traverse(gameAction, this.clipWidth, this.clipHeight, this.visRect_inout);
            if (isTraversed) {
                this.internalX = this.visRect_inout[0];
                this.internalY = this.visRect_inout[1];
                this.internalWidth = this.visRect_inout[2];
                this.internalHeight = this.visRect_inout[3];
                return true;
            }
        }
        this.isEventHandled = false;
        this.keyPressed(keyCode);
        if (this.isEventHandled || !this.isInitialized) {
            return true;
        }
        return super.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        this.isEventHandled = false;
        this.keyRepeated(keyCode);
        if (this.isEventHandled || !this.isInitialized) {
            return true;
        }
        return super.handleKeyRepeated(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        this.isEventHandled = false;
        this.keyReleased(keyCode);
        if (this.isEventHandled || !this.isInitialized) {
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected void setParent(Item item, Item parent) {
        item.parent = parent;
    }

    protected boolean handleKeyPressed(Item item, int keyCode, int gameAction) {
        return item.handleKeyPressed(keyCode, gameAction);
    }

    protected void defocus(Item item, Style originalStyle) {
        item.defocus(originalStyle);
    }

    protected void setInOutRectangle(Item item, int[] visRect_inout) {
        visRect_inout[0] = item.internalX;
        visRect_inout[1] = item.internalY;
        visRect_inout[2] = item.internalWidth;
        visRect_inout[3] = item.internalHeight;
    }

    protected void repaint() {
        this.isEventHandled = true;
        super.repaint();
    }

    protected void repaint(int relX, int relY, int width, int height) {
        this.isEventHandled = true;
        super.repaint(relX, relY, width, height);
    }
}

