/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.CommandItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.MenuBar;
import de.enough.polish.ui.ScreenStateListener;
import de.enough.polish.ui.ScrollBar;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.backgrounds.TranslucentSimpleBackground;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public abstract class Screen
extends Canvas
implements AccessibleCanvas {
    private static final int POSITION_TOP = 0;
    private static final int POSITION_LEFT = 1;
    protected Item title;
    private boolean excludeTitleForBackground;
    private Item subTitle;
    protected int subTitleHeight;
    protected int titleHeight;
    protected Background background;
    protected Border border;
    protected Style style;
    protected int screenHeight;
    protected int originalScreenHeight;
    protected int screenWidth;
    protected String cssSelector;
    private ForwardCommandListener forwardCommandListener;
    protected Container container;
    private boolean isLayoutCenter;
    private boolean isLayoutRight;
    private boolean isLayoutVCenter;
    private boolean isLayoutBottom;
    private boolean isLayoutHorizontalShrink;
    private boolean isLayoutVerticalShrink;
    boolean isInitialized;
    protected int fullScreenHeight;
    protected int menuBarHeight;
    private boolean excludeMenuBarForBackground;
    private Command okCommand;
    private Command cancelCommand;
    private final MenuBar menuBar;
    Item focusedItem;
    protected final ScrollBar scrollBar = new ScrollBar(StyleSheet.scrollbarStyle);
    private boolean showTitleOrMenu = true;
    private StringItem infoItem;
    private boolean showInfoItem;
    protected int infoHeight;
    protected int contentX;
    protected int contentY;
    protected int contentWidth;
    protected int contentHeight;
    private int marginLeft;
    private int marginRight;
    private int marginTop;
    private int marginBottom;
    private boolean repaintPreviousScreen;
    private AccessibleCanvas previousScreen;
    private Background previousScreenOverlayBackground;
    protected ScreenStateListener screenStateListener;
    private boolean isScreenChangeDirtyFlag;
    protected ItemStateListener itemStateListener;
    private final Object paintLock;
    private ArrayList itemCommands;
    private Object data;
    protected long lastInteractionTime;
    protected boolean ignoreRepaintRequests;
    protected boolean isRepaintRequested;
    protected boolean isInitRequested;
    private CommandListener realCommandListener;
    private boolean isResourcesReleased;

    public Screen(String title, boolean createDefaultContainer) {
        this(title, null, createDefaultContainer);
    }

    public Screen(String title, boolean createDefaultContainer, Style style) {
        this(title, style, createDefaultContainer);
    }

    public Screen(String title, Style style, boolean createDefaultContainer) {
        this.scrollBar.screen = this;
        if (createDefaultContainer) {
            this.container = new Container(true);
            this.container.screen = this;
            this.container.isFocused = true;
        }
        this.style = style;
        this.forwardCommandListener = new ForwardCommandListener();
        this.menuBar = new MenuBar(this, StyleSheet.menubarStyle);
        this.setTitle(title);
        this.paintLock = new Object();
    }

    private void init(int width, int height) {
        if (height == 0 || width == 0) {
            return;
        }
        this.fullScreenHeight = height;
        this.screenHeight = height;
        this.originalScreenHeight = height;
        this.screenWidth = width;
        boolean startAnimationThread = false;
        if (StyleSheet.animationThread == null) {
            StyleSheet.animationThread = new AnimationThread();
            startAnimationThread = true;
        }
        if (this.style != null) {
            this.setStyle(this.style);
        }
        if (this.style == null) {
            this.cssSelector = this.createCssSelector();
            this.setStyle(StyleSheet.getStyle(this));
        } else {
            this.cssSelector = this.style.name;
        }
        int availableScreenWidth = this.screenWidth;
        this.menuBarHeight = this.menuBar.getSpaceBottom(availableScreenWidth, this.fullScreenHeight);
        int diff = this.originalScreenHeight - this.screenHeight;
        this.originalScreenHeight = this.fullScreenHeight - this.menuBarHeight;
        this.screenHeight = this.originalScreenHeight - diff;
        if (this.container != null) {
            this.container.screen = this;
        }
        int availableWidth = this.screenWidth - this.marginLeft + this.marginRight;
        if (this.border != null) {
            availableWidth -= this.border.borderWidth << 1;
        }
        if (this.title != null) {
            this.titleHeight = this.title.getItemHeight(availableWidth, availableWidth);
        }
        this.menuBar.relativeY = this.screenHeight;
        if (this.infoItem != null) {
            this.infoHeight = this.infoItem.getItemHeight(this.screenWidth, this.screenWidth);
            this.showInfoItem = true;
        }
        this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        int menuHeight = this.menuBar.getSpaceBottom(availableScreenWidth, this.fullScreenHeight);
        if (menuHeight != this.menuBarHeight) {
            this.menuBarHeight = menuHeight;
            this.screenHeight = this.fullScreenHeight - menuHeight;
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        this.isInitialized = true;
        if (startAnimationThread) {
            StyleSheet.animationThread.start();
        }
    }

    protected void requestInit() {
        if (this.isLayoutHorizontalShrink || this.isLayoutVerticalShrink) {
            this.isInitRequested = true;
        }
    }

    protected void requestRepaint() {
        if (this.ignoreRepaintRequests) {
            this.isRepaintRequested = true;
            return;
        }
        MasterCanvas.repaintCanvas(this);
    }

    protected void requestRepaint(int x, int y, int width, int height) {
        if (this.ignoreRepaintRequests) {
            return;
        }
        MasterCanvas.repaintCanvas(this, x, y, width, height);
    }

    protected boolean checkForRequestInit(Item source) {
        return source == this.container || source == this.title || source == this.menuBar;
    }

    protected void calculateContentArea(int x, int y, int width, int height) {
        if (width < 1 || height < 1) {
            return;
        }
        int availableWidth = this.screenWidth - this.marginLeft - this.marginRight;
        if (this.border != null) {
            availableWidth -= this.border.borderWidth << 1;
        }
        if (this.title != null) {
            this.titleHeight = this.title.getItemHeight(availableWidth, availableWidth);
        }
        if (this.subTitle != null) {
            this.subTitle.relativeX = this.marginLeft;
            this.subTitle.relativeY = this.titleHeight;
            this.subTitleHeight = this.subTitle.getItemHeight(availableWidth, availableWidth);
        }
        x += this.marginLeft;
        width -= this.marginLeft + this.marginRight;
        y += this.marginTop;
        height -= this.marginTop + this.marginBottom;
        if (this.border != null) {
            int borderWidth = this.border.borderWidth;
            width -= borderWidth << 1;
            height -= borderWidth << 1;
            x += borderWidth;
            y += borderWidth;
        }
        int topHeight = this.titleHeight + this.subTitleHeight + this.infoHeight;
        y += topHeight;
        height -= topHeight;
        if (this.container != null) {
            int containerHeight;
            this.scrollBar.scrollBarHeight = height;
            int scrollBarWidth = this.scrollBar.getItemWidth(width, width);
            if (this.scrollBar.overlap) {
                scrollBarWidth = 0;
            }
            if ((containerHeight = this.container.getItemHeight(width - scrollBarWidth, width - scrollBarWidth)) > height) {
                width -= scrollBarWidth;
            } else if (scrollBarWidth != 0) {
                this.container.requestFullInit();
            }
        }
        this.scrollBar.relativeX = x + width;
        this.contentX = x;
        this.contentY = y;
        this.contentWidth = width;
        this.contentHeight = height;
        if (this.container != null) {
            this.container.relativeX = x;
            this.container.relativeY = y;
            this.container.setScrollHeight(height);
        }
    }

    public void showNotify() {
        try {
            if (!this.isInitialized) {
                int w = this.getScreenFullWidth();
                int h = this.getScreenFullHeight();
                this.init(w, h);
            }
            if (this.repaintPreviousScreen) {
                this.previousScreenOverlayBackground = new TranslucentSimpleBackground(-1778384896);
                Object currentDisplayable = MasterCanvas.getCurrent(StyleSheet.display);
                if (currentDisplayable == this) {
                    currentDisplayable = StyleSheet.currentScreen;
                }
                if (currentDisplayable != this && currentDisplayable instanceof AccessibleCanvas) {
                    Screen screen;
                    Screen screen2 = screen = currentDisplayable instanceof Screen ? (Screen)currentDisplayable : null;
                    if (screen != null) {
                        Screen previous = screen;
                        while (previous != null && previous.previousScreen instanceof Screen) {
                            previous = (Screen)previous.previousScreen;
                            if (previous != this) continue;
                            currentDisplayable = (Displayable)previous.previousScreen;
                            Screen screen3 = screen = currentDisplayable instanceof Screen ? (Screen)currentDisplayable : null;
                            break;
                        }
                    }
                    if (this.previousScreen != null && screen != null) {
                        if (screen.previousScreen != this) {
                            this.previousScreen = screen;
                        } else {
                            screen.previousScreen = null;
                        }
                    } else {
                        this.previousScreen = (AccessibleCanvas)currentDisplayable;
                    }
                }
            }
            Item[] items = this.getRootItems();
            for (int i = 0; i < items.length; ++i) {
                Item item = items[i];
                item.screen = this;
                item.showNotify();
            }
            if (this.container != null) {
                this.container.showNotify();
            }
            if (this.title != null) {
                this.title.showNotify();
            }
            if (this.isInitialized) {
                int width = this.screenWidth - (this.marginLeft + this.marginRight);
                if (!this.menuBar.isInitialized) {
                    this.menuBar.init(this.screenWidth, this.screenWidth);
                }
                if (this.container != null && !this.container.isInitialized) {
                    this.container.init(width, width);
                }
                if (this.title != null && !this.title.isInitialized) {
                    this.title.init(width, width);
                }
                this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            }
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.Screen", 1055, (Object)"error while calling showNotify", e);
        }
        StyleSheet.currentScreen = this;
        if (this.background != null) {
            this.background.showNotify();
        }
        if (this.border != null) {
            this.border.showNotify();
        }
        this.lastInteractionTime = System.currentTimeMillis();
        this.isResourcesReleased = false;
    }

    public void hideNotify() {
        this.previousScreenOverlayBackground = null;
        Item[] items = this.getRootItems();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            item.hideNotify();
        }
        if (this.container != null) {
            this.container.hideNotify();
        }
        if (this.title != null) {
            this.title.hideNotify();
        }
        if (this.background != null) {
            this.background.hideNotify();
        }
        if (this.border != null) {
            this.border.hideNotify();
        }
    }

    public void setStyle(Style style) {
        Boolean repaintPreviousScreenBool;
        if (style != this.style && this.style != null) {
            this.style.releaseResources();
        }
        this.style = style;
        this.background = style.background;
        this.border = style.border;
        this.marginTop = style.marginTop;
        this.marginBottom = style.marginBottom;
        this.marginLeft = style.marginRight;
        this.marginRight = style.marginRight;
        if (this.container != null) {
            this.container.setStyle(style, true);
        }
        this.isLayoutVCenter = (style.layout & 0x30) == 48;
        this.isLayoutBottom = !this.isLayoutVCenter && (style.layout & 0x20) == 32;
        this.isLayoutCenter = (style.layout & 3) == 3;
        this.isLayoutRight = !this.isLayoutCenter && (style.layout & 2) == 2;
        this.isLayoutHorizontalShrink = (style.layout & 0x400) == 1024;
        boolean bl = this.isLayoutVerticalShrink = (style.layout & 0x1000) == 4096;
        if (this.title != null && this.title.isInitialized) {
            this.title.isInitialized = false;
            if (this.isInitialized) {
                int width = this.screenWidth - (this.marginLeft + this.marginRight);
                this.titleHeight = this.title.getItemHeight(width, width);
            }
        }
        if ((repaintPreviousScreenBool = style.getBooleanProperty(116)) != null) {
            this.repaintPreviousScreen = repaintPreviousScreenBool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (!this.isInitialized) {
            return;
        }
        Object object = this.paintLock;
        synchronized (object) {
            try {
                int scrollYOffset = 0;
                if (this.container != null) {
                    scrollYOffset = this.container.yOffset;
                }
                if (this.animate()) {
                    repaintRegion.addRegion(0, 0, this.screenWidth, this.fullScreenHeight);
                }
                if (this.background != null) {
                    this.background.animate(this, null, currentTime, repaintRegion);
                }
                if (this.border != null) {
                    this.border.animate(this, null, currentTime, repaintRegion);
                }
                this.menuBar.animate(currentTime, repaintRegion);
                if (this.container != null) {
                    this.container.animate(currentTime, repaintRegion);
                }
                if (this.title != null) {
                    this.title.animate(currentTime, repaintRegion);
                }
                this.scrollBar.animate(currentTime, repaintRegion);
                if (this.container != null && this.container.yOffset != scrollYOffset) {
                    repaintRegion.addRegion(this.scrollBar.relativeX, this.scrollBar.relativeY, this.scrollBar.itemWidth, this.scrollBar.itemHeight);
                }
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 1477, (Object)"animate(currentTime, repaintRegion) threw an exception", e);
            }
        }
    }

    public boolean animate() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.isResourcesReleased) {
            return;
        }
        if (!this.isInitialized) {
            this.init(this.getScreenFullWidth(), this.getScreenFullHeight());
        } else if (this.isInitRequested) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            this.isInitRequested = false;
        }
        Object object = this.paintLock;
        synchronized (object) {
            try {
                if (this.repaintPreviousScreen && this.previousScreen != null) {
                    this.previousScreen.paint(g);
                    if (this.previousScreenOverlayBackground != null) {
                        int height = this.fullScreenHeight;
                        this.previousScreenOverlayBackground.paint(0, 0, this.screenWidth, height, g);
                    }
                }
                int borderWidth = 0;
                if (this.border != null) {
                    borderWidth = this.border.borderWidth;
                }
                int sWidth = this.screenWidth - this.marginLeft - this.marginRight - (borderWidth << 1);
                int leftBorder = this.marginLeft + borderWidth;
                int rightBorder = leftBorder + sWidth;
                int sHeight = this.fullScreenHeight - this.marginTop - this.marginBottom - (borderWidth << 1);
                int topBorder = this.marginTop + borderWidth;
                int space = this.menuBar.getSpaceBottom(this.screenWidth, this.fullScreenHeight);
                sHeight -= space;
                if (this.isLayoutHorizontalShrink) {
                    int contWidth = this.contentWidth;
                    if (this.container != null) {
                        contWidth = this.container.getItemWidth(sWidth, sWidth);
                        if (this.title != null && this.title.itemWidth > contWidth) {
                            this.titleHeight = this.title.getItemHeight(contWidth, contWidth);
                        }
                    }
                    sWidth = contWidth;
                    if (this.isLayoutRight) {
                        leftBorder = rightBorder - sWidth;
                    } else if (this.isLayoutCenter) {
                        int diff = rightBorder - leftBorder - sWidth >> 1;
                        leftBorder += diff;
                        rightBorder -= diff;
                    } else {
                        rightBorder = leftBorder + sWidth;
                    }
                }
                if (this.isLayoutVerticalShrink) {
                    int height;
                    int contHeight = this.contentHeight;
                    if (this.container != null && (height = this.container.getItemHeight(sWidth, sWidth)) < contHeight) {
                        contHeight = height;
                    }
                    sHeight = contHeight + this.titleHeight;
                    if (this.isLayoutBottom) {
                        topBorder = this.screenHeight - (this.marginBottom + sHeight + 1);
                    } else if (this.isLayoutVCenter) {
                        topBorder = this.screenHeight - (this.marginBottom + this.marginTop + sHeight) >> 1;
                    }
                }
                int clipY = g.getClipY();
                int backgroundHeight = sHeight;
                int backgroundY = topBorder + borderWidth;
                if (!this.excludeMenuBarForBackground && this.marginBottom == 0) {
                    backgroundHeight += this.menuBar.getSpaceBottom(this.screenWidth, this.fullScreenHeight);
                }
                if (this.excludeTitleForBackground) {
                    backgroundHeight -= this.titleHeight;
                    backgroundY += this.titleHeight;
                }
                if (this.background != null) {
                    this.background.paint(leftBorder, backgroundY, sWidth, backgroundHeight, g);
                } else {
                    g.setColor(0xFFFFFF);
                    g.fillRect(leftBorder, backgroundY, sWidth, backgroundHeight);
                }
                int topHeight = topBorder;
                if (this.title != null && this.showTitleOrMenu) {
                    if (clipY < topBorder + this.titleHeight) {
                        this.title.paint(leftBorder, topBorder, leftBorder, rightBorder, g);
                    }
                    topHeight += this.titleHeight;
                }
                if (this.subTitle != null) {
                    this.subTitle.paint(leftBorder, topHeight, leftBorder, rightBorder, g);
                    this.subTitle.relativeY = topHeight;
                    topHeight += this.subTitleHeight;
                }
                int infoItemY = topHeight;
                this.paintScreen(g);
                if (this.container != null && this.container.itemHeight > this.contentHeight) {
                    int scrollX;
                    this.scrollBar.relativeX = scrollX = rightBorder - this.scrollBar.initScrollBar(sWidth, this.contentHeight, this.container.itemHeight, this.container.yOffset, this.container.internalY, this.container.internalHeight, this.container.focusedIndex, this.container.size());
                    this.scrollBar.relativeY = this.container.relativeY;
                    this.scrollBar.paint(scrollX, this.scrollBar.relativeY + borderWidth, scrollX, rightBorder, g);
                }
                if (this.showInfoItem) {
                    this.infoItem.paint(this.marginLeft, infoItemY, this.marginLeft, rightBorder, g);
                }
                int bottomY = this.contentY + this.contentHeight;
                if (this.border != null) {
                    this.border.paint(leftBorder - borderWidth, topBorder - borderWidth, sWidth + (borderWidth << 1), sHeight + (borderWidth << 1), g);
                }
                int menuLeftX = 0;
                int menuRightX = this.screenWidth;
                int menuY = this.screenHeight;
                this.menuBar.paint(menuLeftX, menuY, menuLeftX, menuRightX, g);
            }
            catch (RuntimeException e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 2037, (Object)("unable to paint screen (" + this.getClass().getName() + "):"), e);
            }
        }
    }

    protected void paintScreen(Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int y = this.contentY;
        int x = this.contentX;
        int height = this.contentHeight;
        int width = this.contentWidth;
        int containerHeight = this.container.getItemHeight(width, width);
        g.clipRect(x, y, width, height);
        if (g.getClipHeight() > 0) {
            if (containerHeight <= this.container.availableHeight) {
                if (this.isLayoutVCenter) {
                    y += height - containerHeight >> 1;
                } else if (this.isLayoutBottom) {
                    y += height - containerHeight;
                }
            }
            int containerWidth = this.container.itemWidth;
            if (this.isLayoutCenter) {
                int diff = width - containerWidth >> 1;
                x += diff;
                width -= width - containerWidth;
            } else if (this.isLayoutRight) {
                int diff = width - containerWidth;
                x += diff;
                width -= diff;
            }
            this.container.relativeX = x;
            this.container.relativeY = y;
            this.container.paint(x, y, x, x + width, g);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        if (!(this.title instanceof StringItem)) {
            return null;
        }
        return ((StringItem)this.title).getText();
    }

    public void setTitle(String s) {
        this.setTitle(s, null);
    }

    public void setTitle(String text, Style tStyle) {
        if (text != null) {
            this.title = new StringItem(null, text, StyleSheet.titleStyle);
            this.title.screen = this;
            if (tStyle != null) {
                this.title.setStyle(tStyle);
            }
        } else {
            this.title = null;
            this.titleHeight = 0;
        }
        if (this.isInitialized && MasterCanvas.isDisplayableShown((Displayable)this)) {
            if (this.title != null) {
                int width = this.screenWidth - this.marginLeft - this.marginRight;
                if (this.border != null) {
                    width -= this.border.borderWidth << 1;
                }
                this.titleHeight = this.title.getItemHeight(width, width);
            }
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            this.requestRepaint();
        }
    }

    public void setTitle(Item item) {
        this.title = item;
        if (item != null) {
            int width = this.screenWidth - (this.marginLeft + this.marginRight);
            if (width > 1) {
                this.titleHeight = this.title.getItemHeight(width, width);
            }
            item.screen = this;
        } else {
            this.titleHeight = 0;
        }
        if (this.isInitialized && MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
            this.requestRepaint();
        }
    }

    public void setInfo(String infoText) {
        if (this.infoItem == null) {
            this.infoItem = new StringItem(null, infoText, StyleSheet.infoStyle);
            this.infoItem.screen = this;
        } else {
            this.infoItem.setText(infoText);
        }
        int previousHeight = this.infoHeight;
        if (infoText == null) {
            this.infoHeight = 0;
            this.showInfoItem = false;
        } else if (this.screenWidth != 0) {
            this.infoHeight = this.infoItem.getItemHeight(this.screenWidth, this.screenWidth);
            this.showInfoItem = true;
        }
        if (this.infoHeight != previousHeight) {
            this.requestInit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void keyPressed(int keyCode) {
        this.lastInteractionTime = System.currentTimeMillis();
        Object object = this.paintLock;
        synchronized (object) {
            try {
                this.ignoreRepaintRequests = true;
                int gameAction = -1;
                try {
                    gameAction = this.getGameAction(keyCode);
                }
                catch (Exception e) {
                    Debug.debug("warn", "de.enough.polish.ui.Screen", 2499, (Object)("Unable to get game action for key code " + keyCode + ": "), e);
                }
                boolean processed = false;
                boolean letTheMenuBarProcessKey = this.menuBar.isOpened;
                if (!letTheMenuBarProcessKey) {
                    processed = this.handleKeyPressed(keyCode, gameAction);
                }
                if (!processed) {
                    if (this.menuBar.handleKeyPressed(keyCode, gameAction)) {
                        MasterCanvas.repaintCanvas(this);
                        return;
                    }
                    if (this.menuBar.isSoftKeyPressed) {
                        return;
                    }
                }
                if (!processed) {
                    if (!this.isRepaintRequested) return;
                }
                this.isRepaintRequested = false;
                if (gameAction == 1 || gameAction == 6) {
                    this.scrollBar.resetAnimation();
                }
                this.notifyScreenStateChanged();
                MasterCanvas.repaintCanvas(this);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 2656, (Object)"keyPressed() threw an exception", e);
            }
            finally {
                this.ignoreRepaintRequests = false;
                this.isScreenChangeDirtyFlag = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyRepeated(int keyCode) {
        try {
            this.ignoreRepaintRequests = true;
            this.lastInteractionTime = System.currentTimeMillis();
            int gameAction = 0;
            try {
                gameAction = this.getGameAction(keyCode);
            }
            catch (Exception e) {
                Debug.debug("warn", "de.enough.polish.ui.Screen", 2687, (Object)("Unable to get game action for key code " + keyCode + ": "), e);
            }
            if (this.menuBar.handleKeyRepeated(keyCode, gameAction)) {
                MasterCanvas.repaintCanvas(this);
                return;
            }
            if (this.menuBar.isOpened) {
                return;
            }
            boolean handled = this.handleKeyRepeated(keyCode, gameAction);
            if (handled || this.isRepaintRequested) {
                this.isRepaintRequested = false;
                MasterCanvas.repaintCanvas(this);
            }
        }
        finally {
            this.ignoreRepaintRequests = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(int keyCode) {
        boolean processed = false;
        try {
            Object object = this.paintLock;
            synchronized (object) {
                int gameAction;
                block15: {
                    this.ignoreRepaintRequests = true;
                    this.lastInteractionTime = System.currentTimeMillis();
                    gameAction = 0;
                    try {
                        gameAction = this.getGameAction(keyCode);
                    }
                    catch (Exception e) {
                        Debug.debug("warn", "de.enough.polish.ui.Screen", 2746, (Object)("Unable to get game action for key code " + keyCode + ": "), e);
                    }
                    if (!this.isMenuOpened()) break block15;
                    processed = this.menuBar.handleKeyReleased(keyCode, gameAction);
                    if (processed) {
                        MasterCanvas.repaintCanvas(this);
                    }
                    return;
                }
                processed = this.handleKeyReleased(keyCode, gameAction);
                if (!this.isMenuOpened() && !processed) {
                    processed = this.menuBar.handleKeyReleased(keyCode, gameAction);
                }
                if (!processed && gameAction == 8 && keyCode != 53 && this.okCommand != null && !this.isMenuOpened()) {
                    this.callCommandListener(this.okCommand);
                    processed = true;
                }
                int clearKey = -8;
                if (!processed && keyCode == clearKey && this.cancelCommand != null) {
                    this.callCommandListener(this.cancelCommand);
                    processed = true;
                }
                if (processed || this.isRepaintRequested) {
                    this.isRepaintRequested = false;
                    MasterCanvas.repaintCanvas(this);
                }
            }
        }
        finally {
            this.ignoreRepaintRequests = false;
        }
    }

    protected abstract String createCssSelector();

    protected Item[] getRootItems() {
        return new Item[0];
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.container == null) {
            return false;
        }
        return this.container.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        if (this.container == null) {
            return false;
        }
        return this.container.handleKeyRepeated(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        if (this.container == null) {
            return false;
        }
        return this.container.handleKeyReleased(keyCode, gameAction);
    }

    public void setScreenStateListener(ScreenStateListener listener) {
        this.screenStateListener = listener;
    }

    public void notifyScreenStateChanged() {
        if (this.screenStateListener != null && !this.isScreenChangeDirtyFlag) {
            this.isScreenChangeDirtyFlag = true;
            this.screenStateListener.screenStateChanged(this);
        }
    }

    public void setCommandListener(CommandListener listener) {
        this.realCommandListener = listener;
    }

    public CommandListener getCommandListener() {
        return this.realCommandListener;
    }

    public void addCommand(Command cmd) {
        Style menuItemStyle = this.menuBar.getMenuItemStyle();
        if (menuItemStyle != null) {
            this.addCommand(cmd, menuItemStyle);
        } else {
            this.addCommand(cmd, StyleSheet.menuitemStyle);
        }
    }

    public void addCommand(Command cmd, Style commandStyle) {
        int cmdType = cmd.getCommandType();
        if (cmdType == 4 && (this.okCommand == null || this.okCommand.getPriority() > cmd.getPriority())) {
            this.okCommand = cmd;
        } else if (cmdType == 3 && (this.cancelCommand == null || this.cancelCommand.getPriority() > cmd.getPriority())) {
            this.cancelCommand = cmd;
        }
        this.menuBar.addCommand(cmd, commandStyle);
        if (this.isInitialized) {
            this.initMenuBar();
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.requestRepaint();
        }
    }

    public CommandItem getCommandItem(Command command) {
        CommandItem commandItem = null;
        commandItem = this.menuBar.getCommandItem(command);
        return commandItem;
    }

    public void removeAllCommands() {
        this.menuBar.removeAllCommands();
        if (this.isInitialized) {
            this.initMenuBar();
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.requestRepaint();
        }
    }

    public void addSubCommand(Command child, Command parent) {
        this.addSubCommand(child, parent, StyleSheet.menuitemStyle);
    }

    public void addSubCommand(Command child, Command parent, Style commandStyle) {
        this.menuBar.addSubCommand(child, parent, commandStyle);
        if (MasterCanvas.isDisplayableShown((Displayable)this) || this.isMenuOpened()) {
            this.requestRepaint();
        }
    }

    public void removeCommand(Command cmd) {
        this.menuBar.removeCommand(cmd);
        if (this.isInitialized) {
            this.initMenuBar();
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.requestRepaint();
        }
    }

    private void initMenuBar() {
        int availableWidth = this.screenWidth;
        int previousHeight = this.menuBar.itemHeight;
        int height = this.menuBar.getSpaceBottom(availableWidth, this.fullScreenHeight);
        if (height != previousHeight) {
            this.menuBarHeight = height;
            this.menuBar.relativeY = this.screenHeight = this.fullScreenHeight - height;
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
    }

    protected void setItemCommands(ArrayList commandsList, Item item) {
        Command cmd;
        this.focusedItem = item;
        if (commandsList != null) {
            Command command;
            Object[] commands = commandsList.getInternalArray();
            if (this.itemCommands == null) {
                this.itemCommands = new ArrayList(commands.length);
            } else {
                if (this.itemCommands.size() > 0) {
                    this.removeItemCommands(item);
                }
                this.itemCommands.clear();
            }
            for (int i = 0; i < commands.length && (command = (Command)commands[i]) != null; ++i) {
                boolean addCommand;
                boolean bl = addCommand = !this.menuBar.contains(command);
                if (!addCommand) continue;
                this.addCommand(command);
                this.itemCommands.add(command);
            }
        } else if (this.itemCommands != null) {
            this.itemCommands.clear();
        }
        if ((cmd = this.getDefaultCommand(item)) != null) {
            this.menuBar.informDefaultCommand(cmd);
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.requestRepaint();
        }
    }

    protected Command getDefaultCommand(Item item) {
        return item.defaultCommand;
    }

    protected void removeItemCommands(Item item) {
        if (this.itemCommands != null) {
            Command command;
            Object[] commands = this.itemCommands.getInternalArray();
            for (int i = 0; i < commands.length && (command = (Command)commands[i]) != null; ++i) {
                this.menuBar.removeCommand(command);
            }
        }
        if (this.menuBar.size() == 0) {
            this.menuBarHeight = 0;
        }
        if (this.focusedItem == item) {
            this.focusedItem = null;
        }
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            this.requestRepaint();
        }
    }

    protected void callCommandListener(Command cmd) {
        this.menuBar.setOpen(false);
        if (this.forwardCommandListener != null) {
            try {
                this.forwardCommandListener.commandAction(cmd, (Displayable)this);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 3546, (Object)("Screen: unable to process command [" + cmd.getLabel() + "]"), e);
            }
        }
    }

    public int getAvailableHeight() {
        return this.screenHeight - this.titleHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleCommand(Command cmd) {
        try {
            Item item = this.container;
            if (item == null) {
                item = this.getCurrentItem();
            }
            if (item != null && item.handleCommand(cmd)) {
                boolean bl = true;
                return bl;
            }
            if (this.realCommandListener != null) {
                this.realCommandListener.commandAction(cmd, (Displayable)this);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.requestInit();
        }
        return false;
    }

    public void setFullScreenMode(boolean enable) {
        this.showTitleOrMenu = !enable;
        this.screenHeight = enable ? this.fullScreenHeight : this.originalScreenHeight;
        this.requestRepaint();
    }

    public void sizeChanged(int width, int height) {
        boolean doInit;
        if (this.paintLock == null) {
            return;
        }
        if (MasterCanvas.instance == null || MasterCanvas.getScreenHeight() != height || MasterCanvas.getScreenWidth() != width) {
            return;
        }
        boolean bl = doInit = width != this.screenWidth || height != this.fullScreenHeight;
        if (doInit) {
            this.fullScreenHeight = height;
            this.originalScreenHeight = this.screenHeight = height - this.menuBarHeight;
            this.screenWidth = width;
        }
        if (doInit) {
            if (this.container != null) {
                this.container.requestFullInit();
            }
            if (this.title != null) {
                this.title.isInitialized = false;
            }
            this.menuBar.isInitialized = false;
            this.init(width, height);
        }
    }

    public int getScreenHeight() {
        int result = this.fullScreenHeight;
        return result;
    }

    public void focus(Item item) {
        this.focus(item, false);
    }

    public void focus(Item item, boolean force) {
        int index;
        if (item == null) {
            index = -1;
        } else {
            index = this.container.itemsList.indexOf(item);
            if (index == -1) {
                ArrayList children = new ArrayList();
                children.add(item);
                Item parent = item.parent;
                while (parent != null) {
                    if (parent.parent == this.container && (index = this.container.itemsList.indexOf(parent)) != -1) {
                        this.focus(index, parent, force);
                        for (int i = children.size() - 1; i >= 0; --i) {
                            Item child = (Item)children.get(i);
                            if (child.appearanceMode == 0 && !force) {
                                return;
                            }
                            Container parentContainer = (Container)child.parent;
                            parentContainer.focus(parentContainer.indexOf(child), child, 0);
                        }
                        return;
                    }
                    children.add(parent);
                    parent = parent.parent;
                }
            }
        }
        this.focus(index, item, force);
    }

    public void focus(int index) {
        this.focus(index, false);
    }

    public void focus(int index, boolean force) {
        Item item = null;
        if (index != -1) {
            item = this.container.get(index);
        }
        this.focus(index, item, force);
    }

    public void focus(int index, Item item, boolean force) {
        if (index != -1 && item != null && (item.appearanceMode != 0 || force)) {
            this.container.focus(index, item, 0);
            if (index == 0) {
                this.container.setScrollYOffset(0, false);
            }
        } else if (index == -1) {
            this.container.focus(-1);
        } else {
            Debug.debug("warn", "de.enough.polish.ui.Screen", 4079, (Object)("Screen: unable to focus item (did not find it in the container or is not activatable): index=" + index + ", item="), item);
        }
    }

    protected void setSubTitle(Item subTitle) {
        this.subTitle = subTitle;
        if (subTitle == null) {
            this.subTitleHeight = 0;
        } else {
            subTitle.screen = this;
        }
        if (this.isInitialized) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
    }

    public boolean isShown() {
        return StyleSheet.currentScreen == this && MasterCanvas.instance != null && MasterCanvas.isDisplayableShown((Displayable)MasterCanvas.instance);
    }

    public Item getCurrentItem() {
        if (this.container != null) {
            if (this.container.autoFocusEnabled) {
                Item[] items = this.container.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (i < this.container.autoFocusIndex || items[i].appearanceMode == 0) continue;
                    return items[i];
                }
            }
            return this.container.focusedItem;
        }
        return this.focusedItem;
    }

    public int getCurrentIndex() {
        if (this.container != null) {
            return this.container.focusedIndex;
        }
        return -1;
    }

    public boolean isMenuOpened() {
        return this.menuBar.isOpened;
    }

    public void closeMenu() {
        this.menuBar.setOpen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        Object object = this.paintLock;
        synchronized (object) {
            if (this.background != null) {
                this.background.releaseResources();
            }
            if (this.container != null) {
                this.container.releaseResources();
            }
            this.menuBar.releaseResources();
            if (this.title != null) {
                this.title.releaseResources();
            }
            this.isResourcesReleased = true;
        }
    }

    public void scrollRelative(int amount) {
        if (this.container != null) {
            this.container.setScrollYOffset(this.container.getScrollYOffset() + amount);
            this.requestRepaint();
        }
    }

    public void setScreenData(Object data) {
        this.data = data;
    }

    public Object getScreenData() {
        return this.data;
    }

    public Item getItemAt(int x, int y) {
        Item item = null;
        item = this.menuBar.getItemAt(x - this.menuBar.relativeX, y - this.menuBar.relativeY);
        if (item != null) {
            return item;
        }
        if (this.container != null && (item = this.container.getItemAt(x - this.container.relativeX, y - this.container.relativeY)) != null) {
            return item;
        }
        if (this.title != null && (item = this.title.getItemAt(x - this.title.relativeX, y - this.title.relativeY)) != null) {
            return item;
        }
        return null;
    }

    public Style getScreenStyle() {
        return this.style;
    }

    public void setItemStateListener(ItemStateListener iListener) {
        this.itemStateListener = iListener;
    }

    protected void notifyStateListener(Item item) {
        if (this.itemStateListener != null) {
            try {
                this.itemStateListener.itemStateChanged(item);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Screen", 4389, (Object)("Unable to forward itemStateChanged event for listener " + this.itemStateListener), e);
            }
        }
    }

    protected boolean isKeyboardAccessible() {
        return false;
    }

    protected int getScrollBarWidth() {
        int width = 0;
        width = this.scrollBar.itemWidth;
        return width;
    }

    public int getScreenContentHeight() {
        if (this.contentHeight == 0) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        return this.contentHeight;
    }

    public int getScreenContentWidth() {
        if (this.contentHeight == 0) {
            this.calculateContentArea(0, 0, this.screenWidth, this.screenHeight);
        }
        return this.contentWidth;
    }

    public int getScreenFullHeight() {
        int height = MasterCanvas.getScreenHeight();
        if (height == 0) {
            height = this.getHeight();
        }
        return height;
    }

    public int getScreenFullWidth() {
        int width = MasterCanvas.getScreenWidth();
        if (width == 0) {
            width = this.getWidth();
        }
        return width;
    }

    public void setMenuItemStyle(Style menuItemStyle) {
        this.menuBar.setMenuItemStyle(menuItemStyle);
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public void setMenuBarStyle(Style menuBarStyle) {
        this.menuBar.setStyle(menuBarStyle);
        this.requestInit();
    }

    public int getScrollYOffset() {
        if (this.container != null) {
            return this.container.getScrollYOffset();
        }
        return 0;
    }

    public void setScrollYOffset(int offset, boolean smooth) {
        if (this.container != null) {
            this.container.setScrollYOffset(offset, smooth);
        }
    }

    public void setScreenOrientation(int degrees) {
    }

    public boolean isGameActionFire(int keyCode, int gameAction) {
        return gameAction == 8 && keyCode != 53;
    }

    public final boolean isSoftKeyLeft(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        int expected = -6;
        boolean result = keyCode == expected;
        return result;
    }

    public final boolean isSoftKeyRight(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        int expected = -7;
        boolean result = keyCode == expected;
        return result;
    }

    public final boolean isSoftKeyMiddle(int keyCode, int gameAction) {
        if (gameAction == 2 || gameAction == 5 || gameAction == 1 || gameAction == 6) {
            return false;
        }
        int expected = -5;
        return keyCode == expected;
    }

    public boolean isSoftKey(int keyCode) {
        int gameAction = 0;
        try {
            gameAction = this.getGameAction(keyCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isSoftKey(keyCode, gameAction);
    }

    public boolean isSoftKey(int keyCode, int gameAction) {
        return this.isSoftKeyLeft(keyCode, gameAction) || this.isSoftKeyRight(keyCode, gameAction) || this.isSoftKeyMiddle(keyCode, gameAction);
    }

    class ForwardCommandListener
    implements CommandListener {
        public CommandListener realCommandListener;

        ForwardCommandListener() {
        }

        public void commandAction(Command cmd, Displayable thisScreen) {
            Screen.this.handleCommand(cmd);
        }
    }
}

