/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.TextUtil;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class StringItem
extends Item {
    private static final int DIRECTION_BACK_AND_FORTH = 0;
    private static final int DIRECTION_LEFT = 1;
    private static final int DIRECTION_RIGHT = 2;
    protected String text;
    protected String[] textLines;
    protected int textColor;
    protected Font font;
    protected boolean useSingleLine;
    protected boolean clipText;
    protected int xOffset;
    private int textWidth;
    private boolean isHorizontalAnimationDirectionRight;
    protected boolean animateTextWrap = true;
    protected TextEffect textEffect;

    public StringItem(String label, String text) {
        this(label, text, 0);
    }

    public StringItem(String label, String text, Style style) {
        this(label, text, 0, style);
    }

    public StringItem(String label, String text, int appearanceMode) {
        this(label, text, appearanceMode, null);
    }

    public StringItem(String label, String text, int appearanceMode, Style style) {
        super(label, 0, appearanceMode, style);
        this.text = text;
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (this.animateTextWrap && this.useSingleLine && this.clipText) {
            int speed = 1;
            if (this.isHorizontalAnimationDirectionRight) {
                this.xOffset += speed;
                if (this.xOffset >= 0) {
                    this.isHorizontalAnimationDirectionRight = false;
                }
            } else {
                this.xOffset -= speed;
                if (this.xOffset + this.textWidth < this.contentWidth) {
                    this.isHorizontalAnimationDirectionRight = true;
                }
            }
            this.addRelativeToContentRegion(repaintRegion, 0, 0, this.contentWidth, this.contentHeight);
        }
        if (this.textEffect != null) {
            this.textEffect.animate(this, currentTime, repaintRegion);
        }
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
        if (this.clipText) {
            this.xOffset = 0;
        }
    }

    protected void hideNotify() {
        if (this.textEffect != null) {
            this.textEffect.hideNotify();
        }
        super.hideNotify();
    }

    protected void showNotify() {
        if (this.textEffect != null) {
            this.textEffect.showNotify();
        }
        super.showNotify();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.setText(text, null);
    }

    public void setText(String text, Style style) {
        if (style != null) {
            this.setStyle(style);
        }
        this.text = text;
        if (text == null) {
            this.textLines = null;
        }
        this.requestInit();
    }

    public void setTextColor(int color) {
        this.textColor = color;
    }

    public void setFont(Font font) {
        this.font = font;
        this.isInitialized = false;
    }

    public Font getFont() {
        if (this.font == null) {
            if (this.style != null) {
                this.font = this.style.font;
            }
            if (this.font == null) {
                this.font = Font.getDefaultFont();
            }
        }
        return this.font;
    }

    public void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (this.text != null) {
            int clipX = 0;
            int clipY = 0;
            int clipWidth = 0;
            int clipHeight = 0;
            if (this.useSingleLine && this.clipText) {
                clipX = g.getClipX();
                clipY = g.getClipY();
                clipWidth = g.getClipWidth();
                clipHeight = g.getClipHeight();
                g.clipRect(x, y, this.contentWidth, this.contentHeight);
            }
            g.setFont(this.font);
            g.setColor(this.textColor);
            int lineHeight = this.getFontHeight() + this.paddingVertical;
            int centerX = 0;
            if (this.isLayoutCenter) {
                centerX = leftBorder + (rightBorder - leftBorder) / 2;
            }
            if (this.textEffect != null) {
                if (this.useSingleLine && this.clipText) {
                    this.textEffect.drawStrings(this.textLines, this.textColor, x += this.xOffset, y, leftBorder, rightBorder, lineHeight, this.contentWidth, 20, g);
                } else {
                    this.textEffect.drawStrings(this.textLines, this.textColor, x, y, leftBorder, rightBorder, lineHeight, this.contentWidth, this.layout, g);
                }
            } else {
                for (int i = 0; i < this.textLines.length; ++i) {
                    int orientation;
                    String line = this.textLines[i];
                    int lineX = x;
                    int lineY = y;
                    if (this.isLayoutRight) {
                        lineX = rightBorder;
                        orientation = 24;
                    } else if (this.isLayoutCenter) {
                        lineX = centerX;
                        orientation = 17;
                    } else {
                        orientation = 20;
                    }
                    if (this.clipText) {
                        orientation = 20;
                        lineX = x + this.xOffset;
                    }
                    g.drawString(line, lineX, lineY, orientation);
                    x = leftBorder;
                    y += lineHeight;
                }
            }
            if (this.useSingleLine && this.clipText) {
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        }
    }

    public int stringWidth(String str) {
        if (this.textEffect != null) {
            return this.textEffect.stringWidth(str);
        }
        return this.getFont().stringWidth(str);
    }

    public int getFontHeight() {
        if (this.textEffect != null) {
            return this.textEffect.getFontHeight();
        }
        return this.getFont().getHeight();
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        if (this.text != null && this.font == null) {
            this.font = Font.getDefaultFont();
        }
        if (this.text == null) {
            this.contentHeight = 0;
            this.contentWidth = 0;
            this.textLines = null;
            return;
        }
        if (this.useSingleLine) {
            this.textLines = new String[]{this.text};
            int myTextWidth = this.stringWidth(this.text);
            if (myTextWidth > lineWidth) {
                this.clipText = true;
                this.textWidth = myTextWidth;
                this.isHorizontalAnimationDirectionRight = false;
                this.contentWidth = lineWidth;
            } else {
                this.clipText = false;
                this.contentWidth = myTextWidth;
            }
            this.contentHeight = this.getFontHeight();
        } else {
            String[] lines = this.textEffect != null ? this.textEffect.wrap(this.text, this.font, firstLineWidth, lineWidth) : TextUtil.wrap(this.text, this.font, firstLineWidth, lineWidth);
            int fontHeight = this.getFontHeight();
            this.contentHeight = lines.length * (fontHeight + this.paddingVertical) - this.paddingVertical;
            int maxWidth = 0;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int width = this.stringWidth(line);
                if (width <= maxWidth) continue;
                maxWidth = width;
            }
            this.contentWidth = maxWidth;
            this.textLines = lines;
        }
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.textColor = style.getFontColor();
        this.font = style.font;
        TextEffect effect = (TextEffect)style.getObjectProperty(88);
        if (effect != null) {
            this.textEffect = effect;
            effect.setStyle(style);
        } else {
            this.textEffect = null;
        }
        Boolean textWrapBool = style.getBooleanProperty(150);
        if (textWrapBool != null) {
            this.useSingleLine = textWrapBool == false;
        }
    }

    protected String createCssSelector() {
        if (this.appearanceMode == 2) {
            return "button";
        }
        if (this.appearanceMode == 1) {
            return "a";
        }
        return "p";
    }

    public String toString() {
        return "StringItem " + super.toString() + ": \"" + this.getText() + "\"";
    }

    public void releaseResources() {
        super.releaseResources();
        if (this.textEffect != null) {
            this.textEffect.releaseResources();
        }
    }
}

