/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class BallBackground
extends Background {
    private transient int[][] directionArray = new int[][]{{1, 5, 8}, {3, 7, 8}, {2, 5, 6}, {4, 6, 7}};
    private int color;
    private int borderColor;
    private int roundWidth;
    private int roundHeight;
    private int number;
    private transient Random random;
    private boolean gameover;
    private int[] changeX;
    private int[] changeY;
    private int[] detective;
    private int width;
    private int height;
    private int[] direction;
    private transient Sprite[] sprite;
    private String url;

    public BallBackground() {
        this.random = new Random();
    }

    public BallBackground(int color, int borderColor, String url, int roundWidth, int roundHeight, int number) {
        this.color = color;
        this.borderColor = borderColor;
        this.url = url;
        this.roundWidth = roundWidth;
        this.roundHeight = roundHeight;
        this.number = number;
        this.sprite = new Sprite[number];
        this.changeX = new int[number];
        this.changeY = new int[number];
        this.detective = new int[number];
        this.direction = new int[number];
        this.random = new Random();
        Sprite s = null;
        int a = 0;
        try {
            Image image = Image.createImage((String)url);
            s = new Sprite(image, this.roundWidth, this.roundHeight);
            a = image.getHeight() / this.roundHeight + image.getWidth() / this.roundWidth;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < this.number; ++i) {
            this.sprite[i] = new Sprite(s);
            this.changeX[i] = i * 2;
            this.changeY[i] = i;
            this.detective[i] = 0;
            this.direction[i] = 2;
            this.sprite[i].setFrame(i % a);
        }
    }

    public void changeDirection(int id) {
        do {
            this.direction[id] = Math.abs(this.random.nextInt()) % 9;
        } while (this.direction[id] < 1 || this.direction[id] != this.directionArray[this.detective[id]][0] && this.direction[id] != this.directionArray[this.detective[id]][1] && this.direction[id] != this.directionArray[this.detective[id]][2]);
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        this.width = width;
        this.height = height;
        g.setColor(this.color);
        g.fillRect(x, y, width, height);
        g.setColor(this.borderColor);
        g.drawRect(x, y, width, height);
        for (int i = 0; i < this.number; ++i) {
            this.sprite[i].setPosition(this.changeX[i] + x, this.changeY[i] + y);
            this.sprite[i].paint(g);
        }
    }

    private void outbounds() {
        for (int i = 0; i < this.number; ++i) {
            if (this.changeX[i] <= 0) {
                this.detective[i] = 3;
                this.changeDirection(i);
                continue;
            }
            if (this.changeX[i] + this.roundWidth >= this.width) {
                this.detective[i] = 0;
                this.changeDirection(i);
                continue;
            }
            if (this.changeY[i] <= 0) {
                this.detective[i] = 1;
                this.changeDirection(i);
                continue;
            }
            if (this.changeY[i] + this.roundHeight < this.height) continue;
            this.detective[i] = 2;
            this.changeDirection(i);
        }
    }

    public boolean animate() {
        this.outbounds();
        for (int i = 0; i < this.number; ++i) {
            switch (this.direction[i]) {
                case 1: {
                    int n = i;
                    this.changeX[n] = this.changeX[n] - 1;
                    this.sprite[i].setTransform(2);
                    break;
                }
                case 2: {
                    int n = i;
                    this.changeY[n] = this.changeY[n] - 1;
                    this.sprite[i].setTransform(7);
                    break;
                }
                case 3: {
                    int n = i;
                    this.changeY[n] = this.changeY[n] + 1;
                    this.sprite[i].setTransform(5);
                    break;
                }
                case 4: {
                    int n = i;
                    this.changeX[n] = this.changeX[n] + 1;
                    this.sprite[i].setTransform(0);
                    break;
                }
                case 5: {
                    int n = i;
                    this.changeX[n] = this.changeX[n] - 1;
                    int n2 = i;
                    this.changeY[n2] = this.changeY[n2] - 1;
                    this.sprite[i].setTransform(7);
                    break;
                }
                case 6: {
                    int n = i;
                    this.changeY[n] = this.changeY[n] - 1;
                    int n3 = i;
                    this.changeX[n3] = this.changeX[n3] + 1;
                    this.sprite[i].setTransform(7);
                    break;
                }
                case 7: {
                    int n = i;
                    this.changeY[n] = this.changeY[n] + 1;
                    int n4 = i;
                    this.changeX[n4] = this.changeX[n4] + 1;
                    this.sprite[i].setTransform(5);
                    break;
                }
                case 8: {
                    int n = i;
                    this.changeX[n] = this.changeX[n] - 1;
                    int n5 = i;
                    this.changeY[n5] = this.changeY[n5] + 1;
                    this.sprite[i].setTransform(5);
                }
            }
            this.sprite[i].nextFrame();
        }
        return !this.gameover;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.borderColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.changeX = new int[n2];
            n = 0;
            while (n < n2) {
                this.changeX[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.changeY = new int[n2];
            n = 0;
            while (n < n2) {
                this.changeY[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.color = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.detective = new int[n2];
            n = 0;
            while (n < n2) {
                this.detective[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.direction = new int[n2];
            n = 0;
            while (n < n2) {
                this.direction[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.gameover = dataInputStream.readBoolean();
        this.height = dataInputStream.readInt();
        this.number = dataInputStream.readInt();
        this.roundHeight = dataInputStream.readInt();
        this.roundWidth = dataInputStream.readInt();
        this.url = (String)Serializer.deserialize(dataInputStream);
        this.width = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.borderColor);
        if (this.changeX == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.changeX.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.changeX[n]);
                ++n;
            }
        }
        if (this.changeY == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.changeY.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.changeY[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.color);
        if (this.detective == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.detective.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.detective[n]);
                ++n;
            }
        }
        if (this.direction == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.direction.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.direction[n]);
                ++n;
            }
        }
        dataOutputStream.writeBoolean(this.gameover);
        dataOutputStream.writeInt(this.height);
        dataOutputStream.writeInt(this.number);
        dataOutputStream.writeInt(this.roundHeight);
        dataOutputStream.writeInt(this.roundWidth);
        Serializer.serialize(this.url, dataOutputStream);
        dataOutputStream.writeInt(this.width);
    }
}

