/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class GradientVerticalBackground
extends Background {
    private int topColor;
    private int bottomColor;
    private int stroke;
    private int start;
    private int end;
    private boolean isPercent;
    private int[] gradient;
    private int lastHeight;
    private int startLine;
    private int endLine;

    public GradientVerticalBackground(int topColor, int bottomColor, int stroke) {
        this(topColor, bottomColor, stroke, 0, 0, false);
    }

    public GradientVerticalBackground(int topColor, int bottomColor, int stroke, int start, int end, boolean isPercent) {
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.stroke = stroke;
        this.start = start;
        this.end = end;
        this.isPercent = isPercent;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        --width;
        g.setStrokeStyle(this.stroke);
        int startOffset = this.startLine;
        int endOffset = this.endLine;
        if (this.gradient == null || this.lastHeight != height) {
            int steps = height;
            if (this.start != this.end) {
                steps = this.end - this.start;
                if (this.isPercent) {
                    this.startLine = this.start * height / 100;
                    this.endLine = this.end * height / 100;
                    steps = this.endLine - this.startLine;
                } else {
                    this.startLine = this.start;
                    this.endLine = this.end;
                }
                startOffset = this.startLine;
                endOffset = this.endLine;
            } else {
                this.endLine = height;
                endOffset = height;
            }
            this.gradient = DrawUtil.getGradient(this.topColor, this.bottomColor, steps);
            this.lastHeight = height;
        }
        g.setColor(this.topColor);
        for (int i = 0; i < height; ++i) {
            if (i >= startOffset && i < endOffset) {
                int color = this.gradient[i - startOffset];
                g.setColor(color);
            }
            g.drawLine(x, y, x + width, y);
            ++y;
        }
        g.setStrokeStyle(0);
    }

    public GradientVerticalBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomColor = dataInputStream.readInt();
        this.end = dataInputStream.readInt();
        this.endLine = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.gradient = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.gradient[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.isPercent = dataInputStream.readBoolean();
        this.lastHeight = dataInputStream.readInt();
        this.start = dataInputStream.readInt();
        this.startLine = dataInputStream.readInt();
        this.stroke = dataInputStream.readInt();
        this.topColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomColor);
        dataOutputStream.writeInt(this.end);
        dataOutputStream.writeInt(this.endLine);
        if (this.gradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.gradient.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.gradient[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeBoolean(this.isPercent);
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.start);
        dataOutputStream.writeInt(this.startLine);
        dataOutputStream.writeInt(this.stroke);
        dataOutputStream.writeInt(this.topColor);
    }
}

