/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalStripesBackground
extends Background {
    private int firstTopColor;
    private int firstBottomColor;
    private int secondTopColor;
    private int secondBottomColor;
    private int[] firstGradient;
    private int[] secondGradient;

    public HorizontalStripesBackground(int firstTopColor, int firstBottomColor, int secondTopColor, int secondBottomColor) {
        this.firstTopColor = firstTopColor;
        this.firstBottomColor = firstBottomColor;
        this.secondTopColor = secondTopColor;
        this.secondBottomColor = secondBottomColor;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (this.firstGradient == null || height >> 1 != this.firstGradient.length) {
            this.firstGradient = DrawUtil.getGradient(this.firstTopColor, this.firstBottomColor, height >> 1);
            this.secondGradient = DrawUtil.getGradient(this.secondTopColor, this.secondBottomColor, height >> 1);
        }
        int[] first = this.firstGradient;
        int[] second = this.secondGradient;
        int rightX = x + width;
        for (int i = 0; i < height >> 1; ++i) {
            int color = first[i];
            g.setColor(color);
            g.drawLine(x, y, rightX, y);
            color = second[i];
            g.setColor(color);
            g.drawLine(x, ++y, rightX, y);
            ++y;
        }
    }

    public HorizontalStripesBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.firstBottomColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.firstGradient = new int[n2];
            n = 0;
            while (n < n2) {
                this.firstGradient[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.firstTopColor = dataInputStream.readInt();
        this.secondBottomColor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.secondGradient = new int[n2];
            n = 0;
            while (n < n2) {
                this.secondGradient[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.secondTopColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.firstBottomColor);
        if (this.firstGradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.firstGradient.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.firstGradient[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.firstTopColor);
        dataOutputStream.writeInt(this.secondBottomColor);
        if (this.secondGradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.secondGradient.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.secondGradient[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.secondTopColor);
    }
}

