/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class SmoothColorBackground
extends Background {
    private int color;
    private int targetColor;
    private int stroke;

    public SmoothColorBackground(int color, int targetColor, int stroke) {
        this.color = color;
        this.targetColor = targetColor;
        this.stroke = stroke;
    }

    private synchronized int colorValue(int value1, int value2, int sumX, int sumY) {
        if (value1 != value2) {
            int woh = sumX <= sumY ? sumX : sumY;
            if (value1 < value2) {
                int sum = (value2 - value1) / woh;
                value1 += sum;
            } else {
                int sum = (value1 - value2) / woh;
                value1 -= sum;
            }
        }
        return value1;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setStrokeStyle(this.stroke);
        int startX = x;
        int startY = y;
        g.setColor(0);
        g.drawRect(x + 1, y + 1, width, height);
        int red = 0xFF & this.color >>> 16;
        int green = 0xFF & this.color >>> 8;
        int blue = this.color & 0xFF;
        int red2 = 0xFF & this.targetColor >>> 16;
        int green2 = 0xFF & this.targetColor >>> 8;
        int blue2 = this.targetColor & 0xFF;
        do {
            int sumX = width - (x - startX);
            int sumY = height - (y - startY);
            g.setColor(red, green, blue);
            g.drawRect(x, y, sumX, sumY);
            red = this.colorValue(red, red2, sumX, sumY);
            green = this.colorValue(green, green2, sumX, sumY);
            blue = this.colorValue(blue, blue2, sumX, sumY);
        } while ((red != red2 || green != green2 || blue != blue2) && ++x <= width + startX && ++y <= height + startY);
        g.setStrokeStyle(0);
    }

    public SmoothColorBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.color = dataInputStream.readInt();
        this.stroke = dataInputStream.readInt();
        this.targetColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.color);
        dataOutputStream.writeInt(this.stroke);
        dataOutputStream.writeInt(this.targetColor);
    }
}

