/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class SlideContainerView
extends ContainerView {
    private static final int DIRECTION_DOWN = 1;
    private static final int DIRECTION_LEFT = 2;
    private static final int DIRECTION_RIGHT = 3;
    private static final int DIRECTION_DIAGONAL_LEFTUP = 4;
    private static final int DIRECTION_DIAGONAL_RIGHTUP = 5;
    private static final int DIRECTION_DIAGONAL_LEFTDOWN = 6;
    private static final int DIRECTION_DIAGONAL_RIGHTDOWN = 7;
    private boolean isAnimationFinished;
    private int yOffset;
    private int xOffset;
    private int minSpeed = 2;
    private int maxSpeed = -1;
    private int duration = 1600;
    private long animationStartTime;

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        if (!this.isAnimationFinished) {
            int y = 0;
            y = this.calculateNext(this.yOffset, 0, currentTime, this.contentHeight);
            this.parentContainer.addRelativeToBackgroundRegion(repaintRegion, -2, y - 2, this.parentContainer.getBackgroundWidth() + 4, this.parentContainer.getBackgroundHeight() - y + 4);
            this.yOffset = y;
            if (y == 0) {
                this.isAnimationFinished = true;
            }
        }
    }

    protected int calculateNext(int current, int target, long currentTime, int completeDistance) {
        int next;
        boolean isDecrease;
        boolean isPositive = current > 0 || target > 0;
        int speed = isPositive ? Math.max(this.minSpeed, current / 3) : Math.max(this.minSpeed, -current / 3);
        if (this.maxSpeed != -1 && speed > this.maxSpeed) {
            speed = this.maxSpeed;
        }
        boolean bl = isDecrease = target < current;
        if (isDecrease) {
            next = current - speed;
            if (next < target) {
                next = target;
            }
        } else {
            next = current + speed;
            if (next > target) {
                next = target;
            }
        }
        if (this.duration != -1) {
            long timePassed = currentTime - this.animationStartTime;
            if (timePassed > (long)this.duration) {
                return target;
            }
            int timeDistance = (int)(timePassed * (long)completeDistance / (long)this.duration);
            if (isDecrease) {
                if (completeDistance - timeDistance < next) {
                    next = completeDistance - timeDistance;
                }
            } else if (timeDistance - completeDistance > next) {
                next = timeDistance - completeDistance;
            }
        }
        return next;
    }

    protected void initAnimation() {
        this.yOffset = this.contentHeight;
        this.restartAnimation = false;
        this.isAnimationFinished = false;
        this.animationStartTime = System.currentTimeMillis();
    }

    public void showNotify() {
        super.showNotify();
        if (this.contentHeight != 0) {
            this.initAnimation();
        }
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int lineWidth) {
        super.initContent(parentContainerItem, firstLineWidth, lineWidth);
        if (this.restartAnimation) {
            this.initAnimation();
        }
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        boolean setClip;
        boolean bl = setClip = this.yOffset != 0;
        if (setClip) {
            g.clipRect(x - 1, y - 1, rightBorder - leftBorder + 2, this.contentHeight + 2);
            int yOff = this.yOffset;
            g.clipRect(clipX, (y += this.yOffset) - 2, clipWidth, this.contentHeight - this.yOffset + 4);
        }
        super.paintContent(container, myItems, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
        if (setClip) {
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public void paintBackground(Background background, int x, int y, int width, int height, Graphics g) {
        int yOff = this.yOffset;
        super.paintBackground(background, x, y += yOff, width, height -= yOff, g);
    }

    public void paintBorder(Border border, int x, int y, int width, int height, Graphics g) {
        int yOff = this.yOffset;
        super.paintBorder(border, x, y += yOff, width, height -= yOff, g);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animationStartTime = dataInputStream.readLong();
        this.duration = dataInputStream.readInt();
        this.isAnimationFinished = dataInputStream.readBoolean();
        this.maxSpeed = dataInputStream.readInt();
        this.minSpeed = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeLong(this.animationStartTime);
        dataOutputStream.writeInt(this.duration);
        dataOutputStream.writeBoolean(this.isAnimationFinished);
        dataOutputStream.writeInt(this.maxSpeed);
        dataOutputStream.writeInt(this.minSpeed);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

