/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Material;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class Rotate3DScreenChangeAnimation
extends ScreenChangeAnimation {
    private float angle;
    private Graphics3D g3D;
    private Background background;
    private Camera camera;
    private Light light;
    private TriangleStripArray triangleStripArray;
    private VertexBuffer vertexBuffer;
    private Appearance appearance;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        int temp;
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
        this.g3D = Graphics3D.getInstance();
        this.camera = new Camera();
        this.camera.setPerspective(5.0f, (float)width / (float)height, 1.0f, 50.0f);
        this.light = new Light();
        this.light.setMode(128);
        byte[] verticies = new byte[]{1, 1, 1, -1, 1, 1, 1, -1, 1, -1, -1, 1, -1, 1, -1, 1, 1, -1, -1, -1, -1, 1, -1, -1, -1, 1, 1, -1, 1, -1, -1, -1, 1, -1, -1, -1, 1, 1, -1, 1, 1, 1, 1, -1, -1, 1, -1, 1, 1, 1, -1, -1, 1, -1, 1, 1, 1, -1, 1, 1, 1, -1, 1, -1, -1, 1, 1, -1, -1, -1, -1, -1};
        VertexArray vertArray = new VertexArray(verticies.length / 3, 3, 1);
        vertArray.set(0, verticies.length / 3, verticies);
        byte[] tex = new byte[]{1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1};
        VertexArray texArray = new VertexArray(tex.length / 2, 2, 1);
        texArray.set(0, tex.length / 2, tex);
        this.vertexBuffer = new VertexBuffer();
        this.vertexBuffer.setPositions(vertArray, 1.0f, null);
        this.vertexBuffer.setTexCoords(0, texArray, 1.0f, null);
        int[] stripLen = new int[]{4, 4, 4, 4, 4, 4};
        this.triangleStripArray = new TriangleStripArray(0, stripLen);
        Texture2D texture2D = null;
        Integer maxTexDimensionInt = (Integer)Graphics3D.getProperties().get("maxTextureDimension");
        int maxWidth = width;
        int maxHeight = height;
        if (maxTexDimensionInt != null) {
            int texDimension = maxTexDimensionInt;
            maxWidth = Math.min(width, texDimension);
            maxHeight = Math.min(height, texDimension);
        }
        for (temp = 64; temp < maxWidth; temp *= 2) {
        }
        maxWidth = temp / 2;
        for (temp = 64; temp < maxHeight; temp *= 2) {
        }
        maxHeight = temp / 2;
        Image textureImage = Image.createImage((int)128, (int)128);
        Graphics g = textureImage.getGraphics();
        g.drawImage(nxtScreenImage, 0, 0, 20);
        texture2D = new Texture2D(new Image2D(99, (Object)textureImage));
        Material material = new Material();
        material.setColor(1024, -1);
        PolygonMode polygonMode = new PolygonMode();
        polygonMode.setPerspectiveCorrectionEnable(true);
        this.appearance = new Appearance();
        this.appearance.setTexture(0, texture2D);
        this.appearance.setMaterial(material);
        this.appearance.setPolygonMode(polygonMode);
        this.background = new Background();
        this.background.setColor(0);
    }

    protected boolean animate() {
        this.angle += 4.0f;
        return this.angle < 90.0f;
    }

    public void paintAnimation(Graphics g) {
        this.g3D.bindTarget((Object)g);
        this.g3D.clear(this.background);
        Transform transform = new Transform();
        transform.postTranslate(0.0f, 0.0f, 50.0f);
        this.g3D.setCamera(this.camera, transform);
        this.g3D.resetLights();
        this.g3D.addLight(this.light, transform);
        transform.setIdentity();
        transform.postTranslate(0.0f, 0.0f, 1.0f);
        transform.postRotate(this.angle, 1.0f, 1.0f, 1.0f);
        this.g3D.render(this.vertexBuffer, (IndexBuffer)this.triangleStripArray, this.appearance, transform, -1);
        this.g3D.releaseTarget();
    }
}

