/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class VerticalFlashScreenChangeAnimation
extends ScreenChangeAnimation {
    private int currentY;
    private int currentSize;

    protected void setStyle(Style style) {
        super.setStyle(style);
        if (this.isForwardAnimation) {
            this.currentY = this.screenHeight / 2;
            this.currentSize = 0;
        } else {
            this.currentY = 0;
            this.currentSize = this.screenHeight;
        }
    }

    protected boolean animate() {
        int adjust = this.currentY / 3;
        if (adjust < 2) {
            adjust = 2;
        }
        if (this.isForwardAnimation) {
            if (this.currentY > 0) {
                this.currentY -= adjust;
                this.currentSize += adjust << 1;
                return true;
            }
        } else if (this.currentSize > 0) {
            this.currentY += adjust;
            this.currentSize -= adjust << 1;
            return true;
        }
        return false;
    }

    public void paintAnimation(Graphics g) {
        Image second;
        Image first;
        if (this.isForwardAnimation) {
            first = this.lastCanvasImage;
            second = this.nextCanvasImage;
        } else {
            first = this.nextCanvasImage;
            second = this.lastCanvasImage;
        }
        g.drawImage(first, 0, 0, 20);
        g.setColor(0);
        g.drawLine(0, this.currentY - 1, this.screenWidth, this.currentY - 1);
        g.drawLine(0, this.currentY + this.currentSize, this.screenWidth, this.currentY + this.currentSize);
        g.setClip(0, this.currentY, this.screenWidth, this.currentSize);
        g.drawImage(second, 0, 0, 20);
    }
}

