/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class FadeTextEffect
extends TextEffect {
    private transient DrawUtil.FadeUtil fader = new DrawUtil.FadeUtil();
    private String lastText;

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        if (this.lastText != text || text == null) {
            this.fader.changed = true;
            this.lastText = text;
        }
        if (this.fader.changed) {
            this.fader.step();
        }
        if (text == null) {
            return;
        }
        g.setColor(this.fader.cColor);
        g.drawString(text, x, y, orientation);
    }

    public boolean animate() {
        boolean animated = super.animate();
        if (this.lastText == null) {
            return animated;
        }
        return this.fader.step() | animated;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.fader.endColor = style.getFontColor();
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.lastText = (String)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.lastText, dataOutputStream);
    }
}

