/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.ui;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.control.thread.GetCityListThread;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.AddCityUI;
import com.myweather.ui.ChargeUI;
import com.myweather.ui.MainUI;
import com.myweather.util.BasicFunction;
import com.myweather.util.RmsUtility;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TableItem;
import de.enough.polish.util.Debug;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class SettingUI
extends Form
implements CommandListener {
    public MainUI mainUI;
    public ChoiceGroup cityGroup;
    public Vector searchResultList = new Vector();
    public TableItem table;
    StringItem si;
    public boolean addNewCity = false;
    public boolean deleteCity = false;
    public int cityNum = 0;

    public SettingUI(MainUI mainUI) {
        super("");
        this.mainUI = mainUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
    }

    public SettingUI(MainUI mainUI, Style style) {
        super("", style);
        this.mainUI = mainUI;
        this.setCommandListener(this);
        this.addCommand(CommandConstants.BACK);
        this.addCommand(CommandConstants.ADD_SET);
        this.si = new StringItem(null, "\u5df2\u5b9a\u5236\u57ce\u5e02\u5217\u8868", StyleSheet.inputlabelStyle);
        this.append(this.si);
        this.showOrderedCityList();
    }

    public void showOrderedCityList() {
        int[] customizeCityIds = BasicFunction.getCustomizeCityIds();
        this.cityNum = customizeCityIds.length;
        this.table = new TableItem(1, customizeCityIds.length + 1, StyleSheet.temperaturetableStyle);
        ImageItem imgItem = new ImageItem(null, GeneralConstants.NAWEATHER_IMAGE_S, 0, null);
        this.table.set(0, 0, imgItem);
        for (int i = 0; i < customizeCityIds.length; ++i) {
            this.table.set(0, i + 1, GeneralConstants.cityList[customizeCityIds[i]][1], StyleSheet.orderedcitycellStyle);
        }
        this.table.setSelectionMode(16);
        this.table.setLineStyle(TableItem.LINE_STYLE_INVISIBLE, 0);
        this.append(this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCity() {
        RecordStore cityRms = null;
        try {
            cityRms = RmsUtility.openRms("CITY_LIST", true);
            RecordEnumeration recordEnu = cityRms.enumerateRecords(null, null, false);
            int recordIndex = 1;
            while (recordEnu.hasPreviousElement()) {
                int recordIdOfCity = recordEnu.previousRecordId();
                if (recordIndex == this.table.getSelectedRow()) {
                    cityRms.deleteRecord(recordIdOfCity);
                }
                ++recordIndex;
            }
            this.deleteCity = true;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(cityRms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscribe() {
        RecordStore chargeRms = null;
        boolean isSuccess = false;
        try {
            chargeRms = RmsUtility.openRms("CHARGE_TYPE", true);
            RecordEnumeration recordEnu = chargeRms.enumerateRecords(null, null, false);
            byte[] data = BasicFunction.serialize("01/01/08");
            chargeRms.setRecord(1, data, 0, data.length);
            GeneralConstants.HEADER_MODEL = "Free";
        }
        catch (Exception e) {
            isSuccess = false;
            System.out.println("exception:" + e.getMessage());
        }
        finally {
            RmsUtility.closeRmsQuietly(chargeRms);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        if (this.isMenuOpened() || gameAction != 8) {
            if (keyCode == -8 && !GeneralConstants.IS_FREE && this.table.getSelectedRow() > 0) {
                MyWeatherMidlet.getInstance().midletControl.deleteCityAlert(this);
            } else {
                super.keyPressed(keyCode);
            }
        }
        if (this.table.getSelectedRow() == 0) {
            this.removeCommand(CommandConstants.DELETE);
            this.addCommand(CommandConstants.ADD_SET);
        } else {
            this.removeCommand(CommandConstants.ADD_SET);
            if (!GeneralConstants.IS_FREE) {
                this.addCommand(CommandConstants.DELETE);
            }
        }
    }

    public void commandAction(Command command, Displayable disp) {
        if (command == CommandConstants.BACK) {
            if (this.addNewCity) {
                this.mainUI.deleteAll();
                new GetCityListThread(this.mainUI, GeneralConstants.CURR_URL).start();
            } else if (this.deleteCity) {
                try {
                    this.mainUI.deleteAll();
                    new GetCityListThread(this.mainUI, GeneralConstants.CURR_URL).start();
                }
                catch (Exception e) {
                    Debug.debug("error", "com.myweather.ui.SettingUI", 216, e.getMessage());
                }
            } else {
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.mainUI);
            }
        }
        if (command == CommandConstants.DELETE) {
            MyWeatherMidlet.getInstance().midletControl.deleteCityAlert(this);
        }
        if (command == CommandConstants.UNSUBSCRIBE) {
            this.unSubscribe();
        }
        if (command == CommandConstants.OK) {
            this.deleteCity();
            this.delete(1);
            this.showOrderedCityList();
        }
        if (command == CommandConstants.ADD_SET) {
            int[] customizeCityIds = BasicFunction.getCustomizeCityIds();
            if (GeneralConstants.IS_FREE && customizeCityIds.length > 2) {
                ChargeUI chargeUI = new ChargeUI((Displayable)this, StyleSheet.addcityscreenStyle);
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)chargeUI);
            } else {
                AddCityUI addUI = new AddCityUI(this, StyleSheet.addcityscreenStyle);
                MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)addUI);
            }
        }
    }
}

