/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.util;

import com.myweather.util.BasicFunction;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class DateHelper {
    public static Date CURRENT_DATE = new Date();
    public static int CURRENT_YEAR = 2008;
    public static int CURRENT_MONTH = 1;
    public static int CURRENT_DAY_OF_MONTH = 1;

    public static Date getDateOf1970() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.set(5, 10);
        calendar.set(2, 7);
        calendar.set(1, 2009);
        return calendar.getTime();
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(date);
        int calendarMonth = cal.get(2);
        return DateHelper.calendarMonthToInt(calendarMonth);
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getHour(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(date);
        return cal.get(11);
    }

    public static int getMinute(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(date);
        return cal.get(12);
    }

    public static int getSecond(Date date) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(date);
        return cal.get(13);
    }

    public static Date convertStandardDateStringToLocal(String standardDateString) {
        Date localDate = null;
        if (standardDateString == null || standardDateString.equals("")) {
            return new Date();
        }
        try {
            String[] fields = BasicFunction.split(standardDateString, " ");
            TimeZone givenTimeZone = TimeZone.getTimeZone(fields[fields.length - 1]);
            Calendar calendar = Calendar.getInstance(givenTimeZone);
            if (fields[0].endsWith(",")) {
                fields[0] = fields[0].substring(0, fields[0].length() - 1);
            }
            calendar.set(7, DateHelper.calendarDayOfWeekToInt(fields[0]));
            calendar.set(5, Integer.parseInt(fields[1]));
            calendar.set(2, DateHelper.calendarMonthStringToInt(fields[2]));
            calendar.set(1, Integer.parseInt(fields[3]));
            String[] timeString = BasicFunction.split(fields[4], ":");
            calendar.set(11, Integer.parseInt(timeString[0]));
            calendar.set(12, Integer.parseInt(timeString[1]));
            calendar.set(13, Integer.parseInt(timeString[2]));
            localDate = calendar.getTime();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            localDate = new Date();
        }
        return localDate;
    }

    public static String convertGMTLongDateToStandardDateString(long longDate) {
        StringBuffer standardDateString = new StringBuffer();
        Date date = new Date(longDate);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        standardDateString.append(DateHelper.CalendarIntWeekTOString(calendar.get(7)) + ", ");
        standardDateString.append(calendar.get(5) + " ");
        standardDateString.append(DateHelper.CalendarIntMonthToString(calendar.get(2)) + " ");
        standardDateString.append(calendar.get(1) + " ");
        standardDateString.append(calendar.get(11) + ":");
        standardDateString.append(calendar.get(12) + ":");
        standardDateString.append(calendar.get(13) + " ");
        standardDateString.append(calendar.getTimeZone().getID());
        return standardDateString.toString();
    }

    private static String CalendarIntWeekTOString(int dayOfWeek) {
        String result = null;
        switch (dayOfWeek) {
            case 1: {
                result = "SUNDAY";
                break;
            }
            case 2: {
                result = "MONDAY";
                break;
            }
            case 3: {
                result = "TUESDAY";
                break;
            }
            case 4: {
                result = "WEDNESDAY";
                break;
            }
            case 5: {
                result = "THURSDAY";
                break;
            }
            case 6: {
                result = "FRIDAY";
                break;
            }
            case 7: {
                result = "SATURDAY";
                break;
            }
            default: {
                result = "SUNDAY";
            }
        }
        return result.substring(0, 3);
    }

    private static String CalendarIntMonthToString(int monthOfYear) {
        String result = null;
        switch (monthOfYear) {
            case 0: {
                result = "JANUARY";
                break;
            }
            case 1: {
                result = "FEBRUARY";
                break;
            }
            case 2: {
                result = "MARCH";
                break;
            }
            case 3: {
                result = "APRIL";
                break;
            }
            case 4: {
                result = "MAY";
                break;
            }
            case 5: {
                result = "JUNE";
                break;
            }
            case 6: {
                result = "JULY";
                break;
            }
            case 7: {
                result = "AUGUST";
                break;
            }
            case 8: {
                result = "SEPTEMBER";
                break;
            }
            case 9: {
                result = "OCTOBER";
                break;
            }
            case 10: {
                result = "NOVEMBER";
                break;
            }
            case 11: {
                result = "DECEMBER";
                break;
            }
            default: {
                result = "JANUARY";
            }
        }
        return result.substring(0, 3);
    }

    public static String formatDatetimeWithoutSecond(Date date) {
        return DateHelper.formatDatetime(date).substring(0, 16);
    }

    public static String formatDatetime(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        StringBuffer dateString = new StringBuffer();
        int tempInt = 0;
        tempInt = DateHelper.calendarMonthToInt(calendar.get(2));
        if (tempInt < 10) {
            dateString.append("0" + tempInt);
        } else {
            dateString.append(tempInt);
        }
        dateString.append("/");
        tempInt = calendar.get(5);
        if (tempInt < 10) {
            dateString.append("0" + tempInt);
        } else {
            dateString.append(tempInt);
        }
        dateString.append("/");
        dateString.append(calendar.get(1));
        dateString.append(" ");
        tempInt = calendar.get(11);
        if (tempInt < 10) {
            dateString.append("0" + tempInt);
        } else {
            dateString.append(tempInt);
        }
        dateString.append(":");
        tempInt = calendar.get(12);
        if (tempInt < 10) {
            dateString.append("0" + tempInt);
        } else {
            dateString.append(tempInt);
        }
        return dateString.toString();
    }

    public static String formatTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        StringBuffer dateString = new StringBuffer();
        int tempInt = calendar.get(11);
        if (tempInt < 10) {
            dateString.append("0" + tempInt);
        } else {
            dateString.append(tempInt);
        }
        dateString.append(":");
        tempInt = calendar.get(12);
        if (tempInt < 10) {
            dateString.append("0" + tempInt);
        } else {
            dateString.append(tempInt);
        }
        return dateString.toString();
    }

    public static String formatGMTDate(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        if (date != null) {
            calendar.setTime(date);
        }
        String[] fields = BasicFunction.split(calendar.getTime().toString(), " ");
        StringBuffer dateString = new StringBuffer();
        dateString.append(fields[0] + ", ");
        dateString.append(fields[2] + " ");
        dateString.append(fields[1] + " ");
        dateString.append(fields[5] + " ");
        dateString.append(fields[3] + " ");
        dateString.append("GMT");
        return dateString.toString();
    }

    public static String formatDateForRssDisplay(Date date) {
        if (date == null) {
            date = new Date();
        }
        StringBuffer dateString = new StringBuffer();
        int year = DateHelper.getYear(date);
        int month = DateHelper.getMonth(date);
        int dayOfMonth = DateHelper.getDay(date);
        if (year == CURRENT_YEAR && month == CURRENT_MONTH && dayOfMonth == CURRENT_DAY_OF_MONTH) {
            dateString.append("Today");
            int tempInt = DateHelper.getHour(date);
            if (tempInt < 10) {
                dateString.append("0" + tempInt);
            } else {
                dateString.append(tempInt);
            }
            dateString.append(":");
            tempInt = DateHelper.getMinute(date);
            if (tempInt < 10) {
                dateString.append("0" + tempInt);
            } else {
                dateString.append(tempInt);
            }
        } else {
            int tempInt = 0;
            tempInt = DateHelper.getMonth(date);
            if (tempInt < 10) {
                dateString.append("0" + tempInt);
            } else {
                dateString.append(tempInt);
            }
            dateString.append("/");
            tempInt = DateHelper.getDay(date);
            if (tempInt < 10) {
                dateString.append("0" + tempInt);
            } else {
                dateString.append(tempInt);
            }
            dateString.append("/");
            dateString.append(DateHelper.getYear(date));
        }
        return dateString.toString();
    }

    private static int calendarMonthToInt(int calendarMonth) {
        if (calendarMonth == 0) {
            return 1;
        }
        if (calendarMonth == 1) {
            return 2;
        }
        if (calendarMonth == 2) {
            return 3;
        }
        if (calendarMonth == 3) {
            return 4;
        }
        if (calendarMonth == 4) {
            return 5;
        }
        if (calendarMonth == 5) {
            return 6;
        }
        if (calendarMonth == 6) {
            return 7;
        }
        if (calendarMonth == 7) {
            return 8;
        }
        if (calendarMonth == 8) {
            return 9;
        }
        if (calendarMonth == 9) {
            return 10;
        }
        if (calendarMonth == 10) {
            return 11;
        }
        if (calendarMonth == 11) {
            return 12;
        }
        return 1;
    }

    public static int calendarDayOfWeekToInt(String dayOfWeek) {
        if ("SUNDAY".startsWith(dayOfWeek.toUpperCase())) {
            return 1;
        }
        if ("MONDAY".startsWith(dayOfWeek.toUpperCase())) {
            return 2;
        }
        if ("TUESDAY".startsWith(dayOfWeek.toUpperCase())) {
            return 3;
        }
        if ("WEDNESDAY".startsWith(dayOfWeek.toUpperCase())) {
            return 4;
        }
        if ("THURSDAY".startsWith(dayOfWeek.toUpperCase())) {
            return 5;
        }
        if ("FRIDAY".startsWith(dayOfWeek.toUpperCase())) {
            return 6;
        }
        if ("SATURDAY".startsWith(dayOfWeek.toUpperCase())) {
            return 7;
        }
        return 1;
    }

    public static int calendarMonthStringToInt(String monthString) {
        if ("JANUARY".startsWith(monthString.toUpperCase())) {
            return 0;
        }
        if ("FEBRUARY".startsWith(monthString.toUpperCase())) {
            return 1;
        }
        if ("MARCH".startsWith(monthString.toUpperCase())) {
            return 2;
        }
        if ("APRIL".startsWith(monthString.toUpperCase())) {
            return 3;
        }
        if ("MAY".startsWith(monthString.toUpperCase())) {
            return 4;
        }
        if ("JUNE".startsWith(monthString.toUpperCase())) {
            return 5;
        }
        if ("JULY".startsWith(monthString.toUpperCase())) {
            return 6;
        }
        if ("AUGUST".startsWith(monthString.toUpperCase())) {
            return 7;
        }
        if ("SEPTEMBER".startsWith(monthString.toUpperCase())) {
            return 8;
        }
        if ("OCTOBER".startsWith(monthString.toUpperCase())) {
            return 9;
        }
        if ("NOVEMBER".startsWith(monthString.toUpperCase())) {
            return 10;
        }
        if ("DECEMBER".startsWith(monthString.toUpperCase())) {
            return 11;
        }
        return 0;
    }

    private static int intToCalendarMonth(int month) {
        if (month == 1) {
            return 0;
        }
        if (month == 2) {
            return 1;
        }
        if (month == 3) {
            return 2;
        }
        if (month == 4) {
            return 3;
        }
        if (month == 5) {
            return 4;
        }
        if (month == 6) {
            return 5;
        }
        if (month == 7) {
            return 6;
        }
        if (month == 8) {
            return 7;
        }
        if (month == 9) {
            return 8;
        }
        if (month == 10) {
            return 9;
        }
        if (month == 11) {
            return 10;
        }
        if (month == 12) {
            return 11;
        }
        return 0;
    }

    public static long getHowManyHour(long longTime) {
        Date currDate = new Date();
        return (currDate.getTime() - longTime) / 3600000L;
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        Date date = new Date();
        String gmtString = DateHelper.convertGMTLongDateToStandardDateString(date.getTime());
        Date chargeTime = DateHelper.convertStandardDateStringToLocal("THU, 13 AUG 2009 7:54:49 GMT");
        cal.setTime(date);
        System.out.println(chargeTime.getTime());
    }

    static {
        CURRENT_YEAR = DateHelper.getYear(CURRENT_DATE);
        CURRENT_MONTH = DateHelper.getMonth(CURRENT_DATE);
        CURRENT_DAY_OF_MONTH = DateHelper.getDay(CURRENT_DATE);
    }
}

