/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TreeItem
extends Container {
    private Style nodeStyle;
    private Object focusPathKey;
    private Object[] focusPathValues;

    public TreeItem(String label) {
        this(label, null);
    }

    public TreeItem(String label, Style style) {
        super(false, style);
        this.setLabel(label);
    }

    public Item appendToRoot(String text, Image image) {
        return this.appendToRoot(text, image, null);
    }

    public Item appendToRoot(String text, Image image, Style rootStyle) {
        IconItem item = new IconItem(text, image, rootStyle);
        this.appendToRoot(item);
        return item;
    }

    public void appendToRoot(Item item) {
        this.add(item);
    }

    public void appendToRoot(Item item, Style nodeStyle) {
        if (nodeStyle != null) {
            item.setStyle(nodeStyle);
        }
        this.add(item);
    }

    public Item appendToNode(Item node, String text, Image image) {
        return this.appendToNode(node, text, image, null);
    }

    public Item appendToNode(Item node, String text, Image image, Style childStyle) {
        IconItem item = new IconItem(text, image);
        this.appendToNode(node, item, childStyle);
        return item;
    }

    public void appendToNode(Item node, Item item) {
        this.appendToNode(node, item, null);
    }

    public void appendToNode(Item node, Item item, Style nodeStyle) {
        Node parentNode;
        if (nodeStyle != null) {
            item.setStyle(nodeStyle);
        }
        if (!(node.parent instanceof Node)) {
            Container parentContainer = node.parent == this ? this : (Container)node.parent;
            parentNode = new Node(node, this.nodeStyle);
            Item[] myItems = parentContainer.getItems();
            for (int i = 0; i < myItems.length; ++i) {
                Item rootItem = myItems[i];
                if (node != rootItem) continue;
                parentContainer.set(i, parentNode);
                node.parent = parentNode;
                break;
            }
        } else {
            parentNode = (Node)node.parent;
        }
        item.parent = parentNode;
        parentNode.addChild(item);
    }

    public void removeAll() {
        this.clear();
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public Item[] getSelectedPath() {
        ArrayList list = new ArrayList();
        Item current = this.getFocusedItem();
        while (current != null) {
            Item next = null;
            if (current instanceof Node) {
                Node node = (Node)current;
                current = node.root;
                next = node.children.getFocusedItem();
            } else if (current instanceof Container) {
                next = ((Container)current).getFocusedItem();
            }
            list.add(current);
            current = next;
        }
        return (Item[])list.toArray(new Item[list.size()]);
    }

    public Object[] getSelectedPathAsAttributes(Object key) {
        Object[] items = this.getSelectedPath();
        for (int i = 0; i < items.length; ++i) {
            Item item = (Item)items[i];
            Object value = item.getAttribute(key);
            if (value == null) continue;
            items[i] = value;
        }
        return items;
    }

    public void setSelectedPathByAttribute(Object key, Object[] values) {
        if (!this.isFocused) {
            this.focusPathKey = key;
            this.focusPathValues = values;
        } else {
            this.setSelectedPathByAttribute(key, values, this, 0);
        }
    }

    private void setSelectedPathByAttribute(Object key, Object[] values, Container container, int index) {
        Item item;
        Object[] items = container.itemsList.getInternalArray();
        Object valueExpected = values[index];
        if (container.isFocused) {
            container.focus(-1);
        }
        for (int i = 0; i < items.length && (item = (Item)items[i]) != null; ++i) {
            Object valuePresent;
            Node node = null;
            if (item instanceof Node) {
                node = (Node)item;
                item = node.root;
                if (node.isExpanded) {
                    node.setExpanded(false);
                }
            }
            if (!valueExpected.equals(valuePresent = item.getAttribute(key))) continue;
            if (node != null) {
                node.setExpanded(true);
                container.focus(i, node, 1);
            } else {
                container.focus(i, item, 0);
            }
            if (index >= values.length - 1) continue;
            if (node != null) {
                this.setSelectedPathByAttribute(key, values, node.children, index + 1);
                continue;
            }
            if (!(item instanceof Container)) continue;
            this.setSelectedPathByAttribute(key, values, (Container)item, index + 1);
        }
    }

    protected Style focus(Style focusStyle, int direction) {
        Style myPlainStyle = super.focus(focusStyle, direction);
        if (this.focusPathKey != null) {
            this.setSelectedPathByAttribute(this.focusPathKey, this.focusPathValues, this, 0);
            this.focusPathKey = null;
            this.focusPathValues = null;
        }
        return myPlainStyle;
    }

    public void collapseAll() {
        Object item;
        Object[] items = this.itemsList.getInternalArray();
        for (int i = 0; i < items.length && (item = items[i]) != null; ++i) {
            Node node;
            if (!(item instanceof Node) || !(node = (Node)item).isExpanded) continue;
            node.setExpanded(false);
        }
    }

    class Node
    extends Item {
        private final Item root;
        private final Container children;
        private boolean isExpanded;
        int xLeftOffset = 10;
        private Style rootPlainStyle;

        public Node(Item root) {
            this(root, null);
        }

        public Node(Item root, Style childrenStyle) {
            super(null, 0, 3, null);
            this.root = root;
            this.root.parent = this;
            this.children = new Container(false, childrenStyle);
            this.children.parent = this;
        }

        public void addChild(Item child) {
            this.children.add(child);
        }

        protected void initContent(int firstLineWidth, int lineWidth) {
            this.root.init(firstLineWidth, lineWidth);
            this.children.relativeX = this.xLeftOffset;
            this.children.relativeY = this.root.itemHeight;
            int rootWidth = this.root.itemWidth;
            if (!this.isExpanded) {
                this.contentWidth = rootWidth;
                this.contentHeight = this.root.itemHeight;
            } else {
                this.children.init(lineWidth -= this.xLeftOffset, lineWidth);
                this.contentWidth = Math.max(rootWidth, this.children.itemWidth + this.xLeftOffset);
                this.contentHeight = this.root.itemHeight + this.paddingVertical + this.children.itemHeight;
            }
        }

        protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
            this.root.paint(x, y, leftBorder, rightBorder, g);
            if (this.isExpanded) {
                x = leftBorder += this.xLeftOffset;
                this.children.paint(x, y += this.root.itemHeight + this.paddingVertical, leftBorder, rightBorder, g);
            }
        }

        protected String createCssSelector() {
            return "node";
        }

        protected boolean handleKeyPressed(int keyCode, int gameAction) {
            boolean handled = false;
            if (this.isExpanded) {
                if (this.children.isFocused) {
                    handled = this.children.handleKeyPressed(keyCode, gameAction);
                    if (handled) {
                        if (this.children.internalX != -9999) {
                            this.internalX = this.children.relativeX + this.children.contentX + this.children.internalX;
                            this.internalY = this.children.relativeY + this.children.contentY + this.children.internalY;
                            this.internalWidth = this.children.internalWidth;
                            this.internalHeight = this.children.internalHeight;
                        } else {
                            this.internalX = this.children.relativeX;
                            this.internalY = this.children.relativeY;
                            this.internalWidth = this.children.itemWidth;
                            this.internalHeight = this.children.itemHeight;
                        }
                    } else if (gameAction == 1 || gameAction == 2) {
                        this.focusRoot();
                        handled = true;
                    }
                } else if ((gameAction == 6 || gameAction == 5) && this.children.appearanceMode != 0) {
                    if (this.rootPlainStyle != null) {
                        this.root.defocus(this.rootPlainStyle);
                    }
                    this.children.focus(null, gameAction);
                    handled = true;
                }
            }
            if (!handled && this.getScreen().isGameActionFire(keyCode, gameAction)) {
                boolean bl = handled = this.root.notifyItemPressedStart() || this.children.size() > 0;
                if (this.isExpanded) {
                    this.internalX = 0;
                    this.internalY = 0;
                    this.internalHeight = this.root.itemHeight;
                } else if (this.children.size() > 0) {
                    this.internalX = 0;
                    this.internalY = 0;
                    this.internalHeight = this.root.itemHeight + this.paddingVertical + (this.children.itemHeight != 0 ? this.children.itemHeight : 30);
                }
            }
            return handled;
        }

        protected boolean handleKeyReleased(int keyCode, int gameAction) {
            boolean handled = false;
            if (this.isExpanded && this.children.isFocused && (handled = this.children.handleKeyReleased(keyCode, gameAction))) {
                if (this.children.internalX != -9999) {
                    this.internalX = this.children.relativeX + this.children.contentX + this.children.internalX;
                    this.internalY = this.children.relativeY + this.children.contentY + this.children.internalY;
                    this.internalWidth = this.children.internalWidth;
                    this.internalHeight = this.children.internalHeight;
                } else {
                    this.internalX = this.children.relativeX;
                    this.internalY = this.children.relativeY;
                    this.internalWidth = this.children.itemWidth;
                    this.internalHeight = this.children.itemHeight;
                }
            }
            if (!handled && this.getScreen().isGameActionFire(keyCode, gameAction)) {
                this.root.notifyItemPressedEnd();
                this.setExpanded(!this.isExpanded);
                handled = true;
            }
            return handled;
        }

        protected Style focus(Style focusstyle, int direction) {
            this.isFocused = true;
            if (!this.isExpanded || direction != 1 || this.children.size() == 0 || this.children.appearanceMode == 0) {
                this.rootPlainStyle = this.root.focus(null, direction);
                return this.rootPlainStyle;
            }
            this.children.focus(null, direction);
            return this.root.style;
        }

        protected void defocus(Style originalStyle) {
            this.isFocused = false;
            if (this.isExpanded && this.children.isFocused) {
                this.children.defocus(originalStyle);
            } else {
                this.root.defocus(originalStyle);
            }
        }

        private void focusRoot() {
            this.internalX = -this.contentX;
            this.internalY = -this.contentY;
            this.internalWidth = this.root.itemWidth + this.contentX;
            this.internalHeight = this.root.itemHeight + this.contentY;
            if (this.children.isFocused) {
                this.children.defocus(null);
                this.children.focus(-1);
                this.root.focus(null, 1);
            }
        }

        private void setExpanded(boolean expand) {
            if (!expand) {
                this.internalX = -9999;
                Item[] myItems = this.children.getItems();
                for (int i = 0; i < myItems.length; ++i) {
                    Item item = myItems[i];
                    if (!(item instanceof Node)) continue;
                    ((Node)item).setExpanded(false);
                }
                this.children.hideNotify();
                this.focusRoot();
            }
            if (expand != this.isExpanded) {
                this.isExpanded = expand;
                this.requestInit();
                if (expand) {
                    this.children.showNotify();
                }
            }
        }

        public String toString() {
            return "Node " + this.root + "/" + super.toString();
        }

        protected void hideNotify() {
            super.hideNotify();
            this.root.hideNotify();
            if (this.isExpanded) {
                this.children.hideNotify();
            }
        }

        protected void showNotify() {
            super.showNotify();
            this.root.showNotify();
            if (this.isExpanded) {
                this.children.showNotify();
            }
        }
    }
}

