/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HorizontalChoiceView
extends ContainerView {
    private static final int POSITION_BOTH_SIDES = 0;
    private static final int POSITION_RIGHT = 1;
    private static final int POSITION_LEFT = 2;
    private static final int POSITION_NONE = 3;
    private int arrowColor;
    private int arrowWidth = 10;
    private int currentItemIndex;
    private int leftArrowStartX;
    private int leftArrowEndX;
    private int rightArrowStartX;
    private int xOffset;
    private int completeWidthOfItems;

    public HorizontalChoiceView() {
        this.allowsAutoTraversal = false;
    }

    protected void initContent(Item parentItm, int firstLineWidth, int lineWidth) {
        Container parent = (Container)parentItm;
        int selectedItemIndex = ((ChoiceGroup)parent).getSelectedIndex();
        if (selectedItemIndex == -1) {
            selectedItemIndex = 0;
        }
        if (selectedItemIndex < parent.size()) {
            parent.focus(selectedItemIndex, parent.get(selectedItemIndex), 0);
        }
        int height = 0;
        int completeArrowWidth = this.arrowWidth + this.paddingHorizontal << 1;
        this.leftArrowStartX = 0;
        this.leftArrowEndX = this.arrowWidth;
        this.rightArrowStartX = lineWidth - this.arrowWidth;
        lineWidth -= completeArrowWidth;
        int completeWidth = 0;
        Item[] items = parent.getItems();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            ((ChoiceItem)item).drawBox = false;
            int itemHeight = item.getItemHeight(lineWidth, lineWidth);
            int itemWidth = item.itemWidth;
            if (itemHeight > height) {
                height = itemHeight;
            }
            int startX = completeWidth;
            completeWidth += itemWidth + this.paddingHorizontal;
            if (i != selectedItemIndex) continue;
            if (startX + this.xOffset < 0) {
                this.xOffset = -startX;
                continue;
            }
            if (completeWidth + this.xOffset <= lineWidth) continue;
            this.xOffset = lineWidth - completeWidth;
        }
        this.completeWidthOfItems = completeWidth;
        this.contentHeight = height;
        this.contentWidth = lineWidth + completeArrowWidth;
        this.appearanceMode = items.length > 0 ? 3 : 0;
        if (selectedItemIndex < items.length) {
            this.focusedItem = items[selectedItemIndex];
            this.currentItemIndex = selectedItemIndex;
        }
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int startX;
        boolean setClip;
        int modifiedX = x;
        modifiedX += this.arrowWidth + this.paddingHorizontal;
        boolean bl = setClip = this.completeWidthOfItems > (rightBorder -= this.arrowWidth + this.paddingHorizontal) - (leftBorder += this.arrowWidth + this.paddingHorizontal);
        if (setClip) {
            g.clipRect(modifiedX, clipY, rightBorder - modifiedX, clipHeight);
        }
        int itemX = modifiedX + this.xOffset;
        int focusedX = 0;
        int cHeight = this.contentHeight;
        int vOffset = 0;
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            if (item == this.focusedItem) {
                focusedX = itemX;
            } else {
                vOffset = (cHeight - item.itemHeight) / 2;
                item.paint(itemX, y + vOffset, itemX, itemX + item.itemWidth, g);
            }
            itemX += item.itemWidth + this.paddingHorizontal;
        }
        if (this.focusedItem != null) {
            vOffset = (cHeight - this.focusedItem.itemHeight) / 2;
            this.focusedItem.paint(focusedX, y + vOffset, leftBorder, rightBorder, g);
        }
        if (setClip) {
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        g.setColor(this.arrowColor);
        if (this.currentItemIndex > 0) {
            startX = x + this.leftArrowStartX;
            Image image = null;
            if (image != null) {
                g.drawImage(image, startX, y + vOffset, 20);
            } else {
                g.fillTriangle(startX, y + this.contentHeight / 2, startX + this.arrowWidth, y, startX + this.arrowWidth, y + this.contentHeight);
            }
        }
        if (this.currentItemIndex < this.parentContainer.size() - 1) {
            startX = x + this.rightArrowStartX;
            g.fillTriangle(startX + this.arrowWidth, y + this.contentHeight / 2, startX, y, startX, y + this.contentHeight);
        }
    }

    protected Item getNextItem(int keyCode, int gameAction) {
        ChoiceGroup choiceGroup = (ChoiceGroup)this.parentContainer;
        Item[] items = this.parentContainer.getItems();
        ChoiceItem currentItem = (ChoiceItem)this.focusedItem;
        if (currentItem == null) {
            Debug.debug("warn", "de.enough.polish.ui.containerviews.HorizontalChoiceView", 510, "HorizontalChoiceView: getNextItem(): no current item defined, it seems the initContent() has been skipped.");
            this.currentItemIndex = choiceGroup.getSelectedIndex();
            currentItem = (ChoiceItem)items[this.currentItemIndex];
            this.focusedItem = currentItem;
        }
        ChoiceItem nextItem = null;
        if (gameAction == 2 && this.currentItemIndex > 0) {
            currentItem.select(false);
            --this.currentItemIndex;
            nextItem = (ChoiceItem)items[this.currentItemIndex];
            choiceGroup.setSelectedIndex(this.currentItemIndex, true);
            if (this.getScreen() instanceof Form) {
                choiceGroup.notifyStateChanged();
            }
        } else if (gameAction == 5 && this.currentItemIndex < items.length - 1) {
            currentItem.select(false);
            ++this.currentItemIndex;
            nextItem = (ChoiceItem)items[this.currentItemIndex];
            choiceGroup.setSelectedIndex(this.currentItemIndex, true);
            if (this.getScreen() instanceof Form) {
                choiceGroup.notifyStateChanged();
            }
        }
        return nextItem;
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
    }

    public void focus(Style focusstyle, int direction) {
        super.focus(focusstyle, direction);
    }

    protected boolean isValid(Item parent, Style style) {
        return parent instanceof ChoiceGroup;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arrowColor = dataInputStream.readInt();
        this.arrowWidth = dataInputStream.readInt();
        this.completeWidthOfItems = dataInputStream.readInt();
        this.currentItemIndex = dataInputStream.readInt();
        this.leftArrowEndX = dataInputStream.readInt();
        this.leftArrowStartX = dataInputStream.readInt();
        this.rightArrowStartX = dataInputStream.readInt();
        this.xOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arrowColor);
        dataOutputStream.writeInt(this.arrowWidth);
        dataOutputStream.writeInt(this.completeWidthOfItems);
        dataOutputStream.writeInt(this.currentItemIndex);
        dataOutputStream.writeInt(this.leftArrowEndX);
        dataOutputStream.writeInt(this.leftArrowStartX);
        dataOutputStream.writeInt(this.rightArrowStartX);
        dataOutputStream.writeInt(this.xOffset);
    }
}

