/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FadeOutFadeInScreenChangeAnimation
extends ScreenChangeAnimation {
    private int steps = 6;
    private int backgroundColor = 0;
    private int currentStep;
    private int[] shownScreenRgb;
    private boolean isFadingPreviousScreen;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        if (this.shownScreenRgb == null) {
            this.shownScreenRgb = new int[width * height];
        }
        lstScreenImage.getRGB(this.shownScreenRgb, 0, width, 0, 0, width, height);
        this.isFadingPreviousScreen = true;
        this.currentStep = 0;
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
    }

    protected boolean animate() {
        ++this.currentStep;
        if (this.isFadingPreviousScreen) {
            if (this.currentStep >= this.steps) {
                this.nextCanvasImage.getRGB(this.shownScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight);
                this.addOpacity(255 / (this.steps + 1), this.shownScreenRgb);
                this.currentStep = 0;
                this.isFadingPreviousScreen = false;
            } else {
                int opacity = 255 * (this.steps - this.currentStep) / this.steps;
                this.addOpacity(opacity, this.shownScreenRgb);
            }
            return true;
        }
        if (this.currentStep >= this.steps) {
            this.currentStep = 0;
            this.shownScreenRgb = null;
            this.isFadingPreviousScreen = true;
            return false;
        }
        int opacity = 255 * this.currentStep / this.steps;
        this.addOpacity(opacity, this.shownScreenRgb);
        return true;
    }

    private void addOpacity(int opacity, int[] data) {
        opacity = opacity << 24 | 0xFFFFFF;
        for (int i = 0; i < data.length; ++i) {
            data[i] = (data[i] | 0xFF000000) & opacity;
        }
    }

    public void paintAnimation(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g.drawRGB(this.shownScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, true);
    }
}

