/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.view.components;

import com.sonyericsson.fifa.utils.IOUtility;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import java.io.IOException;
import java.util.Vector;

public class Crossfade
extends Container {
    private static int DISPLAYED_TIME = 4000;
    private static int FRAME_TIME = 80;
    private static final int NUMBER_OF_TRANSITIONS = 7;
    private int left = 0;
    private int top = 0;
    private int currentImage = 0;
    private int stepCounter = 0;
    private long lastInvoke;
    private Vector imageSequence;
    private Dimension containerSize;
    private boolean isAnimating = false;
    private boolean isPaused = true;
    private Image[] fadingImages = new Image[4];
    private static int[] fadeInSequence;
    private static int[] fadeOutSequence;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        fadeInSequence = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        nArray2[1] = 1;
        fadeOutSequence = nArray2;
    }

    public Crossfade(int width, int height) {
        this(null, width, height);
    }

    public Crossfade(String[] imagesPath, int width, int height) {
        if (imagesPath != null) {
            this.readImages(imagesPath);
        }
        this.containerSize = new Dimension(width, height);
        this.setFocus(false);
        this.setFocusable(false);
    }

    private void createCrossfadeImages() {
        try {
            if (this.fadingImages[0] == null && this.imageSequence.size() > 0) {
                int width = ((Image)this.imageSequence.elementAt(0)).getWidth();
                int height = ((Image)this.imageSequence.elementAt(0)).getHeight();
                Image originalImage = Image.createImage(IOUtility.openFileInputStream("/crossfade_square.png")).scaled(width, height);
                this.fadingImages[0] = originalImage.modifyAlpha((byte)60);
                this.fadingImages[1] = originalImage.modifyAlpha((byte)120);
                this.fadingImages[2] = originalImage.modifyAlpha((byte)-76);
                this.fadingImages[3] = originalImage.modifyAlpha((byte)-1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setImages(String[] imagesPath) {
        this.readImages(imagesPath);
        this.createCrossfadeImages();
    }

    public void setImages(Vector images) {
        if (images != null) {
            this.imageSequence = images;
            this.createCrossfadeImages();
        }
    }

    private void readImages(String[] imagesPath) {
        if (imagesPath != null) {
            if (this.imageSequence == null) {
                this.imageSequence = new Vector();
            } else {
                this.imageSequence.removeAllElements();
            }
            int i = 0;
            while (i < imagesPath.length) {
                if (imagesPath[i] != null) {
                    try {
                        this.imageSequence.addElement(Image.createImage(IOUtility.openFileInputStream(imagesPath[i])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        if (this.imageSequence != null) {
            this.containerSize = new Dimension(((Image)this.imageSequence.elementAt(0)).getWidth(), ((Image)this.imageSequence.elementAt(0)).getHeight());
        }
    }

    public boolean animate() {
        long current = System.currentTimeMillis();
        if (current - this.lastInvoke > (long)DISPLAYED_TIME) {
            this.lastInvoke = current;
            this.stepCounter = 0;
            if (this.imageSequence.size() > 1) {
                this.isAnimating = true;
            }
            return true;
        }
        if (this.isAnimating && current - this.lastInvoke > (long)FRAME_TIME) {
            this.lastInvoke = current;
            ++this.stepCounter;
            if (this.stepCounter == 7) {
                this.isAnimating = false;
            }
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        if (this.imageSequence != null && !this.imageSequence.isEmpty()) {
            if (this.stepCounter < fadeInSequence.length) {
                g.drawImage((Image)this.imageSequence.elementAt(this.currentImage), this.getX() + this.left, this.getY() + this.top);
                if (this.isAnimating) {
                    g.drawImage(this.fadingImages[fadeInSequence[this.stepCounter]], this.getX() + this.left, this.getY() + this.top);
                }
            } else {
                if (this.stepCounter == fadeInSequence.length) {
                    ++this.currentImage;
                    if (this.currentImage == this.imageSequence.size()) {
                        this.currentImage = 0;
                    }
                }
                g.drawImage((Image)this.imageSequence.elementAt(this.currentImage), this.getX() + this.left, this.getY() + this.top);
                if (this.isAnimating) {
                    g.drawImage(this.fadingImages[fadeOutSequence[this.stepCounter - fadeInSequence.length]], this.getX() + this.left, this.getY() + this.top);
                }
            }
        }
    }

    public void setPadding(int left, int top) {
        this.left = left;
        this.top = top;
    }

    protected Dimension calcPreferredSize() {
        return this.containerSize;
    }

    public boolean startTransition(Form componentForm) {
        if (this.isPaused && this.imageSequence != null && this.imageSequence.size() > 1) {
            this.isPaused = false;
            this.lastInvoke = System.currentTimeMillis();
            this.stepCounter = 0;
            this.currentImage = 0;
            this.isAnimating = false;
            componentForm.registerAnimated(this);
            return true;
        }
        return false;
    }

    public boolean pauseTransition(Form componentForm) {
        if (!this.isPaused && this.imageSequence != null && this.imageSequence.size() > 1) {
            this.isPaused = true;
            componentForm.deregisterAnimated(this);
            return true;
        }
        return false;
    }
}

