/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class WaitCanvas
extends Canvas {
    private int mCount = 0;
    private int mMaximum = 36;
    private int mInterval = 100;
    private int mWidth = this.getWidth();
    private int mHeight = this.getHeight();
    private int mX;
    private int mY;
    private int mRadius;
    private String mMessage;

    public WaitCanvas() {
        int n = (this.mWidth - this.mRadius) / 2;
        int n2 = (this.mHeight - this.mRadius) / 2;
        this.mRadius = Math.min(n, n2);
        this.mX = n - this.mRadius / 2;
        this.mY = n2 - this.mRadius / 2;
        TimerTask timerTask = new TimerTask(){

            public void run() {
                WaitCanvas.this.mCount = (WaitCanvas.this.mCount + 1) % WaitCanvas.this.mMaximum;
                WaitCanvas.this.repaint();
            }
        };
        Timer timer = new Timer();
        timer.schedule(timerTask, 0L, (long)this.mInterval);
    }

    public void setMessage(String string) {
        this.mMessage = "Waiting....";
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = -(this.mCount * 360 / this.mMaximum);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.mWidth, this.mHeight);
        graphics.setColor(0, 0, 0);
        graphics.drawArc(this.mX, this.mY, this.mRadius, this.mRadius, 0, 360);
        graphics.fillArc(this.mX, this.mY, this.mRadius, this.mRadius, n + 90, 90);
        graphics.fillArc(this.mX, this.mY, this.mRadius, this.mRadius, n + 270, 90);
        if (this.mMessage != null) {
            graphics.drawString(this.mMessage, this.mWidth / 2, this.mHeight, 33);
        }
    }
}

