/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;

public class SEGameController
extends MIDlet
implements CommandListener {
    private static final String GAME_NAME = "River Riders";
    private static final String HELP_STRING = "Help text.";
    private Runtime runner = Runtime.getRuntime();
    private Command exitCommand;
    private Command backCommand;
    private Command continueCommand;
    private Command okCommand;
    private int mainMenuSize;
    private int languageMenuSize;
    private int optionMenuSize;
    private int soundMenuSize;
    private int vibrationMenuSize;
    private int highscoreMenuSize;
    private int riverMenuSize;
    private int gametypeMenuSize;
    private int onOffMenuSize;
    private boolean hasMainMenu = true;
    private boolean hasLanguageMenu = true;
    private boolean hasOptionMenu = true;
    private boolean hasSoundMenu = false;
    private boolean hasVibrationMenu = true;
    private boolean hasHighscoreMenu = true;
    private boolean hasRiverMenu = true;
    private boolean hasEnglishLanguage = true;
    private boolean hasFrenchLanguage = false;
    private boolean hasGermanLanguage = false;
    private boolean hasItalianLanguage = false;
    private boolean hasSpanishLanguage = false;
    private boolean hasChineseLanguage = false;
    private boolean hasTradTWChineseLanguage = false;
    private boolean hasTradHKChineseLanguage = false;
    private boolean hasNewGameMenu = true;
    private boolean hasResumeGameMenu = false;
    private boolean hasHelpMenu = true;
    private boolean hasQuit = true;
    private boolean hasGametypeMenu = true;
    private boolean hasPausedGame = false;
    private boolean doFirstTimer = false;
    private SonyEricssonTextLabels sonyEricssonTextLabels;
    private RaftingCanvas game;
    private boolean gameIsRunning = false;
    private StringItem helpTextBox;
    private Form helpTextForm;
    private SEListObject mainMenu;
    private SEListObject languageMenu;
    private SEListObject optionMenu;
    private SEListObject soundMenu;
    private SEListObject vibrationMenu;
    private HighscoreCanvas highscoreMenu;
    private SEListObject riverMenu;
    private SEListObject gametypeMenu;
    private SEItemIdentifier[] mainMenuArray;
    private SEItemIdentifier[] languageMenuArray;
    private SEItemIdentifier[] optionMenuArray;
    private SEItemIdentifier[] soundMenuArray;
    private SEItemIdentifier[] vibrationMenuArray;
    private SEItemIdentifier[] highscoreMenuArray;
    private SEItemIdentifier[] riverMenuArray;
    private SEItemIdentifier[] onOffMenuArray;
    private SEItemIdentifier[] gametypeMenuArray;
    private Display display;
    private int levelUnlocked = 0;
    private int currentLevel = 0;
    private int levelPlaying = 3;
    private static int K_NUMLEVELS = 12;
    private RaftRMS mRaftRMS;
    public String pAdress;
    public String sKeyCode;
    private boolean hasSubmitted = false;
    private boolean careerMode = false;
    public String[][] highscoreData;
    private Form signF;
    private TextField signTF;
    private StringItem signSI;
    private int setScore;
    private int setIndex;
    private boolean hasHighscore = false;
    public String[] raftSettings;
    public int vibration = 100;
    private int NumOfLanguages;
    private int cheatMode;
    private String[] LanguageFiles;

    public SEGameController() {
        String string;
        String string2 = this.getAppProperty("Languages");
        if (string2 != null) {
            this.NumOfLanguages = Integer.parseInt(string2);
            this.pAdress = this.getAppProperty("downloadAdress");
            this.LanguageFiles = new String[this.NumOfLanguages];
            for (int i = 0; i < this.NumOfLanguages; ++i) {
                this.LanguageFiles[i] = this.getAppProperty("Language-File" + i);
            }
        } else {
            this.NumOfLanguages = 1;
            this.pAdress = "http://127.0.0.1";
            this.LanguageFiles = new String[1];
            this.LanguageFiles[0] = "lang_eng.dat";
        }
        this.cheatMode = (string = this.getAppProperty("cheatMode")) != null ? Integer.parseInt(string) : 0;
        this.sonyEricssonTextLabels = new SonyEricssonTextLabels();
        this.sonyEricssonTextLabels.loadLanguages(this.LanguageFiles);
        this.mRaftRMS = new RaftRMS();
        this.display = Display.getDisplay((MIDlet)this);
        this.loadSettings();
    }

    public void startApp() {
        this.initArrays();
        this.initMenus();
        this.displayFirstMenu();
    }

    public void pauseApp() {
        this.pauseGame();
    }

    public void pauseGame() {
        if (this.gameIsRunning) {
            this.game.stop();
            this.gameIsRunning = false;
            if (!this.game.gameOver) {
                this.hasPausedGame = true;
            }
            this.game.removeCommand(this.backCommand);
        }
    }

    public void destroyApp(boolean bl) {
        if (this.game != null) {
            this.game.stop();
        }
    }

    public void initArrays() {
        int n;
        this.mainMenuSize = 5;
        if (this.hasPausedGame) {
            ++this.mainMenuSize;
            this.hasResumeGameMenu = true;
        } else {
            this.hasResumeGameMenu = false;
        }
        this.languageMenuSize = this.NumOfLanguages;
        this.optionMenuSize = 2;
        this.vibrationMenuSize = 2;
        this.gametypeMenuSize = 2;
        this.riverMenuSize = this.levelUnlocked > 2 ? this.levelUnlocked + 1 : 3;
        this.mainMenuArray = new SEItemIdentifier[this.mainMenuSize];
        this.languageMenuArray = new SEItemIdentifier[this.languageMenuSize];
        this.optionMenuArray = new SEItemIdentifier[this.optionMenuSize];
        this.soundMenuArray = null;
        this.vibrationMenuArray = new SEItemIdentifier[this.vibrationMenuSize];
        this.highscoreMenuArray = new SEItemIdentifier[this.highscoreMenuSize];
        this.riverMenuArray = new SEItemIdentifier[this.riverMenuSize];
        this.gametypeMenuArray = new SEItemIdentifier[this.gametypeMenuSize];
        int n2 = 0;
        this.mainMenuArray[n2++] = new SEItemIdentifier(0, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 0));
        if (this.hasResumeGameMenu) {
            this.mainMenuArray[n2++] = new SEItemIdentifier(1, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 1));
        }
        this.mainMenuArray[n2++] = new SEItemIdentifier(2, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 2));
        this.mainMenuArray[n2++] = new SEItemIdentifier(70, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 70));
        this.mainMenuArray[n2++] = new SEItemIdentifier(4, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 4));
        this.mainMenuArray[n2++] = new SEItemIdentifier(5, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 5));
        n2 = 0;
        for (n = 0; n < this.sonyEricssonTextLabels.NUMBEROFAVAILABLELANGUAGES; ++n) {
            this.languageMenuArray[n2++] = new SEItemIdentifier(n, this.sonyEricssonTextLabels.getTextLabel(n, 64));
        }
        n2 = 0;
        this.optionMenuArray[n2++] = new SEItemIdentifier(9, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 9));
        if (this.hasSoundMenu) {
            this.optionMenuArray[n2++] = new SEItemIdentifier(11, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 11));
        }
        this.optionMenuArray[n2++] = new SEItemIdentifier(10, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 10));
        n2 = 0;
        if (this.hasSoundMenu) {
            this.soundMenuArray[n2++] = new SEItemIdentifier(14, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 14));
            this.soundMenuArray[n2++] = new SEItemIdentifier(15, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 15));
        } else {
            this.soundMenuArray = null;
        }
        n2 = 0;
        this.vibrationMenuArray[n2++] = new SEItemIdentifier(12, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 12));
        this.vibrationMenuArray[n2++] = new SEItemIdentifier(13, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 13));
        n2 = 0;
        for (n = 0; n < this.riverMenuSize; ++n) {
            this.riverMenuArray[n2++] = new SEItemIdentifier(27 + n, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 27 + n));
        }
        n2 = 0;
        this.gametypeMenuArray[n2++] = new SEItemIdentifier(6, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 6));
        this.gametypeMenuArray[n2++] = new SEItemIdentifier(8, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 8));
    }

    public void initMenus() {
        this.backCommand = new Command(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 20), 2, 2);
        this.continueCommand = new Command(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 7), 4, 2);
        this.okCommand = new Command(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 42), 4, 2);
        this.exitCommand = new Command(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 5), 2, 2);
        this.languageMenu = new SEListObject(this.sonyEricssonTextLabels.getCurrentLanguage(), this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 9), this.languageMenuArray);
        this.languageMenu.addCommand(this.backCommand);
        this.languageMenu.setCommandListener(this);
        this.signF = new Form(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 2));
        this.mainMenu = new SEListObject(this.sonyEricssonTextLabels.getCurrentLanguage(), this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 86), this.mainMenuArray);
        this.mainMenu.addCommand(this.exitCommand);
        this.mainMenu.setCommandListener(this);
        this.optionMenu = new SEListObject(this.sonyEricssonTextLabels.getCurrentLanguage(), this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 70), this.optionMenuArray);
        this.optionMenu.addCommand(this.backCommand);
        this.optionMenu.setCommandListener(this);
        this.vibrationMenu = new SEListObject(this.sonyEricssonTextLabels.getCurrentLanguage(), this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 10), this.vibrationMenuArray);
        this.vibrationMenu.addCommand(this.backCommand);
        this.vibrationMenu.setCommandListener(this);
        this.highscoreMenu = new HighscoreCanvas(this, this.sonyEricssonTextLabels, this.mRaftRMS, this.display);
        this.gametypeMenu = new SEListObject(this.sonyEricssonTextLabels.getCurrentLanguage(), this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 0), this.gametypeMenuArray);
        this.gametypeMenu.addCommand(this.backCommand);
        this.gametypeMenu.setCommandListener(this);
        this.riverMenu = new SEListObject(this.sonyEricssonTextLabels.getCurrentLanguage(), this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 8), this.riverMenuArray);
        this.riverMenu.addCommand(this.backCommand);
        this.riverMenu.setCommandListener(this);
    }

    public void displayFirstMenu() {
        if (this.doFirstTimer) {
            this.display.setCurrent((Displayable)this.languageMenu);
        } else {
            this.display.setCurrent((Displayable)this.mainMenu);
        }
    }

    public void loadSettings() {
        this.raftSettings = RaftRMS.checkSettings(this.sonyEricssonTextLabels, this.cheatMode);
        if (this.raftSettings[0] == "-1") {
            this.sonyEricssonTextLabels.setCurrentLanguage(0);
            this.levelUnlocked = Integer.parseInt(this.raftSettings[1]);
            this.levelPlaying = Integer.parseInt(this.raftSettings[8]);
            this.vibration = Integer.parseInt(this.raftSettings[9]);
            this.doFirstTimer = true;
            this.sKeyCode = " ";
        } else {
            this.sonyEricssonTextLabels.setCurrentLanguage(Integer.parseInt(this.raftSettings[0]));
            this.levelUnlocked = Integer.parseInt(this.raftSettings[1]);
            this.sKeyCode = " ";
            this.levelPlaying = Integer.parseInt(this.raftSettings[8]);
            this.vibration = Integer.parseInt(this.raftSettings[9]);
            if (this.raftSettings[3] != " ") {
                this.sKeyCode = this.raftSettings[3];
            }
        }
        this.highscoreData = this.mRaftRMS.getHighscoreData();
    }

    public void setMainMenu() {
        this.display.setCurrent((Displayable)this.mainMenu);
    }

    public void setGametypeMenu() {
        this.game.stop();
        this.gameIsRunning = false;
        this.hasPausedGame = false;
        this.game.removeCommand(this.backCommand);
        this.initArrays();
        this.initMenus();
        this.display.setCurrent((Displayable)this.gametypeMenu);
    }

    public void startGame(int n) {
        if (!this.gameIsRunning) {
            try {
                this.gameIsRunning = true;
                if (this.game != null) {
                    this.game.stop();
                }
                this.game = null;
                System.gc();
                this.currentLevel = n - 27;
                this.game = new RaftingCanvas(n, this, this.sonyEricssonTextLabels);
                this.game.addCommand(this.backCommand);
                this.game.setCommandListener(this);
                this.game.start();
                System.out.println(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), n) + ":" + n);
                this.display.setCurrent((Displayable)this.game);
                this.hasHighscore = false;
                this.hasPausedGame = false;
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    public boolean unlockNextLevel(int n) {
        boolean bl = false;
        if (this.levelUnlocked < K_NUMLEVELS) {
            if (this.checkHighscore(n, this.currentLevel)) {
                bl = true;
            }
            if (this.careerMode) {
                this.levelPlaying = this.currentLevel + 1;
                if (this.levelPlaying > 11) {
                    this.levelPlaying = 3;
                }
                if (this.currentLevel >= this.levelUnlocked) {
                    this.levelUnlocked = this.currentLevel;
                }
                System.out.println("Unlocking:" + this.levelUnlocked);
                RaftRMS.setLevelUnlocked(this.levelUnlocked, this.levelPlaying);
            }
        }
        return bl;
    }

    private boolean checkHighscore(int n, int n2) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        int n3 = this.highscoreData.length - 1;
        int n4 = 100;
        int n5 = 0;
        int n6 = 1000000;
        int n7 = n2 + 27;
        for (int i = 0; i < this.highscoreData.length; ++i) {
            try {
                n6 = Integer.parseInt(this.highscoreData[i][2]);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            if (n <= n6) continue;
            if (bl2) {
                n4 = i;
                bl2 = false;
            }
            bl = true;
        }
        if (bl) {
            this.setIndex = bl3 ? n5 * 100 : n4;
            this.setScore = n;
            this.hasHighscore = true;
        }
        return bl;
    }

    public void resumeGame() {
        if (this.game != null) {
            this.game.addCommand(this.backCommand);
            this.game.setCommandListener(this);
            this.hasPausedGame = false;
            this.gameIsRunning = true;
            this.game.start();
            this.display.setCurrent((Displayable)this.game);
        }
    }

    private void saveHighscore() {
        int n;
        int n2 = this.highscoreData.length;
        String[][] stringArray = new String[this.highscoreData.length + 1][3];
        for (int i = 0; i < n2; ++i) {
            stringArray[i][0] = this.highscoreData[i][0];
            stringArray[i][1] = this.highscoreData[i][1];
            stringArray[i][2] = this.highscoreData[i][2];
        }
        stringArray[n2][0] = this.signTF.getString();
        stringArray[n2][1] = "" + (this.currentLevel + 27);
        stringArray[n2][2] = "" + this.setScore;
        ++n2;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2 - 1; ++i) {
                if (Integer.parseInt(stringArray[i][2]) >= Integer.parseInt(stringArray[i + 1][2])) continue;
                String string = stringArray[i + 1][0];
                stringArray[i + 1][0] = stringArray[i][0];
                stringArray[i][0] = string;
                string = stringArray[i + 1][1];
                stringArray[i + 1][1] = stringArray[i][1];
                stringArray[i][1] = string;
                string = stringArray[i + 1][2];
                stringArray[i + 1][2] = stringArray[i][2];
                stringArray[i][2] = string;
            }
        }
        for (n = 0; n < this.highscoreData.length; ++n) {
            this.highscoreData[n][0] = stringArray[n][0];
            this.highscoreData[n][1] = stringArray[n][1];
            this.highscoreData[n][2] = stringArray[n][2];
        }
        this.mRaftRMS.setHighscoreData(this.highscoreData);
        this.raftSettings[7] = "1";
        this.initArrays();
        this.initMenus();
    }

    private void initSaveHighscore(int n) {
        if (this.game != null) {
            this.game.stop();
        }
        this.hasHighscore = false;
        this.signF = new Form(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 2));
        this.signSI = new StringItem(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 63), "" + n);
        this.signTF = new TextField(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 49), "", 3, 0);
        this.signF.append((Item)this.signSI);
        this.signF.append((Item)this.signTF);
        this.signF.addCommand(this.okCommand);
        this.signF.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.signF);
        this.display.setCurrentItem((Item)this.signTF);
    }

    private void showHelp() {
        this.helpTextForm = new Form(this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 4));
        this.helpTextBox = new StringItem(null, this.sonyEricssonTextLabels.getTextLabel(this.sonyEricssonTextLabels.getCurrentLanguage(), 71));
        this.helpTextForm.append((Item)this.helpTextBox);
        this.helpTextForm.addCommand(this.backCommand);
        this.helpTextForm.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.helpTextForm);
    }

    public void requestSaveScore() {
        this.hasHighscore = false;
        this.initSaveHighscore(this.setScore);
    }

    private void showHighscore(boolean bl) {
        this.highscoreMenu.updateTable(bl);
        this.display.setCurrent((Displayable)this.highscoreMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand && this.mainMenu.isShown()) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (command == this.backCommand) {
            if (!this.mainMenu.isShown()) {
                if (this.gameIsRunning) {
                    this.game.stop();
                    this.gameIsRunning = false;
                    if (!this.game.gameOver) {
                        this.hasPausedGame = true;
                    }
                    this.game.removeCommand(this.backCommand);
                    this.initArrays();
                    this.initMenus();
                    this.display.setCurrent((Displayable)this.mainMenu);
                } else if (this.languageMenu.isShown()) {
                    if (this.doFirstTimer) {
                        this.doFirstTimer = false;
                        RaftRMS.clearSettings();
                        this.destroyApp(true);
                        this.notifyDestroyed();
                    } else {
                        this.display.setCurrent((Displayable)this.optionMenu);
                    }
                } else if (this.optionMenu.isShown()) {
                    this.display.setCurrent((Displayable)this.mainMenu);
                } else if (this.vibrationMenu.isShown()) {
                    this.display.setCurrent((Displayable)this.optionMenu);
                } else if (this.highscoreMenu.isShown()) {
                    this.display.setCurrent((Displayable)this.mainMenu);
                } else if (this.riverMenu.isShown()) {
                    this.display.setCurrent((Displayable)this.mainMenu);
                } else if (this.gametypeMenu.isShown()) {
                    this.display.setCurrent((Displayable)this.mainMenu);
                } else if (this.helpTextForm.isShown()) {
                    this.display.setCurrent((Displayable)this.mainMenu);
                }
            }
        } else if (command == this.okCommand && this.signF.isShown()) {
            this.saveHighscore();
            ++this.currentLevel;
            this.game.stop();
            this.game.removeCommand(this.backCommand);
            this.initArrays();
            this.initMenus();
            this.gameIsRunning = false;
            this.hasPausedGame = false;
            this.showHighscore(true);
        } else if (command == SEListObject.SELECT_COMMAND && this.mainMenu.isShown()) {
            switch (this.mainMenuArray[this.mainMenu.getSelectedIndex()].getId()) {
                case 0: {
                    this.display.setCurrent((Displayable)this.gametypeMenu);
                    break;
                }
                case 1: {
                    this.resumeGame();
                    break;
                }
                case 2: {
                    this.showHighscore(false);
                    break;
                }
                case 70: {
                    this.display.setCurrent((Displayable)this.optionMenu);
                    break;
                }
                case 4: {
                    this.showHelp();
                    break;
                }
                case 5: {
                    this.destroyApp(true);
                    this.notifyDestroyed();
                    break;
                }
                default: {
                    this.destroyApp(true);
                    this.notifyDestroyed();
                    break;
                }
            }
        } else if (command == SEListObject.SELECT_COMMAND && this.languageMenu.isShown()) {
            this.sonyEricssonTextLabels.setCurrentLanguage(this.languageMenuArray[this.languageMenu.getSelectedIndex()].getId());
            this.initArrays();
            this.initMenus();
            RaftRMS.storeSettings(this.sonyEricssonTextLabels.getCurrentLanguage(), this.sonyEricssonTextLabels, this);
            if (this.doFirstTimer) {
                this.doFirstTimer = false;
                this.display.setCurrent((Displayable)this.mainMenu);
            } else {
                this.display.setCurrent((Displayable)this.optionMenu);
            }
        } else if (command == SEListObject.SELECT_COMMAND && this.optionMenu.isShown()) {
            switch (this.optionMenuArray[this.optionMenu.getSelectedIndex()].getId()) {
                case 9: {
                    for (int i = 0; i < this.languageMenuArray.length; ++i) {
                        if (this.languageMenuArray[i].getId() != this.sonyEricssonTextLabels.getCurrentLanguage()) continue;
                        this.languageMenu.setSelectedIndex(i, true);
                    }
                    this.display.setCurrent((Displayable)this.languageMenu);
                    break;
                }
                case 11: {
                    break;
                }
                case 10: {
                    if (this.vibration == 0) {
                        this.vibrationMenu.setSelectedIndex(1, true);
                    } else {
                        this.vibrationMenu.setSelectedIndex(0, true);
                    }
                    this.display.setCurrent((Displayable)this.vibrationMenu);
                    break;
                }
                default: {
                    this.destroyApp(true);
                    this.notifyDestroyed();
                    break;
                }
            }
        } else if (command == SEListObject.SELECT_COMMAND && this.vibrationMenu.isShown()) {
            switch (this.vibrationMenuArray[this.vibrationMenu.getSelectedIndex()].getId()) {
                case 12: {
                    this.raftSettings[9] = RaftRMS.setVibration(100);
                    this.vibration = 100;
                    this.display.setCurrent((Displayable)this.optionMenu);
                    break;
                }
                case 13: {
                    this.raftSettings[9] = RaftRMS.setVibration(0);
                    this.vibration = 0;
                    this.display.setCurrent((Displayable)this.optionMenu);
                    break;
                }
                default: {
                    this.destroyApp(true);
                    this.notifyDestroyed();
                    break;
                }
            }
        } else if (command == SEListObject.SELECT_COMMAND && this.riverMenu.isShown()) {
            int n = this.riverMenuArray[this.riverMenu.getSelectedIndex()].getId() - 27;
            this.startGame(this.riverMenuArray[this.riverMenu.getSelectedIndex()].getId());
        } else if (command == SEListObject.SELECT_COMMAND && this.gametypeMenu.isShown()) {
            switch (this.gametypeMenuArray[this.gametypeMenu.getSelectedIndex()].getId()) {
                case 6: {
                    this.careerMode = true;
                    this.currentLevel = this.levelPlaying;
                    this.startGame(27 + this.levelPlaying);
                    break;
                }
                case 7: {
                    this.careerMode = true;
                    this.currentLevel = this.levelUnlocked;
                    this.startGame(27 + this.levelUnlocked);
                    break;
                }
                case 8: {
                    this.careerMode = false;
                    this.display.setCurrent((Displayable)this.riverMenu);
                    break;
                }
                default: {
                    this.destroyApp(true);
                    this.notifyDestroyed();
                }
            }
        }
    }

    private class SEListObject
    extends List {
        public SEListObject(int n, String string, SEItemIdentifier[] sEItemIdentifierArray) {
            super(string, 3);
            for (int i = 0; i < sEItemIdentifierArray.length; ++i) {
                this.append(sEItemIdentifierArray[i].getLabel(), null);
            }
        }
    }

    private class SEItemIdentifier {
        private int intId;
        private String stringLabel;

        public SEItemIdentifier() {
            this.intId = 0;
            this.stringLabel = null;
        }

        public SEItemIdentifier(int n, String string) {
            this.intId = n;
            this.stringLabel = string;
        }

        public void setId(int n) {
            this.intId = n;
        }

        public void setLabel(String string) {
            this.stringLabel = string;
        }

        public int getId() {
            return this.intId;
        }

        public String getLabel() {
            return this.stringLabel;
        }
    }
}

