/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ObjectSprite
extends Sprite {
    private int mKX;
    private int mKY;
    private int frameCount = 0;
    private int myMod;
    private int myHeight;
    private int dmg;
    private int collidedAgo = 0;
    private int myFrame;
    public final int objectType;
    public int myZ;
    public boolean collOnOff = false;
    public boolean hasCollOff;
    private static final int[] kLogFrameLookup = new int[]{5, 4, 3, 2, 1, 0};
    private static final int[] kRockFrameLookup = new int[]{0, 0, 7, 7, 0, 0, 7, 7, 0, 0, 7, 7, 14, 14};
    private static final int[] kLogBFrameLookup = new int[]{14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    private static final int[] kWhirlFrameLookup = new int[]{0, 1, 2, 3};

    public ObjectSprite(Image image, int n, int n2, int n3, int n4) {
        super(image, n, n2);
        this.defineReferencePixel(n / 2, n2 / 2);
        this.objectType = n3;
        this.myHeight = n2 / 2;
        this.myMod = 0;
        this.myFrame = n4;
        this.setFrame(this.myFrame);
        switch (this.objectType) {
            case 0: {
                this.hasCollOff = true;
                this.myMod = kRockFrameLookup.length;
                break;
            }
            case 1: {
                this.myMod = kLogFrameLookup.length;
                this.hasCollOff = true;
                break;
            }
            case 2: {
                this.myMod = kLogBFrameLookup.length;
                this.hasCollOff = false;
                break;
            }
            case 3: {
                this.hasCollOff = false;
                this.myMod = kRockFrameLookup.length;
                break;
            }
            case 4: {
                this.myMod = kWhirlFrameLookup.length;
                this.hasCollOff = true;
                break;
            }
            default: {
                this.myMod = 0;
            }
        }
    }

    public void getDamage() {
        if (!this.collOnOff && this.hasCollOff) {
            this.collOnOff = true;
            this.collidedAgo = 0;
        }
    }

    public boolean tick() {
        this.myZ = this.getY() + this.myHeight;
        if (this.collOnOff) {
            ++this.collidedAgo;
            if (this.collidedAgo == 15) {
                this.collOnOff = false;
            }
        }
        switch (this.objectType) {
            case 0: {
                ++this.frameCount;
                this.frameCount %= this.myMod;
                this.setFrame(this.myFrame + kRockFrameLookup[this.frameCount]);
                break;
            }
            case 1: {
                ++this.frameCount;
                this.frameCount %= this.myMod;
                this.setFrame(kLogFrameLookup[this.frameCount]);
                break;
            }
            case 2: {
                ++this.frameCount;
                this.frameCount %= this.myMod;
                this.setFrame(kLogBFrameLookup[this.frameCount]);
                break;
            }
            case 3: {
                ++this.frameCount;
                this.frameCount %= this.myMod;
                this.setFrame(this.myFrame + kRockFrameLookup[this.frameCount]);
                break;
            }
            case 4: {
                ++this.frameCount;
                this.frameCount %= this.myMod;
                this.setFrame(kWhirlFrameLookup[this.frameCount]);
                break;
            }
        }
        return this.collOnOff;
    }
}

