/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import javax.microedition.midlet.MIDlet;

public class RaftingCanvas
extends GameCanvas
implements Runnable {
    private boolean mTrucking;
    public boolean gameOver;
    public boolean levelComplete;
    public boolean hasHighscore = false;
    private RaftSprite mRaft;
    private Sprite mRaftGhost;
    private Sprite mCollSplash;
    private Sprite mSpeedSplash;
    private TiledLayer mBoardA;
    private TiledLayer mBoardB;
    private LayerManager mLayerManager;
    private LevelData mLevelManager;
    private ObjectSprite[] mObjects;
    private WaterEffects[] water;
    private Random myRandom = new Random();
    private int winCondition;
    private int aTileset;
    private SonyEricssonTextLabels SELabels;
    private boolean myIntro = true;
    private int myIntroDelay = 0;
    private static final Font font = Font.getFont((int)0, (int)1, (int)0);
    private static final Font fontSmall = Font.getFont((int)0, (int)1, (int)8);
    private static final Image[] gameImages = new Image[5];
    private static final Image[] tileImages = new Image[3];
    private static final Image[] interfaceImages = new Image[3];
    public static Image raftImage;
    private static Image ghostImage;
    private static Image collSplash;
    private static Image speedSplash;
    private int repeater;
    private int objectMarker;
    private int level;
    private int grindDamage = 0;
    private int waterPower = 0;
    private int speedSplashCounter = 0;
    private int speedAnim = 0;
    private int inputDelta = 0;
    public int myCurrentLeftX;
    public int myCurrentLeftY;
    public int objectsX = -176;
    public int objectsY = -176;
    private int mX;
    private int mY;
    private int raftVel;
    private int maxSpeed;
    private int scoreCountDown = 0;
    private long gameTime;
    private long gameTimeNow;
    private long gameDuration;
    private SEGameController mParent;
    private Display display;
    private int splashCounter = -1;

    public RaftingCanvas(int n, SEGameController sEGameController, SonyEricssonTextLabels sonyEricssonTextLabels) throws IOException {
        super(true);
        this.setFullScreenMode(true);
        this.mParent = sEGameController;
        this.SELabels = sonyEricssonTextLabels;
        this.display = Display.getDisplay((MIDlet)this.mParent);
        try {
            this.generateLevel(n);
        }
        catch (IOException iOException) {
            System.out.println("Error: Level Creation Failed!");
        }
    }

    private void initAlways() {
        this.repeater = 0;
        this.myCurrentLeftX = 0;
        this.myCurrentLeftY = 0;
        this.objectsX = 0;
        this.objectsY = 0;
        this.maxSpeed = 16;
        this.raftVel = 0;
        this.mX = 0;
        this.mY = 0;
        this.scoreCountDown = 0;
        this.gameTime = 0L;
        this.gameTimeNow = 0L;
        this.gameDuration = 0L;
        this.gameOver = false;
        this.levelComplete = false;
        this.hasHighscore = false;
    }

    public void generateLevel(int n) throws IOException {
        int n2;
        this.initAlways();
        this.maxSpeed += n - 27;
        this.level = n;
        this.waterPower = n - 27 + 5;
        this.mRaft = this.createRaft();
        this.mRaftGhost = this.createGhost();
        this.mBoardA = this.createBoard(n, 0);
        this.mBoardB = this.createBoard(n, 1);
        this.mLayerManager = new LayerManager();
        this.mLevelManager = new LevelData(n - 27);
        this.mSpeedSplash = this.createSpeedSplash();
        this.winCondition = this.mLevelManager.currLevData[this.mLevelManager.currLevData.length - 1][0] + 176;
        this.mBoardB.setPosition(0, 144);
        this.mRaft.setPosition(0, 24);
        this.mRaft.forward(0);
        this.mRaft.requestMove(0, 0);
        this.mRaftGhost.setPosition(0, 24);
        this.mRaftGhost.setVisible(false);
        this.mLayerManager.append((Layer)this.mBoardB);
        this.mLayerManager.append((Layer)this.mRaft);
        this.mLayerManager.append((Layer)this.mRaftGhost);
        this.water = null;
        this.water = new WaterEffects[this.waterPower * 2 + 8];
        for (n2 = 0; n2 < this.water.length; ++n2) {
            this.water[n2] = new WaterEffects();
        }
        this.mObjects = new ObjectSprite[10];
        for (n2 = 0; n2 < this.mObjects.length; ++n2) {
            this.mObjects[n2] = this.createObject(this.mLevelManager.currLevData[n2][1]);
            this.mObjects[n2].setPosition(this.mLevelManager.currLevData[n2][0], this.mLevelManager.currLevData[n2][2]);
            this.mLayerManager.append((Layer)this.mObjects[n2]);
        }
        this.mCollSplash = this.createCollSplash();
        this.mCollSplash.setVisible(false);
        this.mCollSplash.setPosition(0, 24);
        this.mSpeedSplash.setVisible(false);
        this.mLayerManager.append((Layer)this.mSpeedSplash);
        this.mLayerManager.append((Layer)this.mCollSplash);
        this.mLayerManager.append((Layer)this.mBoardA);
        this.objectMarker = this.mObjects.length;
        this.gameOver = false;
        this.levelComplete = false;
    }

    private RaftSprite createRaft() throws IOException {
        return new RaftSprite(raftImage, 64, 64, this);
    }

    private Sprite createCollSplash() throws IOException {
        return new Sprite(collSplash, 22, 22);
    }

    private Sprite createSpeedSplash() throws IOException {
        return new Sprite(speedSplash, 64, 64);
    }

    private Sprite createGhost() throws IOException {
        return new Sprite(ghostImage, 64, 64);
    }

    private ObjectSprite createObject(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = n / 10;
        int n5 = n % 10;
        switch (n4) {
            case 0: {
                n2 = 16;
                n3 = 16;
                break;
            }
            case 1: {
                n2 = 36;
                n3 = 26;
                break;
            }
            case 2: {
                n2 = 24;
                n3 = 26;
                break;
            }
            case 3: {
                n2 = 32;
                n3 = 32;
                break;
            }
            case 4: {
                n2 = 32;
                n3 = 16;
                break;
            }
            default: {
                n2 = 16;
                n3 = 16;
            }
        }
        return new ObjectSprite(gameImages[n4], n2, n3, n4, n5);
    }

    private TiledLayer createBoard(int n, int n2) throws IOException {
        int n3;
        this.aTileset = n3 = n % 3;
        TiledLayer tiledLayer = new TiledLayer(22, 9, tileImages[n3], 16, 16);
        if (n2 == 0) {
            short[] sArray = new short[]{0, 0, 0, 0, 0, 6, 3, 2, 4, 5, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 6, 3, 2, 4, 5, 1, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 2, 4, 5, 1, 5, 5, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 2, 4, 5, 1, 5, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 2, 4, 5, 13, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 2, 4, 5, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 2, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6};
            for (int i = 0; i < sArray.length; ++i) {
                int n4 = i % 22;
                int n5 = i / 22;
                tiledLayer.setCell(n4, n5, (int)sArray[i]);
            }
        } else {
            short[] sArray = new short[]{12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 10, 12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 9, 8, 10, 12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 8, 10, 12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 8, 10, 12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 8, 10, 12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 8, 10, 12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 8, 10, 12, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 9, 8, 10, 12, 11, 0, 0, 0, 0};
            for (int i = 0; i < sArray.length; ++i) {
                int n6 = i % 22;
                int n7 = i / 22;
                tiledLayer.setCell(n6, n7, (int)sArray[i]);
            }
        }
        return tiledLayer;
    }

    public void start() {
        this.mTrucking = true;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        long l;
        Graphics graphics = this.getGraphics();
        int n = 80;
        long l2 = l = System.currentTimeMillis();
        while (this.mTrucking) {
            int n2;
            long l3 = System.currentTimeMillis();
            this.gameDuration = l3 - l;
            l = System.currentTimeMillis();
            if (this.myIntro) {
                this.render(graphics);
                l2 = System.currentTimeMillis();
                n2 = (int)(l2 - l3);
                if (n2 >= n) continue;
                try {
                    Thread.sleep(n - n2);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!this.gameOver && !this.levelComplete) {
                this.gameTimeNow += this.gameDuration;
            }
            if (!this.gameOver && !this.levelComplete) {
                this.input();
            }
            this.tick();
            this.render(graphics);
            l2 = System.currentTimeMillis();
            n2 = (int)(l2 - l3);
            if (n2 >= n) continue;
            try {
                Thread.sleep(n - n2);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean checkRaft() {
        return this.mRaftGhost.collidesWith(this.mBoardA, true);
    }

    private void tick() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.raftVel < this.maxSpeed) {
            ++this.raftVel;
        }
        int n = (this.raftVel + this.inputDelta >> 3) * 2;
        int n2 = this.raftVel + this.inputDelta >> 3;
        if (!this.gameOver && !this.levelComplete) {
            this.mRaft.requestMove(n, n2);
            this.myCurrentLeftX += n;
            this.myCurrentLeftY += n2;
            this.objectsX += n;
            this.objectsY += n2;
            this.mRaftGhost.setVisible(true);
            this.mRaftGhost.setFrame(this.mRaft.getGhostFrame());
            this.mRaftGhost.setTransform(this.mRaft.getGhostTransform());
        }
        this.mRaft.tick(this);
        this.mRaftGhost.setPosition(this.mRaft.getX(), this.mRaft.getY());
        int n3 = this.myCurrentLeftX - 32;
        for (int i = 0; i < this.mObjects.length; ++i) {
            if (this.mObjects[i].getX() < n3) {
                if (this.objectMarker >= this.mLevelManager.currLevData.length) continue;
                this.mLayerManager.remove((Layer)this.mObjects[i]);
                try {
                    this.mObjects[i] = this.createObject(this.mLevelManager.currLevData[this.objectMarker][1]);
                    this.mObjects[i].setPosition(this.mLevelManager.currLevData[this.objectMarker][0] - this.objectsX + this.myCurrentLeftX, this.mLevelManager.currLevData[this.objectMarker][2] - this.objectsY + this.myCurrentLeftY);
                    this.mLayerManager.append((Layer)this.mObjects[i]);
                    ++this.objectMarker;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                continue;
            }
            if (this.mObjects[i].tick() || !this.mRaftGhost.collidesWith((Sprite)this.mObjects[i], true)) continue;
            this.mObjects[i].getDamage();
            if (this.mObjects[i].objectType == 3 || this.mObjects[i].objectType == 2) {
                bl2 = true;
                if (this.raftVel > 8) {
                    bl3 = true;
                    this.mRaft.setDamage(this.mObjects[i].objectType, this.mObjects[i]);
                    this.splashCounter = 2;
                    this.mCollSplash.setVisible(true);
                    this.mCollSplash.setPosition(this.mObjects[i].getX(), (this.mObjects[i].getY() + this.mRaft.getY()) / 2 + 4);
                    continue;
                }
                if (this.splashCounter < 0) {
                    this.splashCounter = 2;
                    this.mCollSplash.setVisible(true);
                }
                if (this.grindDamage > 5) {
                    this.mRaft.setDamage(this.mObjects[i].objectType + 4, this.mObjects[i]);
                    this.grindDamage = 0;
                    continue;
                }
                ++this.grindDamage;
                continue;
            }
            this.raftVel -= 4;
            bl3 = true;
            this.mRaft.setDamage(this.mObjects[i].objectType, this.mObjects[i]);
        }
        if (bl2) {
            this.raftVel = 0;
            this.mRaft.undoMove(-n, -n2);
            this.myCurrentLeftX -= n;
            this.myCurrentLeftY -= n2;
            this.objectsX -= n;
            this.objectsY -= n2;
        } else if (this.raftVel < 0) {
            this.raftVel = 0;
        }
        if (this.splashCounter >= 0) {
            this.mCollSplash.setFrame(2 - this.splashCounter);
            --this.splashCounter;
        } else {
            this.mCollSplash.setVisible(false);
        }
        if (this.speedSplashCounter > 0 && this.mRaft.getState()) {
            if (this.mRaft.getGhostFrame() < 4) {
                ++this.speedAnim;
                this.speedAnim %= 3;
                this.mSpeedSplash.setTransform(this.mRaft.getGhostTransform());
                this.mSpeedSplash.setFrame(this.mRaft.getGhostFrame() + this.speedAnim * 4);
                this.mSpeedSplash.setPosition(this.mRaft.getX() - 12, this.mRaft.getY());
                this.mSpeedSplash.setVisible(true);
                --this.speedSplashCounter;
            }
        } else {
            this.mSpeedSplash.setVisible(false);
        }
        this.mRaftGhost.setVisible(false);
        if (this.mRaft.getDamage() < 1) {
            this.gameOver = true;
            this.mRaft.setDeath();
        }
        if (bl3 && !this.gameOver) {
            this.display.vibrate(this.mParent.vibration);
        }
        if (this.gameOver) {
            this.display.vibrate(0);
        }
        this.doZSort();
    }

    private void doZSort() {
        this.mLayerManager.insert((Layer)this.mRaft, 1);
        this.mLayerManager.insert((Layer)this.mSpeedSplash, 8);
        for (int i = 0; i < this.mObjects.length; ++i) {
            if (this.mObjects[i].objectType != 3 && this.mObjects[i].objectType != 2 || this.mObjects[i].myZ < this.mRaft.myZ) continue;
            this.mLayerManager.insert((Layer)this.mObjects[i], 0);
        }
        this.mLayerManager.insert((Layer)this.mCollSplash, 0);
        this.mLayerManager.insert((Layer)this.mBoardB, 0);
    }

    private void input() {
        int n = this.getKeyStates();
        this.inputDelta = 1;
        if ((n & 0x100) != 0) {
            ++this.inputDelta;
            this.speedSplashCounter = 10;
        }
        if ((n & 4) != 0) {
            this.mRaft.forward(-this.inputDelta);
            --this.raftVel;
        } else if ((n & 0x20) != 0) {
            this.mRaft.forward(this.inputDelta);
            --this.raftVel;
        } else if ((n & 2) != 0) {
            this.mRaft.forward(this.inputDelta);
            --this.raftVel;
        } else if ((n & 0x40) != 0) {
            this.mRaft.forward(-this.inputDelta);
            --this.raftVel;
        } else {
            this.mRaft.followStream();
        }
        if (this.raftVel <= 0) {
            this.raftVel = 0;
        }
    }

    private void render(Graphics graphics) {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        graphics.setColor(4423868);
        graphics.fillRect(0, 24, n2, n3 - 24);
        int n4 = (n2 - 176) / 2;
        int n5 = (n3 - 176) / 2;
        graphics.setColor(40, 70, 128);
        for (n = 0; n < this.waterPower; ++n) {
            this.water[n].rita(graphics);
        }
        graphics.setColor(255, 255, 255);
        for (n = this.waterPower; n < this.water.length; ++n) {
            this.water[n].rita(graphics);
        }
        this.mLayerManager.setViewWindow(this.myCurrentLeftX, this.myCurrentLeftY, 176, 196);
        this.mLayerManager.paint(graphics, 0, 24);
        this.drawHUD(graphics);
        if (this.gameOver) {
            this.drawGameOver(graphics);
        }
        if (this.levelComplete) {
            this.drawLevelComplete(graphics);
        }
        if (this.myIntro) {
            this.drawReadyGo(graphics);
        }
        this.flushGraphics();
        this.wrapMap();
    }

    private void wrapMap() {
        int n;
        if (this.myCurrentLeftY >= 64) {
            for (n = 0; n < this.mObjects.length; ++n) {
                this.mObjects[n].move(-this.myCurrentLeftX, -this.myCurrentLeftY);
            }
            this.mRaft.move(-128, -64);
            this.myCurrentLeftX -= 128;
            this.myCurrentLeftY -= 64;
            ++this.repeater;
        }
        if (this.objectsX > this.winCondition && !this.levelComplete) {
            this.mRaft.setState(9);
            this.levelComplete = true;
            n = 1000 * (this.level - 27) - (int)(this.gameTimeNow / 100L) + this.mRaft.getDamage() * 2;
            if (n < 0) {
                n = 0 + this.mRaft.getDamage() * 2;
            }
            if (this.mParent.unlockNextLevel(n)) {
                this.hasHighscore = true;
            }
        }
    }

    public void stop() {
        this.mTrucking = false;
    }

    public int getRandomInt(int n) {
        int n2 = this.myRandom.nextInt() % n;
        if (n2 < 0) {
            n2 += n;
        }
        return n2;
    }

    private void drawGameOver(Graphics graphics) {
        graphics.setFont(font);
        graphics.setColor(0);
        graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 17), this.getWidth() / 2 + 2, this.getHeight() / 2 + 2, 33);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 17), this.getWidth() / 2, this.getHeight() / 2, 33);
        if (this.scoreCountDown >= 45) {
            this.mParent.setGametypeMenu();
        }
        ++this.scoreCountDown;
    }

    private void drawReadyGo(Graphics graphics) {
        ++this.myIntroDelay;
        if (this.myIntroDelay < 30) {
            int n = this.myIntroDelay % 6;
            if (n < 3) {
                graphics.setFont(font);
                graphics.setColor(0);
                graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 22), this.getWidth() / 2 + 2, this.getHeight() / 2 + 2, 33);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 22), this.getWidth() / 2, this.getHeight() / 2, 33);
            }
        } else if (this.myIntroDelay < 40) {
            graphics.setFont(font);
            graphics.setColor(0);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 23), this.getWidth() / 2 + 2, this.getHeight() / 2 + 2, 33);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 23), this.getWidth() / 2, this.getHeight() / 2, 33);
        } else {
            this.myIntroDelay = 0;
            this.myIntro = false;
        }
    }

    private void drawLevelComplete(Graphics graphics) {
        graphics.setFont(font);
        graphics.setColor(0);
        if (this.hasHighscore) {
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), this.getWidth() / 2 + 2, this.getHeight() / 2 + 2, 33);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 16), this.getWidth() / 2 + 2, this.getHeight() / 2 + 22, 33);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), this.getWidth() / 2, this.getHeight() / 2, 33);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 16), this.getWidth() / 2, this.getHeight() / 2 + 20, 33);
            if (this.scoreCountDown >= 25) {
                this.mParent.requestSaveScore();
            }
        } else {
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), this.getWidth() / 2 + 2, this.getHeight() / 2 + 2, 33);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(this.SELabels.getTextLabel(this.SELabels.getCurrentLanguage(), 18), this.getWidth() / 2, this.getHeight() / 2, 33);
            if (this.scoreCountDown >= 45) {
                this.mParent.setGametypeMenu();
            }
        }
        ++this.scoreCountDown;
    }

    private void drawHUD(Graphics graphics) {
        graphics.setFont(fontSmall);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(0);
        graphics.drawImage(interfaceImages[this.aTileset], 0, 0, 20);
        long l = this.gameTimeNow / 100L;
        graphics.drawString("" + l, 170, 19, 40);
        int n3 = this.mRaft.getDamage();
        if (n3 > 0) {
            graphics.setColor(255 - (n3 <<= 1), n3 + 100, 0);
            graphics.fillRect(32, 7, this.mRaft.getDamage(), 11);
        }
    }

    protected void hideNotify() {
        this.stop();
    }

    protected void showNotify() {
        if (!this.mTrucking) {
            this.start();
        }
    }

    static {
        try {
            RaftingCanvas.gameImages[0] = Image.createImage((String)"/small_static_1.png");
            RaftingCanvas.gameImages[1] = Image.createImage((String)"/log_anim_1.png");
            RaftingCanvas.gameImages[2] = Image.createImage((String)"/log_anim_2.png");
            RaftingCanvas.gameImages[3] = Image.createImage((String)"/large_static_1.png");
            RaftingCanvas.gameImages[4] = Image.createImage((String)"/whirlTiles.png");
            RaftingCanvas.tileImages[0] = Image.createImage((String)"/rockyTileSet.png");
            RaftingCanvas.tileImages[1] = Image.createImage((String)"/forestTileSet.png");
            RaftingCanvas.tileImages[2] = Image.createImage((String)"/mountainTileSet.png");
            RaftingCanvas.interfaceImages[0] = Image.createImage((String)"/gui_r.png");
            RaftingCanvas.interfaceImages[1] = Image.createImage((String)"/gui_f.png");
            RaftingCanvas.interfaceImages[2] = Image.createImage((String)"/gui_m.png");
            raftImage = Image.createImage((String)"/raft.png");
            ghostImage = Image.createImage((String)"/raft_mask.png");
            collSplash = Image.createImage((String)"/collSplash.png");
            speedSplash = Image.createImage((String)"/speedSplash.png");
        }
        catch (IOException iOException) {
            System.out.println("Image loading error:" + iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Not enough memory:" + outOfMemoryError);
        }
    }
}

