/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas.item;

import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItemStyle;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextInputCanvasItem
extends CanvasItem {
    int fieldWidth = 0;
    String inputString = "";
    Font font = Font.getDefaultFont();
    int fontColor = Color.DEFAULT_ITEM_FONT_COLOR;
    String label = "";

    public TextInputCanvasItem(BaseCanvas canvas, String inputString, int itemWidth, int fieldWidth, boolean isSelectable, CanvasItemStyle canvasItemStyle) {
        this(canvas);
        this.canvasItemStyle = canvasItemStyle;
        this.font = this.canvasItemStyle.getFont();
        this.setItemWidth(itemWidth);
        this.setItemHeight(this.font.getHeight());
        this.setFieldWidth(fieldWidth);
        this.setInputString(inputString);
        this.setSelectable(isSelectable);
    }

    public TextInputCanvasItem(BaseCanvas canvas) {
        super(canvas);
        this.setSelectable(false);
    }

    public String getLable() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }

    public String getInputString() {
        if (this.inputString == null) {
            return "";
        }
        return this.inputString;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString != null ? inputString : "";
    }

    public int draw(Graphics g, int x, int y) {
        if (g != null) {
            g.setFont(this.font);
            int tmpX = x;
            if (this.label != null && this.label.length() > 0) {
                g.drawString(String.valueOf(this.label) + " ", x, y, 20);
                tmpX += this.font.stringWidth(String.valueOf(this.label) + " ");
            }
            int color = g.getColor();
            g.setColor(0xFFFFFF);
            int fieldOffset = 0;
            if (this.label != null && this.label.length() > 0) {
                fieldOffset += this.font.stringWidth(String.valueOf(this.label) + " ");
            }
            if (fieldOffset + this.fieldWidth > this.itemWidth) {
                this.fieldWidth = this.itemWidth - fieldOffset;
            }
            g.fillRect(tmpX, y, this.fieldWidth - 1, this.itemHeight - 1);
            g.setColor(color);
            if (this.isHightlighted()) {
                g.setColor(Color.DEFAULT_ITEM_CONTENT_BG_COLOR);
                g.fillRect(x, y, this.getItemWidth(), this.getItemHeight());
            }
            g.setColor(this.fontColor);
            if (this.label != null && this.label.length() > 0) {
                g.drawString(String.valueOf(this.label) + " ", x, y, 20);
                x += this.font.stringWidth(String.valueOf(this.label) + " ");
            }
            g.drawRect(x, y, this.fieldWidth - 1, this.itemHeight - 1);
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int tmpClipY = y;
            if (tmpClipY < clipY) {
                tmpClipY = clipY;
            }
            g.setClip(x, tmpClipY, this.fieldWidth, this.itemHeight);
            g.drawString(this.inputString, x + 2, y, 20);
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        return y += this.itemHeight;
    }

    public void unlaod() {
        this.inputString = null;
        this.font = null;
        this.label = null;
        super.unload();
    }
}

