/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas;

import com.pacmobile.yp.mypcard.MYPConstants;
import com.pacmobile.yp.mypcard.rms.LanguageRMS;
import com.pacmobile.yp.mypcard.rms.PersonalInformationRMS;
import com.pacmobile.yp.mypcard.rms.RegistrationRMS;
import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.PushDownListCanvasItem;
import com.pacmobile.yp.mypcard.utility.Locale;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenuCanvas
extends BaseCanvas {
    private static Image bgImage = null;
    private static Image bgTitleImage = null;
    private static Image bgTitleChiImage = null;
    private static Image bgTitleEngImage = null;
    int itemsOffsetY = MYPConstants.ITEM_OFFSET_Y;
    String magicKeySeq = "*#00193700#*";
    int magicKeyIndex = 0;

    public MainMenuCanvas() {
        System.gc();
        this.setDrawableHeight(this.getHeight() - this.itemsOffsetY - this.getSoftKeyBarHeight());
        this.setDrawableWidth(this.getWidth() - this.getScrollBarWidth());
        this.setDrawableX(0);
        this.setDrawableY(this.itemsOffsetY);
        try {
            if (bgImage == null) {
                bgImage = Image.createImage((String)"/images/bg.png");
            }
            if (bgTitleChiImage == null) {
                bgTitleChiImage = Image.createImage((String)"/images/bg_title_chi.png");
            }
            if (bgTitleEngImage == null) {
                bgTitleEngImage = Image.createImage((String)"/images/bg_title_eng.png");
            }
            bgTitleImage = Locale.getDefaultLocale().equals(Locale.localeEN) ? bgTitleEngImage : bgTitleChiImage;
        }
        catch (Exception e) {
            System.out.println("Cannot load splashImage: " + e);
        }
    }

    public void keyPressed(int keyCode) {
        if (this.isDisabled()) {
            return;
        }
        super.keyPressed(keyCode);
        if (this.displayStatus == BaseCanvas.DISPLAY_STATUS_NORMAL) {
            CanvasItem item;
            if (keyCode == BaseCanvas.KEY_UP || keyCode == BaseCanvas.KEY_2) {
                this.prevSelectableItem();
            }
            if (keyCode == BaseCanvas.KEY_DOWN || keyCode == BaseCanvas.KEY_8) {
                this.nextSelectableItem();
            }
            if ((keyCode == BaseCanvas.KEY_LEFT || keyCode == BaseCanvas.KEY_4) && (item = (CanvasItem)this.canvasItems.elementAt(this.selectedItemIndex)) != null && item instanceof PushDownListCanvasItem) {
                ((PushDownListCanvasItem)item).prevItem();
            }
            if ((keyCode == BaseCanvas.KEY_RIGHT || keyCode == BaseCanvas.KEY_6) && (item = (CanvasItem)this.canvasItems.elementAt(this.selectedItemIndex)) != null && item instanceof PushDownListCanvasItem) {
                ((PushDownListCanvasItem)item).nextItem();
            }
            char magicChar = BaseCanvas.keyCodeToChar(keyCode);
            if (this.magicKeySeq != null && this.magicKeyIndex >= 0 && this.magicKeyIndex < this.magicKeySeq.length()) {
                this.magicKeyIndex = this.magicKeySeq.charAt(this.magicKeyIndex) == magicChar ? ++this.magicKeyIndex : 0;
                if (this.magicKeyIndex == this.magicKeySeq.length()) {
                    LanguageRMS.deleteRecordStore();
                    RegistrationRMS.deleteRecordStore();
                    PersonalInformationRMS.deleteRecordStore();
                }
            }
        }
    }

    public void drawContent(Graphics g, int x, int y) {
        g.setClip(this.getDrawableX(), this.getDrawableY(), this.getDrawableWidth(), this.getDrawableHeight());
        if (this.canvasItems != null && this.canvasItems.size() > 0) {
            int i = 0;
            while (i < this.canvasItems.size()) {
                if (this.canvasItems.elementAt(i) != null) {
                    y = ((CanvasItem)this.canvasItems.elementAt(i)).draw(g, x, y);
                }
                ++i;
            }
        }
        g.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    public void draw() {
        if (this.isDisabled()) {
            return;
        }
        Graphics g = this.getStaticGraphics();
        if (g != null) {
            this.drawBuffer(g);
            this.drawScrollBar(g, this.getWidth() - this.getScrollBarWidth(), this.itemsOffsetY, this.getItemsHeight(), this.drawableHeight, this.contentRelativeY, this.scrollBarHeight);
            this.drawSoftKeyBar(g);
            BaseCanvas.drawDebugMsg(g);
            this.flushGraphics();
        }
    }

    void drawBuffer(Graphics g) {
        if (g != null) {
            if (bgImage != null) {
                g.drawImage(bgImage, 0, 0, 20);
            }
            if ((bgTitleImage = Locale.getDefaultLocale().equals(Locale.localeEN) ? bgTitleEngImage : bgTitleChiImage) != null) {
                g.drawImage(bgTitleImage, 0, 7, 20);
            }
            int x = 0;
            int y = this.itemsOffsetY + this.getContentRelativeY();
            this.drawContent(g, x, y);
        }
    }

    public synchronized void unload() {
        System.gc();
        super.unload();
    }
}

