/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas.item;

import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItemStyle;
import com.pacmobile.yp.mypcard.utility.LineEnumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CheckBoxCanvasItem
extends CanvasItem {
    long flashTime = System.currentTimeMillis();
    long flashTimePeriod = 750L;
    boolean flashFlag = false;
    boolean isFlash = false;
    boolean isSmallFont = false;
    boolean isWarning = false;
    Vector stringList = new Vector();
    Font font = Font.getDefaultFont();
    Image boxImage = null;
    Image checkedImage = null;
    Image uncheckedImage = null;
    LineEnumeration lineEnumeration = null;
    boolean isChecked = true;

    public CheckBoxCanvasItem(BaseCanvas canvas, String string, Image checkedImage, Image uncheckedImage, int itemWidth) {
        this(canvas, string, checkedImage, uncheckedImage, itemWidth, false);
    }

    public CheckBoxCanvasItem(BaseCanvas canvas, String string, Image checkedImage, Image uncheckedImage, int itemWidth, boolean isSelectable) {
        this(canvas, string, checkedImage, uncheckedImage, itemWidth, isSelectable, new CanvasItemStyle());
    }

    public CheckBoxCanvasItem(BaseCanvas canvas, String string, Image checkedImage, Image uncheckedImage, int itemWidth, boolean isSelectable, CanvasItemStyle canvasItemStyle) {
        this(canvas);
        this.setItemWidth(itemWidth);
        this.setSelectable(isSelectable);
        this.checkedImage = checkedImage;
        this.uncheckedImage = uncheckedImage;
        this.boxImage = uncheckedImage;
        this.canvasItemStyle = canvasItemStyle;
        this.font = this.canvasItemStyle.getFont();
        this.addString(string);
    }

    public CheckBoxCanvasItem(BaseCanvas canvas) {
        super(canvas);
        this.setSelectable(false);
        this.lineEnumeration = new LineEnumeration(this.font, "", 0);
    }

    public void setIsChecked(boolean isChecked) {
        this.isChecked = isChecked;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setIsFlash(boolean isFlash) {
        this.isFlash = isFlash;
    }

    public boolean isFlash() {
        return this.isFlash;
    }

    public void setIsSmallFont(boolean isSmallFont) {
        this.isSmallFont = isSmallFont;
    }

    public boolean isSmallFont() {
        return this.isSmallFont;
    }

    public void setIsWarning(boolean isWarning) {
        this.isWarning = isWarning;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public void addString(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        int stringWidth = this.getItemWidth();
        if (this.boxImage != null) {
            stringWidth -= this.boxImage.getWidth();
            stringWidth -= this.font.stringWidth("  ");
        }
        this.lineEnumeration.reset(this.font, string, stringWidth);
        String[] stringArray = this.lineEnumeration.getStringArray();
        if (stringArray != null && stringArray.length > 0) {
            int i = 0;
            while (i < stringArray.length) {
                this.stringList.addElement(stringArray[i]);
                ++i;
            }
        }
    }

    public int getItemHeight() {
        int height = 0;
        if (this.stringList != null && this.stringList.size() > 0) {
            height = this.font.getHeight() * this.stringList.size();
        }
        if (this.boxImage != null && this.boxImage.getHeight() > height) {
            height = this.boxImage.getHeight();
        }
        return height;
    }

    public int draw(Graphics g, int x, int y) {
        int initY = y;
        if (this.stringList != null && this.stringList.size() > 0) {
            if (this.canvasItemStyle.getItemAlign() == CanvasItemStyle.ITEM_ALIGN_CENTER) {
                if (this.canvas != null) {
                    x = (this.canvas.getWidth() - this.getItemWidth()) / 2;
                }
            } else if (this.canvasItemStyle.getItemAlign() == CanvasItemStyle.ITEM_ALIGN_RIGHT && this.canvas != null) {
                x = this.canvas.getWidth() - this.getItemWidth();
            }
            this.isFlash = this.canvasItemStyle.isFlashing();
            if (this.isHightlighted()) {
                g.setColor(Color.DEFAULT_ITEM_CONTENT_BG_COLOR);
                g.fillRect(x, y, this.getItemWidth(), this.getItemHeight());
            } else if (this.canvasItemStyle.isFlashing && this.flashFlag) {
                g.setColor(0xFFFFFF);
                g.fillRect(x, y, this.getItemWidth(), this.getItemHeight());
            }
            g.setFont(this.font);
            if (this.canvasItemStyle.getItemContentAlign() == CanvasItemStyle.ITEM_CONTENT_ALIGN_CENTER) {
                x = (this.getItemWidth() - this.getItemContentWidth()) / 2;
            }
            this.boxImage = this.isChecked() ? this.checkedImage : this.uncheckedImage;
            if (this.boxImage != null) {
                int iconPosY = initY + this.getItemHeight() / 2 - this.boxImage.getHeight() / 2;
                g.drawImage(this.boxImage, x, iconPosY, 20);
                x += this.boxImage.getWidth();
            }
            int i = 0;
            while (i < this.stringList.size()) {
                String string;
                int itemFontHeight = this.font.getHeight();
                int stringPosY = initY + (this.getItemHeight() / this.stringList.size() * i + (this.getItemHeight() / this.stringList.size() - itemFontHeight) / 2);
                g.setColor(Color.DEFAULT_ITEM_FONT_COLOR);
                if (!this.isHightlighted() && this.isFlash) {
                    if (this.flashFlag) {
                        g.setColor(0xFF2200);
                    }
                    if (System.currentTimeMillis() > this.flashTime + this.flashTimePeriod) {
                        this.flashTime = System.currentTimeMillis();
                        boolean bl = this.flashFlag = !this.flashFlag;
                    }
                }
                if (this.isWarning) {
                    g.setColor(0xFF0000);
                }
                if ((string = (String)this.stringList.elementAt(i)) != null && string.length() > 0) {
                    if (this.boxImage != null) {
                        string = "  " + string;
                    }
                    g.drawString(string, x, stringPosY, 20);
                }
                ++i;
            }
        }
        return initY + this.getItemHeight();
    }

    public int getItemContentWidth() {
        int result = 0;
        if (this.boxImage != null) {
            result += this.boxImage.getWidth();
        }
        int stringWidth = 0;
        int i = 0;
        while (i < this.stringList.size()) {
            Font itemFont = null;
            try {
                itemFont = Font.getFont((int)this.canvasItemStyle.getItemFontFace(), (int)this.canvasItemStyle.getItemFontStyle(), (int)this.canvasItemStyle.getItemFontSize());
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.getMessage());
                itemFont = Font.getDefaultFont();
            }
            String string = (String)this.stringList.elementAt(i);
            if (string != null && string.length() > 0) {
                if (this.boxImage != null) {
                    string = "  " + string;
                }
                if (itemFont.stringWidth(string) > stringWidth) {
                    stringWidth = itemFont.stringWidth(string);
                }
            }
            ++i;
        }
        return result += stringWidth;
    }

    public String toString() {
        String result = "";
        if (this.stringList != null && this.stringList.size() > 0) {
            int i = 0;
            while (i < this.stringList.size()) {
                result = String.valueOf(result) + this.stringList.elementAt(i);
                if (i != this.stringList.size() - 1) {
                    result = String.valueOf(result) + ",";
                }
                ++i;
            }
        }
        return result;
    }

    public void unload() {
        if (this.stringList != null) {
            this.stringList.removeAllElements();
            this.stringList = null;
        }
        this.font = null;
        this.boxImage = null;
        if (this.lineEnumeration != null) {
            this.lineEnumeration.unload();
            this.lineEnumeration = null;
        }
        System.gc();
        super.unload();
    }
}

