/*
 * Decompiled with CFR 0.152.
 */
package com.pacmobile.yp.mypcard.scene.canvas.item;

import com.pacmobile.yp.mypcard.scene.canvas.BaseCanvas;
import com.pacmobile.yp.mypcard.scene.canvas.Color;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItem;
import com.pacmobile.yp.mypcard.scene.canvas.item.CanvasItemStyle;
import com.pacmobile.yp.mypcard.utility.LineEnumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class PushDownListCanvasItem
extends CanvasItem {
    int fieldWidth = 0;
    String inputString = "";
    Font font = Font.getDefaultFont();
    int fontColor = Color.DEFAULT_ITEM_FONT_COLOR;
    String label = "";
    LineEnumeration lineEnumeration = null;
    int selectedItemIndex = 0;
    Vector itemList = new Vector();
    int numberOfLine = 1;
    int maxStringWidth = 0;

    public PushDownListCanvasItem(BaseCanvas canvas, int itemWidth, int fieldWidth, boolean isSelectable) {
        this(canvas, itemWidth, fieldWidth, isSelectable, new CanvasItemStyle());
    }

    public PushDownListCanvasItem(BaseCanvas canvas, int itemWidth, int fieldWidth, boolean isSelectable, CanvasItemStyle canvasItemStyle) {
        this(canvas);
        this.canvasItemStyle = canvasItemStyle;
        this.font = this.canvasItemStyle.getFont();
        this.setItemWidth(itemWidth);
        this.setItemHeight(this.font.getHeight());
        this.setFieldWidth(fieldWidth);
        this.setSelectable(isSelectable);
        this.lineEnumeration = new LineEnumeration(this.font, "", 0);
    }

    public PushDownListCanvasItem(BaseCanvas canvas) {
        super(canvas);
        this.setSelectable(false);
    }

    public void setSelectedItemIndex(int selectedItemIndex) {
        this.selectedItemIndex = selectedItemIndex;
    }

    public int getSelectedItemIndex() {
        return this.selectedItemIndex;
    }

    public void addItem(String item) {
        if (this.itemList == null) {
            this.itemList = new Vector();
        }
        if (item != null && item.length() > 0) {
            this.itemList.addElement(item);
            if (this.label != null && this.label.length() > 0 && this.font.stringWidth(item) > this.fieldWidth) {
                this.setItemHeight(2 * this.font.getHeight());
            }
        }
    }

    public void nextItem() {
        if (this.itemList != null && this.itemList.size() > 0) {
            ++this.selectedItemIndex;
            if (this.selectedItemIndex >= this.itemList.size()) {
                this.selectedItemIndex = this.itemList.size() - 1;
            }
        }
    }

    public void prevItem() {
        --this.selectedItemIndex;
        if (this.selectedItemIndex <= 0) {
            this.selectedItemIndex = 0;
        }
    }

    public String getLable() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public void setFieldWidth(int fieldWidth) {
        this.fieldWidth = fieldWidth;
    }

    public String getInputString() {
        return this.inputString;
    }

    public void setInputString(String inputString) {
        this.inputString = inputString;
    }

    public int getMaxStringWidth() {
        if (this.maxStringWidth > 0) {
            return this.maxStringWidth;
        }
        if (this.itemList != null && this.itemList.size() > 0) {
            int i = 0;
            while (i < this.itemList.size()) {
                int stringWidth;
                String string = (String)this.itemList.elementAt(i);
                if (string != null && string.length() > 0 && (stringWidth = this.font.stringWidth(string)) > this.maxStringWidth) {
                    this.maxStringWidth = stringWidth;
                }
                ++i;
            }
        }
        return this.maxStringWidth;
    }

    public int draw(Graphics g, int x, int y) {
        int initY = y;
        if (g != null) {
            if (this.isHightlighted()) {
                g.setColor(Color.DEFAULT_ITEM_CONTENT_BG_COLOR);
                g.fillRect(x, y, this.getItemWidth(), this.getItemHeight());
            }
            g.setColor(this.fontColor);
            g.setFont(this.font);
            int tmpX = x;
            if (this.label != null && this.label.length() > 0) {
                g.drawString(this.label, x, y, 20);
                tmpX += this.font.stringWidth(this.label);
            }
            int color = g.getColor();
            int triangleWidth = this.font.getHeight() / 2;
            int triangleHeight = this.font.getHeight();
            g.setColor(this.fontColor);
            if (this.getItemHeight() > this.font.getHeight()) {
                y += this.font.getHeight();
            } else if (this.label != null && this.label.length() > 0) {
                g.drawString(this.label, x, y, 20);
                x += this.font.stringWidth(this.label);
            }
            tmpX = x;
            int tmpFieldWidth = this.fieldWidth;
            if (this.getItemHeight() > this.font.getHeight()) {
                tmpFieldWidth = this.getMaxStringWidth() + 5;
            }
            g.setColor(0);
            g.fillTriangle(tmpX, y + triangleHeight / 2, tmpX + triangleWidth, y, tmpX + triangleWidth, y + triangleHeight);
            tmpX += triangleWidth + 2;
            if (this.isHightlighted()) {
                g.setColor(Color.DEFAULT_ITEM_CONTENT_BG_COLOR);
            } else {
                g.setColor(0xFFFFFF);
            }
            g.fillRect(tmpX, y, tmpFieldWidth - 1, this.font.getHeight() - 1);
            g.setColor(color);
            g.fillTriangle((tmpX += tmpFieldWidth + 3) + triangleWidth, y + triangleHeight / 2, tmpX, y, tmpX, y + triangleHeight);
            g.drawRect(x += triangleWidth + 2, y, tmpFieldWidth - 1, this.font.getHeight() - 1);
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int tmpClipY = y;
            if (tmpClipY < clipY) {
                tmpClipY = clipY;
            }
            g.setClip(x, tmpClipY, tmpFieldWidth, this.font.getHeight());
            if (this.selectedItemIndex >= 0 && this.itemList.size() > 0 && this.selectedItemIndex < this.itemList.size()) {
                String itemString = (String)this.itemList.elementAt(this.selectedItemIndex);
                int offset = 0;
                if (tmpFieldWidth > this.font.stringWidth(itemString)) {
                    offset = (tmpFieldWidth - this.font.stringWidth(itemString)) / 2 - 1;
                }
                g.drawString(itemString, x + 2 + offset, y, 20);
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
        return initY += this.itemHeight;
    }

    public void unload() {
        this.inputString = null;
        this.font = null;
        this.label = null;
        if (this.lineEnumeration != null) {
            this.lineEnumeration.unload();
            this.lineEnumeration = null;
        }
        if (this.itemList != null) {
            this.itemList.removeAllElements();
            this.itemList = null;
        }
        System.gc();
        super.unload();
    }
}

