/*
 * Decompiled with CFR 0.152.
 */
package ParserPKG;

import ParserPKG.XMLParse;
import RSSPKG.UTF8;
import RSSPKG.Windows1256;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;

public class ParseText {
    int screenWidth;
    int screenHeight = 200;
    int fontHeight;
    int screenLines;
    int nLines;
    int[] linePos;
    char prevPageChar;
    Font font = Font.getFont((int)64, (int)0, (int)8);
    int spaceWidth;
    int hyphenWidth;
    byte[] text;
    int textLength;
    Tag currTag;
    Tag tags;
    int currPagePos;
    int currPageEnd;
    Hashtable index;
    String label = "";
    String url = "";
    static final int BACKGROUND_COLOR = 0xFFFFFF;
    static final int FOREGROUND_COLOR = 0;
    static final int SLIDER_COLOR = 0x8080FF;
    static final int SLIDER_POS_COLOR = 0xFF0000;
    static final int VISITED_LINK_COLOR = 0x800040;
    static final int LINK_COLOR = 255;
    static final int CURRENT_LINK_BACKGROUND_COLOR = 0;
    static final int CURRENT_LINK_FOREGROUND_COLOR = 0xFFFFFF;
    static final int MIN_SLIDER_LENGTH = 3;
    static final int REPEAT_DELAY = 1000;
    static final int REPEAT_PERIOD = 100;
    public static final char HYPHEN = '-';
    static final int OVERLAP = 1;
    static final int INDENTATION = 2;
    static final String[] breakTags = new String[]{"li", "br", "tr", "p", "h1", "h2", "h3", "hr", "/p", "/h1", "/h2", "/h3"};
    static final String[] skipTags = new String[]{"form", "script", "style"};

    public ParseText() {
        this.fontHeight = this.font.getHeight() - 1;
        this.screenLines = this.screenHeight / this.fontHeight;
        this.spaceWidth = this.font.charWidth(' ');
        this.hyphenWidth = this.font.charWidth('-');
        this.linePos = new int[this.screenLines + 1];
        this.prevPageChar = (char)10;
        this.index = new Hashtable();
        this.tags = new Tag();
    }

    public String parseText(String in) {
        if (in.length() < 1) {
            return "";
        }
        this.textLength = in.length();
        try {
            this.text = in.getBytes();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.convertText();
        String atr = "";
        for (int i = 0; i < this.textLength; ++i) {
            atr = atr + ParseText.getChar(this.text[i]);
        }
        if (XMLParse.encoding.equalsIgnoreCase("utf-8")) {
            atr = UTF8.decode(this.text, this.textLength);
        }
        if (XMLParse.encoding.equalsIgnoreCase("windows-1256")) {
            atr = Windows1256.resolve(this.text).substring(0, this.textLength).trim();
        }
        if (atr.startsWith(" ")) {
            atr = atr.substring(1);
        }
        return atr;
    }

    void convertText() {
        byte[] t = this.text;
        int length = this.textLength;
        int skip = 0;
        int preserve = 0;
        int dst = 0;
        block0: for (int src = 0; src < length; ++src) {
            byte b = t[src];
            if (b == 60) {
                int j;
                if (src + 3 < length && t[src + 1] == 33 && t[src + 2] == 45 && t[src + 3] == 45) {
                    src += 3;
                    while (++src + 3 < length && (t[src] != 45 || t[src + 1] != 45 || t[src + 2] != 62)) {
                    }
                    src += 2;
                    continue;
                }
                int start = src + 1;
                while (++src < length && t[src] != 62) {
                    if (t[src] != 60) continue;
                    start = src + 1;
                }
                String element = new String(t, start, src - start);
                String tagName = element.toLowerCase();
                for (j = 0; j < skipTags.length; ++j) {
                    String st = skipTags[j];
                    if (!tagName.equals(st) && (!tagName.startsWith(st) || tagName.charAt(st.length()) != ' ')) continue;
                    ++skip;
                    break;
                }
                if (skip > 0 && tagName.startsWith("/")) {
                    String suf = tagName.substring(1);
                    for (int j2 = 0; j2 < skipTags.length; ++j2) {
                        if (!suf.equals(skipTags[j2])) continue;
                        --skip;
                        break;
                    }
                }
                if (skip > 0) continue;
                if (tagName.startsWith("pre")) {
                    ++preserve;
                    continue;
                }
                if (tagName.startsWith("/pre")) {
                    --preserve;
                    continue;
                }
                if (tagName.startsWith("a href")) {
                    String url = ParseText.getUrl(element);
                    if (url.length() <= 0 || url.equals("#")) continue;
                    this.tags.link(new Tag(url, dst));
                    continue;
                }
                if (tagName.startsWith("a name")) {
                    int qe;
                    int qs = tagName.indexOf(34);
                    if (tagName.substring(qs + 1, qe = tagName.lastIndexOf(34)).equals(this.label)) {
                        this.currPagePos = dst;
                    }
                    this.index.put(ParseText.getUrl(element), new Integer(dst));
                    continue;
                }
                if (tagName.equals("/a")) {
                    if (this.tags.prev.end >= 0) continue;
                    if (this.tags.prev.beg == dst) {
                        this.tags.prev.unlink();
                        continue;
                    }
                    this.tags.prev.end = dst;
                    continue;
                }
                for (j = 0; j < breakTags.length; ++j) {
                    String bt = breakTags[j];
                    if (!tagName.equals(bt) && (!tagName.startsWith(bt) || tagName.charAt(bt.length()) != ' ')) continue;
                    if (bt.equals("p")) {
                        for (int i = 0; i < 2; ++i) {
                            t[dst++] = 32;
                        }
                    } else if (dst == 0 || t[dst - 1] == 10) continue;
                    t[dst++] = 10;
                    continue block0;
                }
                continue;
            }
            if (skip != 0) continue;
            if (b == 38) {
                int j;
                int n = src + 8 < length ? src + 8 : length;
                for (j = src + 1; j < n && t[j] != 59; ++j) {
                }
                if (j < n && t[j] == 59) {
                    int ch;
                    String symStr = new String(t, src + 1, j - src - 1).toLowerCase();
                    src = j;
                    if (symStr.equals("amp")) {
                        ch = 38;
                    } else if (symStr.equals("quot")) {
                        ch = 34;
                    } else if (symStr.equals("lt")) {
                        ch = 60;
                    } else if (symStr.equals("gt")) {
                        ch = 62;
                    } else if (symStr.equals("nbsp")) {
                        ch = 32;
                    } else {
                        if (!symStr.startsWith("#")) continue;
                        ch = (char)Integer.parseInt(symStr.substring(1), 16);
                    }
                    t[dst++] = (byte)ch;
                    continue;
                }
                t[dst++] = 38;
                continue;
            }
            if (b == 10 || b == 32 || b == 9) {
                if (preserve != 0) {
                    t[dst++] = (byte)(b == 10 ? 13 : 32);
                    continue;
                }
                if (dst == 0 || t[dst - 1] == 32 || t[dst - 1] == 10) continue;
                t[dst++] = 32;
                continue;
            }
            if (b == 13) continue;
            t[dst++] = b;
        }
        this.textLength = dst;
    }

    private static String getUrl(String tag) {
        String redirect;
        String url = tag.substring(tag.indexOf(61) + 1).trim();
        if (url.startsWith("\"")) {
            url = url.substring(1, url.indexOf(34, 1));
        } else {
            int sep = url.indexOf(32);
            if (sep >= 0) {
                url = url.substring(0, sep);
            }
        }
        int q = url.indexOf(63);
        if (q >= 0 && (redirect = url.substring(q + 1)).startsWith("http://")) {
            return redirect;
        }
        return url;
    }

    private static boolean isSeparator(char ch) {
        return ch == ' ' || ch == '!' || ch == '.' || ch == ',' || ch == ';' || ch == '?' || ch == '-' || ch == '+' || ch == '=' || ch == ')' || ch == '}' || ch == ']' || ch == '\\' || ch == '/' || ch == ':' || ch == '>';
    }

    final char getChar(int i) {
        if (i >= this.textLength) {
            return '\u0000';
        }
        return ParseText.getChar(this.text[i]);
    }

    int splitWord(StringBuffer buf, int n, int width, boolean align) {
        char c1 = buf.charAt(n - 1);
        char c2 = buf.charAt(n - 2);
        if (ParseText.isSeparator(c2)) {
            if (c2 == ' ') {
                buf.delete(n - 2, buf.length());
                width -= this.spaceWidth + this.font.charWidth(c1);
            } else {
                buf.delete(n - 1, buf.length());
                width -= this.font.charWidth(c1);
            }
            if (align) {
                ParseText.insertSpaces(buf, (this.screenWidth - width) / this.spaceWidth);
            }
            return 1;
        }
        int i = ParseText.split(buf, n);
        if (i <= 0) {
            i = n - 2;
        }
        int rest = n - i;
        boolean insertHyphen = true;
        if (i >= 1 && ParseText.isSeparator(buf.charAt(i - 1))) {
            if (buf.charAt(i - 1) == ' ') {
                --i;
            }
            insertHyphen = false;
        } else if (i >= 2 && ParseText.isSeparator(buf.charAt(i - 2))) {
            i -= buf.charAt(i - 2) == ' ' ? 2 : 1;
            ++rest;
            insertHyphen = false;
        }
        for (int j = i; j < n; ++j) {
            width -= this.font.charWidth(buf.charAt(j));
        }
        buf.delete(i, buf.length());
        if (insertHyphen) {
            buf.insert(i, '-');
            width += this.hyphenWidth;
        }
        if (align) {
            ParseText.insertSpaces(buf, (this.screenWidth - width) / this.spaceWidth);
        }
        return rest;
    }

    public static int split(StringBuffer buf, int i) {
        return -1;
    }

    public static char getChar(byte b) {
        return (char)(b & 0xFF);
    }

    static void insertSpaces(StringBuffer buf, int nSpaces) {
        if (nSpaces > 0) {
            int i = 0;
            int n = buf.length();
            while (buf.charAt(i) == ' ') {
                ++i;
            }
            int nSeparators = 0;
            while (++i < n) {
                if (buf.charAt(i) != ' ') continue;
                ++nSeparators;
            }
            if (nSeparators != 0) {
                int ns1 = nSpaces / nSeparators;
                int ns2 = nSpaces % nSeparators;
                do {
                    if (buf.charAt(--i) != ' ') continue;
                    for (int j = 0; j < ns1; ++j) {
                        buf.insert(i, ' ');
                    }
                    if (ns2 != 0) {
                        buf.insert(i, ' ');
                        --ns2;
                    }
                    --nSeparators;
                } while (nSeparators != 0);
            }
        }
    }

    static class Tag {
        Tag next;
        Tag prev;
        String url;
        int beg;
        int end;
        int pos;

        void link(Tag tag) {
            this.prev.next = tag;
            tag.next = this;
            tag.prev = this.prev;
            this.prev = tag;
        }

        void unlink() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
        }

        Tag(String url, int beg) {
            this.url = url;
            this.beg = beg;
            this.end = -1;
        }

        Tag() {
            this.next = this.prev = this;
            this.end = -1;
            this.beg = -1;
        }
    }
}

