/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.io;

import java.io.IOException;
import java.io.Writer;
import org.kxml.PrefixMap;
import org.kxml.io.State;

public abstract class AbstractXmlWriter
extends Writer {
    protected State current = new State(null, PrefixMap.DEFAULT, null);

    public abstract void attribute(String var1, String var2) throws IOException;

    public void attribute(String namespace, String name, String value) throws IOException {
        if (namespace == null || "".equals(namespace)) {
            this.attribute(name, value);
        } else {
            String prefix = this.current.prefixMap.getPrefix(namespace);
            if (prefix == null || prefix.equals("")) {
                int cnt = 0;
                while (this.current.prefixMap.getNamespace(prefix = "p" + cnt++) != null) {
                }
                this.current.prefixMap = new PrefixMap(this.current.prefixMap, prefix, namespace);
                this.attribute("xmlns:" + prefix, namespace);
            }
            this.attribute(prefix + ":" + name, value);
        }
    }

    public PrefixMap getPrefixMap() {
        return this.current.prefixMap;
    }

    public void startTag(PrefixMap prefixMap, String namespace, String name) throws IOException {
        String prefix;
        if (prefixMap == null) {
            prefixMap = this.current.prefixMap;
        }
        if (namespace == null) {
            namespace = "";
        }
        if ((prefix = prefixMap.getPrefix(namespace)) == null) {
            prefixMap = new PrefixMap(prefixMap, "", namespace);
            prefix = "";
        }
        String tag = prefix.length() == 0 ? name : prefix + ':' + name;
        PrefixMap oldMap = this.current.prefixMap;
        this.startTag(prefixMap, tag);
        if (prefixMap != oldMap) {
            PrefixMap current = prefixMap;
            do {
                String p2 = current.getPrefix();
                String ns = current.getNamespace();
                if (!prefixMap.getNamespace(p2).equals(ns) || ns.equals(oldMap.getNamespace(p2))) continue;
                this.attribute(p2.equals("") ? "xmlns" : "xmlns:" + p2, ns);
            } while ((current = current.getPrevious()) != null && current != oldMap);
        }
    }

    public void startTag(String namespace, String name) throws IOException {
        this.startTag(null, namespace, name);
    }

    public void startTag(String name) throws IOException {
        this.startTag(null, "", name);
    }

    protected abstract void startTag(PrefixMap var1, String var2) throws IOException;

    public abstract void endTag() throws IOException;

    public abstract void writeLegacy(int var1, String var2) throws IOException;
}

