/*
 * Decompiled with CFR 0.152.
 */
package CalendarPKG;

import CalendarPKG.CalCanvas;
import CalendarPKG.WeekView;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Event;
import javax.microedition.pim.PIMException;

public class EventList
extends List
implements CommandListener {
    CalCanvas Parent;
    int day;
    int month;
    int year;
    int hour;
    Vector dayEvents = new Vector();
    Calendar cal = Calendar.getInstance();
    Event ev;
    Vector AllEvents;
    Command back = new Command("Back", 7, 1);
    Command edit = new Command("Edit", 4, 2);
    Command delete = new Command("Delete", 4, 3);

    public EventList(CalCanvas Owner) {
        super("Events", 3);
        this.Parent = Owner;
        this.toggleLang(CalCanvas.Arabic);
    }

    public void toggleLang(boolean Arabic) {
        this.removeCommand(this.back);
        this.removeCommand(this.edit);
        this.removeCommand(this.delete);
        if (Arabic) {
            this.setTitle("\u0623\u062d\u062f\u0627\u062b \u0627\u0644\u062a\u0642\u0648\u064a\u0645");
            this.back = new Command("\u0631\u062c\u0648\u0639", 7, 1);
            this.edit = new Command("\u062a\u0639\u062f\u064a\u0644", 4, 2);
            this.delete = new Command("\u062d\u0630\u0641", 4, 3);
        } else {
            this.setTitle("Events");
            this.back = new Command("Back", 7, 1);
            this.edit = new Command("Edit", 4, 2);
            this.delete = new Command("Delete", 4, 3);
        }
        this.addCommand(this.back);
        this.addCommand(this.edit);
        this.addCommand(this.delete);
        this.setCommandListener(this);
    }

    public void Show(int Gday, int Gmonth, int Gyear, int Ghour, Vector AllEvent) {
        this.dayEvents.removeAllElements();
        this.deleteAll();
        this.AllEvents = AllEvent;
        if (this.AllEvents.size() == 0) {
            return;
        }
        this.day = Gday;
        this.month = Gmonth;
        this.year = Gyear;
        this.hour = Ghour;
        try {
            this.getEvents();
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
        }
        if (this.dayEvents.size() == 0) {
            return;
        }
        this.displayEvents();
    }

    private void getEvents() {
        this.cal.set(5, this.day);
        this.cal.set(2, this.month);
        this.cal.set(1, this.year);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(13, 0);
        this.cal.set(14, 0);
        long compare = this.cal.getTime().getTime();
        Date eventDate = new Date();
        Calendar EventCalendar = Calendar.getInstance();
        boolean anniv = false;
        for (int i = 0; i < this.AllEvents.size(); ++i) {
            this.ev = (Event)this.AllEvents.elementAt(i);
            eventDate.setTime(this.ev.getDate(106, 0));
            long l = eventDate.getTime();
            EventCalendar.getTimeZone();
            EventCalendar.setTime(new Date(l + (long)TimeZone.getDefault().getRawOffset()));
            if (CalCanvas.CALLER == 1) {
                if (eventDate.getTime() < compare || eventDate.getTime() >= compare + 86400000L) continue;
                this.dayEvents.addElement(this.ev);
                continue;
            }
            WeekView cfr_ignored_0 = this.Parent.weeks;
            if (CalCanvas.CALLER != 0 || EventCalendar.getTime().getTime() < compare || EventCalendar.getTime().getTime() >= compare + 86400000L || EventCalendar.get(11) != this.hour && this.ev.getDate(106, 0) != this.ev.getDate(102, 0)) continue;
            this.dayEvents.addElement(this.ev);
        }
    }

    private void displayEvents() {
        Calendar eventDate = Calendar.getInstance();
        Date d = new Date();
        for (int i = 0; i < this.dayEvents.size(); ++i) {
            Event ev = (Event)this.dayEvents.elementAt(i);
            d.setTime(ev.getDate(106, 0));
            eventDate.setTime(d);
            this.append(i + 1 + "-" + ev.getString(107, 0), null);
        }
        Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getPriority() == 1) {
            if (CalCanvas.CALLER == 1) {
                Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent);
            } else {
                Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent.weeks);
            }
        } else if (command.getPriority() == 3) {
            Event v = (Event)this.dayEvents.elementAt(this.getSelectedIndex());
            try {
                this.Parent.eventList.events.removeEvent(v);
            }
            catch (PIMException ex) {
                ex.printStackTrace();
            }
            this.dayEvents.removeElementAt(this.getSelectedIndex());
            this.deleteAll();
            CalCanvas.NeedFullRepaint = true;
            if (this.dayEvents.size() == 0) {
                Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent);
            } else {
                for (int i = 0; i < this.dayEvents.size(); ++i) {
                    this.ev = (Event)this.dayEvents.elementAt(i);
                    this.append(i + 1 + "-" + this.ev.getString(107, 0), null);
                }
            }
        } else if (command.getPriority() == 2) {
            Event v = (Event)this.dayEvents.elementAt(this.getSelectedIndex());
            if (v.getRepeat() != null) {
                this.Parent.annForm.Show(true, (Event)this.dayEvents.elementAt(this.getSelectedIndex()));
            } else if (v.getDate(106, 0) + 60000L == v.getDate(102, 0)) {
                this.Parent.memoForm.Show(true, (Event)this.dayEvents.elementAt(this.getSelectedIndex()));
            } else {
                this.Parent.appForm.Show(true, (Event)this.dayEvents.elementAt(this.getSelectedIndex()));
            }
        }
    }
}

