/*
 * Decompiled with CFR 0.152.
 */
package CalendarPKG;

import CalendarPKG.AnniversaryForm;
import CalendarPKG.AppointmentForm;
import CalendarPKG.CalCanvas;
import CalendarPKG.CalData;
import CalendarPKG.EventList;
import CalendarPKG.MemoForm;
import CalendarPKG.SDATE;
import CalendarPKG.getEvents;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.Event;

public class WeekView
extends Canvas
implements CommandListener {
    final int MAX_ROWS;
    final int MAX_COLUMNS;
    static final int WEEK_VIEW = 0;
    int startIndex = 0;
    int Max_Visible_Rows = 5;
    int Visible_Columns = 7;
    CalCanvas Parent;
    Vector weekEvents;
    int SquareWidth;
    int SquareHeight;
    int HoursWidth;
    boolean CalWeekEvents = false;
    EventList eventViewer;
    int DaysTitleHeight = 20;
    getEvents eventList;
    int selectedRow = 0;
    int selectedColumn = 0;
    AnniversaryForm annForm;
    AppointmentForm appForm;
    MemoForm memoForm;
    Enumeration Events;
    boolean firstItration;
    boolean MarkToday = false;
    boolean DrawPrevWeek;
    boolean reCalStart = false;
    Calendar Today;
    int Week_In_Year;
    boolean firstEventCheck = true;
    public boolean firstPaint = true;
    Calendar ToGetStart = Calendar.getInstance();
    private int Today_Week_In_Year;
    private int Today_Day_of_Week;
    boolean DrawNextWeek;
    boolean runOnce;
    List eventChoice;
    int currentDay = 0;
    Command listCancel;
    Command listOk;
    Command CMD_Exit;
    Command CMD_ShowEvents;
    Command CMD_Holidays;
    Command CMD_AddEvent;
    Command CMD_Adjust;
    Command CMD_Convert;
    Command CMD_MonthlyView;
    public boolean NeedFullRepaint = true;
    Command CMD_SelectDate;
    Command CMD_SwitchLang;
    Command CMD_SwitchMode;
    Command CMD_Today;
    Command CMD_CountryList;
    Command about;
    Image dayNames;
    Image BG;
    Date date = new Date();
    long l;
    long DAY = 86400000L;
    long CurrCalendartemp;
    boolean[][] hasEvent = new boolean[24][7];
    boolean[] hasAllDayEvent = new boolean[7];
    boolean Is_painting = false;
    Calendar c;

    public int getWidthh() {
        return 128;
    }

    public int getHeightt() {
        return 111;
    }

    public WeekView(CalCanvas owner) {
        this.MAX_ROWS = 23;
        this.MAX_COLUMNS = 6;
        try {
            this.setFullScreenMode(false);
            this.Parent = owner;
            this.Today = Calendar.getInstance();
            this.SquareHeight = 25;
            this.SquareWidth = this.getWidth() / 9;
            this.Max_Visible_Rows = (this.getHeight() - this.DaysTitleHeight) / this.SquareHeight;
            this.annForm = new AnniversaryForm(this.Parent);
            this.appForm = new AppointmentForm(this.Parent);
            this.memoForm = new MemoForm(this.Parent);
            this.invertCommands(CalCanvas.Arabic);
            this.setCommandListener(this);
            new Thread(new events(this)).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void invertCommands(boolean arabic) {
        this.createEventChoiceList(arabic);
        this.removeCommand(this.CMD_Exit);
        this.removeCommand(this.CMD_MonthlyView);
        this.removeCommand(this.CMD_SelectDate);
        this.removeCommand(this.CMD_AddEvent);
        this.removeCommand(this.CMD_ShowEvents);
        if (arabic) {
            this.CMD_Exit = new Command("\u062e\u0631\u0648\u062c", 7, 2);
            this.CMD_SelectDate = new Command("\u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u062a\u0627\u0631\u064a\u062e", 4, 3);
            this.CMD_AddEvent = new Command("\u0627\u0636\u0627\u0641\u0629 \u062d\u062f\u062b", 4, 4);
            this.CMD_ShowEvents = new Command("\u0623\u062d\u062f\u0627\u062b \u0627\u0644\u062a\u0642\u0648\u064a\u0645", 4, 5);
            this.CMD_MonthlyView = new Command("\u0639\u0631\u0636 \u0634\u0647\u0631", 4, 1);
        } else {
            this.CMD_Exit = new Command("Exit", 7, 2);
            this.CMD_SelectDate = new Command("Select Date", 4, 3);
            this.CMD_AddEvent = new Command("Add Event", 4, 4);
            this.CMD_ShowEvents = new Command("Show Events", 4, 5);
            this.CMD_MonthlyView = new Command("Monthly View", 4, 1);
        }
        this.addCommand(this.CMD_Exit);
        this.addCommand(this.CMD_MonthlyView);
        this.addCommand(this.CMD_SelectDate);
        this.addCommand(this.CMD_AddEvent);
        this.addCommand(this.CMD_ShowEvents);
    }

    protected void Repaint() {
        try {
            while (this.Is_painting) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.repaint();
    }

    protected void paint(Graphics graphics) {
        int i;
        this.Is_painting = true;
        Calendar curCell = Calendar.getInstance();
        if (this.firstPaint) {
            this.getWeekDetails();
        }
        if (this.NeedFullRepaint) {
            this.eventsPerWeek();
            this.CalWeekEvents = false;
        }
        int TransX = this.HoursWidth = this.getWidth() - this.SquareWidth * 7;
        int TransY = 0;
        int incrmnt = this.HoursWidth;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(0xF0F0F0);
        graphics.fillRect(0, 0, this.HoursWidth, this.getHeight());
        graphics.translate(this.HoursWidth, 0);
        for (i = 0; i < CalData.daysOfWeek.length; ++i) {
            if (CalCanvas.Arabic) {
                this.Parent.drawStringInGrid(graphics, this.SquareWidth, this.DaysTitleHeight, CalData.daysOfWeek[i], 0x808080);
            } else {
                this.Parent.drawStringInGrid(graphics, this.SquareWidth, this.DaysTitleHeight, CalData.weekDaysEnAbr[i], 0x808080);
            }
            TransX += this.SquareWidth;
            graphics.translate(this.SquareWidth, TransY);
        }
        graphics.translate(graphics.getTranslateX() * -1, 0);
        for (i = 0; i < 8; ++i) {
            graphics.drawLine(incrmnt, this.DaysTitleHeight, incrmnt, this.getHeight());
            incrmnt += this.SquareWidth;
        }
        incrmnt = 0;
        for (i = 0; i < this.Max_Visible_Rows; ++i) {
            graphics.drawLine(this.HoursWidth, this.DaysTitleHeight + incrmnt, this.getWidth() + 5, this.DaysTitleHeight + incrmnt);
            incrmnt += this.SquareHeight;
        }
        graphics.translate(graphics.getTranslateX() * -1, 0);
        graphics.setColor(0);
        incrmnt = 0;
        graphics.translate(0, this.DaysTitleHeight);
        if (this.NeedFullRepaint) {
            this.runOnce = true;
        }
        for (int i2 = this.startIndex; i2 <= 23 && i2 < this.Max_Visible_Rows + this.startIndex; ++i2) {
            graphics.setColor(0);
            graphics.drawString(CalData.dayHours[i2], this.HoursWidth / 2, 0, 17);
            ++incrmnt;
            graphics.translate(this.HoursWidth, 0);
            if (this.NeedFullRepaint) {
                curCell.set(1, this.ToGetStart.get(1));
                curCell.set(2, this.ToGetStart.get(2));
                curCell.set(5, this.ToGetStart.get(5));
                curCell.set(11, i2);
                curCell.set(12, 0);
                curCell.set(13, 0);
                curCell.set(14, 0);
            }
            for (int j = 0; j < 7; ++j) {
                if (this.MarkToday) {
                    this.selectedColumn = this.Today_Day_of_Week;
                    this.MarkToday = false;
                }
                if (i2 == this.selectedRow && j == this.selectedColumn) {
                    graphics.setColor(33023);
                    graphics.fillRect(1, 1, this.SquareWidth - 1, this.SquareHeight - 1);
                } else if (j == this.Today_Day_of_Week && this.Week_In_Year == this.Today_Week_In_Year) {
                    graphics.setColor(0xA0F000);
                    graphics.fillRect(1, 1, this.SquareWidth - 1, this.SquareHeight - 1);
                }
                if (this.hasEvent[i2][j]) {
                    graphics.setColor(0);
                    graphics.fillTriangle(2, this.SquareHeight - 2, 9, this.SquareHeight - 2, 2, this.SquareHeight - 9);
                }
                graphics.translate(this.SquareWidth, 0);
            }
            graphics.translate(graphics.getTranslateX() * -1, this.SquareHeight);
        }
        this.firstEventCheck = false;
        this.NeedFullRepaint = false;
        this.Is_painting = false;
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        switch (keyAction) {
            case 6: {
                if (this.selectedRow == this.Max_Visible_Rows + this.startIndex - 1) {
                    if (this.selectedRow < 23) {
                        ++this.startIndex;
                        ++this.selectedRow;
                        break;
                    }
                    return;
                }
                if (this.selectedRow <= 23) {
                    ++this.selectedRow;
                    break;
                }
                return;
            }
            case 1: {
                if (this.selectedRow == 0) {
                    return;
                }
                --this.selectedRow;
                if (this.startIndex <= 0 || this.selectedRow != this.startIndex - 1) break;
                --this.startIndex;
                break;
            }
            case 5: {
                if (this.selectedColumn < 6) {
                    ++this.selectedColumn;
                    this.CalWeekEvents = false;
                } else {
                    this.reCalStart = true;
                    this.NeedFullRepaint = true;
                    this.CalWeekEvents = true;
                    this.selectedColumn = 0;
                }
                this.drawNextDay();
                break;
            }
            case 2: {
                if (this.selectedColumn > 0) {
                    --this.selectedColumn;
                } else {
                    this.reCalStart = true;
                    this.CalWeekEvents = true;
                    this.NeedFullRepaint = true;
                    this.selectedColumn = 6;
                }
                this.drawPreviousDay();
                break;
            }
            case 8: {
                CalCanvas.CALLER = 0;
                this.eventsPerWeek();
                this.eventViewer = null;
                this.eventViewer = new EventList(this.Parent);
                this.eventViewer.Show(this.Parent.curGregDay, this.Parent.curGregMon, this.Parent.curGregYear, this.selectedRow, this.weekEvents);
            }
        }
        this.repaint();
    }

    public void createEventChoiceList(boolean arabic) {
        if (arabic) {
            this.eventChoice = new List("\u0627\u062e\u062a\u0631 \u0646\u0648\u0639 \u0627\u0644\u062d\u062f\u062b", 3, new String[]{"\u0630\u0643\u0631\u0649 \u0633\u0646\u0648\u064a\u0629", "\u0645\u0648\u0639\u062f", "\u0645\u0630\u0643\u0631\u0629"}, null);
            this.listCancel = new Command("\u0625\u0644\u063a\u0627\u0621", 7, 1);
            this.listOk = new Command("\u0627\u062e\u062a\u0631", 4, 2);
        } else {
            this.eventChoice = new List("Choose Event Type", 3, new String[]{"Anniversary", "Meeting", "Memo."}, null);
            this.listCancel = new Command("Cancel", 7, 1);
            this.listOk = new Command("Ok", 4, 2);
        }
        this.eventChoice.addCommand(this.listCancel);
        this.eventChoice.addCommand(this.listOk);
        this.eventChoice.setCommandListener((CommandListener)this);
    }

    private void eventsPerWeek() {
        this.weekEvents = null;
        this.weekEvents = new Vector();
        if (this.reCalStart) {
            this.ToGetStart = Calendar.getInstance();
            this.ToGetStart.set(1, this.Parent.curGregYear);
            this.ToGetStart.set(2, this.Parent.curGregMon);
            this.ToGetStart.set(5, this.Parent.curGregDay);
            this.ToGetStart.set(12, 0);
            this.ToGetStart.set(13, 0);
            this.ToGetStart.set(14, 0);
            this.ToGetStart.set(11, 0);
            this.reCalStart = false;
            if (this.ToGetStart.get(7) != 0) {
                Date d = new Date(this.ToGetStart.getTime().getTime() - (long)((this.ToGetStart.get(7) - 1) * 24 * 60 * 60 * 1000));
                this.ToGetStart.setTime(d);
            }
        }
        long Days7 = 518400000L;
        Date start = this.ToGetStart.getTime();
        this.Events = this.Parent.eventList.getItems(start.getTime(), Days7 += this.ToGetStart.getTime().getTime());
        while (this.Events.hasMoreElements()) {
            this.weekEvents.addElement((Event)this.Events.nextElement());
        }
    }

    private void getWeekDetails() {
        this.c = Calendar.getInstance();
        long yearsToDeduct = (this.Parent.curGregYear - 1970) * 24;
        yearsToDeduct *= 3600000L;
        yearsToDeduct *= 365L;
        if (this.Parent.selectedDate == null) {
            this.c.set(5, this.Parent.curGregDay);
            this.c.set(2, this.Parent.curGregMon);
            this.c.set(1, this.Parent.curGregYear);
        } else {
            this.c.setTime(this.Parent.selectedDate);
            this.Parent.selectedDate = null;
        }
        this.reCalStart = true;
        this.CalWeekEvents = true;
        CalCanvas.isMonthView = false;
        if (this.firstPaint) {
            this.MarkToday = true;
        }
        this.firstPaint = false;
        this.Today.setTime(this.c.getTime());
        this.Today_Week_In_Year = (int)((this.Parent.Today.getTime().getTime() - yearsToDeduct) / 1000L / 60L / 60L / 24L / 7L);
        this.Today_Day_of_Week = this.Today.get(7) - 1;
        this.Week_In_Year = this.calculateWeekInYear(this.c);
        this.c.setTime(this.c.getTime());
        this.updateParentVariables();
    }

    private void drawPreviousDay() {
        this.c.setTime(new Date(this.c.getTime().getTime() - 86400000L));
        this.updateParentVariables();
    }

    private void drawNextDay() {
        this.c.setTime(new Date(this.c.getTime().getTime() + 86400000L));
        this.updateParentVariables();
    }

    private void updateParentVariables() {
        this.Week_In_Year = this.calculateWeekInYear(this.c);
        this.Parent.curGregDay = this.c.get(5);
        this.Parent.curGregMon = this.c.get(2);
        this.Parent.curGregYear = this.c.get(1);
        SDATE temp = new SDATE();
        SDATE retVal = null;
        temp.day = this.Parent.curGregDay;
        temp.mon = this.Parent.curGregMon + 1;
        temp.year = this.Parent.curGregYear;
        if (this.Parent.DefaultHijry) {
            retVal = this.Parent.dateConvert.GregorianToHijriDate(temp, false);
        }
        if (CalCanvas.Arabic) {
            if (!this.Parent.DefaultHijry) {
                this.setTitle("\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644" + this.Week_In_Year + " , " + this.c.get(5) + " " + CalData.grMonths[this.c.get(2)] + " " + this.c.get(1));
            } else {
                this.setTitle("\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644" + this.Week_In_Year + " , " + retVal.day + " " + CalData.arMonths[retVal.mon - 1] + " " + retVal.year);
            }
        } else if (this.Parent.DefaultHijry) {
            this.setTitle(retVal.day + " " + CalData.arMonthsEn[retVal.mon - 1]);
        } else {
            this.setTitle(this.c.get(5) + " " + CalData.grMonthsEn[this.c.get(2)]);
        }
        this.Parent.selectedDate = this.c.getTime();
    }

    public void Show() {
        this.firstPaint = true;
        Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this);
    }

    private int calculateWeekInYear(Calendar c) {
        Calendar BeginOfYear = Calendar.getInstance();
        BeginOfYear.set(5, 1);
        BeginOfYear.set(2, 0);
        BeginOfYear.set(1, c.get(1));
        BeginOfYear.setTime(new Date(BeginOfYear.getTime().getTime() - (long)(86400000 * BeginOfYear.get(7))));
        BeginOfYear.getTime();
        return (int)Math.ceil((double)(c.getTime().getTime() - BeginOfYear.getTime().getTime()) / 6.048E8);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.eventChoice) {
            if (command.getPriority() == 1) {
                Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this);
            } else if (command.getPriority() == 2) {
                if (this.eventChoice.getSelectedIndex() == 0) {
                    this.annForm.Create();
                    this.annForm.Show(false);
                } else if (this.eventChoice.getSelectedIndex() == 1) {
                    this.appForm.Create();
                    this.appForm.Show(false);
                } else {
                    this.memoForm.Create();
                    this.memoForm.Show(false);
                }
            }
        } else {
            switch (command.getPriority()) {
                case 2: {
                    this.Parent.OwnerMidlet.Destroy();
                    break;
                }
                case 3: {
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent.OwnerMidlet.dateForm);
                    break;
                }
                case 4: {
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.eventChoice);
                    this.firstEventCheck = true;
                    break;
                }
                case 5: {
                    this.eventsPerWeek();
                    this.eventViewer = null;
                    this.eventViewer = new EventList(this.Parent);
                    this.eventViewer.Show(this.Parent.curGregDay, this.Parent.curGregMon, this.Parent.curGregYear, this.selectedRow, this.weekEvents);
                    break;
                }
                case 1: {
                    CalCanvas.CALLER = 1;
                    CalCanvas.isMonthView = true;
                    this.Parent.startThread();
                    CalCanvas.NeedFullRepaint = true;
                    Display.getDisplay((MIDlet)this.Parent.OwnerMidlet).setCurrent((Displayable)this.Parent);
                }
            }
        }
    }

    private boolean hasEvent(Calendar curCell) {
        if (this.weekEvents == null) {
            return false;
        }
        if (this.weekEvents.size() == 0) {
            return false;
        }
        int currentHour = curCell.get(11);
        curCell.set(11, 0);
        curCell.set(12, 0);
        curCell.set(13, 0);
        curCell.set(14, 0);
        long compare = curCell.getTime().getTime();
        for (int i = 0; i < this.weekEvents.size(); ++i) {
            Calendar cal = Calendar.getInstance();
            Event e = (Event)this.weekEvents.elementAt(i);
            long strtDate = e.getDate(106, 0);
            cal.getTimeZone();
            cal.setTime(new Date(strtDate += (long)TimeZone.getDefault().getRawOffset()));
            if (cal.get(2) == curCell.get(2) && cal.get(5) == curCell.get(5)) {
                long l = e.getDate(102, 0);
                cal.getTimeZone();
                if (strtDate == l + (long)TimeZone.getDefault().getRawOffset() && e.getRepeat() != null) {
                    this.hasAllDayEvent[this.currentDay] = true;
                    return true;
                }
            }
            if (cal.getTime().getTime() < compare || cal.getTime().getTime() >= compare + 86400000L || cal.get(11) != currentHour) continue;
            return true;
        }
        return false;
    }

    private void fillEvents() {
        Calendar curCell = Calendar.getInstance();
        for (int i = 0; i <= 23; ++i) {
            int day = this.ToGetStart.get(5);
            int month = this.ToGetStart.get(2);
            int year = this.ToGetStart.get(1);
            curCell.set(1, year);
            curCell.set(2, month);
            curCell.set(5, day);
            curCell.set(11, i);
            curCell.set(12, 0);
            curCell.set(13, 0);
            curCell.set(14, 0);
            this.CurrCalendartemp = curCell.getTime().getTime();
            for (int j = 0; j < 7; ++j) {
                this.hasEvent[i][j] = this.hasEvent(curCell);
                this.CurrCalendartemp += this.DAY;
                this.date.setTime(this.CurrCalendartemp);
                curCell.setTime(this.date);
            }
        }
    }

    class events
    implements Runnable {
        WeekView Parent;

        public events(WeekView owner) {
            this.Parent = owner;
        }

        public void run() {
            block4: while (true) {
                try {
                    block5: while (true) {
                        if (WeekView.this.runOnce) {
                            WeekView.this.runOnce = false;
                            for (int i = 0; i < 7; ++i) {
                                WeekView.this.hasAllDayEvent[i] = false;
                            }
                            Calendar curCell = Calendar.getInstance();
                            int i = 0;
                            while (true) {
                                if (i > 23) continue block5;
                                int day = WeekView.this.ToGetStart.get(5);
                                int month = WeekView.this.ToGetStart.get(2);
                                int year = WeekView.this.ToGetStart.get(1);
                                curCell.set(1, year);
                                curCell.set(2, month);
                                curCell.set(5, day);
                                curCell.set(11, i);
                                curCell.set(12, 0);
                                curCell.set(13, 0);
                                curCell.set(14, 0);
                                WeekView.this.CurrCalendartemp = curCell.getTime().getTime();
                                for (int j = 0; j < 7; ++j) {
                                    WeekView.this.hasEvent[i][j] = WeekView.this.hasEvent(curCell);
                                    WeekView.this.CurrCalendartemp += WeekView.this.DAY;
                                    WeekView.this.date.setTime(WeekView.this.CurrCalendartemp);
                                    curCell.setTime(WeekView.this.date);
                                }
                                this.Parent.repaint();
                                ++i;
                            }
                        }
                        try {
                            Thread.sleep(100L);
                            continue block4;
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

