/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.ArabicUtils;
import MobmeControls.CustomComponent;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MobmeCheckBox
extends CustomComponent {
    String m_strLabel = "";
    Displayable m_Parent = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    boolean m_bIsChecked = false;
    Font m_F = null;

    public MobmeCheckBox(String Label, Displayable parent, Display display, boolean bIsArabic) {
        this.m_strLabel = Label;
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        if (this.m_bIsArabic) {
            this.m_strLabel = ArabicUtils.ArabicString(this.m_strLabel);
        }
        this.m_F = Font.getDefaultFont();
    }

    public boolean IsChecked() {
        return this.m_bIsChecked;
    }

    public void Check(boolean bIsChecked) {
        this.m_bIsChecked = bIsChecked;
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.m_F.getHeight() + 2;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_F.getHeight() + 2;
    }

    protected void paint(Graphics gr, int w, int h) {
        int oldC = gr.getColor();
        gr.setColor(0xFFFFFF);
        gr.fillRect(0, 0, w, h);
        gr.setColor(0);
        if (this.m_bIsArabic) {
            this.paintRTL(gr, w, h);
        } else {
            this.paintLTR(gr, w, h);
        }
        gr.setColor(oldC);
    }

    protected void paintCheck(Graphics gr, int x) {
        int h;
        int w = h = this.getMinContentHeight() - 2;
        int y = 1;
        gr.setColor(0);
        gr.fillRect(x, y, w, h);
        gr.setColor(0xFFFFFF);
        gr.fillRect(x + 2, y + 2, w - 4, h - 4);
        gr.setColor(0);
        if (this.m_bIsChecked) {
            gr.drawLine(x + 5, y + h / 2, x + w / 3, y + h - 5);
            gr.drawLine(x + w / 3, y + h - 5, x + w - 7, y + 5);
        }
    }

    protected void paintRTL(Graphics gr, int w, int h) {
        this.paintCheck(gr, w - h - 2);
        gr.drawString(this.m_strLabel, w - h - 4, 0, 24);
    }

    protected void paintLTR(Graphics gr, int w, int h) {
        this.paintCheck(gr, 2);
        gr.drawString(this.m_strLabel, 4, h / 2, 68);
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyAction == 8) {
            this.m_bIsChecked = !this.m_bIsChecked;
            this.rePaint();
        }
    }

    protected void pointerPressed(int x, int y) {
        super.pointerPressed(x, y);
        int w = this.getMinContentWidth();
        int h = this.getMinContentHeight();
        if (this.m_bIsArabic) {
            if (x > w - h - 2 && x < w - 2 && y > 1 && y < h - 1) {
                this.m_bIsChecked = !this.m_bIsChecked;
            }
        } else if (x > 2 && x < h + 2 && y > 1 && y < h - 1) {
            this.m_bIsChecked = !this.m_bIsChecked;
        }
    }

    public void FocusIsGained() {
    }

    protected void pointerReleased(int x, int y) {
    }
}

