/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.ArabicUtils;
import MobmeControls.CustomComponent;
import MobmeControls.IMobeListListener;
import MobmeControls.MobmeForm;
import MobmeControls.MobmeListCtrl;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MobmeEditWHistory
extends CustomComponent
implements CommandListener,
Runnable,
IMobeListListener {
    String m_strTitle = "";
    String m_strEdit = "";
    public Displayable m_Parent = null;
    public Display m_Display = null;
    boolean m_bIsArabic = false;
    boolean m_bIsTraversedOut = true;
    Font m_F;
    int m_iPos;
    int m_iCaretPos;
    public boolean m_bIsDrawCaret;
    boolean m_bIsHasFocus;
    int m_iTxtXScroll;
    String[] m_arrHistory;
    long m_iLastWriteTime = -1L;
    boolean m_bIsDrawBackRect = false;
    MobmeForm m_FullListForm = null;
    MobmeListCtrl m_FullList = null;
    private char[][] SamsungKeyMapAra = new char[][]{{'.', ',', '-', '?', '!', '\'', '@', ':', '1'}, {'\u0628', '\u062a', '\u0629', '\u062b', '2'}, {'\u0627', '\u0623', '\u0625', '\u0622', '\u0621', '\u0626', '\u0624', '3'}, {'\u0633', '\u0634', '\u0635', '\u0636', '4'}, {'\u062f', '\u0630', '\u0631', '\u0632', '5'}, {'\u062c', '\u062d', '\u062e', '6'}, {'\u0646', '\u0647', '\u0648', '\u064a', '\u0649', '7'}, {'\u0641', '\u0642', '\u0643', '\u0644', '\u0645', '8'}, {'\u0637', '\u0638', '\u0639', '\u063a', '9'}, {'*'}, {'0', '+'}, {' '}};
    private char[][] SamsungKeyMapEng = new char[][]{{'.', ',', '-', '?', '!', '\'', '@', ':', '1'}, {'a', 'b', 'c', '2'}, {'d', 'e', 'f', '3'}, {'g', 'h', 'i', '4'}, {'j', 'k', 'l', '5'}, {'m', 'n', 'o', '6'}, {'p', 'q', 'r', 's', '7'}, {'t', 'u', 'v', '8'}, {'w', 'x', 'y', 'z', '9'}, {'*'}, {'0', '+'}, {' '}};
    private char[][] SamsungKeyMap = null;

    public MobmeEditWHistory(String Title, Displayable parent, Display display, Font f, boolean bIsArabic, String[] arrHistory) {
        this.m_strTitle = Title;
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_arrHistory = arrHistory;
        this.m_iPos = -1;
        this.m_iCaretPos = 0;
        this.m_bIsDrawCaret = true;
        this.m_bIsHasFocus = false;
        this.m_iTxtXScroll = 0;
        this.SamsungKeyMap = this.m_bIsArabic ? this.SamsungKeyMapAra : this.SamsungKeyMapEng;
        this.m_FullListForm = new MobmeForm();
        this.m_FullListForm.setTitle("\u0627\u062e\u062a\u0631 \u0645\u0646 \u0627\u0644\u0642\u0627\u0626\u0645\u0629");
        this.m_FullListForm.addCommand(new Command("\u0631\u062c\u0648\u0639", 2, 0));
        this.m_FullListForm.addCommand(new Command("\u0627\u062e\u062a\u0631", 4, 1));
        this.m_FullList = new MobmeListCtrl("", (Displayable)this.m_FullListForm, this.m_Display, Font.getDefaultFont(), this.m_bIsArabic, this.m_arrHistory);
        this.m_FullList.SetDimension(this.m_FullListForm.getWidth(), this.m_FullListForm.getHeight() - 10);
        this.m_FullListForm.append(this.m_FullList);
        this.m_FullList.SetItemChangeListener(this);
        this.m_FullListForm.setCommandListener(this);
        new Thread(this).start();
        new Thread(new CaretFlashingThread()).start();
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.m_F.getHeight() + 6;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_F.getHeight() + 6;
    }

    protected void paint(Graphics graphics, int w, int h) {
        int xCaret;
        long iCurTime;
        int oldC = graphics.getColor();
        Font oldF = graphics.getFont();
        int iFontHight = oldF.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, w, h);
        graphics.setColor(0);
        graphics.drawRect(1, 1, w - 5, h - 2);
        int xUnit = 3;
        int yUnit = 3;
        int TrWidth = (h - 4) / 2;
        graphics.setColor(oldC);
        boolean bIsMultiPressing = this.m_iLastWriteTime != -1L ? (iCurTime = System.currentTimeMillis()) - this.m_iLastWriteTime < 2500L : false;
        if (this.m_iCaretPos > this.m_strEdit.length()) {
            this.m_iCaretPos = this.m_strEdit.length();
        }
        String strEdit = new String(this.m_strEdit);
        if (this.m_bIsArabic) {
            strEdit = ArabicUtils.ArabicStringNoReversal(strEdit);
        }
        char cLast = '\u0000';
        if (bIsMultiPressing) {
            cLast = strEdit.charAt(this.m_iCaretPos - 1);
        }
        if (strEdit.length() <= 0) {
            xCaret = 0;
        } else {
            String stBeforeCaret = strEdit.substring(0, this.m_iCaretPos);
            xCaret = oldF.stringWidth(ArabicUtils.StringReversal(stBeforeCaret));
        }
        if (xCaret + 8 - this.m_iTxtXScroll > w - 14) {
            this.m_iTxtXScroll += 10;
        }
        if (xCaret + 8 - this.m_iTxtXScroll < 8) {
            this.m_iTxtXScroll -= 10;
        }
        if (this.m_iTxtXScroll < 0) {
            this.m_iTxtXScroll = 0;
        }
        if (cLast != '\u0000' && this.m_bIsDrawBackRect) {
            String strLast = "" + cLast;
            int oldc = graphics.getColor();
            graphics.setColor(0xFFFF00);
            if (this.m_bIsArabic) {
                int iCharWidth = oldF.stringWidth(strLast);
                graphics.fillRect(w - 8 - xCaret + this.m_iTxtXScroll, 2, iCharWidth, iFontHight + 1);
            } else {
                int iCharWidth = oldF.stringWidth(strLast);
                graphics.fillRect(8 + xCaret - iCharWidth - this.m_iTxtXScroll, 2, iCharWidth, iFontHight + 1);
            }
            graphics.setColor(oldc);
        }
        if (strEdit.length() > 0) {
            if (this.m_bIsArabic) {
                graphics.setClip(8, 2, w - 8 - 7, h - 2 - 2);
                graphics.drawString(ArabicUtils.StringReversal(strEdit), w - 8 + this.m_iTxtXScroll, 3, 24);
            } else {
                graphics.setClip(8, 2, w - 8 - 7, h - 2 - 2);
                graphics.drawString(strEdit, 8 - this.m_iTxtXScroll, 3, 20);
            }
        }
        if (this.IsFocused() && this.m_bIsDrawCaret) {
            if (this.m_bIsArabic) {
                graphics.drawLine(w - xCaret - 8 + this.m_iTxtXScroll, 2, w - xCaret - 8 + this.m_iTxtXScroll, iFontHight + 3 + 1);
            } else {
                graphics.drawLine(xCaret + 8 - this.m_iTxtXScroll, 2, xCaret + 8 - this.m_iTxtXScroll, iFontHight + 3 + 1);
            }
        }
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyCode >= 48 && keyCode <= 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyAction == 8 && this.m_arrHistory != null && this.m_arrHistory.length > 0) {
            this.m_iLastWriteTime = -1L;
            this.m_iPos = 0;
            this.m_FullList.UpdateList(this.m_arrHistory, 0);
            this.m_FullList.SetSelectedIndex(0);
            this.m_Display.setCurrent((Displayable)this.m_FullListForm);
        }
        if (keyAction != keyCode) {
            return;
        }
        if (keyCode == 42 || keyCode == -8) {
            if (this.m_strEdit.length() > 0 && this.m_iCaretPos > 0) {
                String before = this.m_strEdit.substring(0, this.m_iCaretPos - 1);
                String after = this.m_strEdit.substring(this.m_iCaretPos);
                this.m_strEdit = before + after;
                --this.m_iCaretPos;
            }
            this.m_iLastWriteTime = -1L;
            this.rePaint();
        } else {
            char cLast = '\u0000';
            String before = "";
            String after = "";
            if (this.m_iLastWriteTime != -1L) {
                long iCurTime = System.currentTimeMillis();
                if (iCurTime - this.m_iLastWriteTime < 2500L) {
                    char c;
                    if (this.m_strEdit.length() >= 1) {
                        if (this.m_iCaretPos >= 1) {
                            before = this.m_strEdit.substring(0, this.m_iCaretPos - 1);
                            cLast = this.m_strEdit.charAt(this.m_iCaretPos - 1);
                        }
                        after = this.m_strEdit.substring(this.m_iCaretPos);
                        this.m_strEdit = before;
                    }
                    if ((c = this.MapKeyToChar(keyCode, cLast)) != '\u0000') {
                        this.m_strEdit = this.m_strEdit + c + after;
                        this.m_iLastWriteTime = System.currentTimeMillis();
                    } else {
                        this.m_strEdit = this.m_strEdit + cLast + after;
                    }
                } else {
                    char c;
                    if (this.m_strEdit.length() >= 1) {
                        before = this.m_strEdit.substring(0, this.m_iCaretPos);
                        after = this.m_strEdit.substring(this.m_iCaretPos);
                        this.m_strEdit = before;
                    }
                    if ((c = this.MapKeyToChar(keyCode, '\u0000')) != '\u0000') {
                        this.m_strEdit = this.m_strEdit + c + after;
                        ++this.m_iCaretPos;
                        this.m_iLastWriteTime = System.currentTimeMillis();
                    }
                }
            } else {
                char c;
                if (this.m_strEdit.length() >= 1) {
                    before = this.m_strEdit.substring(0, this.m_iCaretPos);
                    after = this.m_strEdit.substring(this.m_iCaretPos);
                    this.m_strEdit = before;
                }
                if ((c = this.MapKeyToChar(keyCode, '\u0000')) != '\u0000') {
                    this.m_strEdit = this.m_strEdit + c + after;
                    ++this.m_iCaretPos;
                    this.m_iLastWriteTime = System.currentTimeMillis();
                }
            }
            this.m_bIsDrawBackRect = true;
            this.rePaint();
        }
    }

    public String GetString() {
        return this.m_strEdit;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.m_FullListForm) {
            MobmeForm frm;
            if (command.getPriority() == 1) {
                this.m_iPos = this.m_FullList.GetSelectedIndex();
                if (this.m_arrHistory != null && this.m_iPos >= 0 && this.m_iPos < this.m_arrHistory.length) {
                    this.m_strEdit = this.m_arrHistory[this.m_iPos];
                    this.m_iCaretPos = this.m_strEdit.length();
                }
                this.m_Display.setCurrent(this.m_Parent);
                try {
                    frm = (MobmeForm)this.m_Parent;
                    frm.RefreshScreen();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (command.getPriority() == 0) {
                this.m_Display.setCurrent(this.m_Parent);
                try {
                    frm = (MobmeForm)this.m_Parent;
                    frm.RefreshScreen();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private char MapKeyToChar(int keyCode, char cPrev) {
        int iRowIndex = this.GetRowIndex(keyCode);
        char c = '\u0000';
        if (iRowIndex == -1) {
            return c;
        }
        if (cPrev != '\u0000') {
            int cLastIndex = this.GetCharIndex(iRowIndex, cPrev);
            if (cLastIndex == -1) {
                this.m_strEdit = this.m_strEdit + cPrev;
                ++this.m_iCaretPos;
                c = this.SamsungKeyMap[iRowIndex][0];
            } else {
                c = cLastIndex == this.SamsungKeyMap[iRowIndex].length - 1 ? this.SamsungKeyMap[iRowIndex][0] : this.SamsungKeyMap[iRowIndex][cLastIndex + 1];
            }
        } else {
            c = this.SamsungKeyMap[iRowIndex][0];
        }
        return c;
    }

    private int GetCharIndex(int iRowIndex, char cPrev) {
        if (iRowIndex < 0 || iRowIndex >= this.SamsungKeyMap.length) {
            return -1;
        }
        char[] Row = this.SamsungKeyMap[iRowIndex];
        for (int i = 0; i < Row.length; ++i) {
            if (Row[i] != cPrev) continue;
            return i;
        }
        return -1;
    }

    private int GetRowIndex(int keyCode) {
        int iRowIndex = -1;
        switch (keyCode) {
            case 48: {
                iRowIndex = 10;
                break;
            }
            case 49: {
                iRowIndex = 0;
                break;
            }
            case 50: {
                iRowIndex = 1;
                break;
            }
            case 51: {
                iRowIndex = 2;
                break;
            }
            case 52: {
                iRowIndex = 3;
                break;
            }
            case 53: {
                iRowIndex = 4;
                break;
            }
            case 54: {
                iRowIndex = 5;
                break;
            }
            case 55: {
                iRowIndex = 6;
                break;
            }
            case 56: {
                iRowIndex = 7;
                break;
            }
            case 57: {
                iRowIndex = 8;
                break;
            }
            case 42: {
                iRowIndex = 9;
                break;
            }
            case 35: {
                iRowIndex = 11;
                break;
            }
            default: {
                return -1;
            }
        }
        return iRowIndex;
    }

    public void run() {
        try {
            int i = -1;
            while (true) {
                long iCurTime;
                Thread.sleep(150L);
                if (this.m_iLastWriteTime == -1L) {
                    i = -1;
                    continue;
                }
                if (++i % 4 == 0) {
                    i = 0;
                }
                if ((iCurTime = System.currentTimeMillis()) - this.m_iLastWriteTime > 2500L) {
                    this.m_iLastWriteTime = -1L;
                    this.m_bIsDrawBackRect = false;
                    i = -1;
                }
                this.rePaint();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void SetHistory(String[] arrHistory) {
        this.m_arrHistory = arrHistory;
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        this.m_bIsHasFocus = true;
        if (this.m_bIsArabic) {
            switch (dir) {
                case 6: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    if (this.m_iCaretPos < this.m_strEdit.length()) {
                        ++this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                    break;
                }
                case 5: {
                    if (this.m_iCaretPos > 0) {
                        --this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                }
            }
        } else {
            switch (dir) {
                case 6: {
                    return false;
                }
                case 1: {
                    return false;
                }
                case 5: {
                    if (this.m_iCaretPos < this.m_strEdit.length()) {
                        ++this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                    break;
                }
                case 2: {
                    if (this.m_iCaretPos > 0) {
                        --this.m_iCaretPos;
                    }
                    this.m_iLastWriteTime = -1L;
                    this.rePaint();
                }
            }
        }
        return true;
    }

    protected void traverseOut() {
        this.m_bIsTraversedOut = true;
        this.m_bIsHasFocus = false;
    }

    public void OnAction(int iCurSel) {
        this.m_iPos = this.m_FullList.GetSelectedIndex();
        if (this.m_arrHistory != null && this.m_iPos >= 0 && this.m_iPos < this.m_arrHistory.length) {
            this.m_strEdit = this.m_arrHistory[this.m_iPos];
            this.m_iCaretPos = this.m_strEdit.length();
        }
        this.m_Display.setCurrent(this.m_Parent);
        try {
            MobmeForm frm = (MobmeForm)this.m_Parent;
            frm.RefreshScreen();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void OnChangeItem(int iIndex, boolean LangID) {
    }

    public void OnVScroll(int iDirection, boolean LangID) {
    }

    class CaretFlashingThread
    implements Runnable {
        CaretFlashingThread() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(500L);
                        boolean bl = MobmeEditWHistory.this.m_bIsDrawCaret = !MobmeEditWHistory.this.m_bIsDrawCaret;
                        if (MobmeEditWHistory.this.m_Display.getCurrent() != MobmeEditWHistory.this.m_Parent) continue;
                        MobmeEditWHistory.this.rePaint();
                    }
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

