/*
 * Decompiled with CFR 0.152.
 */
package MobmeControls;

import MobmeControls.ArabicUtils;
import MobmeControls.CustomComponent;
import MobmeControls.MobmeGridActionListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MobmeGridControl
extends CustomComponent {
    Displayable m_Parent = null;
    Display m_Display = null;
    boolean m_bIsArabic = false;
    boolean m_bIsFirstTime = true;
    Font m_F;
    MobmeGridActionListener m_ActListener = null;
    int m_iPos;
    int m_nRows;
    int m_nCols;
    int m_nFixedRows;
    int m_nFixedCols;
    int m_nRowHight;
    int[] m_nColsWidths;
    int[] m_nColsAlighnment;
    String[][] m_TextMatrix;
    int m_nScrollX;
    int m_nScrollY;

    public MobmeGridControl(Displayable parent, Display display, Font f, boolean bIsArabic) {
        this.m_Parent = parent;
        this.m_Display = display;
        this.m_bIsArabic = bIsArabic;
        this.m_F = f;
        this.m_iPos = -1;
        this.m_nScrollX = 0;
        this.m_nScrollY = 0;
    }

    public boolean Create(int nRows, int nCols, int nFixedRows, int nFixedCols, String[][] FixedRows, String[][] FixedCols) {
        int j;
        int i;
        this.m_nRows = nRows;
        this.m_nCols = nCols;
        this.m_nFixedRows = nFixedRows;
        this.m_nFixedCols = 0;
        this.m_nRowHight = this.m_F.getHeight() + 4;
        this.m_nColsWidths = new int[this.m_nFixedCols + this.m_nCols];
        this.m_nColsAlighnment = new int[this.m_nFixedCols + this.m_nCols];
        this.m_TextMatrix = new String[this.m_nFixedRows + this.m_nRows][this.m_nFixedCols + this.m_nCols];
        for (i = 0; i < this.m_nFixedRows; ++i) {
            for (j = 0; j < this.m_nCols; ++j) {
                this.m_TextMatrix[i][j] = this.m_bIsArabic ? ArabicUtils.ArabicString(FixedRows[i][j]) : FixedRows[i][j];
            }
        }
        for (i = 0; i < this.m_nRows; ++i) {
            for (j = 0; j < this.m_nFixedCols; ++j) {
                this.m_TextMatrix[i][j] = this.m_bIsArabic ? ArabicUtils.ArabicString(FixedCols[i][j]) : FixedCols[i][j];
            }
        }
        this.AutoLayout();
        this.m_iPos = 0;
        return true;
    }

    public void SetColAutoNum(int iColIndex, int iStartNo) {
        if (iColIndex < 0 || iColIndex > this.m_nColsWidths.length) {
            return;
        }
        for (int i = 0; i < this.m_nRows; ++i) {
            this.m_TextMatrix[i + this.m_nFixedRows][iColIndex] = Integer.toString(iStartNo);
            ++iStartNo;
        }
    }

    public void SetColAlignment(int iColIndex, int iAlignment) {
        if (iColIndex < 0 || iColIndex > this.m_nColsWidths.length) {
            return;
        }
        this.m_nColsAlighnment[iColIndex] = iAlignment;
    }

    public void SetCellText(int nRow, int nCol, String stCell) {
        if (nRow < 0 || nRow > this.m_nRows) {
            return;
        }
        if (nCol < 0 || nCol > this.m_nCols) {
            return;
        }
        this.m_TextMatrix[nRow += this.m_nFixedRows][nCol += this.m_nFixedCols] = this.m_bIsArabic ? ArabicUtils.ArabicString(stCell) : new String(stCell);
    }

    public void SetFixedCellText(int nRow, int nCol, String stCell) {
        if (nRow < 0 || nRow > this.m_nFixedRows) {
            return;
        }
        if (nCol < 0 || nCol > this.m_nFixedCols) {
            return;
        }
        this.m_TextMatrix[nRow][nCol] = this.m_bIsArabic ? ArabicUtils.ArabicString(stCell) : stCell;
    }

    public void setActionListener(MobmeGridActionListener ActListener) {
        this.m_ActListener = ActListener;
    }

    public void SetColWidthPixels(int iColIndex, int iColWidth) {
        if (iColIndex < 0 || iColIndex > this.m_nColsWidths.length) {
            return;
        }
        this.m_nColsWidths[iColIndex] = iColWidth;
    }

    public void SetColWidthPercent(int iColIndex, int iColWidthPercent) {
        if (iColIndex < 0 || iColIndex > this.m_nColsWidths.length) {
            return;
        }
        this.m_nColsWidths[iColIndex] = iColWidthPercent * this.m_Parent.getWidth() / 100;
    }

    public void AutoLayout() {
        int iColWidth = this.m_Parent.getWidth() / this.m_nColsWidths.length;
        for (int i = 0; i < this.m_nColsWidths.length; ++i) {
            this.m_nColsWidths[i] = iColWidth;
            this.m_nColsAlighnment[i] = 20;
        }
    }

    protected int getMinContentWidth() {
        return this.m_Parent.getWidth();
    }

    protected int getMinContentHeight() {
        return this.m_Parent.getHeight() / this.m_nRowHight * this.m_nRowHight;
    }

    protected int getPrefContentWidth(int i) {
        return this.m_Parent.getWidth();
    }

    protected int getPrefContentHeight(int i) {
        return this.m_Parent.getHeight() / this.m_nRowHight * this.m_nRowHight;
    }

    protected void paint(Graphics graphics, int w, int h) {
        if (this.m_bIsArabic) {
            this.paintRTL(graphics, w, h);
        } else {
            this.paintLTR(graphics, w, h);
        }
    }

    protected void paintLTR(Graphics graphics, int w, int h) {
    }

    protected void paintRTL(Graphics graphics, int w, int h) {
        int j;
        int i;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, w, h);
        int ix = 0;
        int iy = 0;
        graphics.setColor(0);
        graphics.drawRect(0, 0, --w, --h);
        iy = 0;
        for (i = 0; i < this.m_nFixedRows; ++i) {
            graphics.setColor(3171278);
            graphics.fillRect(ix, iy, w, this.m_nRowHight);
            graphics.setColor(0);
            graphics.drawRect(ix, iy, w, this.m_nRowHight);
            graphics.setColor(0);
            ix = 0;
            for (j = this.m_nFixedCols; j < this.m_nColsWidths.length; ++j) {
                graphics.setColor(0);
                graphics.drawRect(w - (ix + this.m_nColsWidths[j]), iy, this.m_nColsWidths[j], this.m_nRowHight);
                graphics.setColor(0xFFFFFF);
                graphics.drawString(this.m_TextMatrix[i][j], w - (ix + this.m_nColsWidths[j] / 2), iy + 2, 17);
                ix += this.m_nColsWidths[j];
            }
            iy += this.m_nRowHight;
        }
        graphics.setClip(0, this.m_nFixedRows * this.m_nRowHight, w, h - this.m_nFixedRows * this.m_nRowHight);
        iy = this.m_nFixedRows * this.m_nRowHight - this.m_nScrollY;
        for (i = this.m_nFixedRows; i < this.m_nFixedRows + this.m_nRows; ++i) {
            ix = 0;
            if (i == this.m_iPos + this.m_nFixedRows) {
                graphics.setColor(406932);
                graphics.fillRect(ix + 1, iy, w - 1, this.m_nRowHight);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.setColor(0);
            }
            for (j = this.m_nFixedCols; j < this.m_nColsWidths.length; ++j) {
                if (this.m_TextMatrix[i][j] != null) {
                    switch (this.m_nColsAlighnment[j]) {
                        case 17: {
                            graphics.drawString(this.m_TextMatrix[i][j], w - (ix + this.m_nColsWidths[j] / 2), iy + 2, 17);
                            break;
                        }
                        case 24: {
                            graphics.drawString(this.m_TextMatrix[i][j], w - (ix + this.m_nColsWidths[j] - 5), iy + 2, 20);
                            break;
                        }
                        default: {
                            graphics.drawString(this.m_TextMatrix[i][j], w - (ix + 5), iy + 2, 24);
                        }
                    }
                }
                ix += this.m_nColsWidths[j];
            }
            iy += this.m_nRowHight;
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        switch (dir) {
            case 1: {
                if (this.m_iPos == 0) {
                    this.m_iPos = this.m_nRows - 1;
                    this.m_nScrollY = (this.m_nRows - (this.getMinContentHeight() - this.m_nFixedRows * this.m_nRowHight) / this.m_nRowHight) * this.m_nRowHight;
                    this.rePaint();
                    return true;
                }
                --this.m_iPos;
                if (this.m_nScrollY > this.m_iPos * this.m_nRowHight) {
                    this.m_nScrollY -= this.m_nRowHight;
                }
                this.rePaint();
                return true;
            }
            case 6: {
                if (this.m_iPos == this.m_nRows - 1) {
                    this.m_iPos = 0;
                    this.m_nScrollY = 0;
                    this.rePaint();
                    return true;
                }
                ++this.m_iPos;
                if (this.m_nScrollY + this.getMinContentHeight() - this.m_nFixedRows * this.m_nRowHight < (this.m_iPos + 1) * this.m_nRowHight) {
                    this.m_nScrollY += this.m_nRowHight;
                }
                this.rePaint();
                return true;
            }
            case 2: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return true;
    }

    protected void keyPressed(int keyCode) {
        int keyAction = this.getGameAction(keyCode);
        if (keyCode > 48 && keyCode < 57 || keyCode == 35 || keyCode == 42) {
            keyAction = keyCode;
        }
        if (keyAction == 8 && this.m_ActListener != null) {
            this.m_ActListener.OnAction(this.m_iPos);
        }
    }

    public int GetPos() {
        return this.m_iPos;
    }

    public void RepaintThis() {
        this.rePaint();
    }

    class ArabicUtilsDummy {
        private Shapper s_ShapperObj = new Shapper();

        ArabicUtilsDummy() {
        }

        public String ArabicString(String strIn) {
            String strOut = new String(strIn);
            strOut = this.ArabicString_RemoveDiacs(strOut);
            strOut = this.ArabicString_Shape(strOut);
            strOut = this.ArabicString_AddDiacs(strOut, strIn);
            strOut = this.ArabicString_ShapeDiacs(strOut, strIn);
            strOut = this.ArabicString_Reversal(strOut);
            return strOut;
        }

        public String ArabicStringNoReversal(String strIn) {
            String strOut = strIn;
            strOut = this.ArabicString_RemoveDiacs(strOut);
            strOut = this.ArabicString_Shape(strOut);
            strOut = this.ArabicString_AddDiacs(strOut, strIn);
            strOut = this.ArabicString_ShapeDiacs(strOut, strIn);
            return strOut;
        }

        public String StringReversal(String strIn) {
            String strOut = strIn;
            strOut = this.ArabicString_Reversal(strOut);
            return strOut;
        }

        private String ArabicString_Reversal(String strIn) {
            char c;
            int i;
            if (strIn == null) {
                return null;
            }
            String strOut = "";
            String strOutPart = "";
            String strNum = "";
            String strEngChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            String strCtxChars = "()[]{}\\\"<>`~!@#$%^&*-_+=|/?';:., \t\n\r";
            String strFlipChars = "()[]{}<>";
            String strFlipedChars = ")(][}{><";
            int iCtxDirRTL = -1;
            boolean bIsNum = false;
            boolean bIsEng = false;
            int iLastInsertPos = 0;
            for (i = 0; i < strIn.length(); ++i) {
                c = strIn.charAt(i);
                if (strCtxChars.indexOf(c) != -1 || c >= '0' && c <= '9') continue;
                if (strEngChars.indexOf(c) != -1) {
                    iCtxDirRTL = 0;
                    break;
                }
                iCtxDirRTL = 1;
                break;
            }
            if (iCtxDirRTL == -1) {
                return strIn;
            }
            for (i = 0; i < strIn.length(); ++i) {
                int ii;
                c = strIn.charAt(i);
                if (c >= '0' && c <= '9' || bIsNum && c == '.') {
                    if (strOutPart.compareTo("") != 0) {
                        strOut = iCtxDirRTL == 1 ? strOutPart + strOut : strOut + strOutPart;
                        strOutPart = "";
                    }
                    bIsNum = true;
                    strNum = strNum + c;
                    continue;
                }
                if (bIsNum) {
                    strOutPart = strNum;
                    strOut = iCtxDirRTL == 1 ? strOutPart + strOut : strOut + strOutPart;
                    strNum = "";
                    strOutPart = "";
                    bIsNum = false;
                }
                if (strEngChars.indexOf(c) != -1 || iCtxDirRTL == 0 && strCtxChars.indexOf(c) != -1) {
                    if (!bIsEng) {
                        bIsEng = true;
                        if (iCtxDirRTL == 1) {
                            strOut = strOut.substring(0, iLastInsertPos) + strOutPart + strOut.substring(iLastInsertPos);
                        } else {
                            strOut = strOut + strOutPart;
                            iLastInsertPos = strOut.length();
                        }
                        strOutPart = "";
                        strOutPart = strOutPart + c;
                        iCtxDirRTL = 0;
                        continue;
                    }
                    strOutPart = strOutPart + c;
                    continue;
                }
                if (bIsEng) {
                    if (iCtxDirRTL == 1) {
                        strOut = strOut.substring(0, iLastInsertPos) + strOutPart + strOut.substring(iLastInsertPos);
                    } else {
                        strOut = strOut + strOutPart;
                        iLastInsertPos = strOut.length();
                    }
                    strOutPart = "";
                    bIsEng = false;
                }
                if ((ii = strFlipChars.indexOf(c)) != -1) {
                    c = strFlipedChars.charAt(ii);
                }
                strOutPart = "" + c + strOutPart;
                iCtxDirRTL = 1;
            }
            if (bIsNum) {
                strOutPart = strNum;
                strOut = iCtxDirRTL == 1 ? strOutPart + strOut : strOut + strOutPart;
                strNum = "";
                strOutPart = "";
                bIsNum = false;
            }
            if (strOutPart.compareTo("") != 0) {
                if (iCtxDirRTL == 1) {
                    strOut = strOut.substring(0, iLastInsertPos) + strOutPart + strOut.substring(iLastInsertPos);
                } else {
                    strOut = strOut + strOutPart;
                    iLastInsertPos = strOut.length();
                }
                strOutPart = "";
            }
            return strOut;
        }

        private String ArabicString_Shape(String strIn) {
            String strOut = "";
            Shapper shp = this.s_ShapperObj;
            strOut = shp.ShapeString(strIn);
            return strOut;
        }

        private String ArabicString_RemoveDiacs(String strIn) {
            String strOut = "";
            Shapper shp = this.s_ShapperObj;
            for (int i = 0; i < strIn.length(); ++i) {
                char c = strIn.charAt(i);
                if (shp.is_Diac(c)) continue;
                strOut = strOut + c;
            }
            return strOut;
        }

        private String ArabicString_AddDiacs(String strIn, String strWDiacs) {
            String strOut = "";
            Shapper shp = this.s_ShapperObj;
            int j = 0;
            for (int i = 0; i < strWDiacs.length(); ++i) {
                char c = strWDiacs.charAt(i);
                if (!shp.is_Diac(c)) {
                    c = strIn.charAt(j);
                    ++j;
                    strOut = strOut + c;
                    continue;
                }
                strOut = strOut + c;
            }
            return strOut;
        }

        private String ArabicString_ShapeDiacs(String strIn, String OrgnStr) {
            String strOut = "";
            Shapper shp = this.s_ShapperObj;
            strOut = shp.ShapeStringDiacs(strIn, OrgnStr);
            return strOut;
        }

        class Shapper {
            short AR_SHP_START = (short)1569;
            short AR_SHP_END1 = (short)1610;
            short AR_SHP_END = (short)1648;
            int AR_GLYPH_START1 = 65136;
            int AR_GLYPH_END1 = 65279;
            int AR_GLYPH_START2 = 64336;
            int AR_GLYPH_END2 = 65023;
            int EN_NEUTRAL_START = 37;
            int EN_NEUTRAL_END = 127;
            int EN_NUMERIC_START = 42;
            int EN_NUMERIC_END = 57;
            int AR_DIAC_START = 1611;
            int AR_DIAC_END = 1621;
            int AR_DIAC_SHP_START1 = 65136;
            int AR_DIAC_SHP_END1 = 65151;
            int AR_DIAC_SHP_START2 = 64606;
            int AR_DIAC_SHP_END2 = 64611;
            byte JTYPE_RIGHT = 1;
            byte JTYPE_DUAL = (byte)3;
            byte JTYPE_NON = 0;
            byte JTYPE_NARAB = (byte)4;
            byte JTYPE_DIAC = (byte)11;
            ArabicShapes[] unicodeShapes = new ArabicShapes[]{new ArabicShapes((char)(this.AR_SHP_START + 0), this.JTYPE_NON, '\ufe80', '\ufe80', '\ufe80', '\ufe80', '\ufe80'), new ArabicShapes((char)(this.AR_SHP_START + 1), this.JTYPE_RIGHT, '\ufe81', '\ufe81', '\ufe82', '\ufe81', '\ufe82'), new ArabicShapes((char)(this.AR_SHP_START + 2), this.JTYPE_RIGHT, '\ufe83', '\ufe83', '\ufe84', '\ufe83', '\ufe84'), new ArabicShapes((char)(this.AR_SHP_START + 3), this.JTYPE_RIGHT, '\ufe85', '\ufe85', '\ufe86', '\ufe85', '\ufe86'), new ArabicShapes((char)(this.AR_SHP_START + 4), this.JTYPE_RIGHT, '\ufe87', '\ufe87', '\ufe88', '\ufe87', '\ufe88'), new ArabicShapes((char)(this.AR_SHP_START + 5), this.JTYPE_DUAL, '\ufe89', '\ufe89', '\ufe8a', '\ufe8b', '\ufe8c'), new ArabicShapes((char)(this.AR_SHP_START + 6), this.JTYPE_RIGHT, '\ufe8d', '\ufe8d', '\ufe8e', '\ufe8d', '\ufe8e'), new ArabicShapes((char)(this.AR_SHP_START + 7), this.JTYPE_DUAL, '\ufe8f', '\ufe8f', '\ufe90', '\ufe91', '\ufe92'), new ArabicShapes((char)(this.AR_SHP_START + 8), this.JTYPE_RIGHT, '\ufe93', '\ufe93', '\ufe94', '\ufe93', '\ufe94'), new ArabicShapes((char)(this.AR_SHP_START + 9), this.JTYPE_DUAL, '\ufe95', '\ufe95', '\ufe96', '\ufe97', '\ufe98'), new ArabicShapes((char)(this.AR_SHP_START + 10), this.JTYPE_DUAL, '\ufe99', '\ufe99', '\ufe9a', '\ufe9b', '\ufe9c'), new ArabicShapes((char)(this.AR_SHP_START + 11), this.JTYPE_DUAL, '\ufe9d', '\ufe9d', '\ufe9e', '\ufe9f', '\ufea0'), new ArabicShapes((char)(this.AR_SHP_START + 12), this.JTYPE_DUAL, '\ufea1', '\ufea1', '\ufea2', '\ufea3', '\ufea4'), new ArabicShapes((char)(this.AR_SHP_START + 13), this.JTYPE_DUAL, '\ufea5', '\ufea5', '\ufea6', '\ufea7', '\ufea8'), new ArabicShapes((char)(this.AR_SHP_START + 14), this.JTYPE_RIGHT, '\ufea9', '\ufea9', '\ufeaa', '\ufea9', '\ufeaa'), new ArabicShapes((char)(this.AR_SHP_START + 15), this.JTYPE_RIGHT, '\ufeab', '\ufeab', '\ufeac', '\ufeab', '\ufeac'), new ArabicShapes((char)(this.AR_SHP_START + 16), this.JTYPE_RIGHT, '\ufead', '\ufead', '\ufeae', '\ufead', '\ufeae'), new ArabicShapes((char)(this.AR_SHP_START + 17), this.JTYPE_RIGHT, '\ufeaf', '\ufeaf', '\ufeb0', '\ufeaf', '\ufeb0'), new ArabicShapes((char)(this.AR_SHP_START + 18), this.JTYPE_DUAL, '\ufeb1', '\ufeb1', '\ufeb2', '\ufeb3', '\ufeb4'), new ArabicShapes((char)(this.AR_SHP_START + 19), this.JTYPE_DUAL, '\ufeb5', '\ufeb5', '\ufeb6', '\ufeb7', '\ufeb8'), new ArabicShapes((char)(this.AR_SHP_START + 20), this.JTYPE_DUAL, '\ufeb9', '\ufeb9', '\ufeba', '\ufebb', '\ufebc'), new ArabicShapes((char)(this.AR_SHP_START + 21), this.JTYPE_DUAL, '\ufebd', '\ufebd', '\ufebe', '\ufebf', '\ufec0'), new ArabicShapes((char)(this.AR_SHP_START + 22), this.JTYPE_DUAL, '\ufec1', '\ufec1', '\ufec2', '\ufec3', '\ufec4'), new ArabicShapes((char)(this.AR_SHP_START + 23), this.JTYPE_DUAL, '\ufec5', '\ufec5', '\ufec6', '\ufec7', '\ufec8'), new ArabicShapes((char)(this.AR_SHP_START + 24), this.JTYPE_DUAL, '\ufec9', '\ufec9', '\ufeca', '\ufecb', '\ufecc'), new ArabicShapes((char)(this.AR_SHP_START + 25), this.JTYPE_DUAL, '\ufecd', '\ufecd', '\ufece', '\ufecf', '\ufed0'), new ArabicShapes((char)(this.AR_SHP_START + 26), this.JTYPE_NARAB, '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'), new ArabicShapes((char)(this.AR_SHP_START + 27), this.JTYPE_NARAB, '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'), new ArabicShapes((char)(this.AR_SHP_START + 28), this.JTYPE_NARAB, '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'), new ArabicShapes((char)(this.AR_SHP_START + 29), this.JTYPE_NARAB, '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'), new ArabicShapes((char)(this.AR_SHP_START + 30), this.JTYPE_NARAB, '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'), new ArabicShapes((char)(this.AR_SHP_START + 31), this.JTYPE_DUAL, '\u0640', '\u0640', '\u0640', '\u0640', '\u0640'), new ArabicShapes((char)(this.AR_SHP_START + 32), this.JTYPE_DUAL, '\ufed1', '\ufed1', '\ufed2', '\ufed3', '\ufed4'), new ArabicShapes((char)(this.AR_SHP_START + 33), this.JTYPE_DUAL, '\ufed5', '\ufed5', '\ufed6', '\ufed7', '\ufed8'), new ArabicShapes((char)(this.AR_SHP_START + 34), this.JTYPE_DUAL, '\ufed9', '\ufed9', '\ufeda', '\ufedb', '\ufedc'), new ArabicShapes((char)(this.AR_SHP_START + 35), this.JTYPE_DUAL, '\ufedd', '\ufedd', '\ufede', '\ufedf', '\ufee0'), new ArabicShapes((char)(this.AR_SHP_START + 36), this.JTYPE_DUAL, '\ufee1', '\ufee1', '\ufee2', '\ufee3', '\ufee4'), new ArabicShapes((char)(this.AR_SHP_START + 37), this.JTYPE_DUAL, '\ufee5', '\ufee5', '\ufee6', '\ufee7', '\ufee8'), new ArabicShapes((char)(this.AR_SHP_START + 38), this.JTYPE_DUAL, '\ufeeb', '\ufee9', '\ufeea', '\ufeeb', '\ufeec'), new ArabicShapes((char)(this.AR_SHP_START + 39), this.JTYPE_RIGHT, '\ufeed', '\ufeed', '\ufeee', '\ufeed', '\ufeee'), new ArabicShapes((char)(this.AR_SHP_START + 40), this.JTYPE_RIGHT, '\ufeef', '\ufeef', '\ufef0', '\ufeef', '\ufef0'), new ArabicShapes((char)(this.AR_SHP_START + 41), this.JTYPE_DUAL, '\ufef1', '\ufef1', '\ufef2', '\ufef3', '\ufef4'), new ArabicShapes((char)(this.AR_SHP_START + 42), this.JTYPE_DIAC, '\ufe70', '\ufe70', '\ufe70', '\ufe70', '\ufe71'), new ArabicShapes((char)(this.AR_SHP_START + 43), this.JTYPE_DIAC, '\ufe72', '\ufe72', '\ufe72', '\ufe72', '\ufe72'), new ArabicShapes((char)(this.AR_SHP_START + 44), this.JTYPE_DIAC, '\ufe74', '\ufe74', '\ufe74', '\ufe74', '\ufe74'), new ArabicShapes((char)(this.AR_SHP_START + 45), this.JTYPE_DIAC, '\ufe76', '\ufe76', '\ufe76', '\ufe76', '\ufe77'), new ArabicShapes((char)(this.AR_SHP_START + 46), this.JTYPE_DIAC, '\ufe78', '\ufe78', '\ufe78', '\ufe78', '\ufe79'), new ArabicShapes((char)(this.AR_SHP_START + 47), this.JTYPE_DIAC, '\ufe7a', '\ufe7a', '\ufe7a', '\ufe7a', '\ufe7b'), new ArabicShapes((char)(this.AR_SHP_START + 48), this.JTYPE_DIAC, '\ufe7c', '\ufe7c', '\ufe7c', '\ufe7c', '\ufe7d'), new ArabicShapes((char)(this.AR_SHP_START + 49), this.JTYPE_DIAC, '\ufe7e', '\ufe7e', '\ufe7e', '\ufe7e', '\ufe7f'), new ArabicShapes((char)(this.AR_SHP_START + 50), this.JTYPE_DIAC, '\u0653', '\u0653', '\u0653', '\u0653', '\u0653'), new ArabicShapes((char)(this.AR_SHP_START + 51), this.JTYPE_DIAC, '\u0654', '\u0654', '\u0654', '\u0654', '\u0654'), new ArabicShapes((char)(this.AR_SHP_START + 52), this.JTYPE_DIAC, '\u0655', '\u0655', '\u0655', '\u0655', '\u0655')};

            Shapper() {
            }

            boolean needs_shaping(char ch) {
                return ch >= this.AR_SHP_START && ch <= this.AR_SHP_START + this.unicodeShapes.length;
            }

            boolean arabic_letters(char ch) {
                return ch >= this.AR_SHP_START && ch <= this.AR_SHP_END1;
            }

            public boolean is_Diac(char ch) {
                return ch >= this.AR_DIAC_START && ch <= this.AR_DIAC_END;
            }

            boolean is_Neutral(char ch) {
                return ch >= this.EN_NEUTRAL_START && ch <= this.EN_NEUTRAL_END;
            }

            public String ShapeString(String InStr) {
                int i;
                ArabicShapes nSh;
                ArabicShapes cSh;
                String OutStr = "";
                boolean pIsJoined = false;
                boolean p = false;
                char n = '\u0000';
                int nChars = InStr.length();
                if (nChars <= 1) {
                    return InStr;
                }
                int j = 0;
                char c = InStr.charAt(j);
                n = InStr.charAt(j + 1);
                if (!this.needs_shaping(c) || !this.needs_shaping(n)) {
                    OutStr = OutStr + c;
                } else {
                    cSh = this.unicodeShapes[c - this.AR_SHP_START];
                    nSh = this.unicodeShapes[n - this.AR_SHP_START];
                    if (cSh.joinType != this.JTYPE_DUAL) {
                        OutStr = OutStr + cSh.isolated;
                    } else if (nSh.joinType == this.JTYPE_RIGHT || nSh.joinType == this.JTYPE_DUAL) {
                        OutStr = OutStr + cSh.initial;
                        pIsJoined = true;
                    } else {
                        OutStr = OutStr + cSh.isolated;
                    }
                }
                for (i = 1; i < nChars - 1; ++i) {
                    c = InStr.charAt(i);
                    n = InStr.charAt(i + 1);
                    if (!this.needs_shaping(c)) {
                        OutStr = OutStr + c;
                        pIsJoined = false;
                        continue;
                    }
                    cSh = this.unicodeShapes[c - this.AR_SHP_START];
                    if (cSh.joinType == this.JTYPE_RIGHT || cSh.joinType == this.JTYPE_DUAL && !this.needs_shaping(n) || cSh.joinType == this.JTYPE_NON) {
                        OutStr = pIsJoined ? OutStr + cSh._final : OutStr + cSh.isolated;
                        pIsJoined = false;
                        continue;
                    }
                    if (cSh.joinType != this.JTYPE_DUAL) continue;
                    nSh = this.unicodeShapes[n - this.AR_SHP_START];
                    if (nSh.joinType == this.JTYPE_RIGHT || nSh.joinType == this.JTYPE_DUAL) {
                        OutStr = pIsJoined ? OutStr + cSh.medial : OutStr + cSh.initial;
                        pIsJoined = true;
                        continue;
                    }
                    OutStr = pIsJoined ? OutStr + cSh._final : OutStr + cSh.isolated;
                    pIsJoined = false;
                }
                c = InStr.charAt(i);
                n = '\u0000';
                if (!this.needs_shaping(c)) {
                    OutStr = OutStr + c;
                    pIsJoined = false;
                } else {
                    cSh = this.unicodeShapes[c - this.AR_SHP_START];
                    OutStr = pIsJoined ? OutStr + cSh._final : OutStr + cSh.isolated;
                    pIsJoined = false;
                }
                return OutStr;
            }

            public String ShapeStringDiacs(String InStr, String OrgnString) {
                String OutStr = "";
                boolean pIsJoined = false;
                char p = '\u0000';
                char n = '\u0000';
                int nChars = InStr.length();
                if (nChars <= 1) {
                    return InStr;
                }
                for (int i = 0; i < nChars; ++i) {
                    char c = InStr.charAt(i);
                    if (!this.is_Diac(c)) {
                        OutStr = OutStr + c;
                        continue;
                    }
                    if (!this.needs_shaping(c)) {
                        OutStr = OutStr + c;
                        continue;
                    }
                    ArabicShapes cSh = this.unicodeShapes[c - this.AR_SHP_START];
                    if (cSh.joinType != this.JTYPE_DIAC || i == 0) {
                        OutStr = OutStr + c;
                        continue;
                    }
                    p = OrgnString.charAt(i - 1);
                    if (!this.needs_shaping(p)) {
                        OutStr = OutStr + c;
                        continue;
                    }
                    n = OutStr.charAt(i - 1);
                    ArabicShapes pSh = this.unicodeShapes[p - this.AR_SHP_START];
                    OutStr = !(n != pSh.medial && n != pSh.initial || pSh.joinType != this.JTYPE_DUAL && pSh.joinType != this.JTYPE_DIAC) ? OutStr + cSh.medial : OutStr + c;
                }
                return OutStr;
            }

            class ArabicShapes {
                char code;
                byte joinType;
                char standalone;
                char isolated;
                char _final;
                char initial;
                char medial;

                public ArabicShapes(char co, byte jo, char st, char is, char _f, char in, char me) {
                    this.code = co;
                    this.joinType = jo;
                    this.standalone = st;
                    this.isolated = is;
                    this._final = _f;
                    this.initial = in;
                    this.medial = me;
                }
            }
        }
    }
}

