/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.wap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.kxml.PrefixMap;
import org.kxml.io.AbstractXmlWriter;
import org.kxml.io.State;

public class WbxmlWriter
extends AbstractXmlWriter {
    Hashtable stringTable = new Hashtable();
    OutputStream out;
    ByteArrayOutputStream buf = new ByteArrayOutputStream();
    ByteArrayOutputStream stringTableBuf = new ByteArrayOutputStream();
    String pending;
    Vector attributes = new Vector();
    Hashtable attrStartTable = new Hashtable();
    Hashtable attrValueTable = new Hashtable();
    Hashtable tagTable = new Hashtable();

    public WbxmlWriter(OutputStream out) throws IOException {
        this.out = out;
        this.buf = new ByteArrayOutputStream();
        this.stringTableBuf = new ByteArrayOutputStream();
        out.write(1);
        out.write(1);
        out.write(4);
    }

    public void flush() {
    }

    public void close() throws IOException {
        WbxmlWriter.writeInt(this.out, this.stringTableBuf.size());
        this.out.write(this.stringTableBuf.toByteArray());
        this.out.write(this.buf.toByteArray());
        this.out.flush();
    }

    public void checkPending(boolean degenerated) throws IOException {
        if (this.pending == null) {
            return;
        }
        int len = this.attributes.size();
        Integer idx = (Integer)this.tagTable.get(this.pending);
        if (idx == null) {
            this.buf.write(len == 0 ? (degenerated ? 4 : 68) : (degenerated ? 132 : 196));
            this.writeStrT(this.pending);
        } else {
            this.buf.write(len == 0 ? (degenerated ? idx : idx | 0x40) : (degenerated ? idx | 0x80 : idx | 0xC0));
        }
        for (int i = 0; i < len; ++i) {
            idx = (Integer)this.attrStartTable.get(this.attributes.elementAt(i));
            if (idx == null) {
                this.buf.write(4);
                this.writeStrT((String)this.attributes.elementAt(i));
            } else {
                this.buf.write(idx);
            }
            idx = (Integer)this.attrValueTable.get(this.attributes.elementAt(++i));
            if (idx == null) {
                this.buf.write(3);
                WbxmlWriter.writeStrI(this.buf, (String)this.attributes.elementAt(i));
                continue;
            }
            this.buf.write(idx);
        }
        if (len > 0) {
            this.buf.write(1);
        }
        this.pending = null;
        this.attributes.removeAllElements();
    }

    public void startTag(PrefixMap prefixMap, String name) throws IOException {
        this.current = new State(this.current, prefixMap, name);
        this.checkPending(false);
        this.pending = name;
    }

    public void attribute(String name, String value) {
        this.attributes.addElement(name);
        this.attributes.addElement(value);
    }

    public void write(char[] chars, int start, int len) throws IOException {
        this.checkPending(false);
        this.buf.write(3);
        WbxmlWriter.writeStrI(this.buf, new String(chars, start, len));
    }

    public void endTag() throws IOException {
        this.current = this.current.prev;
        if (this.pending != null) {
            this.checkPending(true);
        } else {
            this.buf.write(1);
        }
    }

    public void writeLegacy(int type, String data) {
    }

    static void writeInt(OutputStream out, int i) throws IOException {
        byte[] buf = new byte[5];
        int idx = 0;
        do {
            buf[idx++] = (byte)(i & 0x7F);
        } while ((i >>= 7) != 0);
        while (idx > 1) {
            out.write(buf[--idx] | 0x80);
        }
        out.write(buf[0]);
    }

    static void writeStrI(OutputStream out, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            out.write((byte)s.charAt(i));
        }
        out.write(0);
    }

    void writeStrT(String s) throws IOException {
        Integer idx = (Integer)this.stringTable.get(s);
        if (idx == null) {
            idx = new Integer(this.stringTableBuf.size());
            this.stringTable.put(s, idx);
            WbxmlWriter.writeStrI(this.stringTableBuf, s);
            this.stringTableBuf.flush();
        }
        WbxmlWriter.writeInt(this.buf, idx);
    }

    public void setTagTable(int page, String[] tagTable) {
        for (int i = 0; i < tagTable.length; ++i) {
            if (tagTable[i] == null) continue;
            Integer idx = new Integer(i + 5);
            this.tagTable.put(tagTable[i], idx);
        }
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrStartTable(int page, String[] attrStartTable) {
        for (int i = 0; i < attrStartTable.length; ++i) {
            if (attrStartTable[i] == null) continue;
            Integer idx = new Integer(i + 5);
            this.attrStartTable.put(attrStartTable[i], idx);
        }
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }

    public void setAttrValueTable(int page, String[] attrValueTable) {
        for (int i = 0; i < attrValueTable.length; ++i) {
            if (attrValueTable[i] == null) continue;
            Integer idx = new Integer(i + 133);
            this.attrValueTable.put(attrValueTable[i], idx);
        }
        if (page != 0) {
            throw new RuntimeException("code pages curr. not supp.");
        }
    }
}

