/*
 * Decompiled with CFR 0.152.
 */
package ParserPKG;

import ParserPKG.Channel;
import ParserPKG.RSSListener;
import ParserPKG.UTF8;
import ParserPKG.Windows1256;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;

public class XMLParse
implements RSSListener {
    private Channel curChannel;
    public static boolean rightAllign;
    public static String encoding;

    public void parse(InputStream in) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        XmlParser parser = new XmlParser(reader);
        ParseEvent pe = null;
        int fieldCount = 0;
        pe = parser.read();
        this.getEncoding(pe);
        parser.skip();
        parser.read(64, null, "rss");
        parser.skip();
        pe = parser.read(64, null, "channel");
        String name = null;
        name = pe.getName();
        String itemID = null;
        String version = null;
        String description = null;
        String link = null;
        String title = null;
        while (fieldCount < 4) {
            pe = parser.read();
            if (pe.getType() == 64 && pe.getName().equals("title")) {
                pe = parser.read();
                title = pe.getText();
                ++fieldCount;
                continue;
            }
            if (pe.getType() == 64 && pe.getName().equals("link")) {
                pe = parser.read();
                link = pe.getText();
                ++fieldCount;
                continue;
            }
            if (pe.getType() == 64 && pe.getName().equals("description")) {
                pe = parser.read();
                description = pe.getText();
                ++fieldCount;
                continue;
            }
            if (pe.getType() != 64 || !pe.getName().equals("version")) continue;
            pe = parser.read();
            version = pe.getText();
            ++fieldCount;
        }
        this.itemParsed(0, title.trim(), link.trim(), description.trim(), version.trim(), itemID);
        boolean trucking = true;
        boolean first = true;
        while (trucking) {
            pe = parser.read();
            if (pe.getType() == 64) {
                name = pe.getName();
                if (name.equals("item")) {
                    itemID = null;
                    version = null;
                    description = null;
                    link = null;
                    title = null;
                    while (pe.getType() != 16 || !pe.getName().equals(name)) {
                        pe = parser.read();
                        if (pe.getType() == 64 && pe.getName().equals("title")) {
                            pe = parser.read();
                            title = pe.getText();
                            continue;
                        }
                        if (pe.getType() == 64 && pe.getName().equals("link")) {
                            pe = parser.read();
                            link = pe.getText();
                            continue;
                        }
                        if (pe.getType() == 64 && pe.getName().equals("description")) {
                            pe = parser.read();
                            description = pe.getText();
                            continue;
                        }
                        if (pe.getType() == 64 && pe.getName().equals("version")) {
                            pe = parser.read();
                            version = pe.getText();
                            continue;
                        }
                        if (pe.getType() != 64 || !pe.getName().equals("id")) continue;
                        pe = parser.read();
                        itemID = pe.getText();
                    }
                    if (description == null) {
                        description = "";
                    }
                    if (link == null) {
                        link = "";
                    }
                    if (title == null) {
                        title = "";
                    }
                    if (encoding.equalsIgnoreCase("windows-1256")) {
                        title = Windows1256.resolve(title.trim().toString().getBytes());
                        description = Windows1256.resolve(description.trim().toString().getBytes());
                    } else if (encoding.equalsIgnoreCase("utf-8")) {
                        title = UTF8.decode(title.trim().toString().getBytes(), title.trim().length());
                        description = UTF8.decode(description.trim().toString().getBytes(), description.trim().length());
                    } else {
                        title = title.trim();
                        description = description.trim();
                    }
                    this.itemParsed(1, title.trim(), link.trim(), description.trim(), version.trim(), itemID.trim());
                } else {
                    while (pe.getType() != 16 || !pe.getName().equals(name)) {
                        pe = parser.read();
                    }
                }
            }
            if (pe.getType() != 16 || !pe.getName().equals("rss")) continue;
            trucking = false;
        }
    }

    public Channel getParse(InputStream in) throws Exception {
        try {
            if (in == null) {
                return null;
            }
            this.parse(in);
            if (this.curChannel == null) {
                in.close();
                return null;
            }
            this.curChannel.setItems();
            in.close();
            return this.curChannel;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            in.close();
            return null;
        }
    }

    public void itemParsed(int type, String title, String link, String description, String ver, String id) {
        if (type == 0) {
            this.curChannel = new Channel(title, link, description, ver);
        } else {
            this.curChannel.appendItem(title, link, this.ParseHTMLTags(description), ver, id);
        }
    }

    private String[] ParseHTMLTags(String in) {
        int i;
        String[] out = new String[2];
        boolean hasStartTag = false;
        boolean hasEndTag = false;
        out[0] = "";
        out[1] = null;
        if (!in.startsWith("<")) {
            out[0] = in;
            out[1] = null;
            return out;
        }
        char[] broken = in.toCharArray();
        for (int i2 = 0; i2 < broken.length; ++i2) {
            if (broken[i2] == '<') {
                hasStartTag = true;
            }
            if (!hasStartTag || broken[i2] != '>') continue;
            hasEndTag = true;
            break;
        }
        if (!hasStartTag && !hasEndTag) {
            out[0] = in;
            out[1] = null;
            return out;
        }
        boolean tagLocated = false;
        for (i = 1; i < broken.length; ++i) {
            if (broken[i] == 'p' && broken[i - 1] == '<') {
                ++i;
                tagLocated = true;
            }
            if (broken[i] != '>' || !tagLocated) continue;
            if (broken[++i] == '<' && broken[i + 1] == 'i' && broken[i + 2] == 'm' && broken[i + 3] == 'g') {
                i += 9;
                out[1] = "";
                while (broken[i] != ' ' && broken[i] != '\"' && broken[i] != '>') {
                    out[1] = out[1] + broken[i++];
                }
                if (broken[i] != '>') {
                    while (broken[i] != '>') {
                        ++i;
                    }
                }
                if (broken[i] == '>') {
                    ++i;
                }
            }
            while (broken[i] != '<') {
                out[0] = out[0] + broken[i++];
            }
            break;
        }
        tagLocated = false;
        if (out[1] == null) {
            for (i = 1; i < broken.length; ++i) {
                block17: {
                    try {
                        if (broken[i] != 'i' || broken[i - 1] != '<' || broken[i + 1] != 'm' || broken[i + 2] != 'g') break block17;
                        i += 8;
                        tagLocated = true;
                    }
                    catch (ArrayIndexOutOfBoundsException aeo) {
                        out[1] = null;
                        break;
                    }
                }
                if (broken[i] != '\"' || !tagLocated) continue;
                tagLocated = false;
                out[1] = "";
                ++i;
                while (broken[i] != '\"') {
                    out[1] = out[1] + broken[i++];
                }
            }
        }
        return out;
    }

    private void getEncoding(ParseEvent pe) {
        String text = pe.getText();
        String endPart = "";
        char[] chars = text.toCharArray();
        int index = text.lastIndexOf(34);
        while (chars[index - 1] != '\"') {
            --index;
        }
        while (chars[index] != '\"') {
            endPart = endPart + chars[index];
            ++index;
        }
        encoding = endPart;
        rightAllign = endPart.equalsIgnoreCase("windows-1256");
    }

    static {
        encoding = "";
    }
}

