/*
 * Decompiled with CFR 0.152.
 */
package UpdaterPackage;

import UpdaterPackage.AppInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RSHandler {
    private RecordStore rs = null;
    static final String REC_STORE = "updater_db";
    static final String LANG_RS = "Language_db";
    private String channelVer = null;
    private String channelLink = null;
    private Vector appsList = new Vector();
    static final int ARABIC = 0;
    static final int ENGLISH = 1;
    private int Language = 0;

    public RSHandler() {
        try {
            this.getCurrentLanguage();
            this.openRecStore();
            if (this.rs.getNumRecords() != 0) {
                this.retrieveListData();
            }
            this.closeRecStore();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private void getCurrentLanguage() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)LANG_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
            try {
                this.rs = RecordStore.openRecordStore((String)LANG_RS, (boolean)true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.rs.getNumRecords() != 0) {
            this.Language = this.readRecords(this.rs.getNextRecordID() - 1).equals("AR") ? 0 : 1;
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public void saveLanguage() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)LANG_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
        }
        String str = this.Language == 0 ? "AR" : "EN";
        if (this.rs.getNumRecords() != 0) {
            byte[] rec = str.getBytes();
            this.rs.setRecord(1, rec, 0, rec.length);
        } else {
            this.writeRecord(str.trim());
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public int getLanguage() {
        return this.Language;
    }

    public void setLanguage(int lang) {
        this.Language = lang;
    }

    public void openRecStore() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            e.printStackTrace();
            try {
                this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.rs.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public String readRecords(int index) {
        try {
            byte[] recData = new byte[this.rs.getRecordSize(index)];
            int len = this.rs.getRecord(index, recData, 0);
            return new String(recData, 0, len);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
            return null;
        }
    }

    public void closeRecStore() {
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public void deleteRecStore() {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)REC_STORE);
            }
            catch (Exception e) {
                e.toString();
                e.printStackTrace();
            }
        }
    }

    private void retrieveListData() {
        try {
            int NoOfItems = 0;
            if (this.rs.getNumRecords() > 2) {
                this.channelVer = this.readRecords(1);
                this.channelLink = this.readRecords(2);
                NoOfItems = Integer.parseInt(this.readRecords(3));
                this.readStream(NoOfItems);
            }
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
    }

    public void readStream(int size) {
        try {
            byte[] recData = this.rs.getRecord(4);
            ByteArrayInputStream strmBytes = new ByteArrayInputStream(recData);
            DataInputStream dis = new DataInputStream(strmBytes);
            for (int i = 1; i <= size; ++i) {
                AppInfo app = new AppInfo(dis.readUTF(), dis.readUTF(), dis.readUTF(), dis.readUTF(), dis.readUTF(), dis.readInt());
                app.Status = dis.readInt();
                this.appsList.addElement(app);
                app = null;
            }
            strmBytes.close();
            dis.close();
        }
        catch (Exception e) {
            System.out.println("Exception...in read Stream");
            e.printStackTrace();
        }
    }

    public Vector getCurrAppsList() {
        if (this.appsList != null && this.appsList.size() > 0) {
            return this.appsList;
        }
        return null;
    }

    public void saveListData(Vector app, String ver, String link) {
        this.writeRecord(ver);
        this.writeRecord(link);
        this.writeRecord("" + app.size());
        this.writeStream(app);
    }

    public void writeStream(Vector appItems) {
        try {
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(strmBytes);
            for (int i = 0; i < appItems.size(); ++i) {
                AppInfo app = (AppInfo)appItems.elementAt(i);
                dos.writeUTF("" + app.name);
                dos.writeUTF("" + app.link);
                dos.writeUTF("" + app.des);
                dos.writeUTF("" + app.imgPath);
                dos.writeUTF("" + app.ver);
                dos.writeInt(app.ID);
                dos.writeInt(app.Status);
                app = null;
            }
            dos.flush();
            byte[] record = strmBytes.toByteArray();
            this.rs.addRecord(record, 0, record.length);
            strmBytes.reset();
            strmBytes.close();
            dos.close();
        }
        catch (Exception e) {
            System.out.println("Exception...in write Stream");
            e.printStackTrace();
        }
    }

    public String getChannelVer() {
        if (this.channelVer != null) {
            return this.channelVer;
        }
        return null;
    }

    public String getChannelLink() {
        if (this.channelVer != null) {
            return this.channelLink;
        }
        return null;
    }
}

