/*
 * Decompiled with CFR 0.152.
 */
package ZakatyPackage;

import ZakatyPackage.Possess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RSHandler {
    private RecordStore rs = null;
    public static boolean IsFirstTime = false;
    static final String REC_STORE = "Zakaty_db";
    static final String Settings_RS = "Settings_db";
    private int Haul = 0;
    private double Nisab = 0.0;
    private String currency = null;
    private Vector[] Zakaty = new Vector[11];
    static final int ARABIC = 0;
    static final int ENGLISH = 1;
    private int Language = 0;

    public RSHandler() {
        try {
            for (int i = 0; i < this.Zakaty.length; ++i) {
                this.Zakaty[i] = new Vector();
            }
            this.openSettingRS();
            if (IsFirstTime) {
                this.saveDefaultSettings();
            } else {
                this.getCurrentSettings();
            }
            this.openRecStore();
            if (this.rs.getNumRecords() != 0) {
                this.retrieveAppData();
            }
            this.closeRecStore();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void openSettingRS() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)Settings_RS, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            try {
                this.rs = RecordStore.openRecordStore((String)Settings_RS, (boolean)true);
                IsFirstTime = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveDefaultSettings() {
        try {
            this.currency = "Egyption Pound";
            this.Haul = 365;
            this.Nisab = 144.5;
            this.saveSettings();
            IsFirstTime = false;
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    private void getCurrentSettings() throws RecordStoreException {
        if (this.rs.getNumRecords() != 0) {
            this.currency = this.readRecords(1);
            this.Haul = Integer.parseInt(this.readRecords(2));
            this.Nisab = Double.parseDouble(this.readRecords(3));
            this.Language = this.readRecords(this.rs.getNextRecordID() - 1).equals("AR") ? 0 : 1;
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public void saveSettings() throws RecordStoreException {
        if (!IsFirstTime) {
            try {
                this.rs = RecordStore.openRecordStore((String)Settings_RS, (boolean)false);
            }
            catch (RecordStoreNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (this.rs.getNumRecords() != 0) {
            byte[] rec = this.currency.getBytes();
            this.rs.setRecord(1, rec, 0, rec.length);
            String str = "" + this.Haul;
            rec = str.getBytes();
            this.rs.setRecord(2, rec, 0, rec.length);
            str = "" + this.Nisab;
            rec = str.getBytes();
            this.rs.setRecord(3, rec, 0, rec.length);
            str = this.Language == 0 ? "AR" : "EN";
            rec = str.getBytes();
            this.rs.setRecord(4, rec, 0, rec.length);
        } else {
            this.writeRecord(this.currency.trim());
            this.writeRecord(("" + this.Haul).trim());
            this.writeRecord(("" + this.Nisab).trim());
            String str = this.Language == 0 ? "AR" : "EN";
            this.writeRecord(str.trim());
        }
        this.rs.closeRecordStore();
        this.rs = null;
    }

    public int getLanguage() {
        return this.Language;
    }

    public String getCurrency() {
        return this.currency;
    }

    public int getHaul() {
        return this.Haul;
    }

    public double getNisab() {
        return this.Nisab;
    }

    public void setLanguage(int lang) {
        this.Language = lang;
    }

    public void setCurrency(String curr) {
        this.currency = curr;
    }

    public void setHaul(int haul) {
        this.Haul = haul;
    }

    public void setNisab(double N) {
        this.Nisab = N;
    }

    public void openRecStore() throws RecordStoreException {
        try {
            this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)false);
        }
        catch (RecordStoreNotFoundException e) {
            try {
                this.rs = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeRecord(String str) {
        byte[] rec = str.getBytes();
        try {
            this.rs.addRecord(rec, 0, rec.length);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public String readRecords(int index) {
        try {
            byte[] recData = new byte[this.rs.getRecordSize(index)];
            int len = this.rs.getRecord(index, recData, 0);
            return new String(recData, 0, len);
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
            return null;
        }
    }

    public void closeRecStore() {
        try {
            this.rs.closeRecordStore();
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
    }

    public void deleteRecStore() {
        if (RecordStore.listRecordStores() != null) {
            try {
                RecordStore.deleteRecordStore((String)REC_STORE);
            }
            catch (Exception e) {
                e.toString();
                e.printStackTrace();
            }
        }
    }

    private void retrieveAppData() {
        try {
            if (this.rs.getNumRecords() > 0) {
                this.readStream();
            }
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
    }

    public void readStream() {
        try {
            byte[] recData = this.rs.getRecord(1);
            ByteArrayInputStream strmBytes = new ByteArrayInputStream(recData);
            DataInputStream dis = new DataInputStream(strmBytes);
            for (int i = 0; i < 11; ++i) {
                Vector<Possess> possesses = new Vector<Possess>();
                int size = dis.readInt();
                for (int j = 1; j <= size; ++j) {
                    Possess poss = new Possess(i, dis.readDouble(), dis.readUTF());
                    poss.setUnitPrice(dis.readFloat());
                    poss.setAmount(dis.readFloat());
                    poss.setDebtStatus(dis.readInt());
                    poss.setCattleType(dis.readInt());
                    poss.setCattleRes(dis.readUTF());
                    poss.setCropsNisab(dis.readFloat());
                    poss.setCropsCost(dis.readFloat());
                    poss.setCropsUnit(dis.readInt());
                    poss.setCropsIrrType(dis.readInt());
                    possesses.addElement(poss);
                    poss = null;
                }
                this.Zakaty[i] = possesses;
                possesses = null;
            }
            strmBytes.close();
            dis.close();
        }
        catch (Exception e) {
            System.out.println("Exception...in read Stream");
            e.printStackTrace();
        }
    }

    public Vector[] getPossesses() {
        return this.Zakaty;
    }

    public void savePossesses(Vector[] toSave) {
        try {
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(strmBytes);
            for (int i = 0; i < toSave.length; ++i) {
                Vector type = toSave[i];
                dos.writeInt(type.size());
                for (int j = 0; j < type.size(); ++j) {
                    Possess poss = (Possess)type.elementAt(j);
                    dos.writeDouble(poss.getValue());
                    if (poss.getDes() == null) {
                        dos.writeUTF("null");
                    } else {
                        dos.writeUTF(poss.getDes());
                    }
                    dos.writeFloat(poss.getUnitPrice());
                    dos.writeFloat(poss.getAmount());
                    dos.writeInt(poss.getDebtStatus());
                    dos.writeInt(poss.getCattleType());
                    if (poss.getCattleRes() == null) {
                        dos.writeUTF("null");
                    } else {
                        dos.writeUTF(poss.getCattleRes());
                    }
                    dos.writeFloat(poss.getCropsNisab());
                    dos.writeFloat(poss.getCropsCost());
                    dos.writeInt(poss.getCropsUnit());
                    dos.writeInt(poss.getCropsIrrType());
                    poss = null;
                }
                type = null;
            }
            dos.flush();
            byte[] record = strmBytes.toByteArray();
            this.rs.addRecord(record, 0, record.length);
            strmBytes.reset();
            strmBytes.close();
            dos.close();
        }
        catch (Exception e) {
            System.out.println("Exception...in write Stream");
            e.printStackTrace();
        }
    }
}

