/*
 * Decompiled with CFR 0.152.
 */
package viewer;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ItemCommandListener;
import net.kbox.ActionController;
import net.kbox.component.KCustomItem;
import net.kbox.exception.NotActionControllerException;

public class BranchItemDetail
extends KCustomItem {
    private Image logo;
    private String text;
    private String longText;
    private Font font;
    private int fontColor;
    private int bgColor;
    private int selectedBGColor;
    private int showedBGColor;
    private int selectedBorderColor;
    private int colSpace;
    private int rowSpace;
    private BranchItemDetail next;
    private BranchItemDetail pre;
    private ActionController ac;
    private boolean isShort = true;

    public BranchItemDetail getNext() {
        return this.next;
    }

    public void setNext(BranchItemDetail next) {
        this.next = next;
    }

    public BranchItemDetail getPre() {
        return this.pre;
    }

    public void setPre(BranchItemDetail pre) {
        this.pre = pre;
    }

    public BranchItemDetail(String label, String uniqueID, Image logo, String text, String longText, Font font, int fontColor, int bgColor, int selectedBGColor, int colSpace, int rowSpace, boolean isShort) {
        super(label, uniqueID);
        this.logo = logo;
        this.text = text == null ? null : text.trim();
        this.font = font;
        this.fontColor = fontColor;
        this.bgColor = bgColor;
        this.colSpace = colSpace;
        this.rowSpace = rowSpace;
        this.longText = longText == null ? null : longText.trim();
        this.selectedBGColor = selectedBGColor;
        this.showedBGColor = bgColor;
        this.selectedBorderColor = bgColor;
        this.isShort = isShort;
    }

    protected int getMinContentHeight() {
        int h;
        int logoH = this.logo.getHeight() + 10;
        if (this.isShort) {
            h = this.font.getHeight() + 3 + this.rowSpace * 5;
            h = h > logoH ? h : logoH;
        } else {
            int textWidth = 240 - this.logo.getWidth() - this.colSpace * 2;
            if (this.text == null) {
                if (this.longText == null) {
                    return logoH;
                }
                int longTextLength = this.font.stringWidth(this.longText) + this.colSpace + 10;
                int textRows = longTextLength / textWidth + 1;
                int rh = textRows * this.font.getHeight() + 6;
                h = rh > logoH ? rh : logoH;
            } else {
                int textLength = this.font.stringWidth(this.text) + this.colSpace + 10;
                int textRows = textLength / textWidth + 1;
                if (this.longText == null) {
                    int rh = textRows * this.font.getHeight() + 6;
                    h = rh > logoH ? rh : logoH;
                } else {
                    int longTextLength = this.font.stringWidth(this.longText) + this.colSpace + 10;
                    int longTextRows = 3;
                    int rh = (textRows + longTextRows) * this.font.getHeight() + 6;
                    h = rh > logoH ? rh : logoH;
                }
            }
        }
        return h + 2 * this.rowSpace;
    }

    protected int getMinContentWidth() {
        return 240;
    }

    protected int getPrefContentHeight(int arg0) {
        return this.getMinContentHeight();
    }

    protected int getPrefContentWidth(int arg0) {
        return this.getMinContentWidth();
    }

    protected void paint(Graphics g, int w, int h) {
        int cw;
        char c;
        int i;
        h = 59;
        g.setColor(this.showedBGColor);
        g.fillRect(0, 0, w, h + 2);
        g.drawImage(this.logo, 4, 5, 20);
        g.setFont(this.font);
        g.setColor(this.fontColor);
        int fixedX = this.logo.getWidth() + this.colSpace * 2;
        int fixedY = 3;
        if (this.text != null) {
            if (this.isShort) {
                i = 0;
                while (i < this.text.length()) {
                    c = this.text.charAt(i);
                    cw = this.font.charWidth(c);
                    if (fixedX + cw + this.colSpace * 3 >= w) {
                        g.drawString("\u2026", fixedX, fixedY, 20);
                        break;
                    }
                    g.drawChar(c, fixedX, fixedY, 20);
                    fixedX += cw;
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.text.length()) {
                    c = this.text.charAt(i);
                    cw = this.font.charWidth(c);
                    if (fixedX + cw + this.colSpace >= w) {
                        fixedX = this.logo.getWidth() + this.colSpace * 2;
                        g.drawChar(c, fixedX, fixedY += this.font.getHeight(), 20);
                        fixedX += cw;
                    } else {
                        g.drawChar(c, fixedX, fixedY, 20);
                        fixedX += cw;
                    }
                    ++i;
                }
            }
        }
        fixedY += this.font.getHeight();
        fixedX = this.logo.getWidth() + this.colSpace * 2;
        if (this.longText != null) {
            if (this.isShort) {
                i = 0;
                while (i < this.longText.length()) {
                    c = this.longText.charAt(i);
                    cw = this.font.charWidth(c);
                    if (fixedY < 2 * this.font.getHeight()) {
                        g.drawChar(c, fixedX, fixedY, 20);
                        if ((fixedX += cw) + cw + this.colSpace * 1 >= w) {
                            fixedY += this.font.getHeight();
                            fixedX = this.logo.getWidth() - this.logo.getWidth() + this.colSpace * 2;
                        }
                    } else {
                        if (fixedX + cw + this.colSpace * 5 >= w) {
                            g.drawString("\u2026", fixedX, fixedY, 20);
                            break;
                        }
                        g.drawChar(c, fixedX, fixedY, 20);
                        fixedX += cw;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.longText.length()) {
                    c = this.longText.charAt(i);
                    cw = this.font.charWidth(c);
                    if (fixedX + cw + this.colSpace >= w) {
                        fixedX = this.logo.getWidth() + this.colSpace * 2;
                        g.drawChar(c, fixedX, fixedY += this.font.getHeight(), 20);
                        fixedX += cw;
                    } else {
                        g.drawChar(c, fixedX, fixedY, 20);
                        fixedX += cw;
                    }
                    ++i;
                }
            }
        }
        int bannerW = 3;
        g.setColor(this.selectedBorderColor);
        g.fillRect(0, 0, bannerW, h);
        g.fillRect(0, 0, w, bannerW);
        g.fillRect(0, h - bannerW + 3, w, bannerW);
        g.fillRect(w - bannerW, 0, bannerW, h);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    protected void keyPressed(int keyCode) {
        String keyName;
        super.keyPressed(keyCode);
        if (this.ac != null && (keyName = this.mapKeyCode(keyCode)) != null && keyName.trim().length() != 0) {
            this.ac.keyPressedAction("PRESSED", keyName, this);
        }
    }

    protected boolean traverse(int dir, int viewportWidth, int viewportHeight, int[] visRect_inout) {
        this.selectedBorderColor = this.selectedBGColor;
        this.repaint();
        return false;
    }

    protected void traverseOut() {
        this.selectedBorderColor = this.bgColor;
        this.repaint();
    }

    public void setItemCommandListener(ItemCommandListener listener) {
        if (!(listener instanceof ActionController)) {
            throw new NotActionControllerException(listener.toString());
        }
        super.setItemCommandListener(listener);
        this.ac = (ActionController)listener;
    }

    protected String mapKeyCode(int keyCode) {
        String mapName;
        block0 : switch (keyCode) {
            case 48: {
                mapName = "0";
                break;
            }
            case 49: {
                mapName = "1";
                break;
            }
            case 51: {
                mapName = "3";
                break;
            }
            case 53: {
                mapName = "5";
                break;
            }
            case 55: {
                mapName = "7";
                break;
            }
            case 57: {
                mapName = "9";
                break;
            }
            case 35: {
                mapName = "#";
                break;
            }
            case 42: {
                mapName = "*";
                break;
            }
            default: {
                int gameAction = this.getGameAction(keyCode);
                switch (gameAction) {
                    case 1: {
                        mapName = "UP";
                        break block0;
                    }
                    case 6: {
                        mapName = "DOWN";
                        break block0;
                    }
                    case 2: {
                        mapName = "LEFT";
                        break block0;
                    }
                    case 5: {
                        mapName = "RIGHT";
                        break block0;
                    }
                    case 8: {
                        mapName = "FIRE";
                        break block0;
                    }
                }
                mapName = "";
            }
        }
        return mapName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLongText() {
        return this.longText;
    }

    public void setLongText(String longText) {
        this.longText = longText;
    }
}

