/*
 * Decompiled with CFR 0.152.
 */
package com.beeweeb.globallauncher.model;

import com.beeweeb.globallauncher.model.Access;
import com.beeweeb.globallauncher.model.AppMidlet;
import com.beeweeb.globallauncher.model.Configuration;
import com.beeweeb.globallauncher.model.InstantLauncherData;
import com.beeweeb.globallauncher.model.Item;
import com.beeweeb.globallauncher.model.Midlet;
import com.beeweeb.globallauncher.model.Network;
import com.beeweeb.globallauncher.model.Shortcut;
import com.beeweeb.globallauncher.model.Strip;
import com.beeweeb.globallauncher.model.Symbian;
import com.beeweeb.globallauncher.model.Teaser;
import com.beeweeb.globallauncher.model.Upgrade;
import com.beeweeb.globallauncher.model.XMLConstants;
import com.beeweeb.globallauncher.util.Log;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LauncherDataDocumentHandler
extends DefaultHandler
implements XMLConstants {
    private InstantLauncherData data;
    private Stack nameStack;
    private Stack elementStack;
    private Item currentItem;
    private Stack itemStack;

    public void startDocument() throws SAXException {
        this.nameStack = new Stack();
        this.elementStack = new Stack();
        this.itemStack = new Stack();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        this.nameStack.push(string2);
        if (string2.equals("instantlauncher")) {
            this.data = new InstantLauncherData();
            this.elementStack.push(this.data);
        } else if (string2.equalsIgnoreCase("configuration")) {
            Configuration configuration = new Configuration();
            this.data.setConfiguration(configuration);
            configuration.setHeartbeatURL(attributes.getValue("heartbeaturl"));
            configuration.setHeartbeatURL(LauncherDataDocumentHandler.unescape(configuration.getHeartbeatURL()));
            configuration.setTrustedContentHost(attributes.getValue("trusted_content_host"));
            configuration.setHandsetType(attributes.getValue("handset_type"));
            String string5 = attributes.getValue("disableurl");
            if (string5 != null) {
                configuration.setDisableURL(string5);
            }
            if ((string5 = attributes.getValue("home_network_mcc")) != null) {
                configuration.setHomeNetworkMCC(Integer.parseInt(string5));
            }
            if ((string5 = attributes.getValue("home_network_mnc")) != null) {
                configuration.setHomeNetworkMNC(Integer.parseInt(string5));
            }
            if ((string5 = attributes.getValue("heartbeatinterval")) != null) {
                configuration.setHeartbeatInterval(Integer.parseInt(string5));
            }
            if ((string5 = attributes.getValue("LOCAL_previousHBinterval")) != null) {
                configuration.setLOCAL_previousHBinterval(Integer.parseInt(string5));
            }
            if ((string5 = attributes.getValue("disable")) != null) {
                configuration.setDisable(new Boolean(string5.equalsIgnoreCase("true")));
            }
            if ((string5 = attributes.getValue("numretries")) != null) {
                configuration.setNumRetries(Integer.parseInt(string5));
            }
            if ((string5 = attributes.getValue("retryinterval")) != null) {
                configuration.setRetryInterval(Integer.parseInt(string5));
            }
            if ((string5 = attributes.getValue("roaming_gprs_teasers")) != null) {
                configuration.setRoamingGPRSTeasers(new Boolean(string5.equalsIgnoreCase("true")));
            }
            if ((string5 = attributes.getValue("roaming_gprs_heartbeat")) != null) {
                configuration.setRoamingGPRSHeartbeat(new Boolean(string5.equalsIgnoreCase("true")));
            }
            if ((string5 = attributes.getValue("roaming_3g_teasers")) != null) {
                configuration.setRoaming3GTeasers(new Boolean(string5.equalsIgnoreCase("true")));
            }
            if ((string5 = attributes.getValue("roaming_3g_heartbeat")) != null) {
                configuration.setRoaming3GHeartbeat(new Boolean(string5.equalsIgnoreCase("true")));
            }
        } else if (string2.equals("upgrade")) {
            Upgrade upgrade = new Upgrade();
            upgrade.setClientVersion(attributes.getValue("client_version"));
            upgrade.setClientURL(attributes.getValue("client_url"));
            this.data.setUpgrade(upgrade);
        } else if (string2.equals("roamingnetworkwhitelist")) {
            Network network = new Network();
            String string6 = attributes.getValue("mcc");
            if (string6 != null) {
                network.setMcc(Integer.parseInt(string6));
            }
            if ((string6 = attributes.getValue("mnc")) != null) {
                network.setMnc(Integer.parseInt(string6));
            }
            this.data.getConfiguration().addNetwork(network);
        } else if (string2.equals("teaser")) {
            Teaser teaser = new Teaser();
            teaser.setID(attributes.getValue("id"));
            teaser.setChannelid(attributes.getValue("buy_url"));
            String string7 = attributes.getValue("posn");
            if (string7 != null) {
                teaser.setPosn(Integer.parseInt(string7));
            }
            if ((string7 = attributes.getValue("LOCAL_click_count")) != null) {
                teaser.setLOCAL_click_count(Integer.parseInt(string7));
            }
            if ((string7 = attributes.getValue("tts")) != null) {
                teaser.setTTS(Integer.parseInt(string7));
            }
            if ((string7 = attributes.getValue("ttl")) != null) {
                teaser.setTTL(Integer.parseInt(string7));
            }
            if ((string7 = attributes.getValue("default")) != null) {
                teaser.setDef(new Boolean(string7.equals("true")));
            }
            if ((string7 = attributes.getValue("LOCAL_teaser_appeared")) != null) {
                teaser.setLOCAL_teaser_appeared(Long.parseLong(string7));
            }
            this.data.setTeaser(teaser);
        } else if (string2.equals("strip")) {
            Strip strip = new Strip();
            this.data.getTeaser().setStrip(strip);
            this.itemStack.push(strip);
            strip.setHref(attributes.getValue("href"));
            String string8 = attributes.getValue("type");
            if (string8 != null) {
                if (string8.equals("teaser_image")) {
                    strip.setType(0);
                } else if (string8.equals("teaser_image_text")) {
                    strip.setType(1);
                } else {
                    strip.setType(2);
                }
            }
            if ((string8 = attributes.getValue("href_type")) != null) {
                if (string8.equals("web")) {
                    strip.setHrefType(0);
                } else if (string8.equals("application")) {
                    strip.setHrefType(1);
                } else {
                    strip.setHrefType(2);
                }
            }
        } else if (string2.equals("shortcuts")) {
            this.data.setShortcutsListVersion(attributes.getValue("list_version"));
        } else if (string2.equals("shortcut")) {
            Shortcut shortcut = new Shortcut();
            if (this.stackPeek2().equals("strip")) {
                this.data.getTeaser().getStrip().setShortcut(shortcut);
                shortcut.setFromTeaser(true);
            } else if (this.stackPeek2().equals("shortcuts")) {
                this.data.addShortcut(shortcut);
            } else if (this.stackPeek2().equals("LOCAL_notdeletables")) {
                this.data.addNotDeletable(shortcut);
            }
            this.itemStack.push(shortcut);
            String string9 = attributes.getValue("type");
            if (string9 != null) {
                if (string9.equals("link_image")) {
                    shortcut.setType(0);
                } else if (string9.equals("link_image_text")) {
                    shortcut.setType(1);
                } else {
                    shortcut.setType(2);
                }
            }
            if ((string9 = attributes.getValue("position")) != null) {
                if (string9.equals("up")) {
                    shortcut.setPosition(0);
                } else {
                    shortcut.setPosition(1);
                }
            }
            if ((string9 = attributes.getValue("LOCAL_click_count")) != null) {
                shortcut.setLOCAL_click_count(Integer.parseInt(string9));
            }
            if ((string9 = attributes.getValue("deletable")) != null) {
                shortcut.setDeletable(string9.equals("true"));
            }
            if ((string9 = attributes.getValue("alwaysdisplay")) != null) {
                shortcut.setAlwaysDisplay(string9.equals("true"));
            }
            if ((string9 = attributes.getValue("bgcolor")) != null) {
                if (string9.startsWith("0x")) {
                    string9 = string9.substring(2);
                }
                shortcut.setBgColor(Integer.parseInt(string9, 16));
            }
            if ((string9 = attributes.getValue("LOCAL_fromteaser")) != null) {
                shortcut.setFromTeaser(string9.equals("true"));
            }
            if ((string9 = attributes.getValue("LOCAL_flexed")) != null) {
                shortcut.setLOCAL_flexed(string9.equals("true"));
            }
        } else if (string2.equals("img")) {
            ((Item)this.itemStack.peek()).setImgSrc(attributes.getValue("src"));
            String string10 = attributes.getValue("srcdwl");
            if (string10 != null) {
                ((Item)this.itemStack.peek()).setImgSrcDwl(string10);
            }
            if ((string10 = attributes.getValue("align")) != null) {
                int n = string10.equals("right") ? 1 : 0;
                ((Item)this.itemStack.peek()).setAlign(n);
            }
        } else if (string2.equals("web")) {
            ((Shortcut)this.itemStack.peek()).setWebURL(attributes.getValue("href"));
        } else if (string2.equals("midlet")) {
            Midlet midlet = new Midlet();
            ((Shortcut)this.itemStack.peek()).setApplication(midlet);
            midlet.setName(attributes.getValue("MIDlet-Name"));
            midlet.setVendor(attributes.getValue("MIDlet-Vendor"));
            midlet.setRealName(attributes.getValue("MIDlet-X"));
            String string11 = attributes.getValue("substituteURL");
            if (string11 != null) {
                midlet.setSubstituteURL(string11);
            }
            if ((string11 = attributes.getValue("LOCAL_previously_installed")) != null) {
                midlet.setPreviouslyInstalled(string11.equals("true"));
            }
            if ((string11 = attributes.getValue("LOCAL_updateurl")) != null) {
                midlet.setLOCAL_updateURL(string11);
            }
        } else if (string2.equals("symbian")) {
            Symbian symbian = new Symbian();
            symbian.setUID(attributes.getValue("UID"));
            ((Shortcut)this.itemStack.peek()).setApplication(symbian);
        } else if (string2.equals("appmidlet")) {
            AppMidlet appMidlet = new AppMidlet();
            this.data.addAppMidlet(appMidlet);
            appMidlet.setName(attributes.getValue("MIDlet-Name"));
            appMidlet.setVendor(attributes.getValue("MIDlet-Vendor"));
            appMidlet.setRealName(attributes.getValue("MIDlet-X"));
            String string12 = attributes.getValue("updateURL");
            if (string12 != null) {
                appMidlet.setUpdateURL(string12);
            }
        } else if (string2.equals("access")) {
            Access access = new Access();
            ((Shortcut)this.itemStack.peek()).setAccess(access);
            String string13 = attributes.getValue("check_access_roaming");
            if (string13 != null && string13 != null) {
                access.setCheckAccessRoaming(new Boolean(string13.equals("true")));
            }
        } else if (string2.equals("title")) {
            ((Item)this.itemStack.peek()).setTitle(attributes.getValue("text"));
            String string14 = attributes.getValue("color");
            if (string14 != null) {
                ((Item)this.itemStack.peek()).setTitleColor(Integer.parseInt(string14));
            }
        } else if (string2.equals("body")) {
            ((Item)this.itemStack.peek()).setBody(attributes.getValue("text"));
            String string15 = attributes.getValue("color");
            if (string15 != null) {
                ((Item)this.itemStack.peek()).setBodyColor(Integer.parseInt(string15));
            }
        } else if (string2.equals("roamingnotification") && (string4 = attributes.getValue("disable")) != null) {
            ((Item)this.itemStack.peek()).setRoamingNotificationDisable(string4.equals("true"));
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.nameStack.peek().equals("roamingtext")) {
                ((Item)this.itemStack.peek()).setRoamingText(new String(cArray, n, n2));
            } else if (this.nameStack.peek().equals("option1")) {
                ((Shortcut)this.itemStack.peek()).getAccess().setOption1(new String(cArray, n, n2));
            } else if (this.nameStack.peek().equals("option2")) {
                ((Shortcut)this.itemStack.peek()).getAccess().setOption2(new String(cArray, n, n2));
            } else if (this.nameStack.peek().equals("option3")) {
                ((Shortcut)this.itemStack.peek()).getAccess().setOption3(new String(cArray, n, n2));
            }
        }
        catch (Throwable throwable) {
            Log.log("Error in XML parser at characters() in element " + this.nameStack.peek().toString());
            Log.log(throwable);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.nameStack.pop();
        if (string2.equals("shortcut") || string2.equals("strip")) {
            this.itemStack.pop();
        }
    }

    public void endDocument() throws SAXException {
    }

    public InstantLauncherData getData() {
        return this.data;
    }

    private synchronized String stackPeek2() {
        String string = this.nameStack.pop().toString();
        String string2 = this.nameStack.peek().toString();
        this.nameStack.push(string);
        return string2;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    private static String replace(String string, String string2, String string3) {
        int n;
        if (string == null) {
            return null;
        }
        String string4 = "";
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            int n3;
            if (string.charAt(n) != string2.charAt(0)) continue;
            boolean bl = true;
            for (n3 = 1; n3 < string2.length(); ++n3) {
                if (string.charAt(n + n3) == string2.charAt(n3)) continue;
                n += n3;
                bl = false;
                break;
            }
            if (!bl) continue;
            string4 = string4 + string.substring(n2, n) + string3;
            n2 = (n += n3 - 1) + 1;
        }
        if (n > n2) {
            string4 = string4 + string.substring(n2, n);
        }
        return string4;
    }

    public static String escape(String string) {
        string = LauncherDataDocumentHandler.replace(string, "&", "&amp;");
        string = LauncherDataDocumentHandler.replace(string, "'", "&apos;");
        string = LauncherDataDocumentHandler.replace(string, "\"", "&quot;");
        string = LauncherDataDocumentHandler.replace(string, "<", "&lt;");
        string = LauncherDataDocumentHandler.replace(string, ">", "&lt;");
        return string;
    }

    public static String unescape(String string) {
        string = LauncherDataDocumentHandler.replace(string, "&amp;", "&");
        string = LauncherDataDocumentHandler.replace(string, "&apos;", "'");
        string = LauncherDataDocumentHandler.replace(string, "&quot;", "\"");
        string = LauncherDataDocumentHandler.replace(string, "&lt;", "<");
        string = LauncherDataDocumentHandler.replace(string, "&lt;", ">");
        return string;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }
}

