/*
 * Decompiled with CFR 0.152.
 */
package com.loboltd.javamap.map;

import com.loboltd.javamap.bean.Building;
import com.loboltd.javamap.location.Point;
import com.loboltd.javamap.map.FlashPoint;
import com.loboltd.javamap.map.Map;
import com.loboltd.javamap.map.NullAreaException;
import com.loboltd.javamap.util.CoordinateTool;
import com.loboltd.javamap.util.DataLoader;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Ticker;
import net.kbox.common.MsgResource;

public abstract class MapCanvas
extends Map {
    public final Graphics graphics = this.getGraphics();
    protected final int halfWidth;
    protected final int halfHeight = this.getHeight() / 2;
    protected String area;
    protected MapCanvas nextMapCanvas;
    protected double rateX = 1.0;
    protected double rateY = 1.0;
    protected int currentX;
    protected int currentY;
    protected int LV;
    protected double fixLn;
    protected double fixLat;
    private static Building currentBuilding;
    private Vector persons;
    private Vector showOnMap;
    protected static Image photo;
    private FlashPoint flashPoint;
    private Vector selectedBuildingIndex;
    private Thread rollRestaurantName;
    private boolean isRollStop = false;

    public void setPhoto(String path) {
        photo = ((DataLoader)DataLoader.getInstance()).loadImage(path);
    }

    protected abstract void drawMap(int var1, int var2) throws NullAreaException;

    public abstract int getMaxMapWidth() throws NullAreaException;

    public abstract int getMaxMapHeight() throws NullAreaException;

    public abstract MapCanvas getNextMapCanvas() throws NullAreaException;

    public MapCanvas(String uniqueID) {
        super(uniqueID);
        this.halfWidth = this.getWidth() / 2;
        this.persons = new Vector();
    }

    public void showMapBy84(double ln, double lat) throws NullAreaException {
        double ln1 = this.fixLn;
        double lat1 = this.fixLat;
        double ln2 = ln;
        double lat2 = lat;
        int x = (int)CoordinateTool.getDX(ln1, lat1, ln2, lat2);
        int y = (int)CoordinateTool.getDY(ln1, lat1, ln2, lat2);
        this.showMap(x, y);
    }

    public void showMapByPoint(Point p) throws NullAreaException {
        this.showMapBy84(p.getLn(), p.getLat());
    }

    public void showMap(int x, int y) throws NullAreaException {
        this.currentX = x;
        this.currentY = y;
        x = (int)((double)this.currentX * this.getRateX());
        y = (int)((double)this.currentY * this.getRateY());
        if (x < this.halfWidth) {
            x = this.halfWidth;
            this.currentX = (int)((double)x / this.rateX);
        } else if (x > this.getMaxMapWidth() - this.halfWidth) {
            x = this.getMaxMapWidth() - this.halfWidth;
            this.currentX = (int)((double)x / this.rateX);
        }
        if (y < this.halfHeight) {
            y = this.halfHeight;
            this.currentY = (int)((double)this.halfHeight / this.rateY);
        } else if (y > this.getMaxMapHeight() - this.halfHeight) {
            y = this.getMaxMapHeight() - this.halfHeight;
            this.currentY = (int)((double)y / this.rateY);
        }
        this.drawMap(x, y);
    }

    public void showPointBy84(String name, double ln, double lat) {
        double ln1 = this.fixLn;
        double lat1 = this.fixLat;
        double ln2 = ln;
        double lat2 = lat;
        int x = (int)CoordinateTool.getDX(ln1, lat1, ln2, lat2);
        int y = (int)CoordinateTool.getDY(ln1, lat1, ln2, lat2);
        this.showPoint(name, x, y);
    }

    public void showPoint(String buildingName, int x, int y) {
        x = (int)((double)x * this.getRateX());
        y = (int)((double)y * this.getRateY());
        if (this.flashPoint != null && this.flashPoint.isAlive()) {
            this.flashPoint.stop();
            this.flashPoint = null;
        }
        this.flashPoint = new FlashPoint();
        this.flashPoint.setMc(this);
        this.flashPoint.setCoordinate(x, y);
        this.flashPoint.start();
    }

    public void showPersionBy84() {
        double ln1 = this.fixLn;
        double lat1 = this.fixLat;
        if (this.persons == null) {
            return;
        }
        Enumeration emu = this.persons.elements();
        while (emu.hasMoreElements()) {
            Building building = (Building)emu.nextElement();
            double ln2 = building.getLn();
            double lat2 = building.getLat();
            int x = (int)CoordinateTool.getDX(ln1, lat1, ln2, lat2);
            int y = (int)CoordinateTool.getDY(ln1, lat1, ln2, lat2);
            this.showPersion(x, y);
        }
    }

    public void showPersion(int x, int y) {
        x = (int)((double)x * this.getRateX());
        y = (int)((double)y * this.getRateY());
        this.graphics.setColor(-256);
        this.graphics.fillArc(x - 8, y - 8, 16, 16, 0, 360);
        this.graphics.setColor(-16776961);
        this.graphics.drawArc(x - 7, y - 7, 14, 14, 0, 360);
        this.graphics.drawArc(x - 8, y - 8, 16, 16, 0, 360);
        this.flushGraphics();
    }

    public synchronized void showBuildings() {
        int table_col_space = 3;
        int table_row_space = 2;
        if (this.showOnMap == null) {
            if (this.rollRestaurantName != null && this.rollRestaurantName.isAlive()) {
                this.isRollStop = true;
            }
            return;
        }
        double ln1 = this.fixLn;
        double lat1 = this.fixLat;
        int i = 0;
        while (i < this.showOnMap.size()) {
            double ln2 = ((Building)this.showOnMap.elementAt(i)).getLn();
            double lat2 = ((Building)this.showOnMap.elementAt(i)).getLat();
            int x = (int)(CoordinateTool.getDX(ln1, lat1, ln2, lat2) * this.getRateX());
            int y = (int)(CoordinateTool.getDY(ln1, lat1, ln2, lat2) * this.getRateY());
            this.graphics.setColor(-16711936);
            this.graphics.fillArc(x - 6, y - 6, 12, 12, 0, 360);
            this.graphics.setColor(-16776961);
            this.graphics.drawArc(x - 5, y - 5, 10, 10, 0, 360);
            this.graphics.drawArc(x - 6, y - 6, 12, 12, 0, 360);
            ++i;
        }
        if (this.selectedBuildingIndex != null && this.selectedBuildingIndex.size() > 0) {
            Vector<Building> selectedBuildings = new Vector<Building>();
            Vector buildings = this.showOnMap;
            int i2 = 0;
            while (i2 < this.selectedBuildingIndex.size()) {
                Building building = (Building)buildings.elementAt((Integer)this.selectedBuildingIndex.elementAt(i2));
                selectedBuildings.addElement(building);
                ++i2;
            }
            Building selectedBuilding = (Building)this.showOnMap.elementAt((Integer)this.selectedBuildingIndex.elementAt(0));
            double ln2 = selectedBuilding.getLn();
            double lat2 = selectedBuilding.getLat();
            int x = (int)(CoordinateTool.getDX(ln1, lat1, ln2, lat2) * this.getRateX());
            int y = (int)(CoordinateTool.getDY(ln1, lat1, ln2, lat2) * this.getRateY());
            this.graphics.setColor(-65536);
            this.graphics.fillArc(x - 7, y - 7, 14, 14, 0, 360);
            this.graphics.setColor(-16776961);
            this.graphics.drawArc(x - 7, y - 7, 14, 14, 0, 360);
            if (selectedBuildings.size() == 1) {
                int row = 1;
                int row_fixedY = 2;
                int c = 0;
                String buildingName = selectedBuilding.getName();
                Font font = Font.getFont((int)0, (int)0, (int)8);
                int nameLength = font.stringWidth(buildingName) + 6;
                if (buildingName.length() > 14) {
                    char cName;
                    int n;
                    int i3 = n = buildingName.length() - 1;
                    while (i3 > -1) {
                        cName = buildingName.charAt(i3);
                        c = i3;
                        if (String.valueOf(cName).equals(" ")) {
                            i3 = -1;
                        }
                        --i3;
                    }
                    if (c == 0) {
                        c = buildingName.length() / 2;
                    } else {
                        if (buildingName.length() > 26) {
                            n = 26;
                        }
                        i3 = n;
                        while (i3 > -1) {
                            cName = buildingName.charAt(i3);
                            c = i3;
                            if (String.valueOf(cName).equals(" ")) {
                                i3 = -1;
                            }
                            --i3;
                        }
                    }
                    row = 5;
                    row_fixedY = 7;
                    int nameLength1 = font.stringWidth(buildingName.substring(c + 1, buildingName.length()));
                    int nameLength2 = font.stringWidth(buildingName.substring(0, c));
                    nameLength = nameLength1 > nameLength2 ? nameLength1 + 10 : nameLength2 + 10;
                }
                this.graphics.setFont(font);
                this.graphics.setColor(-6382436);
                int shadowSize = 3;
                this.graphics.fillRoundRect(x - nameLength / 2 - 3 + shadowSize, y - 34 - 2 * row / row_fixedY - 2 * row, nameLength + 6, 21 + 4 * row, 10, 10);
                this.graphics.setColor(-928551);
                this.graphics.fillRoundRect(x - nameLength / 2 - 3, y - 34 - 2 * (row + 2), nameLength + 6, 21 + 4 * row, 10, 10);
                this.graphics.setColor(-16777216);
                this.graphics.drawRoundRect(x - nameLength / 2 - 3, y - 34 - 2 * (row + 2), nameLength + 6, 21 + 4 * row, 10, 10);
                this.graphics.setColor(-16777216);
                if (buildingName.length() > 14) {
                    this.graphics.drawString(buildingName.substring(0, c + 1), x, y - 30 - 2 * (row + 2), 17);
                    if (buildingName.length() > 50) {
                        this.graphics.drawString(String.valueOf(buildingName.substring(c + 1, 50)) + "\u2026", x, y - 30 - 2 * (row + 2) + font.getHeight(), 17);
                    } else {
                        this.graphics.drawString(buildingName.substring(c + 1, buildingName.length()), x, y - 30 - 2 * (row + 2) + font.getHeight(), 17);
                    }
                } else {
                    this.graphics.drawString(buildingName, x, y - 30 - 2 * (row + 2), 17);
                }
                this.setTicker(null);
                this.setTicker(new Ticker(" ^ " + selectedBuilding.getName().trim() + ":" + selectedBuilding.getAddress().trim()));
            } else {
                StringBuffer address = new StringBuffer();
                Building first = (Building)selectedBuildings.firstElement();
                address.append("^" + first.getName().trim() + ":" + first.getAddress().trim());
                int i4 = 1;
                while (i4 < selectedBuildings.size()) {
                    Building building = (Building)selectedBuildings.elementAt(i4);
                    address.append(" ^ " + building.getName().trim() + ":" + building.getAddress().trim());
                    ++i4;
                }
                this.getTicker().setString(address.toString());
                this.setTicker(null);
                this.setTicker(new Ticker(address.toString()));
                final int fixedx = x;
                final int fixedy = y;
                final Vector<Building> fixedselectedBuildings = selectedBuildings;
                if (this.rollRestaurantName != null && this.rollRestaurantName.isAlive()) {
                    this.isRollStop = true;
                }
                this.rollRestaurantName = new Thread(){
                    int tempMaxNameLength = 0;

                    public void run() {
                        MapCanvas.this.isRollStop = false;
                        int row = 1;
                        int row_fixedY = 2;
                        int[] CutNum = new int[20];
                        int maxNameLength = 0;
                        int c = 0;
                        Font font = Font.getFont((int)0, (int)0, (int)8);
                        int i = 0;
                        while (i < fixedselectedBuildings.size()) {
                            Building selectedBuilding = (Building)fixedselectedBuildings.elementAt(i);
                            String name = selectedBuilding.getName();
                            int nameLength = font.stringWidth(name);
                            int n = maxNameLength = maxNameLength > nameLength ? maxNameLength : nameLength;
                            if (this.tempMaxNameLength < maxNameLength) {
                                this.tempMaxNameLength = maxNameLength;
                            }
                            if (name.length() > 14) {
                                char cName;
                                int n2;
                                int i1 = n2 = name.length() - 1;
                                while (i1 > -1) {
                                    cName = name.charAt(i1);
                                    c = i1;
                                    if (String.valueOf(cName).equals(" ")) {
                                        i1 = -1;
                                    }
                                    --i1;
                                }
                                if (c == 0) {
                                    c = name.length() / 2;
                                } else {
                                    if (name.length() > 26) {
                                        n2 = 26;
                                    }
                                    i1 = n2;
                                    while (i1 > -1) {
                                        cName = name.charAt(i1);
                                        c = i1;
                                        if (String.valueOf(cName).equals(" ")) {
                                            i1 = -1;
                                        }
                                        --i1;
                                    }
                                }
                                CutNum[i] = c;
                                row = 5;
                                row_fixedY = 7;
                                maxNameLength = this.tempMaxNameLength / 2 + 100;
                            }
                            maxNameLength = maxNameLength > 200 ? 200 : maxNameLength;
                            ++i;
                        }
                        MapCanvas.this.graphics.setFont(font);
                        i = 0;
                        while (!MapCanvas.this.isRollStop) {
                            MapCanvas.this.graphics.setColor(-6382436);
                            int shadowSize = 3;
                            MapCanvas.this.graphics.fillRoundRect(fixedx - maxNameLength / 2 - 3 + shadowSize, fixedy - 34 - 2 * row / row_fixedY - 2 * row, maxNameLength + 6, 24 + 4 * row, 10, 10);
                            MapCanvas.this.graphics.setColor(-928551);
                            MapCanvas.this.graphics.fillRoundRect(fixedx - maxNameLength / 2 - 3, fixedy - 34 - 2 * (row + 2), maxNameLength + 6, 24 + 4 * row, 10, 10);
                            MapCanvas.this.graphics.setColor(-16777216);
                            MapCanvas.this.graphics.drawRoundRect(fixedx - maxNameLength / 2 - 3, fixedy - 34 - 2 * (row + 2), maxNameLength + 6, 24 + 4 * row, 10, 10);
                            Building selectedBuilding = (Building)fixedselectedBuildings.elementAt(i);
                            String name = selectedBuilding.getName();
                            MapCanvas.this.graphics.setColor(-16777216);
                            c = CutNum[i];
                            if (name.length() > 14) {
                                MapCanvas.this.graphics.drawString(name.substring(0, c + 1), fixedx, fixedy - 30 - 2 * (row + 2), 17);
                                if (name.length() > 55) {
                                    MapCanvas.this.graphics.drawString(String.valueOf(name.substring(c + 1, 50)) + "\u2026", fixedx, fixedy - 30 - 2 * (row + 2) + font.getHeight(), 17);
                                } else {
                                    MapCanvas.this.graphics.drawString(name.substring(c + 1, name.length()), fixedx, fixedy - 30 - 2 * (row + 2) + font.getHeight(), 17);
                                }
                            } else {
                                MapCanvas.this.graphics.drawString(name, fixedx, fixedy - 30 - 2, 17);
                            }
                            MapCanvas.this.flushGraphics();
                            try {
                                Thread.sleep(1600L);
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e.toString());
                            }
                            i = (i + 1) % fixedselectedBuildings.size();
                        }
                    }
                };
                this.rollRestaurantName.start();
            }
        } else {
            String wlcMsg = MsgResource.getInstance().getMsg("MAPTIPS");
            String oldMsg = this.getTicker().getString();
            if (oldMsg != null && !oldMsg.equals(wlcMsg)) {
                this.getTicker().setString(wlcMsg);
            }
            if (this.rollRestaurantName != null && this.rollRestaurantName.isAlive()) {
                this.isRollStop = true;
            }
        }
        this.flushGraphics();
    }

    public void setNextMapCanvas(MapCanvas nextMapCanvas) {
        this.nextMapCanvas = nextMapCanvas;
    }

    public double getRateX() {
        return this.rateX;
    }

    public double getRateY() {
        return this.rateY;
    }

    public void setRate(double rateX, double rateY) {
        this.rateX = rateX;
        this.rateY = rateY;
    }

    public String getArea() {
        return this.area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public static Building getCurrentBuilding() {
        return currentBuilding;
    }

    public static void setCurrentBuilding(Building currentBuilding) {
        MapCanvas.currentBuilding = currentBuilding;
    }

    public double getFixLn() {
        return this.fixLn;
    }

    public void setFixLn(double fixLn) {
        this.fixLn = fixLn;
    }

    public double getFixLat() {
        return this.fixLat;
    }

    public void setFixLat(double fixLat) {
        this.fixLat = fixLat;
    }

    public int getLV() {
        return this.LV;
    }

    public void setShowOnMap(Vector showOnMap) {
        this.showOnMap = showOnMap;
    }

    public void clearData(boolean stopFlashPoint) {
        if (this.showOnMap != null) {
            this.showOnMap = null;
        }
        if (this.flashPoint != null && this.flashPoint.isAlive()) {
            if (stopFlashPoint) {
                this.flashPoint.stop();
            }
            this.flashPoint = null;
        }
        if (this.persons != null) {
            this.persons.removeAllElements();
        }
        if (this.selectedBuildingIndex != null) {
            this.selectedBuildingIndex.removeAllElements();
            this.selectedBuildingIndex = null;
        }
        if (this.rollRestaurantName != null && this.rollRestaurantName.isAlive()) {
            this.isRollStop = true;
            this.rollRestaurantName = null;
        }
        System.gc();
    }

    public void reflash() throws NullAreaException {
        this.showMap(this.currentX, this.currentY);
    }

    public void setLV(int lv) {
        this.LV = lv;
    }

    public Vector getPersons() {
        return this.persons;
    }

    public void setPersons(Vector persons) {
        this.persons = persons;
    }

    public void setCurrentX(int currentX) {
        this.currentX = currentX;
    }

    public void setCurrentY(int currentY) {
        this.currentY = currentY;
    }

    public void drawString(String s, int ax, int ay) {
        Graphics g = this.graphics;
        int oldtx = g.getTranslateX();
        int oldty = g.getTranslateY();
        g.translate(-oldtx, -oldty);
        g.setColor(0xFFFFFF);
        g.fillRect(ax, ay, this.getWidth(), 20);
        g.setColor(0);
        g.drawString(s, ax, ay, 20);
        g.translate(oldtx, oldty);
        this.flushGraphics();
    }

    public void drawString(String s, int ax, int ay, int bgColor, int foreColor) {
        Graphics g = this.graphics;
        int oldtx = g.getTranslateX();
        int oldty = g.getTranslateY();
        g.translate(-oldtx, -oldty);
        g.setColor(bgColor);
        g.fillRect(ax, ay, this.getWidth(), 20);
        g.setColor(foreColor);
        g.drawString(s, ax, ay, 20);
        g.translate(oldtx, oldty);
        this.flushGraphics();
    }

    public int getHalfWidth() {
        return this.halfWidth;
    }

    public int getHalfHeight() {
        return this.halfHeight;
    }

    public Vector getShowOnMap() {
        return this.showOnMap;
    }

    public Vector getSelectedBuildingIndex() {
        return this.selectedBuildingIndex;
    }

    public void setSelectedBuildingIndex(Vector selectedBuildingIndex) {
        this.selectedBuildingIndex = selectedBuildingIndex;
    }

    public double getCurrentLn() {
        return this.fixLn + CoordinateTool.getLn(0.0, 0.0, this.getCurrentX(), this.getCurrentY());
    }

    public double getCurrentLat() {
        return this.fixLat - CoordinateTool.getLat(0.0, 0.0, this.getCurrentX(), this.getCurrentY());
    }
}

