/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

class PlayGame
extends Canvas
implements Runnable {
    public boolean DrawMenu = false;
    private ScreenMenu scrMenu;
    private Main MainMenuPtr = null;
    private Game game = null;
    private Image img;
    private Timer tm;
    private ProgressTimerTask tt;
    private boolean isPresented = true;
    byte[] txtEnjoy = this.LoadText("/res/text_enjoy_game");
    byte[] txtTrials = this.LoadText("/res/text_trials");
    byte[] txtBtnBuyFull = this.LoadText("/res/text_buy_full");
    byte[] txtBtnStartGame = this.LoadText("/res/text_start_game");
    private boolean UsageOver = false;
    int height;
    int width;
    String str;
    Font font;
    private boolean selectFirstRow = true;
    int fontHeight;
    TextHandler txtHandler;
    private boolean DirectionChanged;
    private LoadGame loaderCanvas;

    private byte[] LoadText(String DetText) {
        byte[] ret = null;
        try {
            InputStream is = this.getClass().getResourceAsStream(DetText);
            int s = is.read() + is.read() * 256;
            ret = new byte[s];
            is.read(ret);
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public PlayGame(Main inMainPtr, Game ptr) {
        this.txtHandler = Menu.mMenuPtr.txtHandler;
        this.DirectionChanged = false;
        this.MainMenuPtr = inMainPtr;
        this.game = ptr;
        try {
            this.img = Image.createImage((String)this.game.Banner);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Menu.UsageLimit - this.game.Usage <= 0) {
            this.UsageOver = true;
        }
        new Thread(this).start();
    }

    public void run() {
        while (this.isPresented) {
            int loopDelay = 50;
            long loopStartTime = System.currentTimeMillis();
            this.MoveMenuBar();
            long loopEndTime = System.currentTimeMillis();
            int loopTime = (int)(loopEndTime - loopStartTime);
            if (loopTime >= loopDelay) continue;
            try {
                Thread.sleep(loopDelay - loopTime);
            }
            catch (Exception e) {}
        }
    }

    protected void paint(Graphics g) {
        this.height = this.getHeight();
        this.width = this.getWidth();
        this.setFullScreenMode(true);
        g.setColor(0);
        g.fillRect(0, 0, this.width, this.height);
        g.drawImage(this.img, this.width / 2, 50, 17);
        this.font = Menu.medBoldFont;
        g.setFont(this.font);
        this.txtHandler.paintText(g, 0, this.txtEnjoy, this.width / 2 + this.txtHandler.getTextWidth(0, this.txtEnjoy) / 2, 130, this.width, this.height);
        g.setColor(0xFF6600);
        g.drawString(this.game.Name, TextHandler.CenterX(this.game.Name, this.font), 150, 0);
        g.setColor(255, 255, 255);
        this.txtHandler.paintText(g, 0, this.txtTrials, this.width / 2 + this.txtHandler.getTextWidth(0, this.txtTrials) / 2 + 10, 180, this.width, this.height);
        g.setFont(Menu.regFont);
        g.drawString(Menu.UsageLimit - this.game.Usage + " :", this.width / 2 - this.txtHandler.getTextWidth(0, this.txtTrials) / 2 - 7, 177, 0);
        this.DrawSelectableTexts(g);
        g.setColor(0xFF6600);
        g.fillTriangle(5, this.height - 1, 1, this.height - 6, 10, this.height - 6);
        if (this.DrawMenu) {
            this.scrMenu.DrawMenu(g, this.width, this.height);
        }
    }

    private void DrawSelectableTexts(Graphics g) {
        int Y;
        int selectedY;
        if (this.selectFirstRow) {
            selectedY = 245;
            Y = 265;
        } else {
            selectedY = 265;
            Y = 245;
        }
        this.fontHeight = this.font.getHeight();
        g.setColor(0xFF6600);
        g.fillRect(0, selectedY, this.width, this.fontHeight);
        g.setColor(0);
        g.fillRect(0, Y, this.width, this.fontHeight);
        this.txtHandler.paintText(g, 0, this.txtBtnBuyFull, this.width / 2 + this.txtHandler.getTextWidth(0, this.txtBtnBuyFull) / 2, 250, this.width, this.height);
        if (!this.UsageOver) {
            this.txtHandler.paintText(g, 0, this.txtBtnStartGame, this.width / 2 + this.txtHandler.getTextWidth(0, this.txtBtnStartGame) / 2, 270, this.width, this.height);
        }
    }

    private void MoveMenuBar() {
        if (this.DirectionChanged) {
            this.repaint();
            this.serviceRepaints();
        }
    }

    protected void keyPressed(int keyCode) {
        int gameAction = this.getGameAction(keyCode);
        switch (gameAction) {
            case 1: {
                if (this.DrawMenu) {
                    this.scrMenu.SelectPrevItem();
                    this.DirectionChanged = true;
                    break;
                }
            }
            case 6: {
                if (this.DrawMenu) {
                    this.scrMenu.SelectNextItem();
                    this.DirectionChanged = true;
                    break;
                }
                if (!this.UsageOver) {
                    this.selectFirstRow = !this.selectFirstRow;
                }
                this.DirectionChanged = true;
                break;
            }
            case 8: {
                if (this.DrawMenu) {
                    if (this.scrMenu.FireCurrentItem()) {
                        this.scrMenu = null;
                        this.DrawMenu = false;
                        System.gc();
                        System.gc();
                    }
                    this.DirectionChanged = true;
                    break;
                }
                if (this.selectFirstRow) {
                    try {
                        Menu.mMenuPtr.platformRequest(this.game.FullURL);
                        Menu.mMenuPtr.notifyDestroyed();
                    }
                    catch (ConnectionNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    break;
                }
                try {
                    this.loaderCanvas = new LoadGame();
                    this.tm = new Timer();
                    this.tt = new ProgressTimerTask(this.loaderCanvas);
                    Display.getDisplay((MIDlet)Menu.mMenuPtr).setCurrent((Displayable)this.loaderCanvas);
                    this.tm.schedule((TimerTask)this.tt, 0L, 50L);
                    ++this.game.Usage;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (keyCode == -6 || keyCode == -21) {
            if (this.scrMenu == null) {
                this.scrMenu = new ScreenMenu(this.MainMenuPtr, false);
            }
            this.DrawMenu = true;
            this.repaint();
            this.serviceRepaints();
        }
    }

    protected void keyReleased(int keyCode) {
        this.DirectionChanged = false;
    }

    static /* synthetic */ byte[] access$000(PlayGame x0, String x1) {
        return x0.LoadText(x1);
    }

    class ProgressTimerTask
    extends TimerTask {
        LoadGame mCanvas = null;

        public ProgressTimerTask(LoadGame can) {
            this.mCanvas = can;
        }

        public void run() {
            if (this.mCanvas.GetProgress() == 100) {
                this.cancel();
                return;
            }
            this.mCanvas.repaint();
            PlayGame.this.serviceRepaints();
        }
    }

    class LoadGame
    extends Canvas
    implements Runnable {
        private int count = 0;
        byte[] txtGameLoading = PlayGame.access$000(PlayGame.this, "/res/text_game_loading");
        byte[] txtLoadingWait = PlayGame.access$000(PlayGame.this, "/res/text_game_loading_wait");
        byte[] txtPlayAnother1 = PlayGame.access$000(PlayGame.this, "/res/text_game_loading_play_another_1");
        byte[] txtPlayAnother2 = PlayGame.access$000(PlayGame.this, "/res/text_game_loading_play_another_2");
        int height;
        int width;
        int currY;
        String str;
        int smallHebFontSize;
        int largeHebFontSize;
        int strSize;

        public LoadGame() {
            this.smallHebFontSize = PlayGame.this.txtHandler.font_heights[0];
            this.largeHebFontSize = PlayGame.this.txtHandler.font_heights[1];
            new Thread(this).start();
        }

        public int GetProgress() {
            return this.count;
        }

        public void paint(Graphics g) {
            try {
                this.setFullScreenMode(true);
                Font font = g.getFont();
                g.setColor(0);
                this.height = this.getHeight();
                this.width = this.getWidth();
                this.currY = 20;
                g.fillRect(0, 0, this.width, this.height);
                PlayGame.this.txtHandler.paintText(g, 0, this.txtGameLoading, this.width / 2 + PlayGame.this.txtHandler.getTextWidth(0, this.txtGameLoading) / 2, this.currY, this.width, this.height);
                this.currY += this.smallHebFontSize + 10;
                this.strSize = PlayGame.this.txtHandler.getTextWidth(0, this.txtLoadingWait);
                PlayGame.this.txtHandler.paintText(g, 0, this.txtLoadingWait, this.width / 2 + this.strSize / 2, this.currY, this.width, this.height);
                this.currY += this.smallHebFontSize + 20;
                g.setColor(255, 255, 255);
                g.fillRect(this.width / 2 - this.strSize / 2, this.currY, this.strSize, 5);
                g.setColor(0xFF6600);
                g.fillRect(this.width / 2 - this.strSize / 2, this.currY, this.strSize * this.count / 100, 5);
                this.currY += 35;
                PlayGame.this.txtHandler.paintText(g, 0, this.txtPlayAnother1, this.width / 2 + PlayGame.this.txtHandler.getTextWidth(0, this.txtPlayAnother1) / 2, this.currY, this.width, this.height);
                this.currY += this.smallHebFontSize + 10;
                PlayGame.this.txtHandler.paintText(g, 0, this.txtPlayAnother2, this.width / 2 + PlayGame.this.txtHandler.getTextWidth(0, this.txtPlayAnother2) / 2, this.currY, this.width, this.height);
                this.currY += this.smallHebFontSize + 10;
                ++this.count;
            }
            catch (Exception ex) {
                System.out.println("Error During Paint. " + ex.getMessage());
            }
        }

        public void run() {
            while (this.count < 100) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
            Menu.RunApp = true;
        }
    }
}

