/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import com.thread.ThreadManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ButtonView
extends View {
    private int bindKey = -999;
    public static final int BINDKEY_LEFT = 0;
    public static final int BINDKEY_RIGHT = 1;
    private int buttonType = 0;
    public static final int BUTTONTYPE_ITEM = 0;
    public static final int BUTTONTYPE_OPTION = 1;
    private boolean isPopup = false;
    public int currentIndex = 0;
    private int popDirect = 0;
    private static final int POP_OUT = 1;
    private static final int POP_IN = 2;
    public static final int moveStep = 25;
    int boardColor = Res.UICOLOR_BORDER;
    private boolean drawBorder = true;

    public ButtonView() {
        this.type = 3;
        this.width = 80;
        this.height = 32;
    }

    public void setX(int x) {
        this.x = x;
        this.currentX = x;
    }

    public void setY(int y) {
        this.y = y;
        this.currentY = y;
    }

    public void setBindKey(String key) {
        if ((key = key.toUpperCase().trim()).equals("LEFT")) {
            this.setBindKey(0);
        } else if (key.equals("RIGHT")) {
            this.setBindKey(1);
        }
    }

    public void setBindKey(int key) {
        this.bindKey = key;
        if (this.container != null) {
            if (key == 0) {
                this.container.setLeftButton(this);
            } else if (key == 1) {
                this.container.setRightButton(this);
            }
        }
    }

    public int getBindKey() {
        return this.bindKey;
    }

    public void setButtonType(int type) {
        this.buttonType = type;
    }

    public int getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(String type) {
        if ((type = type.toUpperCase().trim()).equals("OPTION")) {
            this.setButtonType(1);
        } else if (type.equals("RIGHT")) {
            this.setButtonType(0);
        }
    }

    public boolean isPopup() {
        return this.isPopup;
    }

    public void popout() {
        this.isPopup = true;
        this.refreshButtonItem();
        System.out.println("items size=" + this.items.size());
        int i = 0;
        while (i < this.items.size()) {
            ButtonView bv = (ButtonView)this.items.elementAt(i);
            bv.setVisible(true);
            bv.currentX = this.x - this.getWidth();
            bv.currentY = this.y;
            bv.popDirect = 1;
            ThreadManager.addTask(bv);
            ++i;
        }
    }

    public void popin() {
        this.isPopup = false;
        this.refreshButtonItem();
        int i = 0;
        while (i < this.items.size()) {
            ButtonView bv = (ButtonView)this.items.elementAt(i);
            bv.currentX = bv.x;
            bv.currentY = bv.y;
            bv.x = this.x - this.getWidth();
            bv.y = this.y;
            bv.popDirect = 2;
            ThreadManager.addTask(bv);
            ++i;
        }
    }

    public boolean getActionResult() {
        if (this.currentX == this.x && this.currentY == this.y) {
            if (this.popDirect == 2) {
                this.visible = false;
            } else if (this.popDirect == 1) {
                this.visible = true;
            }
            this.popDirect = 0;
            return false;
        }
        return true;
    }

    public void setActionResult(boolean result) {
    }

    public void threadAction() {
        if (Math.abs(this.x - this.currentX) < 25) {
            this.currentX = this.x;
        } else if (this.currentX < this.x) {
            this.currentX += 25;
        } else if (this.currentX > this.x) {
            this.currentX -= 25;
        }
        if (Math.abs(this.y - this.currentY) < 25) {
            this.currentY = this.y;
        } else if (this.currentY < this.y) {
            this.currentY += 25;
        } else if (this.currentY > this.y) {
            this.currentY -= 25;
        }
    }

    public void setBoardColor(int c) {
        this.boardColor = c;
    }

    public void showBorder(boolean isShow) {
        this.drawBorder = isShow;
    }

    public void paint(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        int dx = this.x;
        int dy = this.y;
        if (this.popDirect > 0) {
            dx = this.currentX;
            dy = this.currentY;
        }
        if (this.fillBG) {
            g.setColor(this.color);
            g.fillRect(dx, dy, this.width, this.height);
        }
        this.drawImage(g, this.img);
        g.setFont(this.font);
        if (this.isSelected) {
            g.setColor(0xFFFFFF);
        } else {
            g.setColor(this.fontColor);
        }
        if (this.label != null && this.label.length() > 0) {
            g.drawString(this.label, dx + (this.width - this.font.stringWidth(this.label) >> 1), dy + (this.height - this.font.getHeight() >> 1), 20);
        }
        g.setColor(this.fontColor);
        if (this.isSelected && this.drawBorder) {
            g.setColor(this.boardColor);
            g.drawRect(dx - 1, dy - 1, this.width + 2, this.height + 2);
            g.drawRect(dx, dy, this.width, this.height);
        }
        int i = 0;
        while (i < this.items.size()) {
            ButtonView view = (ButtonView)this.items.elementAt(i);
            if (view != null && view.isVisible()) {
                view.paint(g);
            }
            ++i;
        }
    }

    public void drawImage(Graphics g, Image img) {
        if (img == null) {
            return;
        }
        int dx = this.x;
        int dy = this.y;
        if (this.popDirect > 0) {
            dx = this.currentX;
            dy = this.currentY;
        }
        if (this.imgFillType == 2) {
            g.drawImage(img, dx + (this.width - img.getWidth() >> 1), dy + (this.height - img.getHeight() >> 1), 20);
        } else if (this.imgFillType == 1) {
            g.drawImage(img, dx, dy, 20);
        } else {
            g.drawImage(img, dx, dy, 20);
        }
    }

    public void addItem(View view) {
        super.addItem(view);
        view.setVisible(false);
        if (this.items.size() > 0) {
            if (this.currentSub != null) {
                this.currentSub.isSelected = false;
            }
            this.currentSub = view;
            this.currentIndex = this.items.size() - 1;
            this.currentSub.isSelected = true;
        }
        this.refreshButtonItem();
    }

    public void refreshButtonItem() {
        block5: {
            int dx;
            block4: {
                if (this.items.size() > 0) {
                    this.currentIndex = this.items.size() - 1;
                    this.currentSub = (ButtonView)this.items.elementAt(this.currentIndex);
                    this.currentSub.isSelected = true;
                }
                dx = this.x;
                int dy = this.y;
                if (this.bindKey != 0 || this.buttonType != 1) break block4;
                int i = 0;
                while (i < this.items.size()) {
                    ButtonView btv = (ButtonView)this.items.elementAt(i);
                    btv.setY(dy -= btv.getHeight());
                    btv.currentY = this.y + btv.getHeight() * i;
                    btv.setX(dx);
                    if (i != this.currentIndex) {
                        btv.isSelected = false;
                    }
                    ++i;
                }
                break block5;
            }
            if (this.bindKey == 1 || this.buttonType != 0) break block5;
            int i = 0;
            while (i < this.items.size()) {
                ButtonView btv = (ButtonView)this.items.elementAt(i);
                btv.setX(dx + this.getWidth());
                btv.setY((dy -= btv.getHeight()) + this.getHeight());
                ++i;
            }
        }
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (this.items != null && this.items.size() > 0) {
            int i = 0;
            while (i < this.items.size()) {
                ButtonView bt = (ButtonView)this.items.elementAt(i);
                if (bt.isPopup) {
                    bt.isSelected = true;
                    return bt.keyReleasedAction(keyCode);
                }
                bt.isSelected = false;
                ++i;
            }
            if (keyCode == 6) {
                --this.currentIndex;
                if (this.currentIndex < 0) {
                    this.currentIndex = this.items.size() - 1;
                }
            } else if (keyCode == 1) {
                ++this.currentIndex;
                this.currentIndex %= this.items.size();
            } else if (keyCode != 2) {
                // empty if block
            }
            this.currentSub = (ButtonView)this.items.elementAt(this.currentIndex);
            this.currentSub.isSelected = true;
            if (keyCode == 8 && this.currentSub != null) {
                ButtonView current = (ButtonView)this.currentSub;
                if (current.items.size() > 0 && !current.isPopup()) {
                    current.popout();
                    return null;
                }
                return this.currentSub.keyReleasedAction(keyCode);
            }
        } else if (keyCode == 8 || keyCode == -6) {
            ViewEvent e = new ViewEvent();
            e.setView(this.container);
            e.setSource(this);
            e.setKeyCode(keyCode);
            e.setDesc(this.id);
            return e;
        }
        return null;
    }
}

