/*
 * Decompiled with CFR 0.152.
 */
package com.canvas.view.item;

import com.canvas.view.View;
import com.canvas.view.item.ListItem;
import com.canvas.view.item.PageNumView;
import com.canvas.view.until.ViewEvent;
import com.res.Res;
import com.thread.ThreadManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ListView
extends View {
    public int listMode = LISTMODE_UP_DOWN;
    public static byte LISTMODE_UP_DOWN = 0;
    public static byte LISTMODE_LEFT_RIGHT = 1;
    public int currentIndex = 0;
    private Image img_Scrol_bg;
    private Image img_Scrol_top;
    private Image img_Scrol_bot;
    private Image img_Scrol_bar;
    private Image img_select = null;
    private Image img_none = null;
    private PageNumView pageNumber;
    private byte lineType = 0;
    public static final byte LINE_NOMAL = 0;
    public static final byte LINE_ONE = 1;
    public static final byte LINE_TWO = 2;
    public static final int ListDistance = 3;
    public int startIndex = 0;
    public int numPerPage = 6;
    private boolean focusLostNotice = false;
    int iCounter = 0;

    public ListView() {
        this.type = 1;
    }

    public int getListMode() {
        return this.listMode;
    }

    public void setListMode(int listMode) {
        this.listMode = listMode;
        if (this.listMode == LISTMODE_UP_DOWN) {
            Image img1 = (Image)Res.imageTable.get("list_slct");
            Image img2 = (Image)Res.imageTable.get("list_none");
            this.setItemImage(img1, img2);
        }
    }

    public void setListMode(String listMode) {
        if (listMode != null) {
            if (listMode.endsWith("UD")) {
                this.setListMode(LISTMODE_UP_DOWN);
            } else if (listMode.endsWith("LR")) {
                this.setListMode(LISTMODE_LEFT_RIGHT);
            }
        }
    }

    public void setItemImage(Image selected, Image normal) {
        this.img_none = normal;
        this.img_select = selected;
        if (this.img_select != null && this.img_none != null) {
            this.numPerPage = (this.height - this.img_select.getHeight()) / (this.img_none.getHeight() + 3);
            ++this.numPerPage;
        } else {
            this.numPerPage = this.height / this.font.getHeight();
            --this.numPerPage;
        }
    }

    public void setPageNumber(PageNumView pnumber) {
        if (pnumber == null) {
            if (this.pageNumber != null) {
                this.height += this.pageNumber.getHeight();
                this.pageNumber = null;
                this.refreshItems();
            }
            return;
        }
        if (this.pageNumber == null) {
            this.height -= pnumber.getHeight();
        }
        this.refreshItems();
        this.pageNumber = pnumber;
    }

    public PageNumView getPageNuber() {
        return this.pageNumber;
    }

    public void addItem(View view) {
        if (view == null) {
            return;
        }
        if (this.items.size() == 0) {
            this.currentIndex = 0;
            this.startIndex = 0;
            this.currentSub = view;
            view.setFocus(true);
        }
        if (view instanceof ListItem) {
            ((ListItem)view).setLineType(this.lineType);
        }
        this.items.addElement(view);
        this.refreshItems();
    }

    public void refreshItems() {
        this.refreshItems_UD();
    }

    public void refreshItems_UD() {
        if (this.items.size() < 1) {
            return;
        }
        this.currentSub = (View)this.items.elementAt(this.currentIndex);
        int dy = this.y + 3;
        int i = this.startIndex;
        while (i < this.startIndex + this.numPerPage) {
            if (i > this.items.size() - 1) break;
            View view = (View)this.items.elementAt(i);
            view.setX(this.x);
            view.setY(dy);
            view.setWidth(this.width);
            if (i == this.currentIndex) {
                view.setImg(this.img_select);
                view.setFocus(true);
            } else {
                view.setImg(this.img_none);
                view.setFocus(false);
            }
            view.setHeight(view.getImg().getHeight());
            dy += view.getImg().getHeight();
            dy += 3;
            ++i;
        }
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        if (this.transparency == -1 && this.fillBG) {
            g.setColor(this.color);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        super.drawImage(g, this.img, this.x, this.y);
        g.setFont(this.font);
        this.paint_UD(g);
    }

    public void paint_UD(Graphics g) {
        int i = this.startIndex;
        while (i < this.startIndex + this.numPerPage) {
            if (i > this.items.size() - 1) break;
            if (i >= 0) {
                View view = (View)this.items.elementAt(i);
                view.paint(g);
            }
            ++i;
        }
        if (this.items.size() > this.numPerPage) {
            if (this.img_Scrol_bg == null) {
                this.img_Scrol_bg = (Image)Res.imageTable.get("Scrollbar_bg");
                this.img_Scrol_bot = (Image)Res.imageTable.get("Scrollbar_bot");
                this.img_Scrol_top = (Image)Res.imageTable.get("Scrollbar_top");
                this.img_Scrol_bar = (Image)Res.imageTable.get("Scrollbar_bar");
            }
            int dx = this.x + this.width - this.img_Scrol_top.getWidth();
            g.drawImage(this.img_Scrol_top, dx, this.y, 20);
            g.drawImage(this.img_Scrol_bot, dx, this.y + this.height - this.img_Scrol_bot.getHeight(), 20);
            int cw = g.getClipWidth();
            int ch = g.getClipHeight();
            int rectH = this.height - this.img_Scrol_top.getHeight() - this.img_Scrol_bot.getHeight();
            int dy = this.y + this.img_Scrol_top.getHeight();
            int cx = g.getClipX();
            int cy = g.getClipY();
            g.setClip(dx, dy, this.img_Scrol_bg.getWidth(), rectH);
            do {
                g.drawImage(this.img_Scrol_bg, dx, dy, 20);
            } while ((dy += this.img_Scrol_bg.getHeight()) < this.y + this.height - this.img_Scrol_bot.getHeight());
            dy = this.y + this.img_Scrol_top.getHeight() + (this.currentIndex + 1) * rectH / this.items.size();
            dx += this.img_Scrol_bg.getWidth() - this.img_Scrol_bar.getWidth() >> 1;
            for (int tmpY = this.y + this.img_Scrol_top.getHeight(); tmpY <= dy - this.img_Scrol_bar.getHeight(); tmpY += this.img_Scrol_bar.getHeight()) {
                g.drawImage(this.img_Scrol_bar, dx, tmpY, 20);
            }
            g.setClip(cx, cy, cw, ch);
        }
        if (this.pageNumber != null) {
            this.pageNumber.paint(g);
        }
    }

    public void refreshStartItem() {
        if (this.currentIndex == 0) {
            this.startIndex = 0;
        } else if (this.currentIndex == this.startIndex - 1) {
            this.startIndex = this.currentIndex;
        } else if (this.currentIndex == this.items.size() - 1 && this.items.size() > this.numPerPage) {
            this.startIndex = this.items.size() - this.numPerPage;
        } else if (this.currentIndex > this.startIndex + this.numPerPage - 1) {
            ++this.startIndex;
        }
    }

    public ViewEvent keyPressedAction(int keyCode) {
        ViewEvent e = new ViewEvent();
        e.setView(this);
        e.setDesc("keyPressed");
        e.setKeyCode(keyCode);
        e.setSource(this.currentSub);
        return e;
    }

    public void animaStart() {
        int i = 0;
        while (i < this.items.size()) {
            View item = (View)this.items.elementAt(i);
            ThreadManager.addTask(item);
            ++i;
        }
    }

    public void setFocusLostNotice(boolean notice) {
        this.focusLostNotice = notice;
    }

    public boolean isPointMe(int px, int py) {
        if (View.isPointInRect(px, py, this.x, this.y, this.width, this.height)) {
            return true;
        }
        return this.pageNumber != null && this.pageNumber.isPointMe(px, py);
    }

    public ViewEvent keyReleasedAction(int keyCode) {
        if (this.currentSub != null) {
            this.currentSub.setFocus(false);
        }
        if (keyCode == 6) {
            if (this.currentIndex == this.items.size() - 1 && this.focusLostNotice) {
                this.currentIndex = 0;
                this.currentSub = (View)this.items.elementAt(0);
                this.currentSub.setFocus(true);
                ViewEvent e = new ViewEvent();
                e.setView(this);
                e.setDesc("focuslost");
                e.setKeyCode(keyCode);
                e.setSource(this.currentSub);
                this.refreshStartItem();
                this.refreshItems();
                return e;
            }
            ++this.currentIndex;
            this.currentIndex %= this.items.size();
            this.refreshStartItem();
            this.refreshItems();
        } else if (keyCode == 1) {
            if (this.currentIndex == 0 && this.focusLostNotice) {
                ViewEvent e = new ViewEvent();
                e.setView(this);
                e.setDesc("focuslost");
                e.setKeyCode(keyCode);
                e.setSource(this.currentSub);
                return e;
            }
            --this.currentIndex;
            if (this.currentIndex < 0) {
                this.currentIndex = this.items.size() - 1;
            }
            this.refreshStartItem();
            this.refreshItems();
        }
        if (this.currentSub != null) {
            this.currentSub.setFocus(true);
        }
        if (keyCode == 8) {
            if (this.currentSub != null) {
                return this.currentSub.keyReleasedAction(keyCode);
            }
        } else if (keyCode == 2 || keyCode == 5) {
            if (this.pageNumber != null && this.listMode == LISTMODE_UP_DOWN) {
                return this.pageNumber.keyReleasedAction(keyCode);
            }
            ViewEvent e = new ViewEvent();
            e.setView(this);
            e.setDesc("left|right");
            e.setKeyCode(keyCode);
            e.setSource(this.currentSub);
            return e;
        }
        return null;
    }

    public ViewEvent pointerReleased(int px, int py) {
        System.out.println("ListIVew PointerReleased items size=" + this.items.size() + " id=" + this.id);
        ViewEvent e = new ViewEvent();
        if (this.pageNumber != null) {
            if (this.pageNumber.pointerLeftArrow(px, py)) {
                if (this.listMode == LISTMODE_UP_DOWN) {
                    return this.pageNumber.keyReleasedAction(2);
                }
                return this.pageNumber.keyReleasedAction(1);
            }
            if (this.pageNumber.pointerRigtArrow(px, py)) {
                if (this.listMode == LISTMODE_UP_DOWN) {
                    return this.pageNumber.keyReleasedAction(5);
                }
                return this.pageNumber.keyReleasedAction(6);
            }
        }
        int i = this.startIndex;
        while (i < this.items.size()) {
            View v = (View)this.items.elementAt(i);
            if (View.isPointInRect(px, py, v.getX(), v.getY(), v.getWidth() - 6, v.getHeight())) {
                boolean isfocus = false;
                if (this.currentIndex == i) {
                    isfocus = true;
                }
                v.setFocus(true);
                this.currentIndex = i;
                this.refreshItems();
                e.setView(v);
                e.setSource(v.getData());
                if (isfocus) {
                    e.setKeyCode(8);
                }
                return e;
            }
            ++i;
        }
        e.setView(this);
        return e;
    }

    public ViewEvent pointerDragged(int lastX, int lastY, int px, int py) {
        ++this.iCounter;
        if (this.iCounter > 9999) {
            this.iCounter = 0;
        }
        ViewEvent e = new ViewEvent();
        e.setView(this);
        return e;
    }

    public void setCurrentIndex(int currentId, int startId) {
        if (this.items.size() < 1) {
            return;
        }
        this.startIndex = startId;
        this.currentIndex = currentId;
        if (this.currentIndex >= this.items.size()) {
            this.currentIndex = this.items.size() - 1;
            if (this.startIndex > 0) {
                --this.startIndex;
            }
        } else {
            int dspL = this.items.size() - this.startIndex;
            if (dspL < this.numPerPage) {
                this.startIndex -= this.numPerPage - dspL;
                if (this.startIndex < 0) {
                    this.startIndex = 0;
                }
                if (this.currentIndex >= this.items.size()) {
                    this.currentIndex = this.items.size() - 1;
                }
            }
        }
        if (this.currentSub != null) {
            this.currentSub.setFocus(false);
        }
        this.refreshItems();
        if (this.currentSub != null) {
            this.currentSub.setFocus(true);
        }
    }

    public byte getLineType() {
        return this.lineType;
    }

    public void setLineType(byte lineType) {
        this.lineType = lineType;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }
}

