/*
 * Decompiled with CFR 0.152.
 */
package com.scene;

import com.WonHot;
import com.canvas.TheCanvas;
import com.canvas.view.View;
import com.canvas.view.item.ButtonView;
import com.canvas.view.item.Dialog;
import com.canvas.view.item.FormView;
import com.canvas.view.item.ListItem;
import com.canvas.view.item.ListView;
import com.canvas.view.item.Progress;
import com.canvas.view.item.TabView;
import com.canvas.view.item.TextView;
import com.canvas.view.item.TitleView;
import com.canvas.view.until.Until;
import com.canvas.view.until.ViewEvent;
import com.canvas.view.until.ViewManager;
import com.file.DownloadManager;
import com.file.File;
import com.file.FileManager;
import com.http.Request;
import com.model.BaseFunction;
import com.model.Node;
import com.model.UserInfo;
import com.res.Res;
import com.scene.DownloadListScene;
import com.scene.MainMenuScene;
import com.scene.PlayerScene;
import com.scene.Scene;
import com.thread.ThreadManager;
import com.tools.Tools;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;

public class FileExplorer
implements Scene,
BaseFunction,
CommandListener {
    public static final String TITLE_EXPLORER = "\u672c\u5730\u6587\u4ef6";
    public static final byte MAX_FILE_NAME_LENGTH = 64;
    public static final byte MAX_TIPS_NAME_LENGTH = 18;
    public static final String[] TYPE_IMAGE = new String[]{"png", "jpg", "gif"};
    public static final String[] TYPE_VIDEO = new String[]{"mp4", "3gp"};
    private File todoFile;
    private File todoNewFile;
    private byte todoType;
    private byte todoPreType;
    private static final byte TODO_NONE = 0;
    private static final byte TODO_DEL = 1;
    private static final byte TODO_COPY = 2;
    private static final byte TODO_MOVE = 3;
    private static final byte TODO_RENAME = 4;
    private static final byte TODO_NEWNAME = 5;
    private static final byte TODO_SAVE_DIR = 6;
    public static final byte TIP_TYPE_CONFIRM = 1;
    public static final byte TIP_TYPE_CHOISE = 2;
    private Vector lastViewStack = new Vector();
    public static DownloadListScene downloadList;
    private PlayerScene playerScene;
    private TextBox inputBox;
    private String oldName;
    private Command cmd_OK;
    private Command cmd_BACK;
    private FormView explorer;
    public Scene preScene;
    private TabView navigator;
    private ListView drivSelector;
    private FormView drivForm;
    private TextView drivHint;
    private TitleView title;
    private FormView foot;
    ButtonView option;
    ButtonView cmd_confirm;
    ButtonView cmd_downloadList;
    ButtonView cmd_selectSaveDir;
    ButtonView cmd_back;
    ButtonView cmd_exit;
    ButtonView cmd_exit_right;
    private Image img_dir;
    private Image img_photo;
    private Image img_file;
    private Image img_video;
    private byte state;
    public static final byte STATE_FILE_EXPLORER = 0;
    public static final byte STATE_FILE_PASTE = 1;
    public static final byte STATE_DOWNLOAD_DIR = 2;
    private final byte OPTION_NAVIGATOR;
    private final byte OPTION_LIST_VIEWER = (byte)3;
    private final byte OPTION_SELECTOR = (byte)4;
    private final byte OPTION_SELECTOR_PRE = (byte)5;
    private final byte OPTION_ONLY_EXIT = (byte)6;
    private final byte OPTION_DOWNLOAD_DIR = (byte)7;
    Progress progress;
    ButtonView oldRight;
    ButtonView oldLeft;

    public FileExplorer() {
        this.OPTION_NAVIGATOR = 1;
        this.inputBox = new TextBox("\u8bf7\u8f93\u5165\u540d\u5b57\uff1a", null, 64, 0);
        this.cmd_OK = new Command("\u786e\u5b9a", 4, 0);
        this.cmd_BACK = new Command("\u8fd4\u56de", 2, 1);
        this.inputBox.addCommand(this.cmd_OK);
        this.inputBox.addCommand(this.cmd_BACK);
        this.inputBox.setCommandListener((CommandListener)this);
        this.img_dir = Tools.createImage("/file_dir.png");
        this.img_file = Tools.createImage("/file_file.png");
        this.img_photo = Tools.createImage("/file_photo.png");
        this.img_video = Tools.createImage("/file_video.png");
        this.createSubView();
    }

    public void gotoInput(String text) {
        this.oldName = text;
        if (text != null && text.length() > 64) {
            text = text.substring(0, 64);
        }
        this.inputBox.setString(text);
        WonHot.setCurrentDisp((Displayable)this.inputBox);
    }

    public void createSubView() {
        this.explorer = new FormView();
        this.explorer.setId("explorer");
        this.explorer.setX(0);
        this.explorer.setY(0);
        this.explorer.setWidth(240);
        this.explorer.setHeight(320);
        TitleView tv = (TitleView)ViewManager.getViewByName("title");
        this.title = new TitleView();
        this.title = (TitleView)tv.copytoView(this.title);
        this.title.setLabel(TITLE_EXPLORER);
        FormView form = (FormView)ViewManager.getViewByName("foot");
        this.foot = new FormView();
        this.foot = (FormView)form.copytoView(this.foot);
        this.foot.isPointeMe = false;
        ButtonView temp = (ButtonView)ViewManager.getViewByName("exit");
        this.cmd_back = new ButtonView();
        this.cmd_back = (ButtonView)temp.copytoView(this.cmd_back);
        this.cmd_back.setBindKey("RIGHT");
        this.cmd_back.setLabel("\u8fd4  \u56de");
        this.cmd_exit_right = new ButtonView();
        this.cmd_exit_right = (ButtonView)temp.copytoView(this.cmd_exit_right);
        this.cmd_exit_right.setLabel("\u9000  \u51fa");
        this.cmd_exit_right.setBindKey("RIGHT");
        this.explorer.addItem(this.title);
        this.explorer.addItem(this.foot);
        this.explorer.setScene(this);
        this.navigator = new TabView();
        this.navigator.setId("navigator");
        this.navigator.setX(0);
        this.navigator.setY(this.title.getHeight());
        this.navigator.setWidth(240);
        this.navigator.setHeight(320 - this.foot.getHeight() - this.title.getHeight());
        this.navigator.setImg("bg");
        this.navigator.setImgType("CENTER");
        this.navigator.setFocus(true);
        this.drivForm = new FormView();
        this.drivForm.setId("drivForm");
        this.drivForm.setX(this.navigator.getX());
        this.drivForm.setY(this.navigator.getY());
        this.drivForm.setWidth(this.navigator.getWidth());
        this.drivForm.setHeight(this.navigator.getHeight());
        this.drivForm.setPassableKey(true);
        this.drivForm.setFillBG(false);
        this.drivForm.setFocus(true);
        this.drivForm.setImg("bg");
        this.drivHint = new TextView();
        this.drivHint.setX(this.drivForm.getX() + 10);
        this.drivHint.setY(this.drivForm.getY() + 10);
        this.drivHint.setWidth(this.drivForm.getWidth() - 20);
        this.drivHint.setHeight(Res.UIFONT.getHeight() * 2);
        this.drivHint.setFillBG(false);
        this.drivHint.setText("\u8bf7\u9009\u62e9\u4e00\u4e2a\u4f4d\u7f6e\uff1a");
        this.drivSelector = new ListView();
        this.drivSelector.setId("drivSelector");
        this.drivSelector.setX(this.drivForm.getX());
        this.drivSelector.setY(this.drivHint.getY() + this.drivHint.getHeight());
        this.drivSelector.setWidth(this.drivForm.getWidth());
        this.drivSelector.setHeight(this.navigator.getHeight() - this.drivSelector.getY());
        this.drivSelector.setListMode(ListView.LISTMODE_UP_DOWN);
        this.drivSelector.setImgType("CENTER");
        this.drivSelector.setFillBG(false);
        this.drivSelector.setFontColor(0xFFFFFF);
        this.drivSelector.setFocus(true);
        this.drivForm.addItem(this.drivHint);
        this.drivForm.addItem(this.drivSelector);
        this.drivForm.setCurrentSub(this.drivSelector);
        temp = (ButtonView)ViewManager.getViewByName("optionMenu");
        this.option = new ButtonView();
        this.option.setX(temp.getX());
        this.option.setY(temp.getY());
        this.option.setWidth(temp.getWidth());
        this.option.setHeight(temp.getHeight());
        this.option.setBindKey(temp.getBindKey());
        this.option.setLabel(temp.getLabel());
        this.option.setButtonType(temp.getButtonType());
        this.option.setFillBG(temp.getFillBG());
        this.option.setFontColor(temp.getFontColor());
        this.cmd_confirm = new ButtonView();
        this.cmd_confirm.setWidth(110);
        this.cmd_confirm.setButtonType(0);
        this.cmd_confirm.setImg("bot_line");
        this.cmd_confirm.setImgType("EXTEND");
        this.cmd_confirm.setLabel("\u4fdd  \u5b58");
        this.cmd_confirm.setId("confirm");
        this.cmd_downloadList = new ButtonView();
        this.cmd_downloadList.setWidth(110);
        this.cmd_downloadList.setButtonType(0);
        this.cmd_downloadList.setImg("bot_line");
        this.cmd_downloadList.setImgType("EXTEND");
        this.cmd_downloadList.setLabel("\u4e0b\u8f7d\u7ba1\u7406");
        this.cmd_downloadList.setId("downloadList");
        this.cmd_selectSaveDir = new ButtonView();
        this.cmd_selectSaveDir.setWidth(110);
        this.cmd_selectSaveDir.setButtonType(0);
        this.cmd_selectSaveDir.setImg("bot_line");
        this.cmd_selectSaveDir.setImgType("EXTEND");
        this.cmd_selectSaveDir.setLabel("\u66f4\u6539\u4e0b\u8f7d\u76ee\u5f55");
        this.cmd_selectSaveDir.setId("selectSaveDir");
        this.cmd_exit = new ButtonView();
        this.cmd_exit.setWidth(110);
        this.cmd_exit.setButtonType(0);
        this.cmd_exit.setImg("bot_line");
        this.cmd_exit.setImgType("EXTEND");
        this.cmd_exit.setLabel("\u9000  \u51fa");
        this.cmd_exit.setId("exit");
    }

    public void open() {
    }

    public void openSelector(byte s) {
        this.cleanTips();
        this.state = s;
        this.drivSelector.items.removeAllElements();
        File[] roots = FileManager.getRoot(false);
        if (roots != null) {
            long[] size = new long[roots.length];
            int i = 0;
            while (i < size.length) {
                try {
                    size[i] = FileManager.getAvailable(roots[i]);
                }
                catch (Exception e) {
                    size[i] = 0L;
                }
                ListItem item = new ListItem();
                item.setLabel(roots[i].getDisplayName());
                String sizeString = FileManager.changeSizeToString(size[i]);
                if (sizeString != null) {
                    item.setDeskCribe("\u53ef\u7528\u7a7a\u95f4\uff1a" + sizeString);
                } else {
                    item.setDeskCribe("\u4e0d\u53ef\u7528");
                }
                item.setData(roots[i]);
                item.setIcon(this.img_dir);
                this.drivSelector.addItem(item);
                ++i;
            }
        }
        this.myAddItem(this.drivForm);
        this.makeOptions(5);
    }

    private void makeOptions(int optionType) {
        this.option.items.removeAllElements();
        if (optionType == 1) {
            this.option.addItem(this.cmd_selectSaveDir);
            this.option.addItem(this.cmd_downloadList);
            this.explorer.setRightButton(this.cmd_exit_right);
            this.explorer.setLeftButton(this.option);
        } else if (optionType == 3) {
            this.option.addItem(this.cmd_exit);
            this.option.addItem(this.cmd_selectSaveDir);
            this.option.addItem(this.cmd_downloadList);
            this.explorer.setLeftButton(this.option);
            this.explorer.setRightButton(this.cmd_back);
        } else if (optionType == 4) {
            this.explorer.setLeftButton(null);
            this.explorer.setRightButton(this.cmd_back);
        } else if (optionType == 7) {
            this.option.addItem(this.cmd_exit);
            this.option.addItem(this.cmd_confirm);
            this.explorer.setLeftButton(this.option);
            this.explorer.setRightButton(this.cmd_back);
        } else if (optionType == 5) {
            this.explorer.setLeftButton(null);
            this.explorer.setRightButton(this.cmd_back);
        } else if (optionType == 6) {
            this.explorer.setLeftButton(null);
            this.explorer.setRightButton(this.cmd_exit_right);
        }
    }

    public void show() {
        this.viewGoBack(true);
        this.explorer.setCurrentX(240);
        this.explorer.setCurrentY(0);
        this.explorer.setX(0);
        this.explorer.setY(0);
        this.explorer.popout();
        ThreadManager.addTask(this.explorer);
        TheCanvas.setCurrentView(this.explorer);
        Request.function = this;
        if (DownloadManager.saveDir == null) {
            this.explorer.tips = FileExplorer.createTips(this.explorer, "\u65e0\u6cd5\u521b\u5efa\u9ed8\u8ba4\u7684\u4e0b\u8f7d\u6587\u4ef6\u4fdd\u5b58\u76ee\u5f55\uff0c\u8bf7\u6309 '\u9009\u9879' \u8fdb\u5165 '\u6539\u4e0b\u8f7d\u76ee\u5f55' \u8fdb\u884c\u624b\u52a8\u8bbe\u7f6e", (byte)1);
        }
    }

    public void createExplorer() {
        this.state = 0;
        File[] roots = FileManager.getRoot(true);
        this.createNavigator(roots, (byte)0);
    }

    private void refreshExplorer(File file) {
        if (this.state == 0) {
            if (file == null) {
                this.createExplorer();
            } else if (file != null && file.isDir()) {
                if (file.getFather() == null) {
                    this.createExplorer();
                } else {
                    this.createNavigator(new File[]{file}, (byte)0);
                }
            }
        } else if (this.state == 1 || this.state == 2) {
            if (file == null) {
                this.openSelector(this.state);
            } else if (file.isDir()) {
                this.createNavigator(new File[]{file}, (byte)1);
            }
        }
    }

    private void createNavigator(File[] files, byte readType) {
        this.navigator.removeAllTabItem();
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (i == 0) {
                    if (this.state == 0) {
                        if (files[i].getFather() == null) {
                            this.makeOptions(1);
                        } else {
                            this.makeOptions(3);
                        }
                    } else if (this.state == 1) {
                        if (files[i] == null) {
                            this.makeOptions(5);
                        } else {
                            this.makeOptions(4);
                        }
                    } else if (this.state == 2) {
                        if (files[i] == null) {
                            this.makeOptions(5);
                        } else {
                            this.makeOptions(7);
                        }
                    }
                }
                FormView listForm = new FormView();
                listForm.setId("listForm");
                listForm.setData(files[i]);
                this.navigator.addTabItem(files[i].getDisplayName(), listForm);
                this.navigator.setStartIndex(0);
                ListView fileList = new ListView();
                fileList.setId("fileList");
                fileList.setFillBG(false);
                fileList.setX(listForm.getX());
                fileList.setY(listForm.getY());
                fileList.setWidth(listForm.getWidth());
                fileList.setHeight(listForm.getHeight());
                fileList.setListMode(ListView.LISTMODE_UP_DOWN);
                fileList.setFocus(true);
                fileList.setFontColor(0xFFFFFF);
                listForm.addItem(fileList);
                listForm.setCurrentSub(fileList);
                listForm.setPassableKey(true);
                listForm.setFillBG(false);
                listForm.setDrawBorder(true);
                File[] subFiles = FileManager.getSubFiles(files[i], readType);
                if (subFiles != null) {
                    int j = 0;
                    while (j < subFiles.length) {
                        ListItem item = new ListItem();
                        item.setLabel(subFiles[j].getDisplayName());
                        item.setData(subFiles[j]);
                        fileList.addItem(item);
                        if (subFiles[j].isDir()) {
                            item.setIcon(this.img_dir);
                        } else {
                            item.setDscribePos((byte)2);
                            item.setDeskCribe(FileManager.changeSizeToString(subFiles[j].getFileSize()));
                            String type = subFiles[j].getType();
                            type = type == null ? " " : type.toLowerCase().trim();
                            boolean setImg = false;
                            if (!setImg) {
                                int k = 0;
                                while (k < TYPE_VIDEO.length) {
                                    if (type.equals(TYPE_VIDEO[k])) {
                                        item.setIcon(this.img_video);
                                        setImg = true;
                                    }
                                    ++k;
                                }
                            }
                            if (!setImg) {
                                item.setIcon(this.img_file);
                            }
                        }
                        ++j;
                    }
                } else {
                    ListItem item = new ListItem();
                    item.setLabel("[\u6587\u4ef6\u5939\u4e3a\u7a7a]");
                    fileList.addItem(item);
                }
                fileList.setCurrentIndex(0, 0);
                fileList.setFocus(true);
                ++i;
            }
        } else {
            this.makeOptions(6);
            FormView listForm = new FormView();
            listForm.setId("listForm");
            this.navigator.addTabItem("[\u7a7a]", listForm);
            ListView fileList = new ListView();
            fileList.setId("fileList");
            fileList.setFillBG(false);
            fileList.setX(listForm.getX());
            fileList.setY(listForm.getY());
            fileList.setWidth(listForm.getWidth());
            fileList.setHeight(listForm.getHeight());
            fileList.setListMode(ListView.LISTMODE_UP_DOWN);
            fileList.setFocus(true);
            fileList.setFontColor(0xFFFFFF);
            listForm.addItem(fileList);
            listForm.setCurrentSub(fileList);
            ListItem item = new ListItem();
            item.setLabel("\u6ca1\u6709\u53ef\u8bfb\u78c1\u76d8");
            fileList.addItem(item);
        }
        this.myAddItem(this.navigator);
    }

    public static Dialog createTips(View view, String txt, byte type) {
        if (view.tips != null) {
            view.tips.clear();
            view.tips = null;
        }
        Dialog dialog = new Dialog();
        dialog.setVisible(true);
        dialog.setId("userinfotip");
        dialog.setLabel("   " + txt);
        dialog.setCurrentX(210);
        dialog.setCurrentY(290);
        dialog.setX(240 - dialog.getWidth() >> 1);
        dialog.setY(320 - dialog.getHeight() >> 1);
        dialog.setColor(0xFFFFFF);
        View v = new View();
        v.setWidth(dialog.getWidth());
        v.setHeight(dialog.getTitleHeight());
        v.setImg("bot_line");
        v.setImgType(1);
        Image img = v.getImg();
        dialog.setTitleImage(img);
        dialog.setFocus(true);
        if (type == 2) {
            dialog.setLeftButtonStr("\u786e\u5b9a");
            dialog.setRightButtonStr("\u53d6\u6d88");
        } else if (type == 1) {
            dialog.setRightButtonStr("\u786e\u5b9a");
        }
        v = null;
        view.tips = dialog;
        dialog.popout();
        return dialog;
    }

    private void cleanTips() {
        if (this.explorer.tips != null) {
            this.explorer.tips.clear();
            this.explorer.tips = null;
        }
    }

    public void ActionKeyReleased(ViewEvent e) {
        if (e == null) {
            return;
        }
        if (e.getView() instanceof Dialog) {
            try {
                if (this.todoType == 1 && e.getKeyCode() == -6) {
                    this.addLastView(this.todoFile.getFather(), this.navigator.getCurrentIndex(), this.navigator.getStartIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getCurrentIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getStartIndex(), this.state);
                    this.caughtTimeAction(this.todoFile, null);
                }
                this.cleanTips();
            }
            catch (Exception e1) {
                this.cleanTips();
                this.explorer.tips = e1.getMessage() == null ? FileExplorer.createTips(this.explorer, e1.toString(), (byte)1) : FileExplorer.createTips(this.explorer, e1.getMessage(), (byte)1);
            }
            return;
        }
        if (e.getKeyCode() == -7) {
            if (this.option.isPopup()) {
                this.option.popin();
                return;
            }
            if (e.getSource() instanceof ButtonView) {
                if (e.getSource() == this.cmd_exit_right) {
                    this.exit();
                } else if (e.getSource() == this.cmd_back) {
                    if (this.explorer.getCurrentSub() == this.navigator) {
                        this.viewGoBack(false);
                    } else if (this.explorer.getCurrentSub() == this.drivForm) {
                        this.viewGoBack(false);
                    }
                }
            }
            return;
        }
        if (e.getKeyCode() == 8) {
            File file;
            if (e.getSource() instanceof ButtonView) {
                ListView list;
                FormView form;
                if (this.navigator.getCurrentSub() != null && (form = (FormView)this.navigator.getCurrentSub()).getCurrentSub() != null && (list = (ListView)form.getCurrentSub()).getCurrentSub() != null) {
                    File file2 = (File)((ListItem)list.getCurrentSub()).getData();
                    ButtonView select = (ButtonView)e.getSource();
                    try {
                        if (select == this.cmd_downloadList) {
                            if (downloadList == null) {
                                downloadList = new DownloadListScene();
                            }
                            FileExplorer.downloadList.preScene = this;
                            downloadList.show();
                            this.addLastView((File)form.getData(), this.navigator.getCurrentIndex(), this.navigator.getStartIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getCurrentIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getStartIndex(), this.state);
                            return;
                        }
                        if (select == this.cmd_exit) {
                            this.exit();
                            return;
                        }
                        if (file2 != null) {
                            if (select == this.cmd_selectSaveDir) {
                                this.addLastView(file2.getFather(), this.navigator.getCurrentIndex(), this.navigator.getStartIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getCurrentIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getStartIndex(), this.state);
                                this.todoFile = file2.getFather();
                                this.todoType = (byte)6;
                                this.openSelector((byte)2);
                            } else if (select == this.cmd_confirm) {
                                this.saveDownloadUrl(this.todoFile, file2.getFather());
                            }
                        } else {
                            file2 = (File)this.navigator.getCurrentSub().getData();
                            if (select == this.cmd_selectSaveDir) {
                                this.addLastView(file2, this.navigator.getCurrentIndex(), this.navigator.getStartIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getCurrentIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getStartIndex(), this.state);
                                this.todoFile = file2;
                                this.todoType = (byte)6;
                                this.openSelector((byte)2);
                            } else if (select == this.cmd_confirm) {
                                this.saveDownloadUrl(this.todoFile, file2);
                            }
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        this.explorer.tips = e1.getMessage() == null ? FileExplorer.createTips(this.explorer, e1.toString(), (byte)1) : FileExplorer.createTips(this.explorer, e1.getMessage(), (byte)1);
                    }
                }
                return;
            }
            if (this.explorer.getCurrentSub() == this.navigator) {
                FormView form;
                if (this.navigator.getCurrentSub() != null && (form = (FormView)this.navigator.getCurrentSub()).getCurrentSub() != null && e.getSource() != null && e.getSource() instanceof File) {
                    File file3 = (File)e.getSource();
                    if (file3.isDir()) {
                        this.addLastView(file3.getFather(), this.navigator.getCurrentIndex(), this.navigator.getStartIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getCurrentIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getStartIndex(), this.state);
                        this.refreshExplorer(file3);
                    } else {
                        String type = file3.getType();
                        type = type == null ? " " : type.toLowerCase().trim();
                        boolean setImg = false;
                        int k = 0;
                        while (k < TYPE_VIDEO.length) {
                            if (type.equals(TYPE_VIDEO[k])) {
                                setImg = true;
                                break;
                            }
                            ++k;
                        }
                        if (setImg) {
                            this.addLastView(file3.getFather(), this.navigator.getCurrentIndex(), this.navigator.getStartIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getCurrentIndex(), ((ListView)this.navigator.getCurrentSub().getCurrentSub()).getStartIndex(), this.state);
                            this.playerScene = new PlayerScene();
                            this.playerScene.preScene = this;
                            Node node = new Node();
                            node.name = file3.getDisplayName();
                            node.isLive = false;
                            node.playUrl = file3.getLocator();
                            this.playerScene.setNode(node);
                            this.playerScene.show();
                        }
                    }
                }
            } else if (this.explorer.getCurrentSub() == this.drivForm && this.drivForm.getCurrentSub() != null && e.getSource() != null && e.getSource() instanceof File && (file = (File)e.getSource()).isDir()) {
                this.addLastView(file.getFather(), this.navigator.getCurrentIndex(), this.navigator.getStartIndex(), ((ListView)this.drivForm.getCurrentSub()).getCurrentIndex(), ((ListView)this.drivForm.getCurrentSub()).getStartIndex(), this.state);
                this.refreshExplorer(file);
            }
        }
    }

    public void ActionkeyPressed(ViewEvent obj) {
    }

    public void close() {
    }

    public void setResult(Object obj) {
        this.explorer.setPassableKey(true);
        if (this.progress != null) {
            this.progress.stop();
            this.explorer.removeItem(this.progress);
            this.progress.clear();
            this.progress = null;
        }
        if (obj == null) {
            return;
        }
    }

    public void setStatus(String str) {
    }

    public void startProgress() {
        this.navigator.setPassableKey(false);
        this.progress = new Progress();
        this.progress.setLabel("\u8bf7\u7a0d\u5019..");
        this.progress.setX(50);
        this.progress.setWidth(140);
        this.progress.setHeight(80);
        this.progress.setY(320 - this.progress.getHeight() - 30);
        Image img_loading1 = (Image)Res.imageTable.get("loading1");
        Image img_loading2 = (Image)Res.imageTable.get("loading2");
        Image[] img = Until.RollImage(img_loading1, img_loading2);
        this.progress.setProgerssImg(img);
        this.progress.setProgType(1);
        this.progress.setFontColor(0);
        ThreadManager.addTask(this.progress);
        if (!this.explorer.items.contains(this.progress)) {
            this.explorer.addItem(this.progress);
        }
        this.oldRight = this.explorer.getRightButton();
        this.oldLeft = this.explorer.getLeftButton();
        this.explorer.setRightButton(null);
        this.explorer.setLeftButton(null);
    }

    private void stopProgress() {
        if (this.progress != null) {
            this.progress.stop();
            this.explorer.removeItem(this.progress);
            this.progress.clear();
        }
        this.explorer.setRightButton(this.oldRight);
        this.explorer.setLeftButton(this.oldLeft);
    }

    public byte getType() {
        return this.state;
    }

    public void setType(byte type) {
        this.state = type;
    }

    public Object[] getParameters() {
        return null;
    }

    private void exit() {
        if (this.preScene == null) {
            return;
        }
        this.lastViewStack.removeAllElements();
        if (this.explorer.tips != null) {
            this.explorer.tips = null;
        }
        this.preScene.show();
        TheCanvas.lastView = null;
        if (this.preScene instanceof MainMenuScene) {
            this.explorer.setCurrentX(0);
            this.explorer.setCurrentY(0);
            this.explorer.setX(240);
            this.explorer.setY(0);
            this.explorer.popin();
            ThreadManager.addTask(this.explorer);
        }
    }

    private void caughtTimeAction(final File src, final File dest) {
        this.startProgress();
        new Thread(new Runnable(){

            public void run() {
                try {
                    if (FileExplorer.this.todoType == 2) {
                        FileManager.copyFile(src, dest);
                    } else if (FileExplorer.this.todoType == 3) {
                        FileManager.moveFile(FileExplorer.this.todoFile, dest);
                    } else if (FileExplorer.this.todoType == 1) {
                        FileExplorer.this.todoType = (byte)0;
                        FileManager.delFile(src);
                    }
                    FileExplorer.this.viewGoBack((byte)0);
                }
                catch (Exception e) {
                    FileExplorer.this.viewGoBack((byte)0);
                    FileExplorer.this.stopProgress();
                    ((FileExplorer)FileExplorer.this).explorer.tips = e.getMessage() == null ? FileExplorer.createTips(FileExplorer.this.explorer, e.toString(), (byte)1) : FileExplorer.createTips(FileExplorer.this.explorer, e.getMessage(), (byte)1);
                }
                FileExplorer.this.stopProgress();
            }
        }).start();
    }

    private void myAddItem(View v) {
        this.explorer.removeItem(this.navigator);
        this.explorer.removeItem(this.drivForm);
        if (!this.explorer.items.contains(v)) {
            this.explorer.addItem(v);
        }
        this.explorer.setCurrentSub(v);
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == this.cmd_OK) {
            String s = this.inputBox.getString();
            if (s != null && s.length() > 0) {
                try {
                    if (this.oldName == null || !this.oldName.equals(s)) {
                        if (this.todoType == 4) {
                            if (!this.todoFile.isDir() && this.todoFile.getType() != null) {
                                s = String.valueOf(s) + "." + this.todoFile.getType();
                            }
                            FileManager.rename(this.todoFile, s);
                        } else if (this.todoType == 5) {
                            this.todoType = this.todoPreType;
                            FileManager.makeDir(this.todoNewFile, s);
                        }
                    }
                    this.goBackFromInput();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.showAlert(e.getMessage());
                }
            }
        } else if (cmd == this.cmd_BACK) {
            this.goBackFromInput();
        }
    }

    public void goBackFromInput() {
        this.viewGoBack(false);
        WonHot.setCurrentDisp((Displayable)WonHot.canvas);
        WonHot.canvas.setFullScreenMode(true);
    }

    private void showAlert(String s) {
        Alert alert = new Alert("\u63d0\u793a\uff1a", s, null, AlertType.CONFIRMATION);
        alert.addCommand(Alert.DISMISS_COMMAND);
        alert.setTimeout(-2);
        WonHot.display.setCurrent(alert, (Displayable)this.inputBox);
    }

    private void saveDownloadUrl(File src, File dest) {
        String url = dest.getLocator();
        String tempUrl = String.valueOf(url) + "temp" + "/";
        try {
            if (!FileManager.isExist(tempUrl)) {
                FileManager.makeDir(url, "temp");
            }
            FileManager.defaultStoreURL = url;
            DownloadManager.saveDir = url;
            UserInfo.iUserInfo.saveDirectoryUrl = url;
            UserInfo.saveRecord(UserInfo.iUserInfo);
            this.viewGoBack((byte)0);
        }
        catch (Exception e) {
            this.explorer.tips = FileExplorer.createTips(this.explorer, "\u60a8\u9009\u62e9\u7684\u76ee\u5f55\u53ef\u80fd\u662f\u7cfb\u7edf\u76d8\u7684\u6839\u76ee\u5f55\uff0c\u65e0\u6cd5\u5728\u8be5\u76ee\u5f55\u4e0b\u521b\u5efa\u6587\u4ef6\u6216\u8005\u6587\u4ef6\u5939\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (byte)1);
        }
    }

    private void addLastView(File file, int navigatorIndex, int navigatorStateIndex, int listCurrentId, int listStartId, byte state) {
        this.lastViewStack.addElement(new LastView(file, navigatorIndex, navigatorStateIndex, listCurrentId, listStartId, state));
    }

    private void viewGoBack(boolean init) {
        if (this.lastViewStack.size() > 0) {
            LastView lastView = (LastView)this.lastViewStack.elementAt(this.lastViewStack.size() - 1);
            this.lastViewStack.removeElementAt(this.lastViewStack.size() - 1);
            this.state = lastView.state;
            this.refreshExplorer(lastView.file);
            if (lastView.navigatorIndex > -1) {
                this.navigator.setCurrentItem(lastView.navigatorIndex);
                this.navigator.setStartIndex(lastView.navigatorStateIndex);
            }
            ((ListView)this.navigator.getCurrentSub().getCurrentSub()).setCurrentIndex(lastView.listCurrentID, lastView.listStartID);
            ((ListView)this.drivForm.getCurrentSub()).setCurrentIndex(lastView.listCurrentID, lastView.listStartID);
        } else if (init) {
            this.createExplorer();
        } else {
            this.exit();
        }
    }

    private void viewGoBack(byte gotoState) {
        boolean hasLastView = false;
        int i = this.lastViewStack.size() - 1;
        while (i > -1) {
            LastView lastView = (LastView)this.lastViewStack.elementAt(i);
            this.lastViewStack.removeElementAt(this.lastViewStack.size() - 1);
            if (lastView.state == gotoState) {
                hasLastView = true;
                this.state = lastView.state;
                this.refreshExplorer(lastView.file);
                if (lastView.navigatorIndex > -1) {
                    this.navigator.setCurrentItem(lastView.navigatorIndex);
                    this.navigator.setStartIndex(lastView.navigatorStateIndex);
                }
                ((ListView)this.navigator.getCurrentSub().getCurrentSub()).setCurrentIndex(lastView.listCurrentID, lastView.listStartID);
                ((ListView)this.drivForm.getCurrentSub()).setCurrentIndex(lastView.listCurrentID, lastView.listStartID);
                break;
            }
            --i;
        }
        if (!hasLastView) {
            this.exit();
        }
    }

    public void ActionPointReleased(ViewEvent e) {
        this.ActionKeyReleased(e);
    }

    private class LastView {
        public byte state;
        public File file;
        public int navigatorIndex;
        public int navigatorStateIndex;
        public int listCurrentID;
        public int listStartID;

        LastView(File file, int navigatorIndex, int navigatorStateIndex, int listCurrentID, int listStartID, byte state) {
            this.file = file;
            this.navigatorIndex = navigatorIndex;
            this.navigatorStateIndex = navigatorStateIndex;
            this.listCurrentID = listCurrentID;
            this.listStartID = listStartID;
            this.state = state;
        }
    }
}

