/*
 * Decompiled with CFR 0.152.
 */
package com.tools;

import java.io.IOException;

public class GZIP {
    private static final int FTEXT_MASK = 1;
    private static final int FHCRC_MASK = 2;
    private static final int FEXTRA_MASK = 4;
    private static final int FNAME_MASK = 8;
    private static final int FCOMMENT_MASK = 16;
    private static final int BTYPE_NONE = 0;
    private static final int BTYPE_FIXED = 1;
    private static final int BTYPE_DYNAMIC = 2;
    private static final int BTYPE_RESERVED = 3;
    private static final int MAX_BITS = 16;
    private static final int MAX_CODE_LITERALS = 287;
    private static final int MAX_CODE_DISTANCES = 31;
    private static final int MAX_CODE_LENGTHS = 18;
    private static final int EOB_CODE = 256;
    private static final int[] LENGTH_EXTRA_BITS;
    private static final int[] LENGTH_VALUES;
    private static final int[] DISTANCE_EXTRA_BITS;
    private static final int[] DISTANCE_VALUES;
    private static final int[] DYNAMIC_LENGTH_ORDER;
    private static int gzipIndex;
    private static int gzipByte;
    private static int gzipBit;

    static {
        int[] nArray = new int[31];
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArray[11] = 1;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 3;
        nArray[18] = 3;
        nArray[19] = 3;
        nArray[20] = 4;
        nArray[21] = 4;
        nArray[22] = 4;
        nArray[23] = 4;
        nArray[24] = 5;
        nArray[25] = 5;
        nArray[26] = 5;
        nArray[27] = 5;
        nArray[29] = 99;
        nArray[30] = 99;
        LENGTH_EXTRA_BITS = nArray;
        int[] nArray2 = new int[31];
        nArray2[0] = 3;
        nArray2[1] = 4;
        nArray2[2] = 5;
        nArray2[3] = 6;
        nArray2[4] = 7;
        nArray2[5] = 8;
        nArray2[6] = 9;
        nArray2[7] = 10;
        nArray2[8] = 11;
        nArray2[9] = 13;
        nArray2[10] = 15;
        nArray2[11] = 17;
        nArray2[12] = 19;
        nArray2[13] = 23;
        nArray2[14] = 27;
        nArray2[15] = 31;
        nArray2[16] = 35;
        nArray2[17] = 43;
        nArray2[18] = 51;
        nArray2[19] = 59;
        nArray2[20] = 67;
        nArray2[21] = 83;
        nArray2[22] = 99;
        nArray2[23] = 115;
        nArray2[24] = 131;
        nArray2[25] = 163;
        nArray2[26] = 195;
        nArray2[27] = 227;
        nArray2[28] = 258;
        LENGTH_VALUES = nArray2;
        int[] nArray3 = new int[30];
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 2;
        nArray3[7] = 2;
        nArray3[8] = 3;
        nArray3[9] = 3;
        nArray3[10] = 4;
        nArray3[11] = 4;
        nArray3[12] = 5;
        nArray3[13] = 5;
        nArray3[14] = 6;
        nArray3[15] = 6;
        nArray3[16] = 7;
        nArray3[17] = 7;
        nArray3[18] = 8;
        nArray3[19] = 8;
        nArray3[20] = 9;
        nArray3[21] = 9;
        nArray3[22] = 10;
        nArray3[23] = 10;
        nArray3[24] = 11;
        nArray3[25] = 11;
        nArray3[26] = 12;
        nArray3[27] = 12;
        nArray3[28] = 13;
        nArray3[29] = 13;
        DISTANCE_EXTRA_BITS = nArray3;
        DISTANCE_VALUES = new int[]{1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577};
        int[] nArray4 = new int[19];
        nArray4[0] = 16;
        nArray4[1] = 17;
        nArray4[2] = 18;
        nArray4[4] = 8;
        nArray4[5] = 7;
        nArray4[6] = 9;
        nArray4[7] = 6;
        nArray4[8] = 10;
        nArray4[9] = 5;
        nArray4[10] = 11;
        nArray4[11] = 4;
        nArray4[12] = 12;
        nArray4[13] = 3;
        nArray4[14] = 13;
        nArray4[15] = 2;
        nArray4[16] = 14;
        nArray4[17] = 1;
        nArray4[18] = 15;
        DYNAMIC_LENGTH_ORDER = nArray4;
    }

    public static byte[] inflate(byte[] gzip) throws IOException {
        gzipBit = 0;
        gzipByte = 0;
        gzipIndex = 0;
        if (GZIP.readBits(gzip, 16) != 35615 || GZIP.readBits(gzip, 8) != 8) {
            throw new IOException("Invalid GZIP format");
        }
        int flg = GZIP.readBits(gzip, 8);
        gzipIndex += 6;
        if ((flg & 4) != 0) {
            gzipIndex += GZIP.readBits(gzip, 16);
        }
        if ((flg & 8) != 0) {
            while (gzip[gzipIndex++] != 0) {
            }
        }
        if ((flg & 0x10) != 0) {
            while (gzip[gzipIndex++] != 0) {
            }
        }
        if ((flg & 2) != 0) {
            gzipIndex += 2;
        }
        int index = gzipIndex;
        gzipIndex = gzip.length - 4;
        byte[] uncompressed = new byte[GZIP.readBits(gzip, 16) | GZIP.readBits(gzip, 16) << 16];
        int uncompressedIndex = 0;
        gzipIndex = index;
        int bfinal = 0;
        int btype = 0;
        do {
            int[] distanceTree;
            int[] literalTree;
            bfinal = GZIP.readBits(gzip, 1);
            btype = GZIP.readBits(gzip, 2);
            if (btype == 0) {
                gzipBit = 0;
                int len = GZIP.readBits(gzip, 16);
                int nlen = GZIP.readBits(gzip, 16);
                System.arraycopy(gzip, gzipIndex, uncompressed, uncompressedIndex, len);
                gzipIndex += len;
                uncompressedIndex += len;
                continue;
            }
            if (btype == 2) {
                int hlit = GZIP.readBits(gzip, 5) + 257;
                int hdist = GZIP.readBits(gzip, 5) + 1;
                int hclen = GZIP.readBits(gzip, 4) + 4;
                byte[] lengthBits = new byte[19];
                int i = 0;
                while (i < hclen) {
                    lengthBits[GZIP.DYNAMIC_LENGTH_ORDER[i]] = (byte)GZIP.readBits(gzip, 3);
                    ++i;
                }
                int[] lengthTree = GZIP.createHuffmanTree(lengthBits, 18);
                literalTree = GZIP.createHuffmanTree(GZIP.decodeCodeLengths(gzip, lengthTree, hlit), hlit - 1);
                distanceTree = GZIP.createHuffmanTree(GZIP.decodeCodeLengths(gzip, lengthTree, hdist), hdist - 1);
            } else {
                byte[] literalBits = new byte[288];
                int i = 0;
                while (i < 144) {
                    literalBits[i] = 8;
                    ++i;
                }
                i = 144;
                while (i < 256) {
                    literalBits[i] = 9;
                    ++i;
                }
                i = 256;
                while (i < 280) {
                    literalBits[i] = 7;
                    ++i;
                }
                i = 280;
                while (i < 288) {
                    literalBits[i] = 8;
                    ++i;
                }
                literalTree = GZIP.createHuffmanTree(literalBits, 287);
                byte[] distanceBits = new byte[32];
                int i2 = 0;
                while (i2 < distanceBits.length) {
                    distanceBits[i2] = 5;
                    ++i2;
                }
                distanceTree = GZIP.createHuffmanTree(distanceBits, 31);
            }
            int code = 0;
            int leb = 0;
            int deb = 0;
            while ((code = GZIP.readCode(gzip, literalTree)) != 256) {
                if (code > 256) {
                    int length = LENGTH_VALUES[code -= 257];
                    leb = LENGTH_EXTRA_BITS[code];
                    if (leb > 0) {
                        length += GZIP.readBits(gzip, leb);
                    }
                    code = GZIP.readCode(gzip, distanceTree);
                    int distance = DISTANCE_VALUES[code];
                    deb = DISTANCE_EXTRA_BITS[code];
                    if (deb > 0) {
                        distance += GZIP.readBits(gzip, deb);
                    }
                    int offset = uncompressedIndex - distance;
                    while (distance < length) {
                        System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, distance);
                        uncompressedIndex += distance;
                        length -= distance;
                        distance <<= 1;
                    }
                    System.arraycopy(uncompressed, offset, uncompressed, uncompressedIndex, length);
                    uncompressedIndex += length;
                    continue;
                }
                uncompressed[uncompressedIndex++] = (byte)code;
            }
        } while (bfinal == 0);
        return uncompressed;
    }

    private static int readBits(byte[] gzip, int n) {
        int data = gzipBit == 0 ? (gzipByte = gzip[gzipIndex++] & 0xFF) : gzipByte >> gzipBit;
        int i = 8 - gzipBit;
        while (i < n) {
            gzipByte = gzip[gzipIndex++] & 0xFF;
            data |= gzipByte << i;
            i += 8;
        }
        gzipBit = gzipBit + n & 7;
        return data & (1 << n) - 1;
    }

    private static int readCode(byte[] gzip, int[] tree) {
        int node = tree[0];
        while (node >= 0) {
            if (gzipBit == 0) {
                gzipByte = gzip[gzipIndex++] & 0xFF;
            }
            node = (gzipByte & 1 << gzipBit) == 0 ? tree[node >> 16] : tree[node & 0xFFFF];
            gzipBit = gzipBit + 1 & 7;
        }
        return node & 0xFFFF;
    }

    private static byte[] decodeCodeLengths(byte[] gzip, int[] lengthTree, int count) {
        byte[] bits = new byte[count];
        int i = 0;
        int code = 0;
        int last = 0;
        while (i < count) {
            code = GZIP.readCode(gzip, lengthTree);
            if (code >= 16) {
                int repeat = 0;
                if (code == 16) {
                    repeat = 3 + GZIP.readBits(gzip, 2);
                    code = last;
                } else {
                    repeat = code == 17 ? 3 + GZIP.readBits(gzip, 3) : 11 + GZIP.readBits(gzip, 7);
                    code = 0;
                }
                while (repeat-- > 0) {
                    bits[i++] = (byte)code;
                }
            } else {
                bits[i++] = (byte)code;
            }
            last = code;
        }
        return bits;
    }

    private static int[] createHuffmanTree(byte[] bits, int maxCode) {
        int[] bl_count = new int[17];
        int i = 0;
        while (i < bits.length) {
            byte by = bits[i];
            bl_count[by] = bl_count[by] + 1;
            ++i;
        }
        int code = 0;
        bl_count[0] = 0;
        int[] next_code = new int[17];
        int i2 = 1;
        while (i2 <= 16) {
            next_code[i2] = code = code + bl_count[i2 - 1] << 1;
            ++i2;
        }
        int[] tree = new int[(maxCode << 1) + 16];
        int treeInsert = 1;
        int i3 = 0;
        while (i3 <= maxCode) {
            byte len = bits[i3];
            if (len != 0) {
                byte by = len;
                next_code[by] = next_code[by] + 1;
                int node = 0;
                int bit = len - 1;
                while (bit >= 0) {
                    int value = code & 1 << bit;
                    if (value == 0) {
                        int left = tree[node] >> 16;
                        if (left == 0) {
                            int n = node;
                            tree[n] = tree[n] | treeInsert << 16;
                            node = treeInsert++;
                        } else {
                            node = left;
                        }
                    } else {
                        int right = tree[node] & 0xFFFF;
                        if (right == 0) {
                            int n = node;
                            tree[n] = tree[n] | treeInsert;
                            node = treeInsert++;
                        } else {
                            node = right;
                        }
                    }
                    --bit;
                }
                tree[node] = Integer.MIN_VALUE | i3;
            }
            ++i3;
        }
        return tree;
    }
}

